/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.ExpressionNode;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.utilities.Utilities;

public class TypeDetails {
    private List<ProfiledType> types = new ArrayList<ProfiledType>();
    private ExpressionNode.CollectionStatus collectionStatus;

    public TypeDetails(ExpressionNode.CollectionStatus collectionStatus, String ... names) {
        this.collectionStatus = collectionStatus;
        for (String n : names) {
            this.types.add(new ProfiledType(n));
        }
    }

    public TypeDetails(ExpressionNode.CollectionStatus collectionStatus, Set<String> names) {
        this.collectionStatus = collectionStatus;
        for (String n : names) {
            this.addType(new ProfiledType(n));
        }
    }

    public TypeDetails(ExpressionNode.CollectionStatus collectionStatus, ProfiledType pt) {
        this.collectionStatus = collectionStatus;
        this.types.add(pt);
    }

    public String addType(String n) {
        ProfiledType pt = new ProfiledType(n);
        String res = pt.uri;
        this.addType(pt);
        return res;
    }

    public String addType(String n, String p) {
        ProfiledType pt = new ProfiledType(n);
        pt.addProfile(p);
        String res = pt.uri;
        this.addType(pt);
        return res;
    }

    public void addType(ProfiledType pt) {
        for (ProfiledType et : this.types) {
            if (!et.uri.equals(pt.uri)) continue;
            if (pt.profiles != null) {
                for (String p : pt.profiles) {
                    if (et.profiles == null) {
                        et.profiles = new ArrayList();
                    }
                    if (et.profiles.contains(p)) continue;
                    et.profiles.add(p);
                }
            }
            if (pt.bindings != null) {
                for (ElementDefinition.ElementDefinitionBindingComponent b : pt.bindings) {
                    if (et.bindings == null) {
                        et.bindings = new ArrayList();
                    }
                    if (et.hasBinding(b)) continue;
                    et.bindings.add(b);
                }
            }
            return;
        }
        this.types.add(pt);
    }

    public void addTypes(Collection<String> names) {
        for (String n : names) {
            this.addType(new ProfiledType(n));
        }
    }

    public boolean hasType(IWorkerContext context, String ... tn) {
        for (String n : tn) {
            String t = ProfiledType.ns(n);
            if (!this.typesContains(t)) continue;
            return true;
        }
        for (String n : tn) {
            String id = n.contains("#") ? n.substring(0, n.indexOf("#")) : n;
            String tail = null;
            if (n.contains("#")) {
                tail = n.substring(n.indexOf("#") + 1);
                tail = tail.substring(tail.indexOf("."));
            }
            String t = ProfiledType.ns(n);
            StructureDefinition sd = context.fetchResource(StructureDefinition.class, t);
            while (sd != null) {
                if (tail == null && this.typesContains(sd.getUrl())) {
                    return true;
                }
                if (tail != null && this.typesContains(sd.getUrl() + "#" + sd.getType() + tail)) {
                    return true;
                }
                if (sd.hasBaseDefinition()) {
                    sd = context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
                    continue;
                }
                sd = null;
            }
        }
        return false;
    }

    private boolean typesContains(String t) {
        for (ProfiledType pt : this.types) {
            if (!pt.uri.equals(t)) continue;
            return true;
        }
        return false;
    }

    public void update(TypeDetails source) {
        for (ProfiledType pt : source.types) {
            this.addType(pt);
        }
        this.collectionStatus = this.collectionStatus == null ? source.collectionStatus : (source.collectionStatus == ExpressionNode.CollectionStatus.UNORDERED ? source.collectionStatus : ExpressionNode.CollectionStatus.ORDERED);
    }

    public TypeDetails union(TypeDetails right) {
        TypeDetails result = new TypeDetails(null, new String[0]);
        result.collectionStatus = right.collectionStatus == ExpressionNode.CollectionStatus.UNORDERED || this.collectionStatus == ExpressionNode.CollectionStatus.UNORDERED ? ExpressionNode.CollectionStatus.UNORDERED : ExpressionNode.CollectionStatus.ORDERED;
        for (ProfiledType pt : this.types) {
            result.addType(pt);
        }
        for (ProfiledType pt : right.types) {
            result.addType(pt);
        }
        return result;
    }

    public boolean hasNoTypes() {
        return this.types.isEmpty();
    }

    public Set<String> getTypes() {
        HashSet<String> res = new HashSet<String>();
        for (ProfiledType pt : this.types) {
            res.add(pt.uri);
        }
        return res;
    }

    public TypeDetails toSingleton() {
        TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
        result.types.addAll(this.types);
        return result;
    }

    public ExpressionNode.CollectionStatus getCollectionStatus() {
        return this.collectionStatus;
    }

    public boolean hasType(Set<String> tn) {
        for (String n : tn) {
            String t = ProfiledType.ns(n);
            if (!this.typesContains(t)) continue;
            return true;
        }
        return false;
    }

    public String describe() {
        return this.getTypes().toString();
    }

    public String getType() {
        Iterator<ProfiledType> iterator2 = this.types.iterator();
        if (iterator2.hasNext()) {
            ProfiledType pt = iterator2.next();
            return pt.uri;
        }
        return null;
    }

    public String toString() {
        return (this.collectionStatus == null ? ExpressionNode.CollectionStatus.SINGLETON.toString() : this.collectionStatus.toString()) + this.getTypes().toString();
    }

    public String getTypeCode() throws DefinitionException {
        if (this.types.size() != 1) {
            throw new DefinitionException("Multiple types? (" + this.types.toString() + ")");
        }
        Iterator<ProfiledType> iterator2 = this.types.iterator();
        if (iterator2.hasNext()) {
            ProfiledType pt = iterator2.next();
            if (pt.uri.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                return pt.uri.substring(40);
            }
            return pt.uri;
        }
        return null;
    }

    public List<ProfiledType> getProfiledTypes() {
        return this.types;
    }

    public boolean hasBinding() {
        for (ProfiledType pt : this.types) {
            if (!pt.hasBindings()) continue;
            return true;
        }
        return false;
    }

    public ElementDefinition.ElementDefinitionBindingComponent getBinding() {
        for (ProfiledType pt : this.types) {
            Iterator<ElementDefinition.ElementDefinitionBindingComponent> iterator2 = pt.getBindings().iterator();
            if (!iterator2.hasNext()) continue;
            ElementDefinition.ElementDefinitionBindingComponent b = iterator2.next();
            return b;
        }
        return null;
    }

    public static class ProfiledType {
        private String uri;
        private List<String> profiles;
        private List<ElementDefinition.ElementDefinitionBindingComponent> bindings;

        public ProfiledType(String n) {
            this.uri = ProfiledType.ns(n);
        }

        public String getUri() {
            return this.uri;
        }

        public boolean hasProfiles() {
            return this.profiles != null && this.profiles.size() > 0;
        }

        public List<String> getProfiles() {
            return this.profiles;
        }

        public boolean hasBindings() {
            return this.bindings != null && this.bindings.size() > 0;
        }

        public List<ElementDefinition.ElementDefinitionBindingComponent> getBindings() {
            return this.bindings;
        }

        public static String ns(String n) {
            return Utilities.isAbsoluteUrl(n) ? n : "http://hl7.org/fhir/StructureDefinition/" + n;
        }

        public void addProfile(String profile2) {
            this.profiles = new ArrayList<String>();
            this.profiles.add(profile2);
        }

        public void addBinding(ElementDefinition.ElementDefinitionBindingComponent binding) {
            this.bindings = new ArrayList<ElementDefinition.ElementDefinitionBindingComponent>();
            this.bindings.add(binding);
        }

        public boolean hasBinding(ElementDefinition.ElementDefinitionBindingComponent b) {
            return false;
        }
    }
}

