/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.Contract;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.Substance;
import org.hl7.fhir.dstu3.model.SupplyRequest;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="SupplyDelivery", profile="http://hl7.org/fhir/Profile/SupplyDelivery")
public class SupplyDelivery
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="External identifier", formalDefinition="Identifier assigned by the dispensing facility when the item(s) is dispensed.")
    protected Identifier identifier;
    @Child(name="basedOn", type={SupplyRequest.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Fulfills plan, proposal or order", formalDefinition="A plan, proposal or order that is fulfilled in whole or in part by this event.")
    protected List<Reference> basedOn;
    protected List<SupplyRequest> basedOnTarget;
    @Child(name="partOf", type={SupplyDelivery.class, Contract.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of referenced event", formalDefinition="A larger event of which this particular event is a component or step.")
    protected List<Reference> partOf;
    protected List<Resource> partOfTarget;
    @Child(name="status", type={CodeType.class}, order=3, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | completed | abandoned | entered-in-error", formalDefinition="A code specifying the state of the dispense event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/supplydelivery-status")
    protected Enumeration<SupplyDeliveryStatus> status;
    @Child(name="patient", type={Patient.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Patient for whom the item is supplied", formalDefinition="A link to a resource representing the person whom the delivered item is for.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="type", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Category of dispense event", formalDefinition="Indicates the type of dispensing event that is performed. Examples include: Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/supplydelivery-type")
    protected CodeableConcept type;
    @Child(name="suppliedItem", type={}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The item that is delivered or supplied", formalDefinition="The item that is being delivered or has been supplied.")
    protected SupplyDeliverySuppliedItemComponent suppliedItem;
    @Child(name="occurrence", type={DateTimeType.class, Period.class, Timing.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When event occurred", formalDefinition="The date or time(s) the activity occurred.")
    protected Type occurrence;
    @Child(name="supplier", type={Practitioner.class, Organization.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Dispenser", formalDefinition="The individual responsible for dispensing the medication, supplier or device.")
    protected Reference supplier;
    protected Resource supplierTarget;
    @Child(name="destination", type={Location.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where the Supply was sent", formalDefinition="Identification of the facility/location where the Supply was shipped to, as part of the dispense event.")
    protected Reference destination;
    protected Location destinationTarget;
    @Child(name="receiver", type={Practitioner.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who collected the Supply", formalDefinition="Identifies the person who picked up the Supply.")
    protected List<Reference> receiver;
    protected List<Practitioner> receiverTarget;
    private static final long serialVersionUID = 2033462996L;
    @SearchParamDefinition(name="identifier", path="SupplyDelivery.identifier", description="External identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="receiver", path="SupplyDelivery.receiver", description="Who collected the Supply", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class})
    public static final String SP_RECEIVER = "receiver";
    public static final ReferenceClientParam RECEIVER = new ReferenceClientParam("receiver");
    public static final Include INCLUDE_RECEIVER = new Include("SupplyDelivery:receiver").toLocked();
    @SearchParamDefinition(name="patient", path="SupplyDelivery.patient", description="Patient for whom the item is supplied", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("SupplyDelivery:patient").toLocked();
    @SearchParamDefinition(name="supplier", path="SupplyDelivery.supplier", description="Dispenser", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class})
    public static final String SP_SUPPLIER = "supplier";
    public static final ReferenceClientParam SUPPLIER = new ReferenceClientParam("supplier");
    public static final Include INCLUDE_SUPPLIER = new Include("SupplyDelivery:supplier").toLocked();
    @SearchParamDefinition(name="status", path="SupplyDelivery.status", description="in-progress | completed | abandoned | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public SupplyDelivery setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public SupplyDelivery setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public SupplyDelivery addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    @Deprecated
    public List<SupplyRequest> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<SupplyRequest>();
        }
        return this.basedOnTarget;
    }

    @Deprecated
    public SupplyRequest addBasedOnTarget() {
        SupplyRequest r = new SupplyRequest();
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<SupplyRequest>();
        }
        this.basedOnTarget.add(r);
        return r;
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public SupplyDelivery setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public SupplyDelivery addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    @Deprecated
    public List<Resource> getPartOfTarget() {
        if (this.partOfTarget == null) {
            this.partOfTarget = new ArrayList<Resource>();
        }
        return this.partOfTarget;
    }

    public Enumeration<SupplyDeliveryStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<SupplyDeliveryStatus>(new SupplyDeliveryStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public SupplyDelivery setStatusElement(Enumeration<SupplyDeliveryStatus> value) {
        this.status = value;
        return this;
    }

    public SupplyDeliveryStatus getStatus() {
        return this.status == null ? null : (SupplyDeliveryStatus)((Object)this.status.getValue());
    }

    public SupplyDelivery setStatus(SupplyDeliveryStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<SupplyDeliveryStatus>(new SupplyDeliveryStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public SupplyDelivery setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public SupplyDelivery setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public SupplyDelivery setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public SupplyDeliverySuppliedItemComponent getSuppliedItem() {
        if (this.suppliedItem == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.suppliedItem");
            }
            if (Configuration.doAutoCreate()) {
                this.suppliedItem = new SupplyDeliverySuppliedItemComponent();
            }
        }
        return this.suppliedItem;
    }

    public boolean hasSuppliedItem() {
        return this.suppliedItem != null && !this.suppliedItem.isEmpty();
    }

    public SupplyDelivery setSuppliedItem(SupplyDeliverySuppliedItemComponent value) {
        this.suppliedItem = value;
        return this;
    }

    public Type getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this != null && this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this != null && this.occurrence instanceof Period;
    }

    public Timing getOccurrenceTiming() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Timing)this.occurrence;
    }

    public boolean hasOccurrenceTiming() {
        return this != null && this.occurrence instanceof Timing;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public SupplyDelivery setOccurrence(Type value) throws FHIRFormatError {
        if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Timing)) {
            throw new FHIRFormatError("Not the right type for SupplyDelivery.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public Reference getSupplier() {
        if (this.supplier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.supplier");
            }
            if (Configuration.doAutoCreate()) {
                this.supplier = new Reference();
            }
        }
        return this.supplier;
    }

    public boolean hasSupplier() {
        return this.supplier != null && !this.supplier.isEmpty();
    }

    public SupplyDelivery setSupplier(Reference value) {
        this.supplier = value;
        return this;
    }

    public Resource getSupplierTarget() {
        return this.supplierTarget;
    }

    public SupplyDelivery setSupplierTarget(Resource value) {
        this.supplierTarget = value;
        return this;
    }

    public Reference getDestination() {
        if (this.destination == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.destination");
            }
            if (Configuration.doAutoCreate()) {
                this.destination = new Reference();
            }
        }
        return this.destination;
    }

    public boolean hasDestination() {
        return this.destination != null && !this.destination.isEmpty();
    }

    public SupplyDelivery setDestination(Reference value) {
        this.destination = value;
        return this;
    }

    public Location getDestinationTarget() {
        if (this.destinationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.destination");
            }
            if (Configuration.doAutoCreate()) {
                this.destinationTarget = new Location();
            }
        }
        return this.destinationTarget;
    }

    public SupplyDelivery setDestinationTarget(Location value) {
        this.destinationTarget = value;
        return this;
    }

    public List<Reference> getReceiver() {
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        return this.receiver;
    }

    public SupplyDelivery setReceiver(List<Reference> theReceiver) {
        this.receiver = theReceiver;
        return this;
    }

    public boolean hasReceiver() {
        if (this.receiver == null) {
            return false;
        }
        for (Reference item : this.receiver) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReceiver() {
        Reference t = new Reference();
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        this.receiver.add(t);
        return t;
    }

    public SupplyDelivery addReceiver(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        this.receiver.add(t);
        return this;
    }

    public Reference getReceiverFirstRep() {
        if (this.getReceiver().isEmpty()) {
            this.addReceiver();
        }
        return this.getReceiver().get(0);
    }

    @Deprecated
    public List<Practitioner> getReceiverTarget() {
        if (this.receiverTarget == null) {
            this.receiverTarget = new ArrayList<Practitioner>();
        }
        return this.receiverTarget;
    }

    @Deprecated
    public Practitioner addReceiverTarget() {
        Practitioner r = new Practitioner();
        if (this.receiverTarget == null) {
            this.receiverTarget = new ArrayList<Practitioner>();
        }
        this.receiverTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier assigned by the dispensing facility when the item(s) is dispensed.", 0, 1, this.identifier));
        children.add(new Property("basedOn", "Reference(SupplyRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this event.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("partOf", "Reference(SupplyDelivery|Contract)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, "code", "A code specifying the state of the dispense event.", 0, 1, this.status));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "A link to a resource representing the person whom the delivered item is for.", 0, 1, this.patient));
        children.add(new Property("type", "CodeableConcept", "Indicates the type of dispensing event that is performed. Examples include: Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.", 0, 1, this.type));
        children.add(new Property("suppliedItem", "", "The item that is being delivered or has been supplied.", 0, 1, this.suppliedItem));
        children.add(new Property("occurrence[x]", "dateTime|Period|Timing", "The date or time(s) the activity occurred.", 0, 1, this.occurrence));
        children.add(new Property(SP_SUPPLIER, "Reference(Practitioner|Organization)", "The individual responsible for dispensing the medication, supplier or device.", 0, 1, this.supplier));
        children.add(new Property("destination", "Reference(Location)", "Identification of the facility/location where the Supply was shipped to, as part of the dispense event.", 0, 1, this.destination));
        children.add(new Property(SP_RECEIVER, "Reference(Practitioner)", "Identifies the person who picked up the Supply.", 0, Integer.MAX_VALUE, this.receiver));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier assigned by the dispensing facility when the item(s) is dispensed.", 0, 1, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(SupplyRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this event.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -995410646: {
                return new Property("partOf", "Reference(SupplyDelivery|Contract)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "A code specifying the state of the dispense event.", 0, 1, this.status);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "A link to a resource representing the person whom the delivered item is for.", 0, 1, this.patient);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "Indicates the type of dispensing event that is performed. Examples include: Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.", 0, 1, this.type);
            }
            case 1993333233: {
                return new Property("suppliedItem", "", "The item that is being delivered or has been supplied.", 0, 1, this.suppliedItem);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The date or time(s) the activity occurred.", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The date or time(s) the activity occurred.", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The date or time(s) the activity occurred.", 0, 1, this.occurrence);
            }
            case 1397156594: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The date or time(s) the activity occurred.", 0, 1, this.occurrence);
            }
            case 1515218299: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The date or time(s) the activity occurred.", 0, 1, this.occurrence);
            }
            case -1663305268: {
                return new Property(SP_SUPPLIER, "Reference(Practitioner|Organization)", "The individual responsible for dispensing the medication, supplier or device.", 0, 1, this.supplier);
            }
            case -1429847026: {
                return new Property("destination", "Reference(Location)", "Identification of the facility/location where the Supply was shipped to, as part of the dispense event.", 0, 1, this.destination);
            }
            case -808719889: {
                return new Property(SP_RECEIVER, "Reference(Practitioner)", "Identifies the person who picked up the Supply.", 0, Integer.MAX_VALUE, this.receiver);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.patient;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.type;
                }
                return baseArray;
            }
            case 1993333233: {
                Base[] baseArray;
                if (this.suppliedItem == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.suppliedItem;
                }
                return baseArray;
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.occurrence;
                }
                return baseArray;
            }
            case -1663305268: {
                Base[] baseArray;
                if (this.supplier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.supplier;
                }
                return baseArray;
            }
            case -1429847026: {
                Base[] baseArray;
                if (this.destination == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.destination;
                }
                return baseArray;
            }
            case -808719889: {
                return this.receiver == null ? new Base[]{} : this.receiver.toArray(new Base[this.receiver.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(this.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new SupplyDeliveryStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case 1993333233: {
                this.suppliedItem = (SupplyDeliverySuppliedItemComponent)((Object)value);
                return value;
            }
            case 1687874001: {
                this.occurrence = this.castToType(value);
                return value;
            }
            case -1663305268: {
                this.supplier = this.castToReference(value);
                return value;
            }
            case -1429847026: {
                this.destination = this.castToReference(value);
                return value;
            }
            case -808719889: {
                this.getReceiver().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(this.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new SupplyDeliveryStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("suppliedItem")) {
            this.suppliedItem = (SupplyDeliverySuppliedItemComponent)((Object)value);
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = this.castToType(value);
        } else if (name.equals(SP_SUPPLIER)) {
            this.supplier = this.castToReference(value);
        } else if (name.equals("destination")) {
            this.destination = this.castToReference(value);
        } else if (name.equals(SP_RECEIVER)) {
            this.getReceiver().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 3575610: {
                return this.getType();
            }
            case 1993333233: {
                return this.getSuppliedItem();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case -1663305268: {
                return this.getSupplier();
            }
            case -1429847026: {
                return this.getDestination();
            }
            case -808719889: {
                return this.addReceiver();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 1993333233: {
                return new String[0];
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period", "Timing"};
            }
            case -1663305268: {
                return new String[]{"Reference"};
            }
            case -1429847026: {
                return new String[]{"Reference"};
            }
            case -808719889: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type SupplyDelivery.status");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("suppliedItem")) {
            this.suppliedItem = new SupplyDeliverySuppliedItemComponent();
            return this.suppliedItem;
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals("occurrenceTiming")) {
            this.occurrence = new Timing();
            return this.occurrence;
        }
        if (name.equals(SP_SUPPLIER)) {
            this.supplier = new Reference();
            return this.supplier;
        }
        if (name.equals("destination")) {
            this.destination = new Reference();
            return this.destination;
        }
        if (name.equals(SP_RECEIVER)) {
            return this.addReceiver();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SupplyDelivery";
    }

    @Override
    public SupplyDelivery copy() {
        SupplyDelivery dst = new SupplyDelivery();
        this.copyValues(dst);
        Identifier identifier = dst.identifier = this.identifier == null ? null : this.identifier.copy();
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference i2 : this.basedOn) {
                dst.basedOn.add(i2.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference i2 : this.partOf) {
                dst.partOf.add(i2.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.suppliedItem = this.suppliedItem == null ? null : this.suppliedItem.copy();
        dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        dst.supplier = this.supplier == null ? null : this.supplier.copy();
        Reference reference = dst.destination = this.destination == null ? null : this.destination.copy();
        if (this.receiver != null) {
            dst.receiver = new ArrayList<Reference>();
            for (Reference i2 : this.receiver) {
                dst.receiver.add(i2.copy());
            }
        }
        return dst;
    }

    protected SupplyDelivery typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SupplyDelivery)) {
            return false;
        }
        SupplyDelivery o = (SupplyDelivery)other_;
        return SupplyDelivery.compareDeep(this.identifier, o.identifier, true) && SupplyDelivery.compareDeep(this.basedOn, o.basedOn, true) && SupplyDelivery.compareDeep(this.partOf, o.partOf, true) && SupplyDelivery.compareDeep(this.status, o.status, true) && SupplyDelivery.compareDeep(this.patient, o.patient, true) && SupplyDelivery.compareDeep(this.type, o.type, true) && SupplyDelivery.compareDeep(this.suppliedItem, o.suppliedItem, true) && SupplyDelivery.compareDeep(this.occurrence, o.occurrence, true) && SupplyDelivery.compareDeep(this.supplier, o.supplier, true) && SupplyDelivery.compareDeep(this.destination, o.destination, true) && SupplyDelivery.compareDeep(this.receiver, o.receiver, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SupplyDelivery)) {
            return false;
        }
        SupplyDelivery o = (SupplyDelivery)other_;
        return SupplyDelivery.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.basedOn, this.partOf, this.status, this.patient, this.type, this.suppliedItem, this.occurrence, this.supplier, this.destination, this.receiver);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SupplyDelivery;
    }

    @Block
    public static class SupplyDeliverySuppliedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="quantity", type={SimpleQuantity.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Amount dispensed", formalDefinition="The amount of supply that has been dispensed. Includes unit of measure.")
        protected SimpleQuantity quantity;
        @Child(name="item", type={CodeableConcept.class, Medication.class, Substance.class, Device.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Medication, Substance, or Device supplied", formalDefinition="Identifies the medication, substance or device being dispensed. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/supply-item")
        protected Type item;
        private static final long serialVersionUID = 80196045L;

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupplyDeliverySuppliedItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public SupplyDeliverySuppliedItemComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Type getItem() {
            return this.item;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (this.item == null) {
                return null;
            }
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this != null && this.item instanceof CodeableConcept;
        }

        public Reference getItemReference() throws FHIRException {
            if (this.item == null) {
                return null;
            }
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this != null && this.item instanceof Reference;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public SupplyDeliverySuppliedItemComponent setItem(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for SupplyDelivery.suppliedItem.item[x]: " + value.fhirType());
            }
            this.item = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("quantity", "SimpleQuantity", "The amount of supply that has been dispensed. Includes unit of measure.", 0, 1, this.quantity));
            children.add(new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device)", "Identifies the medication, substance or device being dispensed. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The amount of supply that has been dispensed. Includes unit of measure.", 0, 1, this.quantity);
                }
                case 2116201613: {
                    return new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device)", "Identifies the medication, substance or device being dispensed. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
                }
                case 3242771: {
                    return new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device)", "Identifies the medication, substance or device being dispensed. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
                }
                case 106644494: {
                    return new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device)", "Identifies the medication, substance or device being dispensed. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
                }
                case 1376364920: {
                    return new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device)", "Identifies the medication, substance or device being dispensed. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.item;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    return value;
                }
                case 3242771: {
                    this.item = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("item[x]")) {
                this.item = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return this.getQuantity();
                }
                case 2116201613: {
                    return this.getItem();
                }
                case 3242771: {
                    return this.getItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case 3242771: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            return super.addChild(name);
        }

        @Override
        public SupplyDeliverySuppliedItemComponent copy() {
            SupplyDeliverySuppliedItemComponent dst = new SupplyDeliverySuppliedItemComponent();
            this.copyValues(dst);
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.item = this.item == null ? null : this.item.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SupplyDeliverySuppliedItemComponent)) {
                return false;
            }
            SupplyDeliverySuppliedItemComponent o = (SupplyDeliverySuppliedItemComponent)other_;
            return SupplyDeliverySuppliedItemComponent.compareDeep(this.quantity, o.quantity, true) && SupplyDeliverySuppliedItemComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SupplyDeliverySuppliedItemComponent)) {
                return false;
            }
            SupplyDeliverySuppliedItemComponent o = (SupplyDeliverySuppliedItemComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.quantity, this.item);
        }

        @Override
        public String fhirType() {
            return "SupplyDelivery.suppliedItem";
        }
    }

    public static class SupplyDeliveryStatusEnumFactory
    implements EnumFactory<SupplyDeliveryStatus> {
        @Override
        public SupplyDeliveryStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return SupplyDeliveryStatus.INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return SupplyDeliveryStatus.COMPLETED;
            }
            if ("abandoned".equals(codeString)) {
                return SupplyDeliveryStatus.ABANDONED;
            }
            if ("entered-in-error".equals(codeString)) {
                return SupplyDeliveryStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown SupplyDeliveryStatus code '" + codeString + "'");
        }

        public Enumeration<SupplyDeliveryStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SupplyDeliveryStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<SupplyDeliveryStatus>(this, SupplyDeliveryStatus.INPROGRESS);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<SupplyDeliveryStatus>(this, SupplyDeliveryStatus.COMPLETED);
            }
            if ("abandoned".equals(codeString)) {
                return new Enumeration<SupplyDeliveryStatus>(this, SupplyDeliveryStatus.ABANDONED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<SupplyDeliveryStatus>(this, SupplyDeliveryStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown SupplyDeliveryStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(SupplyDeliveryStatus code) {
            if (code == SupplyDeliveryStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == SupplyDeliveryStatus.COMPLETED) {
                return "completed";
            }
            if (code == SupplyDeliveryStatus.ABANDONED) {
                return "abandoned";
            }
            if (code == SupplyDeliveryStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(SupplyDeliveryStatus code) {
            return code.getSystem();
        }
    }

    public static enum SupplyDeliveryStatus {
        INPROGRESS,
        COMPLETED,
        ABANDONED,
        ENTEREDINERROR,
        NULL;


        public static SupplyDeliveryStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("abandoned".equals(codeString)) {
                return ABANDONED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SupplyDeliveryStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ABANDONED: {
                    return "abandoned";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/supplydelivery-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/supplydelivery-status";
                }
                case ABANDONED: {
                    return "http://hl7.org/fhir/supplydelivery-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/supplydelivery-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "Supply has been requested, but not delivered.";
                }
                case COMPLETED: {
                    return "Supply has been delivered (\"completed\").";
                }
                case ABANDONED: {
                    return "Delivery was not completed.";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it. (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".)";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In Progress";
                }
                case COMPLETED: {
                    return "Delivered";
                }
                case ABANDONED: {
                    return "Abandoned";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

