/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.formats;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.hl7.fhir.dstu3.formats.FormatUtilities;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;

public abstract class ParserBase
extends FormatUtilities
implements IParser {
    protected String xhtmlMessage;
    protected boolean handleComments = false;
    protected boolean allowUnknownContent;
    protected IParser.OutputStyle style = IParser.OutputStyle.NORMAL;
    protected Map<String, Object> idMap = new HashMap<String, Object>();

    @Override
    public Resource parse(String input) throws FHIRFormatError, IOException {
        return this.parse(input.getBytes("UTF-8"));
    }

    @Override
    public Resource parse(byte[] bytes) throws FHIRFormatError, IOException {
        ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
        return this.parse(bi);
    }

    @Override
    public Type parseType(String input, String typeName) throws FHIRFormatError, IOException {
        return this.parseType(input.getBytes("UTF-8"), typeName);
    }

    @Override
    public Type parseType(byte[] bytes, String typeName) throws FHIRFormatError, IOException {
        ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
        return this.parseType(bi, typeName);
    }

    @Override
    public String composeString(Resource resource) throws IOException {
        return new String(this.composeBytes(resource));
    }

    @Override
    public byte[] composeBytes(Resource resource) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        this.compose(bytes, resource);
        bytes.close();
        return bytes.toByteArray();
    }

    @Override
    public String composeString(Type type, String typeName) throws IOException {
        return new String(this.composeBytes(type, typeName));
    }

    @Override
    public byte[] composeBytes(Type type, String typeName) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        this.compose(bytes, type, typeName);
        bytes.close();
        return bytes.toByteArray();
    }

    @Override
    public IParser setSuppressXhtml(String message) {
        this.xhtmlMessage = message;
        return this;
    }

    @Override
    public boolean getHandleComments() {
        return this.handleComments;
    }

    @Override
    public IParser setHandleComments(boolean value) {
        this.handleComments = value;
        return this;
    }

    @Override
    public boolean isAllowUnknownContent() {
        return this.allowUnknownContent;
    }

    @Override
    public IParser setAllowUnknownContent(boolean allowUnknownContent) {
        this.allowUnknownContent = allowUnknownContent;
        return this;
    }

    @Override
    public IParser.OutputStyle getOutputStyle() {
        return this.style;
    }

    @Override
    public IParser setOutputStyle(IParser.OutputStyle style) {
        this.style = style;
        return this;
    }

    protected int parseIntegerPrimitive(String value) {
        if (value.startsWith("+") && Utilities.isInteger(value.substring(1))) {
            value = value.substring(1);
        }
        return Integer.parseInt(value);
    }

    protected int parseIntegerPrimitive(Long value) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(value + " cannot be cast to int without changing its value.");
        }
        return value.intValue();
    }

    protected String parseCodePrimitive(String value) {
        return value;
    }

    protected String parseTimePrimitive(String value) throws ParseException {
        return value;
    }

    protected BigDecimal parseDecimalPrimitive(BigDecimal value) {
        return value;
    }

    protected BigDecimal parseDecimalPrimitive(String value) {
        return new BigDecimal(value);
    }

    protected String parseUriPrimitive(String value) {
        return value;
    }

    protected byte[] parseBase64BinaryPrimitive(String value) {
        return Base64.decodeBase64((byte[])value.getBytes());
    }

    protected String parseOidPrimitive(String value) {
        return value;
    }

    protected Boolean parseBooleanPrimitive(String value) {
        return Boolean.valueOf(value);
    }

    protected Boolean parseBooleanPrimitive(Boolean value) {
        return (boolean)value;
    }

    protected String parseIdPrimitive(String value) {
        return value;
    }

    protected String parseStringPrimitive(String value) {
        return value;
    }

    protected String parseUuidPrimitive(String value) {
        return value;
    }
}

