/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.hl7.fhir.convertors.misc.OIDBasedValueSetImporter;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.CSVReader;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;

public class PhinVadsImporter
extends OIDBasedValueSetImporter {
    public static void main(String[] args2) throws FileNotFoundException, FHIRException, IOException, ParseException {
        PhinVadsImporter self = new PhinVadsImporter();
        self.process(args2[0], args2[1]);
    }

    public PhinVadsImporter() throws FileNotFoundException, FHIRException, IOException {
        this.init();
    }

    private void process(String source, String dest) {
        for (File f : new File(source).listFiles()) {
            try {
                System.out.println("Process " + f.getName());
                ValueSet vs = this.importValueSet(TextFile.fileToBytes(f));
                if (vs.getId() == null) continue;
                new JsonParser().compose(new FileOutputStream(Utilities.path(dest, "ValueSet-" + vs.getId() + ".json")), (Resource)vs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private ValueSet importValueSet(byte[] source) throws FHIRException, IOException, ParseException {
        List<byte[]> parts = Utilities.splitBytes(source, "\r\n\r\n".getBytes());
        if (parts.size() < 2) {
            TextFile.bytesToFile(source, "c:\\temp\\phinvads.txt");
            throw new FHIRException("Unable to parse phinvads value set: " + parts.size() + " parts found");
        }
        CSVReader rdr = new CSVReader(new ByteArrayInputStream(parts.get(0)));
        rdr.setDelimiter('\t');
        rdr.setMultiline(true);
        rdr.readHeaders();
        rdr.line();
        ValueSet vs = new ValueSet();
        vs.setId(rdr.cell("Value Set OID"));
        vs.setUrl("http://phinvads.cdc.gov/fhir/ValueSet/" + vs.getId());
        vs.getMeta().setSource("https://phinvads.cdc.gov/vads/ViewValueSet.action?oid=" + vs.getId());
        vs.setVersion(rdr.cell("Value Set Version"));
        vs.setTitle(rdr.cell("Value Set Name"));
        vs.setName(rdr.cell("Value Set Code"));
        vs.setDescription(rdr.cell("Value Set Definition"));
        if ("Published".equals(rdr.cell("Value Set Status"))) {
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        } else {
            vs.setStatus(Enumerations.PublicationStatus.DRAFT);
        }
        if (rdr.has("VS Last Updated Date")) {
            vs.setDate(new SimpleDateFormat("mm/dd/yyyy").parse(rdr.cell("VS Last Updated Date")));
        }
        rdr = new CSVReader(new ByteArrayInputStream(parts.get(parts.size() - 1)));
        rdr.setMultiline(true);
        rdr.setDelimiter('\t');
        rdr.readHeaders();
        while (rdr.line()) {
            String code = rdr.cell("Concept Code");
            String display = rdr.cell("Preferred Concept Name");
            String csoid = rdr.cell("Code System OID");
            String csver = rdr.cell("Code System Version");
            String url = this.context.oid2Uri(csoid);
            if (url == null) {
                url = "urn:oid:" + csoid;
            }
            csver = this.fixVersionforSystem(url, csver);
            ValueSet.ConceptSetComponent inc = this.getInclude(vs, url, csver);
            inc.addConcept().setCode(code).setDisplay(display);
        }
        return vs;
    }
}

