/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.JsonTrackingParser;

public class PackageMaintainer {
    private static final String PATH = "C:\\work\\org.hl7.fhir\\packages\\core";

    public static void main(String[] args2) throws IOException {
        new PackageMaintainer().check("r4");
        new PackageMaintainer().check("r2");
        new PackageMaintainer().check("r3");
        new PackageMaintainer().check("r2b");
    }

    private void check(String ver) throws IOException {
        System.out.println("Check " + ver);
        List<String> allIds = this.listResources(Utilities.path(PATH, "hl7.fhir." + ver + ".examples", "package"));
        List<String> coreIds = this.listResources(Utilities.path(PATH, "hl7.fhir." + ver + ".core", "package"));
        for (String s2 : coreIds) {
            if (allIds.contains(s2)) continue;
            System.out.println("Core contains " + s2 + " but allIds doesn't");
        }
        for (String s2 : allIds) {
            if (coreIds.contains(s2)) continue;
            String c = s2.substring(0, s2.indexOf("-"));
            if (!Utilities.existsInList(c, "CodeSystem", "ValueSet", "ConceptMap", "StructureDefinition", "StructureMap", "NamingSystem", "SearchParameter", "OperationDefinition", "CapabilityStatement", "Conformance")) continue;
            System.out.println("Examples contains " + s2 + " but core doesn't");
        }
        this.strip(new File(Utilities.path(PATH, "hl7.fhir." + ver + ".core", "package")));
        this.strip(new File(Utilities.path(PATH, "hl7.fhir." + ver + ".expansions", "package")));
        if (!ver.equals("r2b")) {
            this.strip(new File(Utilities.path(PATH, "hl7.fhir." + ver + ".elements", "package")));
        }
    }

    private List<String> listResources(String dir) {
        File folder = new File(dir);
        ArrayList<String> res = new ArrayList<String>();
        for (String fn : folder.list()) {
            if (!fn.endsWith(".json") || !fn.contains("-")) continue;
            String s2 = fn;
            s2 = s2.substring(0, s2.indexOf("."));
            res.add(s2);
        }
        return res;
    }

    private void strip(File folder) throws IOException {
        for (File f : folder.listFiles()) {
            JsonObject json;
            if (f.isDirectory()) {
                this.strip(f);
                continue;
            }
            if (!f.getName().endsWith(".json") || !(json = JsonTrackingParser.parseJson(f)).has("resourceType") || !json.has("text")) continue;
            json.remove("text");
            Gson gson = new GsonBuilder().create();
            String src = gson.toJson((JsonElement)json);
            TextFile.stringToFile(src, f.getAbsolutePath());
        }
    }
}

