/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.JsonParser;
import org.hl7.fhir.dstu2016may.formats.XmlParser;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.JsonTrackingParser;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class CorePackageTools {
    public static void main(String[] args2) throws FHIRFormatError, FileNotFoundException, IOException {
        if ("-xml".equals(args2[0])) {
            new CorePackageTools().buildXml(args2[1], args2[2], args2[3]);
        }
        if ("-pack".equals(args2[0])) {
            new CorePackageTools().buildPackage(args2[1], args2[2]);
        }
    }

    private void buildPackage(String path, String output) throws IOException {
        NpmPackage npm = NpmPackage.fromFolder(path);
        npm.loadAllFiles();
        npm.save(new FileOutputStream(output));
    }

    private void buildXml(String json, String xml, String version) throws FHIRFormatError, FileNotFoundException, IOException {
        for (File f : new File(Utilities.path(json, "package")).listFiles()) {
            if (!f.getName().endsWith(".json")) continue;
            new JsonTrackingParser();
            JsonObject j = JsonTrackingParser.parseJson(f);
            if (!j.has("resourceType") || !"1.4".equals(version)) continue;
            String n = f.getName();
            System.out.println(n);
            String xn = Utilities.changeFileExt(n, ".xml");
            Resource r = new JsonParser().parse((InputStream)new FileInputStream(f));
            new XmlParser().setOutputStyle(IParser.OutputStyle.NORMAL).compose((OutputStream)new FileOutputStream(Utilities.path(xml, "package", xn)), r);
        }
    }
}

