/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.loaders;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.convertors.advisors.VersionConvertorAdvisor50;
import org.hl7.fhir.convertors.loaders.BaseLoaderR5;
import org.hl7.fhir.dstu2016may.formats.JsonParser;
import org.hl7.fhir.dstu2016may.formats.XmlParser;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.FhirPublication;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;

public class R2016MayToR5Loader
extends BaseLoaderR5
implements VersionConvertorAdvisor50 {
    private List<CodeSystem> cslist = new ArrayList<CodeSystem>();

    public R2016MayToR5Loader(String[] types, BaseLoaderR5.ILoaderKnowledgeProvider lkp) {
        super(types, lkp);
    }

    @Override
    public Bundle loadBundle(InputStream stream, boolean isJson) throws FHIRException, IOException {
        Bundle b;
        org.hl7.fhir.dstu2016may.model.Resource r2016may = null;
        r2016may = isJson ? new JsonParser().parse(stream) : new XmlParser().parse(stream);
        Resource r5 = VersionConvertor_14_50.convertResource(r2016may);
        if (r5 instanceof Bundle) {
            b = (Bundle)r5;
        } else {
            b = new Bundle();
            b.setId(UUID.randomUUID().toString().toLowerCase());
            b.setType(Bundle.BundleType.COLLECTION);
            b.addEntry().setResource(r5).setFullUrl(r5 instanceof CanonicalResource ? ((CanonicalResource)r5).getUrl() : null);
        }
        for (CodeSystem codeSystem : this.cslist) {
            Bundle.BundleEntryComponent be = b.addEntry();
            be.setFullUrl(codeSystem.getUrl());
            be.setResource(codeSystem);
        }
        if (this.killPrimitives) {
            ArrayList<Bundle.BundleEntryComponent> remove = new ArrayList<Bundle.BundleEntryComponent>();
            for (Bundle.BundleEntryComponent be : b.getEntry()) {
                StructureDefinition sd;
                if (!be.hasResource() || !(be.getResource() instanceof StructureDefinition) || (sd = (StructureDefinition)be.getResource()).getKind() != StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) continue;
                remove.add(be);
            }
            b.getEntry().removeAll(remove);
        }
        for (Bundle.BundleEntryComponent bundleEntryComponent : b.getEntry()) {
            if (!bundleEntryComponent.hasResource() || !(bundleEntryComponent.getResource() instanceof StructureDefinition)) continue;
            StructureDefinition sd = (StructureDefinition)bundleEntryComponent.getResource();
            new ProfileUtilities(null, null, null).setIds(sd, false);
            if (!this.patchUrls) continue;
            sd.setUrl(sd.getUrl().replace("http://hl7.org/fhir/", "http://hl7.org/fhir/1.4/"));
            sd.addExtension().setUrl("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace").setValue(new UriType("http://hl7.org/fhir/"));
        }
        return b;
    }

    @Override
    public Resource loadResource(InputStream stream, boolean isJson) throws FHIRException, IOException {
        org.hl7.fhir.dstu2016may.model.Resource r2016may = null;
        r2016may = isJson ? new JsonParser().parse(stream) : new XmlParser().parse(stream);
        Resource r5 = VersionConvertor_14_50.convertResource(r2016may);
        this.setPath(r5);
        if (!this.cslist.isEmpty()) {
            throw new FHIRException("Error: Cannot have included code systems");
        }
        if (this.killPrimitives) {
            throw new FHIRException("Cannot kill primitives when using deferred loading");
        }
        if (this.patchUrls && r5 instanceof StructureDefinition) {
            StructureDefinition sd = (StructureDefinition)r5;
            sd.setUrl(sd.getUrl().replace("http://hl7.org/fhir/", "http://hl7.org/fhir/4.0/"));
            sd.addExtension().setUrl("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace").setValue(new UriType("http://hl7.org/fhir/"));
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                this.patchUrl(ed);
            }
            for (ElementDefinition ed : sd.getDifferential().getElement()) {
                this.patchUrl(ed);
            }
        }
        return r5;
    }

    private void patchUrl(ElementDefinition ed) {
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            for (CanonicalType s2 : tr.getTargetProfile()) {
                s2.setValue(((String)s2.getValue()).replace("http://hl7.org/fhir/", "http://hl7.org/fhir/1.4/"));
            }
            for (CanonicalType s2 : tr.getProfile()) {
                s2.setValue(((String)s2.getValue()).replace("http://hl7.org/fhir/", "http://hl7.org/fhir/1.4/"));
            }
        }
    }

    @Override
    public boolean ignoreEntry(Bundle.BundleEntryComponent src, FhirPublication publication) {
        return false;
    }

    @Override
    public void handleCodeSystem(CodeSystem cs, ValueSet vs) {
        cs.setId(vs.getId());
        cs.setValueSet(vs.getUrl());
        this.cslist.add(cs);
    }

    @Override
    public CodeSystem getCodeSystem(ValueSet src) {
        return null;
    }
}

