/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.loaders;

import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import org.hl7.fhir.convertors.loaders.R2016MayToR5Loader;
import org.hl7.fhir.convertors.loaders.R2ToR5Loader;
import org.hl7.fhir.convertors.loaders.R3ToR5Loader;
import org.hl7.fhir.convertors.loaders.R4ToR5Loader;
import org.hl7.fhir.convertors.loaders.R5ToR5Loader;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.npm.NpmPackage;

public abstract class BaseLoaderR5
implements IWorkerContext.IContextResourceLoader {
    protected final String URL_BASE = "http://hl7.org/fhir/";
    protected final String URL_DSTU2 = "http://hl7.org/fhir/1.0/";
    protected final String URL_DSTU2016MAY = "http://hl7.org/fhir/1.4/";
    protected final String URL_DSTU3 = "http://hl7.org/fhir/3.0/";
    protected final String URL_R4 = "http://hl7.org/fhir/4.0/";
    protected final String URL_ELEMENT_DEF_NAMESPACE = "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace";
    protected boolean patchUrls;
    protected boolean killPrimitives;
    protected String[] types;
    protected ILoaderKnowledgeProvider lkp;

    public BaseLoaderR5(String[] types, ILoaderKnowledgeProvider lkp) {
        this.types = types;
        this.lkp = lkp;
    }

    @Override
    public String[] getTypes() {
        return this.types;
    }

    public boolean isPatchUrls() {
        return this.patchUrls;
    }

    public BaseLoaderR5 setPatchUrls(boolean patchUrls) {
        this.patchUrls = patchUrls;
        return this;
    }

    public boolean isKillPrimitives() {
        return this.killPrimitives;
    }

    public BaseLoaderR5 setKillPrimitives(boolean killPrimitives) {
        this.killPrimitives = killPrimitives;
        return this;
    }

    @Override
    public String getResourcePath(Resource resource) {
        return this.lkp.getResourcePath(resource);
    }

    public void setPath(Resource r) {
        String path = this.lkp.getResourcePath(r);
        if (path != null) {
            r.setUserData("path", path);
        }
    }

    @Override
    public IWorkerContext.IContextResourceLoader getNewLoader(NpmPackage npm) throws JsonSyntaxException, IOException {
        BaseLoaderR5 ret = this.loaderFactory(npm);
        ret.patchUrls = this.patchUrls;
        ret.killPrimitives = this.killPrimitives;
        return ret;
    }

    protected BaseLoaderR5 loaderFactory(NpmPackage npm) throws JsonSyntaxException, IOException {
        if (VersionUtilities.isR5Ver(npm.fhirVersion())) {
            return new R5ToR5Loader(this.types, this.lkp.forNewPackage(npm));
        }
        if (VersionUtilities.isR4Ver(npm.fhirVersion())) {
            return new R4ToR5Loader(this.types, this.lkp.forNewPackage(npm));
        }
        if (VersionUtilities.isR3Ver(npm.fhirVersion())) {
            return new R3ToR5Loader(this.types, this.lkp.forNewPackage(npm));
        }
        if (VersionUtilities.isR2Ver(npm.fhirVersion())) {
            return new R2ToR5Loader(this.types, this.lkp.forNewPackage(npm));
        }
        if (VersionUtilities.isR2BVer(npm.fhirVersion())) {
            return new R2016MayToR5Loader(this.types, this.lkp.forNewPackage(npm));
        }
        throw new FHIRException("Unsupported FHIR Version " + npm.fhirVersion());
    }

    public static class NullLoaderKnowledgeProvider
    implements ILoaderKnowledgeProvider {
        @Override
        public String getResourcePath(Resource resource) {
            return null;
        }

        @Override
        public ILoaderKnowledgeProvider forNewPackage(NpmPackage npm) {
            return this;
        }
    }

    public static interface ILoaderKnowledgeProvider {
        public String getResourcePath(Resource var1);

        public ILoaderKnowledgeProvider forNewPackage(NpmPackage var1) throws JsonSyntaxException, IOException;
    }
}

