/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Questionnaire;

public class Questionnaire40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Questionnaire convertQuestionnaire(Questionnaire src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Questionnaire tgt = new org.hl7.fhir.r5.model.Questionnaire();
        Questionnaire40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(Questionnaire40_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Questionnaire40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(Questionnaire40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Questionnaire40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(Questionnaire40_50.convertString(src.getTitleElement()));
        }
        for (CanonicalType canonicalType : src.getDerivedFrom()) {
            tgt.getDerivedFrom().add(Questionnaire40_50.convertCanonical(canonicalType));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(Questionnaire40_50.convertBoolean(src.getExperimentalElement()));
        }
        for (CodeType codeType : src.getSubjectType()) {
            tgt.getSubjectType().add(Questionnaire40_50.convertResourceEnum(codeType));
        }
        if (src.hasDate()) {
            tgt.setDateElement(Questionnaire40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(Questionnaire40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(Questionnaire40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Questionnaire40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(Questionnaire40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(Questionnaire40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(Questionnaire40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(Questionnaire40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(Questionnaire40_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(Questionnaire40_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(Questionnaire40_50.convertPeriod(src.getEffectivePeriod()));
        }
        for (org.hl7.fhir.r4.model.Coding coding : src.getCode()) {
            tgt.addCode(Questionnaire40_50.convertCoding(coding));
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire40_50.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static Questionnaire convertQuestionnaire(org.hl7.fhir.r5.model.Questionnaire src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire tgt = new Questionnaire();
        Questionnaire40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(Questionnaire40_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Questionnaire40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(Questionnaire40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Questionnaire40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(Questionnaire40_50.convertString(src.getTitleElement()));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getDerivedFrom()) {
            tgt.getDerivedFrom().add(Questionnaire40_50.convertCanonical(canonicalType));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(Questionnaire40_50.convertBoolean(src.getExperimentalElement()));
        }
        for (org.hl7.fhir.r5.model.CodeType codeType : src.getSubjectType()) {
            tgt.getSubjectType().add(Questionnaire40_50.convertResourceEnum(codeType));
        }
        if (src.hasDate()) {
            tgt.setDateElement(Questionnaire40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(Questionnaire40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(Questionnaire40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Questionnaire40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(Questionnaire40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(Questionnaire40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(Questionnaire40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(Questionnaire40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(Questionnaire40_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(Questionnaire40_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(Questionnaire40_50.convertPeriod(src.getEffectivePeriod()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addCode(Questionnaire40_50.convertCoding(coding));
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire40_50.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemComponent convertQuestionnaireItemComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        Questionnaire40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLinkId()) {
            tgt.setLinkIdElement(Questionnaire40_50.convertString(src.getLinkIdElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(Questionnaire40_50.convertUri(src.getDefinitionElement()));
        }
        for (org.hl7.fhir.r4.model.Coding coding : src.getCode()) {
            tgt.addCode(Questionnaire40_50.convertCoding(coding));
        }
        if (src.hasPrefix()) {
            tgt.setPrefixElement(Questionnaire40_50.convertString(src.getPrefixElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(Questionnaire40_50.convertStringToMarkdown(src.getTextElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Questionnaire40_50.convertQuestionnaireItemType(src.getTypeElement()));
            if (src.getType() == Questionnaire.QuestionnaireItemType.CHOICE) {
                tgt.setAnswerConstraint(Questionnaire.QuestionnaireAnswerConstraint.OPTIONSONLY);
            } else if (src.getType() == Questionnaire.QuestionnaireItemType.OPENCHOICE) {
                tgt.setAnswerConstraint(Questionnaire.QuestionnaireAnswerConstraint.OPTIONSORSTRING);
            }
        }
        for (Questionnaire.QuestionnaireItemEnableWhenComponent questionnaireItemEnableWhenComponent : src.getEnableWhen()) {
            tgt.addEnableWhen(Questionnaire40_50.convertQuestionnaireItemEnableWhenComponent(questionnaireItemEnableWhenComponent));
        }
        if (src.hasEnableBehavior()) {
            tgt.setEnableBehaviorElement(Questionnaire40_50.convertEnableWhenBehavior(src.getEnableBehaviorElement()));
        }
        if (src.hasRequired()) {
            tgt.setRequiredElement(Questionnaire40_50.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasRepeats()) {
            tgt.setRepeatsElement(Questionnaire40_50.convertBoolean(src.getRepeatsElement()));
        }
        if (src.hasReadOnly()) {
            tgt.setReadOnlyElement(Questionnaire40_50.convertBoolean(src.getReadOnlyElement()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(Questionnaire40_50.convertInteger(src.getMaxLengthElement()));
        }
        if (src.hasAnswerValueSet()) {
            tgt.setAnswerValueSetElement(Questionnaire40_50.convertCanonical(src.getAnswerValueSetElement()));
        }
        for (Questionnaire.QuestionnaireItemAnswerOptionComponent questionnaireItemAnswerOptionComponent : src.getAnswerOption()) {
            tgt.addAnswerOption(Questionnaire40_50.convertQuestionnaireItemAnswerOptionComponent(questionnaireItemAnswerOptionComponent));
        }
        for (Questionnaire.QuestionnaireItemInitialComponent questionnaireItemInitialComponent : src.getInitial()) {
            tgt.addInitial(Questionnaire40_50.convertQuestionnaireItemInitialComponent(questionnaireItemInitialComponent));
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire40_50.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemComponent convertQuestionnaireItemComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        Questionnaire40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLinkId()) {
            tgt.setLinkIdElement(Questionnaire40_50.convertString(src.getLinkIdElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(Questionnaire40_50.convertUri(src.getDefinitionElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addCode(Questionnaire40_50.convertCoding(coding));
        }
        if (src.hasPrefix()) {
            tgt.setPrefixElement(Questionnaire40_50.convertString(src.getPrefixElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(Questionnaire40_50.convertString(src.getTextElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Questionnaire40_50.convertQuestionnaireItemType(src.getTypeElement(), src.getAnswerConstraint()));
        }
        for (Questionnaire.QuestionnaireItemEnableWhenComponent questionnaireItemEnableWhenComponent : src.getEnableWhen()) {
            tgt.addEnableWhen(Questionnaire40_50.convertQuestionnaireItemEnableWhenComponent(questionnaireItemEnableWhenComponent));
        }
        if (src.hasEnableBehavior()) {
            tgt.setEnableBehaviorElement(Questionnaire40_50.convertEnableWhenBehavior(src.getEnableBehaviorElement()));
        }
        if (src.hasRequired()) {
            tgt.setRequiredElement(Questionnaire40_50.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasRepeats()) {
            tgt.setRepeatsElement(Questionnaire40_50.convertBoolean(src.getRepeatsElement()));
        }
        if (src.hasReadOnly()) {
            tgt.setReadOnlyElement(Questionnaire40_50.convertBoolean(src.getReadOnlyElement()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(Questionnaire40_50.convertInteger(src.getMaxLengthElement()));
        }
        if (src.hasAnswerValueSet()) {
            tgt.setAnswerValueSetElement(Questionnaire40_50.convertCanonical(src.getAnswerValueSetElement()));
        }
        for (Questionnaire.QuestionnaireItemAnswerOptionComponent questionnaireItemAnswerOptionComponent : src.getAnswerOption()) {
            tgt.addAnswerOption(Questionnaire40_50.convertQuestionnaireItemAnswerOptionComponent(questionnaireItemAnswerOptionComponent));
        }
        for (Questionnaire.QuestionnaireItemInitialComponent questionnaireItemInitialComponent : src.getInitial()) {
            tgt.addInitial(Questionnaire40_50.convertQuestionnaireItemInitialComponent(questionnaireItemInitialComponent));
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire40_50.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Questionnaire.QuestionnaireItemType> convertQuestionnaireItemType(Enumeration<Questionnaire.QuestionnaireItemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Questionnaire.QuestionnaireItemType> tgt = new org.hl7.fhir.r5.model.Enumeration<Questionnaire.QuestionnaireItemType>(new Questionnaire.QuestionnaireItemTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Questionnaire.QuestionnaireItemType)((Object)src.getValue())) {
            case GROUP: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.GROUP);
                break;
            }
            case DISPLAY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DISPLAY);
                break;
            }
            case QUESTION: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.GROUP);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.BOOLEAN);
                break;
            }
            case DECIMAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DECIMAL);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.INTEGER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATE);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATETIME);
                break;
            }
            case TIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TIME);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.STRING);
                break;
            }
            case TEXT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TEXT);
                break;
            }
            case URL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.URL);
                break;
            }
            case CHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.CODING);
                break;
            }
            case OPENCHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.CODING);
                break;
            }
            case ATTACHMENT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.ATTACHMENT);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.REFERENCE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.QUANTITY);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Questionnaire.QuestionnaireItemType> convertQuestionnaireItemType(org.hl7.fhir.r5.model.Enumeration<Questionnaire.QuestionnaireItemType> src, Questionnaire.QuestionnaireAnswerConstraint constraint) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Questionnaire.QuestionnaireItemType> tgt = new Enumeration<Questionnaire.QuestionnaireItemType>(new Questionnaire.QuestionnaireItemTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Questionnaire.QuestionnaireItemType)((Object)src.getValue())) {
            case GROUP: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.GROUP);
                break;
            }
            case DISPLAY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DISPLAY);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.BOOLEAN);
                break;
            }
            case DECIMAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DECIMAL);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.INTEGER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATE);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATETIME);
                break;
            }
            case TIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TIME);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.STRING);
                break;
            }
            case TEXT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TEXT);
                break;
            }
            case URL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.URL);
                break;
            }
            case CODING: {
                if (constraint == Questionnaire.QuestionnaireAnswerConstraint.OPTIONSORSTRING) {
                    tgt.setValue((Object)Questionnaire.QuestionnaireItemType.OPENCHOICE);
                    break;
                }
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.CHOICE);
                break;
            }
            case ATTACHMENT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.ATTACHMENT);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.REFERENCE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.QUANTITY);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Questionnaire.EnableWhenBehavior> convertEnableWhenBehavior(Enumeration<Questionnaire.EnableWhenBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Questionnaire.EnableWhenBehavior> tgt = new org.hl7.fhir.r5.model.Enumeration<Questionnaire.EnableWhenBehavior>(new Questionnaire.EnableWhenBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Questionnaire.EnableWhenBehavior)((Object)src.getValue())) {
            case ALL: {
                tgt.setValue((Object)Questionnaire.EnableWhenBehavior.ALL);
                break;
            }
            case ANY: {
                tgt.setValue((Object)Questionnaire.EnableWhenBehavior.ANY);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.EnableWhenBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Questionnaire.EnableWhenBehavior> convertEnableWhenBehavior(org.hl7.fhir.r5.model.Enumeration<Questionnaire.EnableWhenBehavior> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Questionnaire.EnableWhenBehavior> tgt = new Enumeration<Questionnaire.EnableWhenBehavior>(new Questionnaire.EnableWhenBehaviorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Questionnaire.EnableWhenBehavior)((Object)src.getValue())) {
            case ALL: {
                tgt.setValue((Object)Questionnaire.EnableWhenBehavior.ALL);
                break;
            }
            case ANY: {
                tgt.setValue((Object)Questionnaire.EnableWhenBehavior.ANY);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.EnableWhenBehavior.NULL);
            }
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemEnableWhenComponent convertQuestionnaireItemEnableWhenComponent(Questionnaire.QuestionnaireItemEnableWhenComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemEnableWhenComponent tgt = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        Questionnaire40_50.copyElement(src, tgt, new String[0]);
        if (src.hasQuestion()) {
            tgt.setQuestionElement(Questionnaire40_50.convertString(src.getQuestionElement()));
        }
        if (src.hasOperator()) {
            tgt.setOperatorElement(Questionnaire40_50.convertQuestionnaireItemOperator(src.getOperatorElement()));
        }
        if (src.hasAnswer()) {
            tgt.setAnswer(Questionnaire40_50.convertType(src.getAnswer()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemEnableWhenComponent convertQuestionnaireItemEnableWhenComponent(Questionnaire.QuestionnaireItemEnableWhenComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemEnableWhenComponent tgt = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        Questionnaire40_50.copyElement(src, tgt, new String[0]);
        if (src.hasQuestion()) {
            tgt.setQuestionElement(Questionnaire40_50.convertString(src.getQuestionElement()));
        }
        if (src.hasOperator()) {
            tgt.setOperatorElement(Questionnaire40_50.convertQuestionnaireItemOperator(src.getOperatorElement()));
        }
        if (src.hasAnswer()) {
            tgt.setAnswer(Questionnaire40_50.convertType(src.getAnswer()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Questionnaire.QuestionnaireItemOperator> convertQuestionnaireItemOperator(Enumeration<Questionnaire.QuestionnaireItemOperator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Questionnaire.QuestionnaireItemOperator> tgt = new org.hl7.fhir.r5.model.Enumeration<Questionnaire.QuestionnaireItemOperator>(new Questionnaire.QuestionnaireItemOperatorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Questionnaire.QuestionnaireItemOperator)((Object)src.getValue())) {
            case EXISTS: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.EXISTS);
                break;
            }
            case EQUAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.EQUAL);
                break;
            }
            case NOT_EQUAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.NOT_EQUAL);
                break;
            }
            case GREATER_THAN: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.GREATER_THAN);
                break;
            }
            case LESS_THAN: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.LESS_THAN);
                break;
            }
            case GREATER_OR_EQUAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.GREATER_OR_EQUAL);
                break;
            }
            case LESS_OR_EQUAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.LESS_OR_EQUAL);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Questionnaire.QuestionnaireItemOperator> convertQuestionnaireItemOperator(org.hl7.fhir.r5.model.Enumeration<Questionnaire.QuestionnaireItemOperator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Questionnaire.QuestionnaireItemOperator> tgt = new Enumeration<Questionnaire.QuestionnaireItemOperator>(new Questionnaire.QuestionnaireItemOperatorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Questionnaire.QuestionnaireItemOperator)((Object)src.getValue())) {
            case EXISTS: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.EXISTS);
                break;
            }
            case EQUAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.EQUAL);
                break;
            }
            case NOT_EQUAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.NOT_EQUAL);
                break;
            }
            case GREATER_THAN: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.GREATER_THAN);
                break;
            }
            case LESS_THAN: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.LESS_THAN);
                break;
            }
            case GREATER_OR_EQUAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.GREATER_OR_EQUAL);
                break;
            }
            case LESS_OR_EQUAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.LESS_OR_EQUAL);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemOperator.NULL);
            }
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemAnswerOptionComponent convertQuestionnaireItemAnswerOptionComponent(Questionnaire.QuestionnaireItemAnswerOptionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemAnswerOptionComponent tgt = new Questionnaire.QuestionnaireItemAnswerOptionComponent();
        Questionnaire40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(Questionnaire40_50.convertType(src.getValue()));
        }
        if (src.hasInitialSelected()) {
            tgt.setInitialSelectedElement(Questionnaire40_50.convertBoolean(src.getInitialSelectedElement()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemAnswerOptionComponent convertQuestionnaireItemAnswerOptionComponent(Questionnaire.QuestionnaireItemAnswerOptionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemAnswerOptionComponent tgt = new Questionnaire.QuestionnaireItemAnswerOptionComponent();
        Questionnaire40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(Questionnaire40_50.convertType(src.getValue()));
        }
        if (src.hasInitialSelected()) {
            tgt.setInitialSelectedElement(Questionnaire40_50.convertBoolean(src.getInitialSelectedElement()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemInitialComponent convertQuestionnaireItemInitialComponent(Questionnaire.QuestionnaireItemInitialComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemInitialComponent tgt = new Questionnaire.QuestionnaireItemInitialComponent();
        Questionnaire40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(Questionnaire40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemInitialComponent convertQuestionnaireItemInitialComponent(Questionnaire.QuestionnaireItemInitialComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemInitialComponent tgt = new Questionnaire.QuestionnaireItemInitialComponent();
        Questionnaire40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(Questionnaire40_50.convertType(src.getValue()));
        }
        return tgt;
    }
}

