/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Reference;

public class Observation40_50
extends VersionConvertor_40_50 {
    public static Observation convertObservation(org.hl7.fhir.r4.model.Observation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation tgt = new Observation();
        Observation40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Observation40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(Observation40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(Observation40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Observation40_50.convertObservationStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Observation40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(Observation40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Observation40_50.convertReference(src.getSubject()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getFocus()) {
            tgt.addFocus(Observation40_50.convertReference(reference));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Observation40_50.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(Observation40_50.convertType(src.getEffective()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(Observation40_50.convertInstant(src.getIssuedElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPerformer()) {
            tgt.addPerformer(Observation40_50.convertReference(reference));
        }
        if (src.hasValue()) {
            tgt.setValue(Observation40_50.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(Observation40_50.convertCodeableConcept(src.getDataAbsentReason()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getInterpretation()) {
            tgt.addInterpretation(Observation40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(Observation40_50.convertAnnotation(annotation));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(Observation40_50.convertCodeableConcept(src.getBodySite()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(Observation40_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(Observation40_50.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(Observation40_50.convertReference(src.getDevice()));
        }
        for (Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation40_50.convertObservationReferenceRangeComponent(observationReferenceRangeComponent));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getHasMember()) {
            tgt.addHasMember(Observation40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getDerivedFrom()) {
            tgt.addDerivedFrom(Observation40_50.convertReference(reference));
        }
        for (Observation.ObservationComponentComponent observationComponentComponent : src.getComponent()) {
            tgt.addComponent(Observation40_50.convertObservationComponentComponent(observationComponentComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Observation convertObservation(Observation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Observation tgt = new org.hl7.fhir.r4.model.Observation();
        Observation40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Observation40_50.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(Observation40_50.convertReference(reference));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(Observation40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Observation40_50.convertObservationStatus(src.getStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Observation40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(Observation40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Observation40_50.convertReference(src.getSubject()));
        }
        for (Reference reference : src.getFocus()) {
            tgt.addFocus(Observation40_50.convertReference(reference));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Observation40_50.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(Observation40_50.convertType(src.getEffective()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(Observation40_50.convertInstant(src.getIssuedElement()));
        }
        for (Reference reference : src.getPerformer()) {
            tgt.addPerformer(Observation40_50.convertReference(reference));
        }
        if (src.hasValue()) {
            tgt.setValue(Observation40_50.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(Observation40_50.convertCodeableConcept(src.getDataAbsentReason()));
        }
        for (CodeableConcept codeableConcept : src.getInterpretation()) {
            tgt.addInterpretation(Observation40_50.convertCodeableConcept(codeableConcept));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(Observation40_50.convertAnnotation(annotation));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(Observation40_50.convertCodeableConcept(src.getBodySite()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(Observation40_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(Observation40_50.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(Observation40_50.convertReference(src.getDevice()));
        }
        for (Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation40_50.convertObservationReferenceRangeComponent(observationReferenceRangeComponent));
        }
        for (Reference reference : src.getHasMember()) {
            tgt.addHasMember(Observation40_50.convertReference(reference));
        }
        for (Reference reference : src.getDerivedFrom()) {
            tgt.addDerivedFrom(Observation40_50.convertReference(reference));
        }
        for (Observation.ObservationComponentComponent observationComponentComponent : src.getComponent()) {
            tgt.addComponent(Observation40_50.convertObservationComponentComponent(observationComponentComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus> convertObservationStatus(Enumeration<Observation.ObservationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus>(new Enumerations.ObservationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Observation.ObservationStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)Enumerations.ObservationStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Enumerations.ObservationStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.CORRECTED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.ObservationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.ObservationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ObservationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Observation.ObservationStatus> convertObservationStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Observation.ObservationStatus> tgt = new Enumeration<Observation.ObservationStatus>(new Observation.ObservationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ObservationStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)Observation.ObservationStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)Observation.ObservationStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Observation.ObservationStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Observation.ObservationStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)Observation.ObservationStatus.CORRECTED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Observation.ObservationStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Observation.ObservationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Observation.ObservationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Observation.ObservationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Observation.ObservationReferenceRangeComponent convertObservationReferenceRangeComponent(Observation.ObservationReferenceRangeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationReferenceRangeComponent tgt = new Observation.ObservationReferenceRangeComponent();
        Observation40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(Observation40_50.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(Observation40_50.convertSimpleQuantity(src.getHigh()));
        }
        if (src.hasType()) {
            tgt.setType(Observation40_50.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getAppliesTo()) {
            tgt.addAppliesTo(Observation40_50.convertCodeableConcept(t));
        }
        if (src.hasAge()) {
            tgt.setAge(Observation40_50.convertRange(src.getAge()));
        }
        if (src.hasText()) {
            tgt.setTextElement(Observation40_50.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static Observation.ObservationReferenceRangeComponent convertObservationReferenceRangeComponent(Observation.ObservationReferenceRangeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationReferenceRangeComponent tgt = new Observation.ObservationReferenceRangeComponent();
        Observation40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(Observation40_50.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(Observation40_50.convertSimpleQuantity(src.getHigh()));
        }
        if (src.hasType()) {
            tgt.setType(Observation40_50.convertCodeableConcept(src.getType()));
        }
        for (CodeableConcept t : src.getAppliesTo()) {
            tgt.addAppliesTo(Observation40_50.convertCodeableConcept(t));
        }
        if (src.hasAge()) {
            tgt.setAge(Observation40_50.convertRange(src.getAge()));
        }
        if (src.hasText()) {
            tgt.setTextElement(Observation40_50.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static Observation.ObservationComponentComponent convertObservationComponentComponent(Observation.ObservationComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationComponentComponent tgt = new Observation.ObservationComponentComponent();
        Observation40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(Observation40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(Observation40_50.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(Observation40_50.convertCodeableConcept(src.getDataAbsentReason()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getInterpretation()) {
            tgt.addInterpretation(Observation40_50.convertCodeableConcept(codeableConcept));
        }
        for (Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation40_50.convertObservationReferenceRangeComponent(observationReferenceRangeComponent));
        }
        return tgt;
    }

    public static Observation.ObservationComponentComponent convertObservationComponentComponent(Observation.ObservationComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationComponentComponent tgt = new Observation.ObservationComponentComponent();
        Observation40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(Observation40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(Observation40_50.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(Observation40_50.convertCodeableConcept(src.getDataAbsentReason()));
        }
        for (CodeableConcept codeableConcept : src.getInterpretation()) {
            tgt.addInterpretation(Observation40_50.convertCodeableConcept(codeableConcept));
        }
        for (Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation40_50.convertObservationReferenceRangeComponent(observationReferenceRangeComponent));
        }
        return tgt;
    }
}

