/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.Reference;

public class MedicationDispense40_50
extends VersionConvertor_40_50 {
    public static MedicationDispense convertMedicationDispense(org.hl7.fhir.r4.model.MedicationDispense src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationDispense tgt = new MedicationDispense();
        MedicationDispense40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MedicationDispense40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(MedicationDispense40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationDispense40_50.convertMedicationStatus(src.getStatusElement()));
        }
        if (src.hasStatusReasonCodeableConcept()) {
            tgt.getStatusReason().setConcept(MedicationDispense40_50.convertCodeableConcept(src.getStatusReasonCodeableConcept()));
        }
        if (src.hasStatusReasonReference()) {
            tgt.getStatusReason().setReference(MedicationDispense40_50.convertReference(src.getStatusReasonReference()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(MedicationDispense40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedicationCodeableConcept()) {
            tgt.getMedication().setConcept(MedicationDispense40_50.convertCodeableConcept(src.getMedicationCodeableConcept()));
        }
        if (src.hasMedicationReference()) {
            tgt.getMedication().setReference(MedicationDispense40_50.convertReference(src.getMedicationReference()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(MedicationDispense40_50.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(MedicationDispense40_50.convertReference(src.getContext()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(MedicationDispense40_50.convertReference(reference));
        }
        for (MedicationDispense.MedicationDispensePerformerComponent medicationDispensePerformerComponent : src.getPerformer()) {
            tgt.addPerformer(MedicationDispense40_50.convertMedicationDispensePerformerComponent(medicationDispensePerformerComponent));
        }
        if (src.hasLocation()) {
            tgt.setLocation(MedicationDispense40_50.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getAuthorizingPrescription()) {
            tgt.addAuthorizingPrescription(MedicationDispense40_50.convertReference(reference));
        }
        if (src.hasType()) {
            tgt.setType(MedicationDispense40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(MedicationDispense40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDaysSupply()) {
            tgt.setDaysSupply(MedicationDispense40_50.convertSimpleQuantity(src.getDaysSupply()));
        }
        if (src.hasWhenPrepared()) {
            tgt.setWhenPreparedElement(MedicationDispense40_50.convertDateTime(src.getWhenPreparedElement()));
        }
        if (src.hasWhenHandedOver()) {
            tgt.setWhenHandedOverElement(MedicationDispense40_50.convertDateTime(src.getWhenHandedOverElement()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(MedicationDispense40_50.convertReference(src.getDestination()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReceiver()) {
            tgt.addReceiver(MedicationDispense40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(MedicationDispense40_50.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.r4.model.Dosage dosage : src.getDosageInstruction()) {
            tgt.addDosageInstruction(MedicationDispense40_50.convertDosage(dosage));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationDispense40_50.convertMedicationDispenseSubstitutionComponent(src.getSubstitution()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getDetectedIssue()) {
            tgt.addDetectedIssue(MedicationDispense40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(MedicationDispense40_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MedicationDispense convertMedicationDispense(MedicationDispense src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.MedicationDispense tgt = new org.hl7.fhir.r4.model.MedicationDispense();
        MedicationDispense40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MedicationDispense40_50.convertIdentifier(identifier));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(MedicationDispense40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationDispense40_50.convertStatus(src.getStatusElement()));
        }
        if (src.getStatusReason().hasConcept()) {
            tgt.setStatusReason(MedicationDispense40_50.convertType(src.getStatusReason().getConcept()));
        }
        if (src.getStatusReason().hasReference()) {
            tgt.setStatusReason(MedicationDispense40_50.convertType(src.getStatusReason().getReference()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(MedicationDispense40_50.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.getMedication().hasConcept()) {
            tgt.setMedication(MedicationDispense40_50.convertType(src.getMedication().getConcept()));
        }
        if (src.getMedication().hasReference()) {
            tgt.setMedication(MedicationDispense40_50.convertType(src.getMedication().getReference()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(MedicationDispense40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(MedicationDispense40_50.convertReference(src.getEncounter()));
        }
        for (Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(MedicationDispense40_50.convertReference(reference));
        }
        for (MedicationDispense.MedicationDispensePerformerComponent medicationDispensePerformerComponent : src.getPerformer()) {
            tgt.addPerformer(MedicationDispense40_50.convertMedicationDispensePerformerComponent(medicationDispensePerformerComponent));
        }
        if (src.hasLocation()) {
            tgt.setLocation(MedicationDispense40_50.convertReference(src.getLocation()));
        }
        for (Reference reference : src.getAuthorizingPrescription()) {
            tgt.addAuthorizingPrescription(MedicationDispense40_50.convertReference(reference));
        }
        if (src.hasType()) {
            tgt.setType(MedicationDispense40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(MedicationDispense40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDaysSupply()) {
            tgt.setDaysSupply(MedicationDispense40_50.convertSimpleQuantity(src.getDaysSupply()));
        }
        if (src.hasWhenPrepared()) {
            tgt.setWhenPreparedElement(MedicationDispense40_50.convertDateTime(src.getWhenPreparedElement()));
        }
        if (src.hasWhenHandedOver()) {
            tgt.setWhenHandedOverElement(MedicationDispense40_50.convertDateTime(src.getWhenHandedOverElement()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(MedicationDispense40_50.convertReference(src.getDestination()));
        }
        for (Reference reference : src.getReceiver()) {
            tgt.addReceiver(MedicationDispense40_50.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(MedicationDispense40_50.convertAnnotation(annotation));
        }
        for (Dosage dosage : src.getDosageInstruction()) {
            tgt.addDosageInstruction(MedicationDispense40_50.convertDosage(dosage));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationDispense40_50.convertMedicationDispenseSubstitutionComponent(src.getSubstitution()));
        }
        for (Reference reference : src.getDetectedIssue()) {
            tgt.addDetectedIssue(MedicationDispense40_50.convertReference(reference));
        }
        for (Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(MedicationDispense40_50.convertReference(reference));
        }
        return tgt;
    }

    private static Enumeration<MedicationDispense.MedicationDispenseStatus> convertStatus(org.hl7.fhir.r5.model.Enumeration<MedicationDispense.MedicationDispenseStatusCodes> src) {
        if (src == null) {
            return null;
        }
        Enumeration<MedicationDispense.MedicationDispenseStatus> tgt = new Enumeration<MedicationDispense.MedicationDispenseStatus>(new MedicationDispense.MedicationDispenseStatusEnumFactory());
        MedicationDispense40_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationDispense.MedicationDispenseStatusCodes)((Object)src.getValue())) {
            case CANCELLED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.CANCELLED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.COMPLETED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.DECLINED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.ENTEREDINERROR);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.INPROGRESS);
                break;
            }
            case NULL: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.NULL);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.ONHOLD);
                break;
            }
            case PREPARATION: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.PREPARATION);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.STOPPED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.UNKNOWN);
            }
        }
        return tgt;
    }

    private static org.hl7.fhir.r5.model.Enumeration<MedicationDispense.MedicationDispenseStatusCodes> convertMedicationStatus(Enumeration<MedicationDispense.MedicationDispenseStatus> src) {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MedicationDispense.MedicationDispenseStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<MedicationDispense.MedicationDispenseStatusCodes>(new MedicationDispense.MedicationDispenseStatusCodesEnumFactory());
        MedicationDispense40_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationDispense.MedicationDispenseStatus)((Object)src.getValue())) {
            case CANCELLED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.CANCELLED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.COMPLETED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.DECLINED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.ENTEREDINERROR);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.INPROGRESS);
                break;
            }
            case NULL: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.NULL);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.ONHOLD);
                break;
            }
            case PREPARATION: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.PREPARATION);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.STOPPED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.UNKNOWN);
            }
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispensePerformerComponent convertMedicationDispensePerformerComponent(MedicationDispense.MedicationDispensePerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationDispense.MedicationDispensePerformerComponent tgt = new MedicationDispense.MedicationDispensePerformerComponent();
        MedicationDispense40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFunction()) {
            tgt.setFunction(MedicationDispense40_50.convertCodeableConcept(src.getFunction()));
        }
        if (src.hasActor()) {
            tgt.setActor(MedicationDispense40_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispensePerformerComponent convertMedicationDispensePerformerComponent(MedicationDispense.MedicationDispensePerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationDispense.MedicationDispensePerformerComponent tgt = new MedicationDispense.MedicationDispensePerformerComponent();
        MedicationDispense40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFunction()) {
            tgt.setFunction(MedicationDispense40_50.convertCodeableConcept(src.getFunction()));
        }
        if (src.hasActor()) {
            tgt.setActor(MedicationDispense40_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispenseSubstitutionComponent convertMedicationDispenseSubstitutionComponent(MedicationDispense.MedicationDispenseSubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationDispense.MedicationDispenseSubstitutionComponent tgt = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        MedicationDispense40_50.copyElement(src, tgt, new String[0]);
        if (src.hasWasSubstituted()) {
            tgt.setWasSubstitutedElement(MedicationDispense40_50.convertBoolean(src.getWasSubstitutedElement()));
        }
        if (src.hasType()) {
            tgt.setType(MedicationDispense40_50.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReason(MedicationDispense40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getResponsibleParty()) {
            tgt.setResponsibleParty(MedicationDispense40_50.convertReference(reference));
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispenseSubstitutionComponent convertMedicationDispenseSubstitutionComponent(MedicationDispense.MedicationDispenseSubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationDispense.MedicationDispenseSubstitutionComponent tgt = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        MedicationDispense40_50.copyElement(src, tgt, new String[0]);
        if (src.hasWasSubstituted()) {
            tgt.setWasSubstitutedElement(MedicationDispense40_50.convertBoolean(src.getWasSubstitutedElement()));
        }
        if (src.hasType()) {
            tgt.setType(MedicationDispense40_50.convertCodeableConcept(src.getType()));
        }
        for (CodeableConcept t : src.getReason()) {
            tgt.addReason(MedicationDispense40_50.convertCodeableConcept(t));
        }
        if (src.hasResponsibleParty()) {
            tgt.addResponsibleParty(MedicationDispense40_50.convertReference(src.getResponsibleParty()));
        }
        return tgt;
    }
}

