/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Reference;

public class MeasureReport40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.MeasureReport convertMeasureReport(MeasureReport src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.MeasureReport tgt = new org.hl7.fhir.r5.model.MeasureReport();
        MeasureReport40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MeasureReport40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MeasureReport40_50.convertMeasureReportStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(MeasureReport40_50.convertMeasureReportType(src.getTypeElement()));
        }
        if (src.hasMeasure()) {
            tgt.setMeasureElement(MeasureReport40_50.convertCanonical(src.getMeasureElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(MeasureReport40_50.convertReference(src.getSubject()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(MeasureReport40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasReporter()) {
            tgt.setReporter(MeasureReport40_50.convertReference(src.getReporter()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(MeasureReport40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasImprovementNotation()) {
            tgt.setImprovementNotation(MeasureReport40_50.convertCodeableConcept(src.getImprovementNotation()));
        }
        for (MeasureReport.MeasureReportGroupComponent measureReportGroupComponent : src.getGroup()) {
            tgt.addGroup(MeasureReport40_50.convertMeasureReportGroupComponent(measureReportGroupComponent));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEvaluatedResource()) {
            tgt.addEvaluatedResource(MeasureReport40_50.convertReference(reference));
        }
        return tgt;
    }

    public static MeasureReport convertMeasureReport(org.hl7.fhir.r5.model.MeasureReport src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MeasureReport tgt = new MeasureReport();
        MeasureReport40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MeasureReport40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MeasureReport40_50.convertMeasureReportStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(MeasureReport40_50.convertMeasureReportType(src.getTypeElement()));
        }
        if (src.hasMeasure()) {
            tgt.setMeasureElement(MeasureReport40_50.convertCanonical(src.getMeasureElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(MeasureReport40_50.convertReference(src.getSubject()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(MeasureReport40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasReporter()) {
            tgt.setReporter(MeasureReport40_50.convertReference(src.getReporter()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(MeasureReport40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasImprovementNotation()) {
            tgt.setImprovementNotation(MeasureReport40_50.convertCodeableConcept(src.getImprovementNotation()));
        }
        for (MeasureReport.MeasureReportGroupComponent measureReportGroupComponent : src.getGroup()) {
            tgt.addGroup(MeasureReport40_50.convertMeasureReportGroupComponent(measureReportGroupComponent));
        }
        for (Reference reference : src.getEvaluatedResource()) {
            tgt.addEvaluatedResource(MeasureReport40_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<MeasureReport.MeasureReportStatus> convertMeasureReportStatus(Enumeration<MeasureReport.MeasureReportStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MeasureReport.MeasureReportStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<MeasureReport.MeasureReportStatus>(new MeasureReport.MeasureReportStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MeasureReport.MeasureReportStatus)((Object)src.getValue())) {
            case COMPLETE: {
                tgt.setValue((Object)MeasureReport.MeasureReportStatus.COMPLETE);
                break;
            }
            case PENDING: {
                tgt.setValue((Object)MeasureReport.MeasureReportStatus.PENDING);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)MeasureReport.MeasureReportStatus.ERROR);
                break;
            }
            default: {
                tgt.setValue((Object)MeasureReport.MeasureReportStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MeasureReport.MeasureReportStatus> convertMeasureReportStatus(org.hl7.fhir.r5.model.Enumeration<MeasureReport.MeasureReportStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MeasureReport.MeasureReportStatus> tgt = new Enumeration<MeasureReport.MeasureReportStatus>(new MeasureReport.MeasureReportStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MeasureReport.MeasureReportStatus)((Object)src.getValue())) {
            case COMPLETE: {
                tgt.setValue((Object)MeasureReport.MeasureReportStatus.COMPLETE);
                break;
            }
            case PENDING: {
                tgt.setValue((Object)MeasureReport.MeasureReportStatus.PENDING);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)MeasureReport.MeasureReportStatus.ERROR);
                break;
            }
            default: {
                tgt.setValue((Object)MeasureReport.MeasureReportStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<MeasureReport.MeasureReportType> convertMeasureReportType(Enumeration<MeasureReport.MeasureReportType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MeasureReport.MeasureReportType> tgt = new org.hl7.fhir.r5.model.Enumeration<MeasureReport.MeasureReportType>(new MeasureReport.MeasureReportTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MeasureReport.MeasureReportType)((Object)src.getValue())) {
            case INDIVIDUAL: {
                tgt.setValue((Object)MeasureReport.MeasureReportType.INDIVIDUAL);
                break;
            }
            case SUBJECTLIST: {
                tgt.setValue((Object)MeasureReport.MeasureReportType.SUBJECTLIST);
                break;
            }
            case SUMMARY: {
                tgt.setValue((Object)MeasureReport.MeasureReportType.SUMMARY);
                break;
            }
            case DATACOLLECTION: {
                tgt.setValue((Object)MeasureReport.MeasureReportType.DATACOLLECTION);
                break;
            }
            default: {
                tgt.setValue((Object)MeasureReport.MeasureReportType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MeasureReport.MeasureReportType> convertMeasureReportType(org.hl7.fhir.r5.model.Enumeration<MeasureReport.MeasureReportType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MeasureReport.MeasureReportType> tgt = new Enumeration<MeasureReport.MeasureReportType>(new MeasureReport.MeasureReportTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MeasureReport.MeasureReportType)((Object)src.getValue())) {
            case INDIVIDUAL: {
                tgt.setValue((Object)MeasureReport.MeasureReportType.INDIVIDUAL);
                break;
            }
            case SUBJECTLIST: {
                tgt.setValue((Object)MeasureReport.MeasureReportType.SUBJECTLIST);
                break;
            }
            case SUMMARY: {
                tgt.setValue((Object)MeasureReport.MeasureReportType.SUMMARY);
                break;
            }
            case DATACOLLECTION: {
                tgt.setValue((Object)MeasureReport.MeasureReportType.DATACOLLECTION);
                break;
            }
            default: {
                tgt.setValue((Object)MeasureReport.MeasureReportType.NULL);
            }
        }
        return tgt;
    }

    public static MeasureReport.MeasureReportGroupComponent convertMeasureReportGroupComponent(MeasureReport.MeasureReportGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MeasureReport.MeasureReportGroupComponent tgt = new MeasureReport.MeasureReportGroupComponent();
        MeasureReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(MeasureReport40_50.convertCodeableConcept(src.getCode()));
        }
        for (MeasureReport.MeasureReportGroupPopulationComponent measureReportGroupPopulationComponent : src.getPopulation()) {
            tgt.addPopulation(MeasureReport40_50.convertMeasureReportGroupPopulationComponent(measureReportGroupPopulationComponent));
        }
        if (src.hasMeasureScore()) {
            tgt.setMeasureScore(MeasureReport40_50.convertQuantity(src.getMeasureScore()));
        }
        for (MeasureReport.MeasureReportGroupStratifierComponent measureReportGroupStratifierComponent : src.getStratifier()) {
            tgt.addStratifier(MeasureReport40_50.convertMeasureReportGroupStratifierComponent(measureReportGroupStratifierComponent));
        }
        return tgt;
    }

    public static MeasureReport.MeasureReportGroupComponent convertMeasureReportGroupComponent(MeasureReport.MeasureReportGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MeasureReport.MeasureReportGroupComponent tgt = new MeasureReport.MeasureReportGroupComponent();
        MeasureReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(MeasureReport40_50.convertCodeableConcept(src.getCode()));
        }
        for (MeasureReport.MeasureReportGroupPopulationComponent measureReportGroupPopulationComponent : src.getPopulation()) {
            tgt.addPopulation(MeasureReport40_50.convertMeasureReportGroupPopulationComponent(measureReportGroupPopulationComponent));
        }
        if (src.hasMeasureScoreQuantity()) {
            tgt.setMeasureScore(MeasureReport40_50.convertQuantity(src.getMeasureScoreQuantity()));
        }
        for (MeasureReport.MeasureReportGroupStratifierComponent measureReportGroupStratifierComponent : src.getStratifier()) {
            tgt.addStratifier(MeasureReport40_50.convertMeasureReportGroupStratifierComponent(measureReportGroupStratifierComponent));
        }
        return tgt;
    }

    public static MeasureReport.MeasureReportGroupPopulationComponent convertMeasureReportGroupPopulationComponent(MeasureReport.MeasureReportGroupPopulationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MeasureReport.MeasureReportGroupPopulationComponent tgt = new MeasureReport.MeasureReportGroupPopulationComponent();
        MeasureReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(MeasureReport40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasCount()) {
            tgt.setCountElement(MeasureReport40_50.convertInteger(src.getCountElement()));
        }
        if (src.hasSubjectResults()) {
            tgt.setSubjectResults(MeasureReport40_50.convertReference(src.getSubjectResults()));
        }
        return tgt;
    }

    public static MeasureReport.MeasureReportGroupPopulationComponent convertMeasureReportGroupPopulationComponent(MeasureReport.MeasureReportGroupPopulationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MeasureReport.MeasureReportGroupPopulationComponent tgt = new MeasureReport.MeasureReportGroupPopulationComponent();
        MeasureReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(MeasureReport40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasCount()) {
            tgt.setCountElement(MeasureReport40_50.convertInteger(src.getCountElement()));
        }
        if (src.hasSubjectResults()) {
            tgt.setSubjectResults(MeasureReport40_50.convertReference(src.getSubjectResults()));
        }
        return tgt;
    }

    public static MeasureReport.MeasureReportGroupStratifierComponent convertMeasureReportGroupStratifierComponent(MeasureReport.MeasureReportGroupStratifierComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MeasureReport.MeasureReportGroupStratifierComponent tgt = new MeasureReport.MeasureReportGroupStratifierComponent();
        MeasureReport40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(MeasureReport40_50.convertCodeableConcept(codeableConcept));
        }
        for (MeasureReport.StratifierGroupComponent stratifierGroupComponent : src.getStratum()) {
            tgt.addStratum(MeasureReport40_50.convertStratifierGroupComponent(stratifierGroupComponent));
        }
        return tgt;
    }

    public static MeasureReport.MeasureReportGroupStratifierComponent convertMeasureReportGroupStratifierComponent(MeasureReport.MeasureReportGroupStratifierComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MeasureReport.MeasureReportGroupStratifierComponent tgt = new MeasureReport.MeasureReportGroupStratifierComponent();
        MeasureReport40_50.copyElement(src, tgt, new String[0]);
        for (CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(MeasureReport40_50.convertCodeableConcept(codeableConcept));
        }
        for (MeasureReport.StratifierGroupComponent stratifierGroupComponent : src.getStratum()) {
            tgt.addStratum(MeasureReport40_50.convertStratifierGroupComponent(stratifierGroupComponent));
        }
        return tgt;
    }

    public static MeasureReport.StratifierGroupComponent convertStratifierGroupComponent(MeasureReport.StratifierGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MeasureReport.StratifierGroupComponent tgt = new MeasureReport.StratifierGroupComponent();
        MeasureReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(MeasureReport40_50.convertCodeableConcept(src.getValue()));
        }
        for (MeasureReport.StratifierGroupComponentComponent stratifierGroupComponentComponent : src.getComponent()) {
            tgt.addComponent(MeasureReport40_50.convertStratifierGroupComponentComponent(stratifierGroupComponentComponent));
        }
        for (MeasureReport.StratifierGroupPopulationComponent stratifierGroupPopulationComponent : src.getPopulation()) {
            tgt.addPopulation(MeasureReport40_50.convertStratifierGroupPopulationComponent(stratifierGroupPopulationComponent));
        }
        if (src.hasMeasureScore()) {
            tgt.setMeasureScore(MeasureReport40_50.convertQuantity(src.getMeasureScore()));
        }
        return tgt;
    }

    public static MeasureReport.StratifierGroupComponent convertStratifierGroupComponent(MeasureReport.StratifierGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MeasureReport.StratifierGroupComponent tgt = new MeasureReport.StratifierGroupComponent();
        MeasureReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValueCodeableConcept()) {
            tgt.setValue(MeasureReport40_50.convertCodeableConcept(src.getValueCodeableConcept()));
        }
        for (MeasureReport.StratifierGroupComponentComponent stratifierGroupComponentComponent : src.getComponent()) {
            tgt.addComponent(MeasureReport40_50.convertStratifierGroupComponentComponent(stratifierGroupComponentComponent));
        }
        for (MeasureReport.StratifierGroupPopulationComponent stratifierGroupPopulationComponent : src.getPopulation()) {
            tgt.addPopulation(MeasureReport40_50.convertStratifierGroupPopulationComponent(stratifierGroupPopulationComponent));
        }
        if (src.hasMeasureScoreQuantity()) {
            tgt.setMeasureScore(MeasureReport40_50.convertQuantity(src.getMeasureScoreQuantity()));
        }
        return tgt;
    }

    public static MeasureReport.StratifierGroupComponentComponent convertStratifierGroupComponentComponent(MeasureReport.StratifierGroupComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MeasureReport.StratifierGroupComponentComponent tgt = new MeasureReport.StratifierGroupComponentComponent();
        MeasureReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(MeasureReport40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(MeasureReport40_50.convertCodeableConcept(src.getValue()));
        }
        return tgt;
    }

    public static MeasureReport.StratifierGroupComponentComponent convertStratifierGroupComponentComponent(MeasureReport.StratifierGroupComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MeasureReport.StratifierGroupComponentComponent tgt = new MeasureReport.StratifierGroupComponentComponent();
        MeasureReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(MeasureReport40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValueCodeableConcept()) {
            tgt.setValue(MeasureReport40_50.convertCodeableConcept(src.getValueCodeableConcept()));
        }
        return tgt;
    }

    public static MeasureReport.StratifierGroupPopulationComponent convertStratifierGroupPopulationComponent(MeasureReport.StratifierGroupPopulationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MeasureReport.StratifierGroupPopulationComponent tgt = new MeasureReport.StratifierGroupPopulationComponent();
        MeasureReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(MeasureReport40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasCount()) {
            tgt.setCountElement(MeasureReport40_50.convertInteger(src.getCountElement()));
        }
        if (src.hasSubjectResults()) {
            tgt.setSubjectResults(MeasureReport40_50.convertReference(src.getSubjectResults()));
        }
        return tgt;
    }

    public static MeasureReport.StratifierGroupPopulationComponent convertStratifierGroupPopulationComponent(MeasureReport.StratifierGroupPopulationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MeasureReport.StratifierGroupPopulationComponent tgt = new MeasureReport.StratifierGroupPopulationComponent();
        MeasureReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(MeasureReport40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasCount()) {
            tgt.setCountElement(MeasureReport40_50.convertInteger(src.getCountElement()));
        }
        if (src.hasSubjectResults()) {
            tgt.setSubjectResults(MeasureReport40_50.convertReference(src.getSubjectResults()));
        }
        return tgt;
    }
}

