/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Invoice;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Invoice;

public class Invoice40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Invoice convertInvoice(Invoice src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Invoice tgt = new org.hl7.fhir.r5.model.Invoice();
        Invoice40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Invoice40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Invoice40_50.convertInvoiceStatus(src.getStatusElement()));
        }
        if (src.hasCancelledReason()) {
            tgt.setCancelledReasonElement(Invoice40_50.convertString(src.getCancelledReasonElement()));
        }
        if (src.hasType()) {
            tgt.setType(Invoice40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Invoice40_50.convertReference(src.getSubject()));
        }
        if (src.hasRecipient()) {
            tgt.setRecipient(Invoice40_50.convertReference(src.getRecipient()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(Invoice40_50.convertDateTime(src.getDateElement()));
        }
        for (Invoice.InvoiceParticipantComponent invoiceParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(Invoice40_50.convertInvoiceParticipantComponent(invoiceParticipantComponent));
        }
        if (src.hasIssuer()) {
            tgt.setIssuer(Invoice40_50.convertReference(src.getIssuer()));
        }
        if (src.hasAccount()) {
            tgt.setAccount(Invoice40_50.convertReference(src.getAccount()));
        }
        for (Invoice.InvoiceLineItemComponent invoiceLineItemComponent : src.getLineItem()) {
            tgt.addLineItem(Invoice40_50.convertInvoiceLineItemComponent(invoiceLineItemComponent));
        }
        for (Invoice.InvoiceLineItemPriceComponentComponent invoiceLineItemPriceComponentComponent : src.getTotalPriceComponent()) {
            tgt.addTotalPriceComponent(Invoice40_50.convertInvoiceLineItemPriceComponentComponent(invoiceLineItemPriceComponentComponent));
        }
        if (src.hasTotalNet()) {
            tgt.setTotalNet(Invoice40_50.convertMoney(src.getTotalNet()));
        }
        if (src.hasTotalGross()) {
            tgt.setTotalGross(Invoice40_50.convertMoney(src.getTotalGross()));
        }
        if (src.hasPaymentTerms()) {
            tgt.setPaymentTermsElement(Invoice40_50.convertMarkdown(src.getPaymentTermsElement()));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(Invoice40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static Invoice convertInvoice(org.hl7.fhir.r5.model.Invoice src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Invoice tgt = new Invoice();
        Invoice40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Invoice40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Invoice40_50.convertInvoiceStatus(src.getStatusElement()));
        }
        if (src.hasCancelledReason()) {
            tgt.setCancelledReasonElement(Invoice40_50.convertString(src.getCancelledReasonElement()));
        }
        if (src.hasType()) {
            tgt.setType(Invoice40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Invoice40_50.convertReference(src.getSubject()));
        }
        if (src.hasRecipient()) {
            tgt.setRecipient(Invoice40_50.convertReference(src.getRecipient()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(Invoice40_50.convertDateTime(src.getDateElement()));
        }
        for (Invoice.InvoiceParticipantComponent invoiceParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(Invoice40_50.convertInvoiceParticipantComponent(invoiceParticipantComponent));
        }
        if (src.hasIssuer()) {
            tgt.setIssuer(Invoice40_50.convertReference(src.getIssuer()));
        }
        if (src.hasAccount()) {
            tgt.setAccount(Invoice40_50.convertReference(src.getAccount()));
        }
        for (Invoice.InvoiceLineItemComponent invoiceLineItemComponent : src.getLineItem()) {
            tgt.addLineItem(Invoice40_50.convertInvoiceLineItemComponent(invoiceLineItemComponent));
        }
        for (Invoice.InvoiceLineItemPriceComponentComponent invoiceLineItemPriceComponentComponent : src.getTotalPriceComponent()) {
            tgt.addTotalPriceComponent(Invoice40_50.convertInvoiceLineItemPriceComponentComponent(invoiceLineItemPriceComponentComponent));
        }
        if (src.hasTotalNet()) {
            tgt.setTotalNet(Invoice40_50.convertMoney(src.getTotalNet()));
        }
        if (src.hasTotalGross()) {
            tgt.setTotalGross(Invoice40_50.convertMoney(src.getTotalGross()));
        }
        if (src.hasPaymentTerms()) {
            tgt.setPaymentTermsElement(Invoice40_50.convertMarkdown(src.getPaymentTermsElement()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(Invoice40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Invoice.InvoiceStatus> convertInvoiceStatus(Enumeration<Invoice.InvoiceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Invoice.InvoiceStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Invoice.InvoiceStatus>(new Invoice.InvoiceStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Invoice.InvoiceStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Invoice.InvoiceStatus.DRAFT);
                break;
            }
            case ISSUED: {
                tgt.setValue((Object)Invoice.InvoiceStatus.ISSUED);
                break;
            }
            case BALANCED: {
                tgt.setValue((Object)Invoice.InvoiceStatus.BALANCED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Invoice.InvoiceStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Invoice.InvoiceStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Invoice.InvoiceStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Invoice.InvoiceStatus> convertInvoiceStatus(org.hl7.fhir.r5.model.Enumeration<Invoice.InvoiceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Invoice.InvoiceStatus> tgt = new Enumeration<Invoice.InvoiceStatus>(new Invoice.InvoiceStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Invoice.InvoiceStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Invoice.InvoiceStatus.DRAFT);
                break;
            }
            case ISSUED: {
                tgt.setValue((Object)Invoice.InvoiceStatus.ISSUED);
                break;
            }
            case BALANCED: {
                tgt.setValue((Object)Invoice.InvoiceStatus.BALANCED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Invoice.InvoiceStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Invoice.InvoiceStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Invoice.InvoiceStatus.NULL);
            }
        }
        return tgt;
    }

    public static Invoice.InvoiceParticipantComponent convertInvoiceParticipantComponent(Invoice.InvoiceParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Invoice.InvoiceParticipantComponent tgt = new Invoice.InvoiceParticipantComponent();
        Invoice40_50.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRole(Invoice40_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasActor()) {
            tgt.setActor(Invoice40_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static Invoice.InvoiceParticipantComponent convertInvoiceParticipantComponent(Invoice.InvoiceParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Invoice.InvoiceParticipantComponent tgt = new Invoice.InvoiceParticipantComponent();
        Invoice40_50.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRole(Invoice40_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasActor()) {
            tgt.setActor(Invoice40_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static Invoice.InvoiceLineItemComponent convertInvoiceLineItemComponent(Invoice.InvoiceLineItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Invoice.InvoiceLineItemComponent tgt = new Invoice.InvoiceLineItemComponent();
        Invoice40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Invoice40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasChargeItem()) {
            tgt.setChargeItem(Invoice40_50.convertType(src.getChargeItem()));
        }
        for (Invoice.InvoiceLineItemPriceComponentComponent t : src.getPriceComponent()) {
            tgt.addPriceComponent(Invoice40_50.convertInvoiceLineItemPriceComponentComponent(t));
        }
        return tgt;
    }

    public static Invoice.InvoiceLineItemComponent convertInvoiceLineItemComponent(Invoice.InvoiceLineItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Invoice.InvoiceLineItemComponent tgt = new Invoice.InvoiceLineItemComponent();
        Invoice40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Invoice40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasChargeItem()) {
            tgt.setChargeItem(Invoice40_50.convertType(src.getChargeItem()));
        }
        for (Invoice.InvoiceLineItemPriceComponentComponent t : src.getPriceComponent()) {
            tgt.addPriceComponent(Invoice40_50.convertInvoiceLineItemPriceComponentComponent(t));
        }
        return tgt;
    }

    public static Invoice.InvoiceLineItemPriceComponentComponent convertInvoiceLineItemPriceComponentComponent(Invoice.InvoiceLineItemPriceComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Invoice.InvoiceLineItemPriceComponentComponent tgt = new Invoice.InvoiceLineItemPriceComponentComponent();
        Invoice40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(Invoice40_50.convertInvoicePriceComponentType(src.getTypeElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(Invoice40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(Invoice40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(Invoice40_50.convertMoney(src.getAmount()));
        }
        return tgt;
    }

    public static Invoice.InvoiceLineItemPriceComponentComponent convertInvoiceLineItemPriceComponentComponent(Invoice.InvoiceLineItemPriceComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Invoice.InvoiceLineItemPriceComponentComponent tgt = new Invoice.InvoiceLineItemPriceComponentComponent();
        Invoice40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(Invoice40_50.convertInvoicePriceComponentType(src.getTypeElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(Invoice40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(Invoice40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(Invoice40_50.convertMoney(src.getAmount()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.InvoicePriceComponentType> convertInvoicePriceComponentType(Enumeration<Invoice.InvoicePriceComponentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.InvoicePriceComponentType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.InvoicePriceComponentType>(new Enumerations.InvoicePriceComponentTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Invoice.InvoicePriceComponentType)((Object)src.getValue())) {
            case BASE: {
                tgt.setValue((Object)Enumerations.InvoicePriceComponentType.BASE);
                break;
            }
            case SURCHARGE: {
                tgt.setValue((Object)Enumerations.InvoicePriceComponentType.SURCHARGE);
                break;
            }
            case DEDUCTION: {
                tgt.setValue((Object)Enumerations.InvoicePriceComponentType.DEDUCTION);
                break;
            }
            case DISCOUNT: {
                tgt.setValue((Object)Enumerations.InvoicePriceComponentType.DISCOUNT);
                break;
            }
            case TAX: {
                tgt.setValue((Object)Enumerations.InvoicePriceComponentType.TAX);
                break;
            }
            case INFORMATIONAL: {
                tgt.setValue((Object)Enumerations.InvoicePriceComponentType.INFORMATIONAL);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.InvoicePriceComponentType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Invoice.InvoicePriceComponentType> convertInvoicePriceComponentType(org.hl7.fhir.r5.model.Enumeration<Enumerations.InvoicePriceComponentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Invoice.InvoicePriceComponentType> tgt = new Enumeration<Invoice.InvoicePriceComponentType>(new Invoice.InvoicePriceComponentTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.InvoicePriceComponentType)((Object)src.getValue())) {
            case BASE: {
                tgt.setValue((Object)Invoice.InvoicePriceComponentType.BASE);
                break;
            }
            case SURCHARGE: {
                tgt.setValue((Object)Invoice.InvoicePriceComponentType.SURCHARGE);
                break;
            }
            case DEDUCTION: {
                tgt.setValue((Object)Invoice.InvoicePriceComponentType.DEDUCTION);
                break;
            }
            case DISCOUNT: {
                tgt.setValue((Object)Invoice.InvoicePriceComponentType.DISCOUNT);
                break;
            }
            case TAX: {
                tgt.setValue((Object)Invoice.InvoicePriceComponentType.TAX);
                break;
            }
            case INFORMATIONAL: {
                tgt.setValue((Object)Invoice.InvoicePriceComponentType.INFORMATIONAL);
                break;
            }
            default: {
                tgt.setValue((Object)Invoice.InvoicePriceComponentType.NULL);
            }
        }
        return tgt;
    }
}

