/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.ImplementationGuide;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.utils.ToolingExtensions;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.utils.GuideParameterCode;
import org.hl7.fhir.utilities.Utilities;

public class ImplementationGuide40_50
extends VersionConvertor_40_50 {
    static final String EXT_IG_DEFINITION_PARAMETER = "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter";

    public static org.hl7.fhir.r5.model.ImplementationGuide convertImplementationGuide(ImplementationGuide src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ImplementationGuide tgt = new org.hl7.fhir.r5.model.ImplementationGuide();
        ImplementationGuide40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(ImplementationGuide40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ImplementationGuide40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ImplementationGuide40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ImplementationGuide40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(ImplementationGuide40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ImplementationGuide40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(ImplementationGuide40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ImplementationGuide40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ImplementationGuide40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(ImplementationGuide40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(ImplementationGuide40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(ImplementationGuide40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasPackageId()) {
            tgt.setPackageIdElement(ImplementationGuide40_50.convertId(src.getPackageIdElement()));
        }
        if (src.hasLicense()) {
            tgt.setLicenseElement(ImplementationGuide40_50.convertSPDXLicense(src.getLicenseElement()));
        }
        tgt.setFhirVersion(src.getFhirVersion().stream().map(Enumerations40_50::convertFHIRVersion).collect(Collectors.toList()));
        for (ImplementationGuide.ImplementationGuideDependsOnComponent implementationGuideDependsOnComponent : src.getDependsOn()) {
            tgt.addDependsOn(ImplementationGuide40_50.convertImplementationGuideDependsOnComponent(implementationGuideDependsOnComponent));
        }
        for (ImplementationGuide.ImplementationGuideGlobalComponent implementationGuideGlobalComponent : src.getGlobal()) {
            tgt.addGlobal(ImplementationGuide40_50.convertImplementationGuideGlobalComponent(implementationGuideGlobalComponent));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(ImplementationGuide40_50.convertImplementationGuideDefinitionComponent(src.getDefinition()));
        }
        if (src.hasManifest()) {
            tgt.setManifest(ImplementationGuide40_50.convertImplementationGuideManifestComponent(src.getManifest()));
        }
        return tgt;
    }

    public static ImplementationGuide convertImplementationGuide(org.hl7.fhir.r5.model.ImplementationGuide src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide tgt = new ImplementationGuide();
        ImplementationGuide40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(ImplementationGuide40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ImplementationGuide40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ImplementationGuide40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ImplementationGuide40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(ImplementationGuide40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ImplementationGuide40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(ImplementationGuide40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ImplementationGuide40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ImplementationGuide40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(ImplementationGuide40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(ImplementationGuide40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(ImplementationGuide40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasPackageId()) {
            tgt.setPackageIdElement(ImplementationGuide40_50.convertId(src.getPackageIdElement()));
        }
        if (src.hasLicense()) {
            tgt.setLicenseElement(ImplementationGuide40_50.convertSPDXLicense(src.getLicenseElement()));
        }
        tgt.setFhirVersion(src.getFhirVersion().stream().map(Enumerations40_50::convertFHIRVersion).collect(Collectors.toList()));
        for (ImplementationGuide.ImplementationGuideDependsOnComponent implementationGuideDependsOnComponent : src.getDependsOn()) {
            tgt.addDependsOn(ImplementationGuide40_50.convertImplementationGuideDependsOnComponent(implementationGuideDependsOnComponent));
        }
        for (ImplementationGuide.ImplementationGuideGlobalComponent implementationGuideGlobalComponent : src.getGlobal()) {
            tgt.addGlobal(ImplementationGuide40_50.convertImplementationGuideGlobalComponent(implementationGuideGlobalComponent));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(ImplementationGuide40_50.convertImplementationGuideDefinitionComponent(src.getDefinition()));
        }
        if (src.hasManifest()) {
            tgt.setManifest(ImplementationGuide40_50.convertImplementationGuideManifestComponent(src.getManifest()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ImplementationGuide.SPDXLicense> convertSPDXLicense(Enumeration<ImplementationGuide.SPDXLicense> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ImplementationGuide.SPDXLicense> tgt = new org.hl7.fhir.r5.model.Enumeration<ImplementationGuide.SPDXLicense>(new ImplementationGuide.SPDXLicenseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ImplementationGuide.SPDXLicense)((Object)src.getValue())) {
            case NOTOPENSOURCE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NOTOPENSOURCE);
                break;
            }
            case _0BSD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense._0BSD);
                break;
            }
            case AAL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AAL);
                break;
            }
            case ABSTYLES: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ABSTYLES);
                break;
            }
            case ADOBE2006: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ADOBE2006);
                break;
            }
            case ADOBEGLYPH: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ADOBEGLYPH);
                break;
            }
            case ADSL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ADSL);
                break;
            }
            case AFL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AFL1_1);
                break;
            }
            case AFL1_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AFL1_2);
                break;
            }
            case AFL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AFL2_0);
                break;
            }
            case AFL2_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AFL2_1);
                break;
            }
            case AFL3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AFL3_0);
                break;
            }
            case AFMPARSE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AFMPARSE);
                break;
            }
            case AGPL1_0ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AGPL1_0ONLY);
                break;
            }
            case AGPL1_0ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AGPL1_0ORLATER);
                break;
            }
            case AGPL3_0ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AGPL3_0ONLY);
                break;
            }
            case AGPL3_0ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AGPL3_0ORLATER);
                break;
            }
            case ALADDIN: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ALADDIN);
                break;
            }
            case AMDPLPA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AMDPLPA);
                break;
            }
            case AML: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AML);
                break;
            }
            case AMPAS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AMPAS);
                break;
            }
            case ANTLRPD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ANTLRPD);
                break;
            }
            case APACHE1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APACHE1_0);
                break;
            }
            case APACHE1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APACHE1_1);
                break;
            }
            case APACHE2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APACHE2_0);
                break;
            }
            case APAFML: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APAFML);
                break;
            }
            case APL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APL1_0);
                break;
            }
            case APSL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APSL1_0);
                break;
            }
            case APSL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APSL1_1);
                break;
            }
            case APSL1_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APSL1_2);
                break;
            }
            case APSL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APSL2_0);
                break;
            }
            case ARTISTIC1_0CL8: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ARTISTIC1_0CL8);
                break;
            }
            case ARTISTIC1_0PERL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ARTISTIC1_0PERL);
                break;
            }
            case ARTISTIC1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ARTISTIC1_0);
                break;
            }
            case ARTISTIC2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ARTISTIC2_0);
                break;
            }
            case BAHYPH: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BAHYPH);
                break;
            }
            case BARR: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BARR);
                break;
            }
            case BEERWARE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BEERWARE);
                break;
            }
            case BITTORRENT1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BITTORRENT1_0);
                break;
            }
            case BITTORRENT1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BITTORRENT1_1);
                break;
            }
            case BORCEUX: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BORCEUX);
                break;
            }
            case BSD1CLAUSE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD1CLAUSE);
                break;
            }
            case BSD2CLAUSEFREEBSD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD2CLAUSEFREEBSD);
                break;
            }
            case BSD2CLAUSENETBSD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD2CLAUSENETBSD);
                break;
            }
            case BSD2CLAUSEPATENT: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD2CLAUSEPATENT);
                break;
            }
            case BSD2CLAUSE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD2CLAUSE);
                break;
            }
            case BSD3CLAUSEATTRIBUTION: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD3CLAUSEATTRIBUTION);
                break;
            }
            case BSD3CLAUSECLEAR: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD3CLAUSECLEAR);
                break;
            }
            case BSD3CLAUSELBNL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD3CLAUSELBNL);
                break;
            }
            case BSD3CLAUSENONUCLEARLICENSE2014: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD3CLAUSENONUCLEARLICENSE2014);
                break;
            }
            case BSD3CLAUSENONUCLEARLICENSE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD3CLAUSENONUCLEARLICENSE);
                break;
            }
            case BSD3CLAUSENONUCLEARWARRANTY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD3CLAUSENONUCLEARWARRANTY);
                break;
            }
            case BSD3CLAUSE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD3CLAUSE);
                break;
            }
            case BSD4CLAUSEUC: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD4CLAUSEUC);
                break;
            }
            case BSD4CLAUSE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD4CLAUSE);
                break;
            }
            case BSDPROTECTION: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSDPROTECTION);
                break;
            }
            case BSDSOURCECODE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSDSOURCECODE);
                break;
            }
            case BSL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSL1_0);
                break;
            }
            case BZIP21_0_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BZIP21_0_5);
                break;
            }
            case BZIP21_0_6: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BZIP21_0_6);
                break;
            }
            case CALDERA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CALDERA);
                break;
            }
            case CATOSL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CATOSL1_1);
                break;
            }
            case CCBY1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBY1_0);
                break;
            }
            case CCBY2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBY2_0);
                break;
            }
            case CCBY2_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBY2_5);
                break;
            }
            case CCBY3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBY3_0);
                break;
            }
            case CCBY4_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBY4_0);
                break;
            }
            case CCBYNC1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNC1_0);
                break;
            }
            case CCBYNC2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNC2_0);
                break;
            }
            case CCBYNC2_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNC2_5);
                break;
            }
            case CCBYNC3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNC3_0);
                break;
            }
            case CCBYNC4_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNC4_0);
                break;
            }
            case CCBYNCND1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCND1_0);
                break;
            }
            case CCBYNCND2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCND2_0);
                break;
            }
            case CCBYNCND2_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCND2_5);
                break;
            }
            case CCBYNCND3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCND3_0);
                break;
            }
            case CCBYNCND4_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCND4_0);
                break;
            }
            case CCBYNCSA1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCSA1_0);
                break;
            }
            case CCBYNCSA2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCSA2_0);
                break;
            }
            case CCBYNCSA2_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCSA2_5);
                break;
            }
            case CCBYNCSA3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCSA3_0);
                break;
            }
            case CCBYNCSA4_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCSA4_0);
                break;
            }
            case CCBYND1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYND1_0);
                break;
            }
            case CCBYND2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYND2_0);
                break;
            }
            case CCBYND2_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYND2_5);
                break;
            }
            case CCBYND3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYND3_0);
                break;
            }
            case CCBYND4_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYND4_0);
                break;
            }
            case CCBYSA1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYSA1_0);
                break;
            }
            case CCBYSA2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYSA2_0);
                break;
            }
            case CCBYSA2_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYSA2_5);
                break;
            }
            case CCBYSA3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYSA3_0);
                break;
            }
            case CCBYSA4_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYSA4_0);
                break;
            }
            case CC01_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CC01_0);
                break;
            }
            case CDDL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CDDL1_0);
                break;
            }
            case CDDL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CDDL1_1);
                break;
            }
            case CDLAPERMISSIVE1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CDLAPERMISSIVE1_0);
                break;
            }
            case CDLASHARING1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CDLASHARING1_0);
                break;
            }
            case CECILL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CECILL1_0);
                break;
            }
            case CECILL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CECILL1_1);
                break;
            }
            case CECILL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CECILL2_0);
                break;
            }
            case CECILL2_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CECILL2_1);
                break;
            }
            case CECILLB: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CECILLB);
                break;
            }
            case CECILLC: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CECILLC);
                break;
            }
            case CLARTISTIC: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CLARTISTIC);
                break;
            }
            case CNRIJYTHON: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CNRIJYTHON);
                break;
            }
            case CNRIPYTHONGPLCOMPATIBLE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CNRIPYTHONGPLCOMPATIBLE);
                break;
            }
            case CNRIPYTHON: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CNRIPYTHON);
                break;
            }
            case CONDOR1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CONDOR1_1);
                break;
            }
            case CPAL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CPAL1_0);
                break;
            }
            case CPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CPL1_0);
                break;
            }
            case CPOL1_02: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CPOL1_02);
                break;
            }
            case CROSSWORD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CROSSWORD);
                break;
            }
            case CRYSTALSTACKER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CRYSTALSTACKER);
                break;
            }
            case CUAOPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CUAOPL1_0);
                break;
            }
            case CUBE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CUBE);
                break;
            }
            case CURL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CURL);
                break;
            }
            case DFSL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.DFSL1_0);
                break;
            }
            case DIFFMARK: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.DIFFMARK);
                break;
            }
            case DOC: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.DOC);
                break;
            }
            case DOTSEQN: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.DOTSEQN);
                break;
            }
            case DSDP: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.DSDP);
                break;
            }
            case DVIPDFM: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.DVIPDFM);
                break;
            }
            case ECL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ECL1_0);
                break;
            }
            case ECL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ECL2_0);
                break;
            }
            case EFL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EFL1_0);
                break;
            }
            case EFL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EFL2_0);
                break;
            }
            case EGENIX: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EGENIX);
                break;
            }
            case ENTESSA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ENTESSA);
                break;
            }
            case EPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EPL1_0);
                break;
            }
            case EPL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EPL2_0);
                break;
            }
            case ERLPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ERLPL1_1);
                break;
            }
            case EUDATAGRID: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EUDATAGRID);
                break;
            }
            case EUPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EUPL1_0);
                break;
            }
            case EUPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EUPL1_1);
                break;
            }
            case EUPL1_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EUPL1_2);
                break;
            }
            case EUROSYM: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EUROSYM);
                break;
            }
            case FAIR: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.FAIR);
                break;
            }
            case FRAMEWORX1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.FRAMEWORX1_0);
                break;
            }
            case FREEIMAGE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.FREEIMAGE);
                break;
            }
            case FSFAP: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.FSFAP);
                break;
            }
            case FSFUL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.FSFUL);
                break;
            }
            case FSFULLR: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.FSFULLR);
                break;
            }
            case FTL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.FTL);
                break;
            }
            case GFDL1_1ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GFDL1_1ONLY);
                break;
            }
            case GFDL1_1ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GFDL1_1ORLATER);
                break;
            }
            case GFDL1_2ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GFDL1_2ONLY);
                break;
            }
            case GFDL1_2ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GFDL1_2ORLATER);
                break;
            }
            case GFDL1_3ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GFDL1_3ONLY);
                break;
            }
            case GFDL1_3ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GFDL1_3ORLATER);
                break;
            }
            case GIFTWARE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GIFTWARE);
                break;
            }
            case GL2PS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GL2PS);
                break;
            }
            case GLIDE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GLIDE);
                break;
            }
            case GLULXE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GLULXE);
                break;
            }
            case GNUPLOT: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GNUPLOT);
                break;
            }
            case GPL1_0ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GPL1_0ONLY);
                break;
            }
            case GPL1_0ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GPL1_0ORLATER);
                break;
            }
            case GPL2_0ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GPL2_0ONLY);
                break;
            }
            case GPL2_0ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GPL2_0ORLATER);
                break;
            }
            case GPL3_0ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GPL3_0ONLY);
                break;
            }
            case GPL3_0ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GPL3_0ORLATER);
                break;
            }
            case GSOAP1_3B: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GSOAP1_3B);
                break;
            }
            case HASKELLREPORT: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.HASKELLREPORT);
                break;
            }
            case HPND: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.HPND);
                break;
            }
            case IBMPIBS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.IBMPIBS);
                break;
            }
            case ICU: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ICU);
                break;
            }
            case IJG: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.IJG);
                break;
            }
            case IMAGEMAGICK: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.IMAGEMAGICK);
                break;
            }
            case IMATIX: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.IMATIX);
                break;
            }
            case IMLIB2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.IMLIB2);
                break;
            }
            case INFOZIP: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.INFOZIP);
                break;
            }
            case INTELACPI: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.INTELACPI);
                break;
            }
            case INTEL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.INTEL);
                break;
            }
            case INTERBASE1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.INTERBASE1_0);
                break;
            }
            case IPA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.IPA);
                break;
            }
            case IPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.IPL1_0);
                break;
            }
            case ISC: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ISC);
                break;
            }
            case JASPER2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.JASPER2_0);
                break;
            }
            case JSON: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.JSON);
                break;
            }
            case LAL1_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LAL1_2);
                break;
            }
            case LAL1_3: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LAL1_3);
                break;
            }
            case LATEX2E: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LATEX2E);
                break;
            }
            case LEPTONICA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LEPTONICA);
                break;
            }
            case LGPL2_0ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LGPL2_0ONLY);
                break;
            }
            case LGPL2_0ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LGPL2_0ORLATER);
                break;
            }
            case LGPL2_1ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LGPL2_1ONLY);
                break;
            }
            case LGPL2_1ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LGPL2_1ORLATER);
                break;
            }
            case LGPL3_0ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LGPL3_0ONLY);
                break;
            }
            case LGPL3_0ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LGPL3_0ORLATER);
                break;
            }
            case LGPLLR: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LGPLLR);
                break;
            }
            case LIBPNG: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LIBPNG);
                break;
            }
            case LIBTIFF: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LIBTIFF);
                break;
            }
            case LILIQP1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LILIQP1_1);
                break;
            }
            case LILIQR1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LILIQR1_1);
                break;
            }
            case LILIQRPLUS1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LILIQRPLUS1_1);
                break;
            }
            case LINUXOPENIB: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LINUXOPENIB);
                break;
            }
            case LPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LPL1_0);
                break;
            }
            case LPL1_02: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LPL1_02);
                break;
            }
            case LPPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LPPL1_0);
                break;
            }
            case LPPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LPPL1_1);
                break;
            }
            case LPPL1_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LPPL1_2);
                break;
            }
            case LPPL1_3A: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LPPL1_3A);
                break;
            }
            case LPPL1_3C: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LPPL1_3C);
                break;
            }
            case MAKEINDEX: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MAKEINDEX);
                break;
            }
            case MIROS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MIROS);
                break;
            }
            case MIT0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MIT0);
                break;
            }
            case MITADVERTISING: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MITADVERTISING);
                break;
            }
            case MITCMU: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MITCMU);
                break;
            }
            case MITENNA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MITENNA);
                break;
            }
            case MITFEH: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MITFEH);
                break;
            }
            case MIT: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MIT);
                break;
            }
            case MITNFA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MITNFA);
                break;
            }
            case MOTOSOTO: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MOTOSOTO);
                break;
            }
            case MPICH2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MPICH2);
                break;
            }
            case MPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MPL1_0);
                break;
            }
            case MPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MPL1_1);
                break;
            }
            case MPL2_0NOCOPYLEFTEXCEPTION: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MPL2_0NOCOPYLEFTEXCEPTION);
                break;
            }
            case MPL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MPL2_0);
                break;
            }
            case MSPL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MSPL);
                break;
            }
            case MSRL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MSRL);
                break;
            }
            case MTLL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MTLL);
                break;
            }
            case MULTICS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MULTICS);
                break;
            }
            case MUP: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MUP);
                break;
            }
            case NASA1_3: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NASA1_3);
                break;
            }
            case NAUMEN: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NAUMEN);
                break;
            }
            case NBPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NBPL1_0);
                break;
            }
            case NCSA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NCSA);
                break;
            }
            case NETSNMP: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NETSNMP);
                break;
            }
            case NETCDF: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NETCDF);
                break;
            }
            case NEWSLETR: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NEWSLETR);
                break;
            }
            case NGPL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NGPL);
                break;
            }
            case NLOD1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NLOD1_0);
                break;
            }
            case NLPL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NLPL);
                break;
            }
            case NOKIA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NOKIA);
                break;
            }
            case NOSL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NOSL);
                break;
            }
            case NOWEB: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NOWEB);
                break;
            }
            case NPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NPL1_0);
                break;
            }
            case NPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NPL1_1);
                break;
            }
            case NPOSL3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NPOSL3_0);
                break;
            }
            case NRL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NRL);
                break;
            }
            case NTP: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NTP);
                break;
            }
            case OCCTPL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OCCTPL);
                break;
            }
            case OCLC2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OCLC2_0);
                break;
            }
            case ODBL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ODBL1_0);
                break;
            }
            case OFL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OFL1_0);
                break;
            }
            case OFL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OFL1_1);
                break;
            }
            case OGTSL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OGTSL);
                break;
            }
            case OLDAP1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP1_1);
                break;
            }
            case OLDAP1_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP1_2);
                break;
            }
            case OLDAP1_3: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP1_3);
                break;
            }
            case OLDAP1_4: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP1_4);
                break;
            }
            case OLDAP2_0_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_0_1);
                break;
            }
            case OLDAP2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_0);
                break;
            }
            case OLDAP2_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_1);
                break;
            }
            case OLDAP2_2_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_2_1);
                break;
            }
            case OLDAP2_2_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_2_2);
                break;
            }
            case OLDAP2_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_2);
                break;
            }
            case OLDAP2_3: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_3);
                break;
            }
            case OLDAP2_4: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_4);
                break;
            }
            case OLDAP2_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_5);
                break;
            }
            case OLDAP2_6: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_6);
                break;
            }
            case OLDAP2_7: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_7);
                break;
            }
            case OLDAP2_8: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_8);
                break;
            }
            case OML: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OML);
                break;
            }
            case OPENSSL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OPENSSL);
                break;
            }
            case OPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OPL1_0);
                break;
            }
            case OSETPL2_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OSETPL2_1);
                break;
            }
            case OSL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OSL1_0);
                break;
            }
            case OSL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OSL1_1);
                break;
            }
            case OSL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OSL2_0);
                break;
            }
            case OSL2_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OSL2_1);
                break;
            }
            case OSL3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OSL3_0);
                break;
            }
            case PDDL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.PDDL1_0);
                break;
            }
            case PHP3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.PHP3_0);
                break;
            }
            case PHP3_01: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.PHP3_01);
                break;
            }
            case PLEXUS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.PLEXUS);
                break;
            }
            case POSTGRESQL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.POSTGRESQL);
                break;
            }
            case PSFRAG: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.PSFRAG);
                break;
            }
            case PSUTILS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.PSUTILS);
                break;
            }
            case PYTHON2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.PYTHON2_0);
                break;
            }
            case QHULL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.QHULL);
                break;
            }
            case QPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.QPL1_0);
                break;
            }
            case RDISC: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RDISC);
                break;
            }
            case RHECOS1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RHECOS1_1);
                break;
            }
            case RPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RPL1_1);
                break;
            }
            case RPL1_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RPL1_5);
                break;
            }
            case RPSL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RPSL1_0);
                break;
            }
            case RSAMD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RSAMD);
                break;
            }
            case RSCPL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RSCPL);
                break;
            }
            case RUBY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RUBY);
                break;
            }
            case SAXPD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SAXPD);
                break;
            }
            case SAXPATH: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SAXPATH);
                break;
            }
            case SCEA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SCEA);
                break;
            }
            case SENDMAIL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SENDMAIL);
                break;
            }
            case SGIB1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SGIB1_0);
                break;
            }
            case SGIB1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SGIB1_1);
                break;
            }
            case SGIB2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SGIB2_0);
                break;
            }
            case SIMPL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SIMPL2_0);
                break;
            }
            case SISSL1_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SISSL1_2);
                break;
            }
            case SISSL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SISSL);
                break;
            }
            case SLEEPYCAT: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SLEEPYCAT);
                break;
            }
            case SMLNJ: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SMLNJ);
                break;
            }
            case SMPPL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SMPPL);
                break;
            }
            case SNIA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SNIA);
                break;
            }
            case SPENCER86: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SPENCER86);
                break;
            }
            case SPENCER94: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SPENCER94);
                break;
            }
            case SPENCER99: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SPENCER99);
                break;
            }
            case SPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SPL1_0);
                break;
            }
            case SUGARCRM1_1_3: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SUGARCRM1_1_3);
                break;
            }
            case SWL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SWL);
                break;
            }
            case TCL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.TCL);
                break;
            }
            case TCPWRAPPERS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.TCPWRAPPERS);
                break;
            }
            case TMATE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.TMATE);
                break;
            }
            case TORQUE1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.TORQUE1_1);
                break;
            }
            case TOSL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.TOSL);
                break;
            }
            case UNICODEDFS2015: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.UNICODEDFS2015);
                break;
            }
            case UNICODEDFS2016: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.UNICODEDFS2016);
                break;
            }
            case UNICODETOU: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.UNICODETOU);
                break;
            }
            case UNLICENSE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.UNLICENSE);
                break;
            }
            case UPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.UPL1_0);
                break;
            }
            case VIM: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.VIM);
                break;
            }
            case VOSTROM: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.VOSTROM);
                break;
            }
            case VSL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.VSL1_0);
                break;
            }
            case W3C19980720: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.W3C19980720);
                break;
            }
            case W3C20150513: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.W3C20150513);
                break;
            }
            case W3C: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.W3C);
                break;
            }
            case WATCOM1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.WATCOM1_0);
                break;
            }
            case WSUIPA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.WSUIPA);
                break;
            }
            case WTFPL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.WTFPL);
                break;
            }
            case X11: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.X11);
                break;
            }
            case XEROX: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.XEROX);
                break;
            }
            case XFREE861_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.XFREE861_1);
                break;
            }
            case XINETD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.XINETD);
                break;
            }
            case XNET: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.XNET);
                break;
            }
            case XPP: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.XPP);
                break;
            }
            case XSKAT: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.XSKAT);
                break;
            }
            case YPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.YPL1_0);
                break;
            }
            case YPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.YPL1_1);
                break;
            }
            case ZED: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZED);
                break;
            }
            case ZEND2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZEND2_0);
                break;
            }
            case ZIMBRA1_3: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZIMBRA1_3);
                break;
            }
            case ZIMBRA1_4: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZIMBRA1_4);
                break;
            }
            case ZLIBACKNOWLEDGEMENT: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZLIBACKNOWLEDGEMENT);
                break;
            }
            case ZLIB: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZLIB);
                break;
            }
            case ZPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZPL1_1);
                break;
            }
            case ZPL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZPL2_0);
                break;
            }
            case ZPL2_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZPL2_1);
                break;
            }
            default: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ImplementationGuide.SPDXLicense> convertSPDXLicense(org.hl7.fhir.r5.model.Enumeration<ImplementationGuide.SPDXLicense> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ImplementationGuide.SPDXLicense> tgt = new Enumeration<ImplementationGuide.SPDXLicense>(new ImplementationGuide.SPDXLicenseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ImplementationGuide.SPDXLicense)((Object)src.getValue())) {
            case NOTOPENSOURCE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NOTOPENSOURCE);
                break;
            }
            case _0BSD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense._0BSD);
                break;
            }
            case AAL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AAL);
                break;
            }
            case ABSTYLES: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ABSTYLES);
                break;
            }
            case ADOBE2006: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ADOBE2006);
                break;
            }
            case ADOBEGLYPH: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ADOBEGLYPH);
                break;
            }
            case ADSL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ADSL);
                break;
            }
            case AFL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AFL1_1);
                break;
            }
            case AFL1_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AFL1_2);
                break;
            }
            case AFL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AFL2_0);
                break;
            }
            case AFL2_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AFL2_1);
                break;
            }
            case AFL3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AFL3_0);
                break;
            }
            case AFMPARSE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AFMPARSE);
                break;
            }
            case AGPL1_0ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AGPL1_0ONLY);
                break;
            }
            case AGPL1_0ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AGPL1_0ORLATER);
                break;
            }
            case AGPL3_0ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AGPL3_0ONLY);
                break;
            }
            case AGPL3_0ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AGPL3_0ORLATER);
                break;
            }
            case ALADDIN: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ALADDIN);
                break;
            }
            case AMDPLPA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AMDPLPA);
                break;
            }
            case AML: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AML);
                break;
            }
            case AMPAS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.AMPAS);
                break;
            }
            case ANTLRPD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ANTLRPD);
                break;
            }
            case APACHE1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APACHE1_0);
                break;
            }
            case APACHE1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APACHE1_1);
                break;
            }
            case APACHE2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APACHE2_0);
                break;
            }
            case APAFML: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APAFML);
                break;
            }
            case APL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APL1_0);
                break;
            }
            case APSL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APSL1_0);
                break;
            }
            case APSL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APSL1_1);
                break;
            }
            case APSL1_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APSL1_2);
                break;
            }
            case APSL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.APSL2_0);
                break;
            }
            case ARTISTIC1_0CL8: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ARTISTIC1_0CL8);
                break;
            }
            case ARTISTIC1_0PERL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ARTISTIC1_0PERL);
                break;
            }
            case ARTISTIC1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ARTISTIC1_0);
                break;
            }
            case ARTISTIC2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ARTISTIC2_0);
                break;
            }
            case BAHYPH: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BAHYPH);
                break;
            }
            case BARR: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BARR);
                break;
            }
            case BEERWARE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BEERWARE);
                break;
            }
            case BITTORRENT1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BITTORRENT1_0);
                break;
            }
            case BITTORRENT1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BITTORRENT1_1);
                break;
            }
            case BORCEUX: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BORCEUX);
                break;
            }
            case BSD1CLAUSE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD1CLAUSE);
                break;
            }
            case BSD2CLAUSEFREEBSD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD2CLAUSEFREEBSD);
                break;
            }
            case BSD2CLAUSENETBSD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD2CLAUSENETBSD);
                break;
            }
            case BSD2CLAUSEPATENT: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD2CLAUSEPATENT);
                break;
            }
            case BSD2CLAUSE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD2CLAUSE);
                break;
            }
            case BSD3CLAUSEATTRIBUTION: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD3CLAUSEATTRIBUTION);
                break;
            }
            case BSD3CLAUSECLEAR: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD3CLAUSECLEAR);
                break;
            }
            case BSD3CLAUSELBNL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD3CLAUSELBNL);
                break;
            }
            case BSD3CLAUSENONUCLEARLICENSE2014: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD3CLAUSENONUCLEARLICENSE2014);
                break;
            }
            case BSD3CLAUSENONUCLEARLICENSE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD3CLAUSENONUCLEARLICENSE);
                break;
            }
            case BSD3CLAUSENONUCLEARWARRANTY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD3CLAUSENONUCLEARWARRANTY);
                break;
            }
            case BSD3CLAUSE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD3CLAUSE);
                break;
            }
            case BSD4CLAUSEUC: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD4CLAUSEUC);
                break;
            }
            case BSD4CLAUSE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSD4CLAUSE);
                break;
            }
            case BSDPROTECTION: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSDPROTECTION);
                break;
            }
            case BSDSOURCECODE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSDSOURCECODE);
                break;
            }
            case BSL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BSL1_0);
                break;
            }
            case BZIP21_0_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BZIP21_0_5);
                break;
            }
            case BZIP21_0_6: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.BZIP21_0_6);
                break;
            }
            case CALDERA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CALDERA);
                break;
            }
            case CATOSL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CATOSL1_1);
                break;
            }
            case CCBY1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBY1_0);
                break;
            }
            case CCBY2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBY2_0);
                break;
            }
            case CCBY2_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBY2_5);
                break;
            }
            case CCBY3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBY3_0);
                break;
            }
            case CCBY4_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBY4_0);
                break;
            }
            case CCBYNC1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNC1_0);
                break;
            }
            case CCBYNC2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNC2_0);
                break;
            }
            case CCBYNC2_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNC2_5);
                break;
            }
            case CCBYNC3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNC3_0);
                break;
            }
            case CCBYNC4_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNC4_0);
                break;
            }
            case CCBYNCND1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCND1_0);
                break;
            }
            case CCBYNCND2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCND2_0);
                break;
            }
            case CCBYNCND2_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCND2_5);
                break;
            }
            case CCBYNCND3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCND3_0);
                break;
            }
            case CCBYNCND4_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCND4_0);
                break;
            }
            case CCBYNCSA1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCSA1_0);
                break;
            }
            case CCBYNCSA2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCSA2_0);
                break;
            }
            case CCBYNCSA2_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCSA2_5);
                break;
            }
            case CCBYNCSA3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCSA3_0);
                break;
            }
            case CCBYNCSA4_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYNCSA4_0);
                break;
            }
            case CCBYND1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYND1_0);
                break;
            }
            case CCBYND2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYND2_0);
                break;
            }
            case CCBYND2_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYND2_5);
                break;
            }
            case CCBYND3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYND3_0);
                break;
            }
            case CCBYND4_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYND4_0);
                break;
            }
            case CCBYSA1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYSA1_0);
                break;
            }
            case CCBYSA2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYSA2_0);
                break;
            }
            case CCBYSA2_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYSA2_5);
                break;
            }
            case CCBYSA3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYSA3_0);
                break;
            }
            case CCBYSA4_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CCBYSA4_0);
                break;
            }
            case CC01_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CC01_0);
                break;
            }
            case CDDL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CDDL1_0);
                break;
            }
            case CDDL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CDDL1_1);
                break;
            }
            case CDLAPERMISSIVE1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CDLAPERMISSIVE1_0);
                break;
            }
            case CDLASHARING1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CDLASHARING1_0);
                break;
            }
            case CECILL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CECILL1_0);
                break;
            }
            case CECILL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CECILL1_1);
                break;
            }
            case CECILL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CECILL2_0);
                break;
            }
            case CECILL2_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CECILL2_1);
                break;
            }
            case CECILLB: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CECILLB);
                break;
            }
            case CECILLC: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CECILLC);
                break;
            }
            case CLARTISTIC: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CLARTISTIC);
                break;
            }
            case CNRIJYTHON: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CNRIJYTHON);
                break;
            }
            case CNRIPYTHONGPLCOMPATIBLE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CNRIPYTHONGPLCOMPATIBLE);
                break;
            }
            case CNRIPYTHON: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CNRIPYTHON);
                break;
            }
            case CONDOR1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CONDOR1_1);
                break;
            }
            case CPAL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CPAL1_0);
                break;
            }
            case CPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CPL1_0);
                break;
            }
            case CPOL1_02: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CPOL1_02);
                break;
            }
            case CROSSWORD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CROSSWORD);
                break;
            }
            case CRYSTALSTACKER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CRYSTALSTACKER);
                break;
            }
            case CUAOPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CUAOPL1_0);
                break;
            }
            case CUBE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CUBE);
                break;
            }
            case CURL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.CURL);
                break;
            }
            case DFSL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.DFSL1_0);
                break;
            }
            case DIFFMARK: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.DIFFMARK);
                break;
            }
            case DOC: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.DOC);
                break;
            }
            case DOTSEQN: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.DOTSEQN);
                break;
            }
            case DSDP: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.DSDP);
                break;
            }
            case DVIPDFM: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.DVIPDFM);
                break;
            }
            case ECL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ECL1_0);
                break;
            }
            case ECL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ECL2_0);
                break;
            }
            case EFL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EFL1_0);
                break;
            }
            case EFL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EFL2_0);
                break;
            }
            case EGENIX: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EGENIX);
                break;
            }
            case ENTESSA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ENTESSA);
                break;
            }
            case EPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EPL1_0);
                break;
            }
            case EPL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EPL2_0);
                break;
            }
            case ERLPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ERLPL1_1);
                break;
            }
            case EUDATAGRID: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EUDATAGRID);
                break;
            }
            case EUPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EUPL1_0);
                break;
            }
            case EUPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EUPL1_1);
                break;
            }
            case EUPL1_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EUPL1_2);
                break;
            }
            case EUROSYM: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.EUROSYM);
                break;
            }
            case FAIR: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.FAIR);
                break;
            }
            case FRAMEWORX1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.FRAMEWORX1_0);
                break;
            }
            case FREEIMAGE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.FREEIMAGE);
                break;
            }
            case FSFAP: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.FSFAP);
                break;
            }
            case FSFUL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.FSFUL);
                break;
            }
            case FSFULLR: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.FSFULLR);
                break;
            }
            case FTL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.FTL);
                break;
            }
            case GFDL1_1ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GFDL1_1ONLY);
                break;
            }
            case GFDL1_1ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GFDL1_1ORLATER);
                break;
            }
            case GFDL1_2ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GFDL1_2ONLY);
                break;
            }
            case GFDL1_2ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GFDL1_2ORLATER);
                break;
            }
            case GFDL1_3ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GFDL1_3ONLY);
                break;
            }
            case GFDL1_3ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GFDL1_3ORLATER);
                break;
            }
            case GIFTWARE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GIFTWARE);
                break;
            }
            case GL2PS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GL2PS);
                break;
            }
            case GLIDE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GLIDE);
                break;
            }
            case GLULXE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GLULXE);
                break;
            }
            case GNUPLOT: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GNUPLOT);
                break;
            }
            case GPL1_0ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GPL1_0ONLY);
                break;
            }
            case GPL1_0ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GPL1_0ORLATER);
                break;
            }
            case GPL2_0ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GPL2_0ONLY);
                break;
            }
            case GPL2_0ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GPL2_0ORLATER);
                break;
            }
            case GPL3_0ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GPL3_0ONLY);
                break;
            }
            case GPL3_0ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GPL3_0ORLATER);
                break;
            }
            case GSOAP1_3B: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.GSOAP1_3B);
                break;
            }
            case HASKELLREPORT: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.HASKELLREPORT);
                break;
            }
            case HPND: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.HPND);
                break;
            }
            case IBMPIBS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.IBMPIBS);
                break;
            }
            case ICU: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ICU);
                break;
            }
            case IJG: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.IJG);
                break;
            }
            case IMAGEMAGICK: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.IMAGEMAGICK);
                break;
            }
            case IMATIX: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.IMATIX);
                break;
            }
            case IMLIB2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.IMLIB2);
                break;
            }
            case INFOZIP: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.INFOZIP);
                break;
            }
            case INTELACPI: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.INTELACPI);
                break;
            }
            case INTEL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.INTEL);
                break;
            }
            case INTERBASE1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.INTERBASE1_0);
                break;
            }
            case IPA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.IPA);
                break;
            }
            case IPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.IPL1_0);
                break;
            }
            case ISC: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ISC);
                break;
            }
            case JASPER2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.JASPER2_0);
                break;
            }
            case JSON: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.JSON);
                break;
            }
            case LAL1_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LAL1_2);
                break;
            }
            case LAL1_3: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LAL1_3);
                break;
            }
            case LATEX2E: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LATEX2E);
                break;
            }
            case LEPTONICA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LEPTONICA);
                break;
            }
            case LGPL2_0ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LGPL2_0ONLY);
                break;
            }
            case LGPL2_0ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LGPL2_0ORLATER);
                break;
            }
            case LGPL2_1ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LGPL2_1ONLY);
                break;
            }
            case LGPL2_1ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LGPL2_1ORLATER);
                break;
            }
            case LGPL3_0ONLY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LGPL3_0ONLY);
                break;
            }
            case LGPL3_0ORLATER: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LGPL3_0ORLATER);
                break;
            }
            case LGPLLR: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LGPLLR);
                break;
            }
            case LIBPNG: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LIBPNG);
                break;
            }
            case LIBTIFF: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LIBTIFF);
                break;
            }
            case LILIQP1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LILIQP1_1);
                break;
            }
            case LILIQR1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LILIQR1_1);
                break;
            }
            case LILIQRPLUS1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LILIQRPLUS1_1);
                break;
            }
            case LINUXOPENIB: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LINUXOPENIB);
                break;
            }
            case LPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LPL1_0);
                break;
            }
            case LPL1_02: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LPL1_02);
                break;
            }
            case LPPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LPPL1_0);
                break;
            }
            case LPPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LPPL1_1);
                break;
            }
            case LPPL1_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LPPL1_2);
                break;
            }
            case LPPL1_3A: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LPPL1_3A);
                break;
            }
            case LPPL1_3C: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.LPPL1_3C);
                break;
            }
            case MAKEINDEX: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MAKEINDEX);
                break;
            }
            case MIROS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MIROS);
                break;
            }
            case MIT0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MIT0);
                break;
            }
            case MITADVERTISING: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MITADVERTISING);
                break;
            }
            case MITCMU: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MITCMU);
                break;
            }
            case MITENNA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MITENNA);
                break;
            }
            case MITFEH: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MITFEH);
                break;
            }
            case MIT: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MIT);
                break;
            }
            case MITNFA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MITNFA);
                break;
            }
            case MOTOSOTO: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MOTOSOTO);
                break;
            }
            case MPICH2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MPICH2);
                break;
            }
            case MPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MPL1_0);
                break;
            }
            case MPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MPL1_1);
                break;
            }
            case MPL2_0NOCOPYLEFTEXCEPTION: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MPL2_0NOCOPYLEFTEXCEPTION);
                break;
            }
            case MPL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MPL2_0);
                break;
            }
            case MSPL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MSPL);
                break;
            }
            case MSRL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MSRL);
                break;
            }
            case MTLL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MTLL);
                break;
            }
            case MULTICS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MULTICS);
                break;
            }
            case MUP: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.MUP);
                break;
            }
            case NASA1_3: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NASA1_3);
                break;
            }
            case NAUMEN: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NAUMEN);
                break;
            }
            case NBPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NBPL1_0);
                break;
            }
            case NCSA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NCSA);
                break;
            }
            case NETSNMP: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NETSNMP);
                break;
            }
            case NETCDF: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NETCDF);
                break;
            }
            case NEWSLETR: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NEWSLETR);
                break;
            }
            case NGPL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NGPL);
                break;
            }
            case NLOD1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NLOD1_0);
                break;
            }
            case NLPL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NLPL);
                break;
            }
            case NOKIA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NOKIA);
                break;
            }
            case NOSL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NOSL);
                break;
            }
            case NOWEB: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NOWEB);
                break;
            }
            case NPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NPL1_0);
                break;
            }
            case NPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NPL1_1);
                break;
            }
            case NPOSL3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NPOSL3_0);
                break;
            }
            case NRL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NRL);
                break;
            }
            case NTP: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NTP);
                break;
            }
            case OCCTPL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OCCTPL);
                break;
            }
            case OCLC2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OCLC2_0);
                break;
            }
            case ODBL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ODBL1_0);
                break;
            }
            case OFL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OFL1_0);
                break;
            }
            case OFL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OFL1_1);
                break;
            }
            case OGTSL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OGTSL);
                break;
            }
            case OLDAP1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP1_1);
                break;
            }
            case OLDAP1_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP1_2);
                break;
            }
            case OLDAP1_3: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP1_3);
                break;
            }
            case OLDAP1_4: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP1_4);
                break;
            }
            case OLDAP2_0_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_0_1);
                break;
            }
            case OLDAP2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_0);
                break;
            }
            case OLDAP2_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_1);
                break;
            }
            case OLDAP2_2_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_2_1);
                break;
            }
            case OLDAP2_2_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_2_2);
                break;
            }
            case OLDAP2_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_2);
                break;
            }
            case OLDAP2_3: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_3);
                break;
            }
            case OLDAP2_4: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_4);
                break;
            }
            case OLDAP2_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_5);
                break;
            }
            case OLDAP2_6: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_6);
                break;
            }
            case OLDAP2_7: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_7);
                break;
            }
            case OLDAP2_8: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OLDAP2_8);
                break;
            }
            case OML: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OML);
                break;
            }
            case OPENSSL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OPENSSL);
                break;
            }
            case OPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OPL1_0);
                break;
            }
            case OSETPL2_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OSETPL2_1);
                break;
            }
            case OSL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OSL1_0);
                break;
            }
            case OSL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OSL1_1);
                break;
            }
            case OSL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OSL2_0);
                break;
            }
            case OSL2_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OSL2_1);
                break;
            }
            case OSL3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.OSL3_0);
                break;
            }
            case PDDL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.PDDL1_0);
                break;
            }
            case PHP3_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.PHP3_0);
                break;
            }
            case PHP3_01: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.PHP3_01);
                break;
            }
            case PLEXUS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.PLEXUS);
                break;
            }
            case POSTGRESQL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.POSTGRESQL);
                break;
            }
            case PSFRAG: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.PSFRAG);
                break;
            }
            case PSUTILS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.PSUTILS);
                break;
            }
            case PYTHON2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.PYTHON2_0);
                break;
            }
            case QHULL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.QHULL);
                break;
            }
            case QPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.QPL1_0);
                break;
            }
            case RDISC: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RDISC);
                break;
            }
            case RHECOS1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RHECOS1_1);
                break;
            }
            case RPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RPL1_1);
                break;
            }
            case RPL1_5: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RPL1_5);
                break;
            }
            case RPSL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RPSL1_0);
                break;
            }
            case RSAMD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RSAMD);
                break;
            }
            case RSCPL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RSCPL);
                break;
            }
            case RUBY: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.RUBY);
                break;
            }
            case SAXPD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SAXPD);
                break;
            }
            case SAXPATH: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SAXPATH);
                break;
            }
            case SCEA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SCEA);
                break;
            }
            case SENDMAIL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SENDMAIL);
                break;
            }
            case SGIB1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SGIB1_0);
                break;
            }
            case SGIB1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SGIB1_1);
                break;
            }
            case SGIB2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SGIB2_0);
                break;
            }
            case SIMPL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SIMPL2_0);
                break;
            }
            case SISSL1_2: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SISSL1_2);
                break;
            }
            case SISSL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SISSL);
                break;
            }
            case SLEEPYCAT: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SLEEPYCAT);
                break;
            }
            case SMLNJ: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SMLNJ);
                break;
            }
            case SMPPL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SMPPL);
                break;
            }
            case SNIA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SNIA);
                break;
            }
            case SPENCER86: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SPENCER86);
                break;
            }
            case SPENCER94: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SPENCER94);
                break;
            }
            case SPENCER99: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SPENCER99);
                break;
            }
            case SPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SPL1_0);
                break;
            }
            case SUGARCRM1_1_3: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SUGARCRM1_1_3);
                break;
            }
            case SWL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.SWL);
                break;
            }
            case TCL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.TCL);
                break;
            }
            case TCPWRAPPERS: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.TCPWRAPPERS);
                break;
            }
            case TMATE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.TMATE);
                break;
            }
            case TORQUE1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.TORQUE1_1);
                break;
            }
            case TOSL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.TOSL);
                break;
            }
            case UNICODEDFS2015: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.UNICODEDFS2015);
                break;
            }
            case UNICODEDFS2016: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.UNICODEDFS2016);
                break;
            }
            case UNICODETOU: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.UNICODETOU);
                break;
            }
            case UNLICENSE: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.UNLICENSE);
                break;
            }
            case UPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.UPL1_0);
                break;
            }
            case VIM: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.VIM);
                break;
            }
            case VOSTROM: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.VOSTROM);
                break;
            }
            case VSL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.VSL1_0);
                break;
            }
            case W3C19980720: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.W3C19980720);
                break;
            }
            case W3C20150513: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.W3C20150513);
                break;
            }
            case W3C: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.W3C);
                break;
            }
            case WATCOM1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.WATCOM1_0);
                break;
            }
            case WSUIPA: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.WSUIPA);
                break;
            }
            case WTFPL: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.WTFPL);
                break;
            }
            case X11: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.X11);
                break;
            }
            case XEROX: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.XEROX);
                break;
            }
            case XFREE861_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.XFREE861_1);
                break;
            }
            case XINETD: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.XINETD);
                break;
            }
            case XNET: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.XNET);
                break;
            }
            case XPP: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.XPP);
                break;
            }
            case XSKAT: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.XSKAT);
                break;
            }
            case YPL1_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.YPL1_0);
                break;
            }
            case YPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.YPL1_1);
                break;
            }
            case ZED: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZED);
                break;
            }
            case ZEND2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZEND2_0);
                break;
            }
            case ZIMBRA1_3: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZIMBRA1_3);
                break;
            }
            case ZIMBRA1_4: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZIMBRA1_4);
                break;
            }
            case ZLIBACKNOWLEDGEMENT: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZLIBACKNOWLEDGEMENT);
                break;
            }
            case ZLIB: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZLIB);
                break;
            }
            case ZPL1_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZPL1_1);
                break;
            }
            case ZPL2_0: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZPL2_0);
                break;
            }
            case ZPL2_1: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.ZPL2_1);
                break;
            }
            default: {
                tgt.setValue((Object)ImplementationGuide.SPDXLicense.NULL);
            }
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDependsOnComponent convertImplementationGuideDependsOnComponent(ImplementationGuide.ImplementationGuideDependsOnComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependsOnComponent tgt = new ImplementationGuide.ImplementationGuideDependsOnComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUri()) {
            tgt.setUriElement(ImplementationGuide40_50.convertCanonical(src.getUriElement()));
        }
        if (src.hasPackageId()) {
            tgt.setPackageIdElement(ImplementationGuide40_50.convertId(src.getPackageIdElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ImplementationGuide40_50.convertString(src.getVersionElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDependsOnComponent convertImplementationGuideDependsOnComponent(ImplementationGuide.ImplementationGuideDependsOnComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependsOnComponent tgt = new ImplementationGuide.ImplementationGuideDependsOnComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUri()) {
            tgt.setUriElement(ImplementationGuide40_50.convertCanonical(src.getUriElement()));
        }
        if (src.hasPackageId()) {
            tgt.setPackageIdElement(ImplementationGuide40_50.convertId(src.getPackageIdElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ImplementationGuide40_50.convertString(src.getVersionElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(ImplementationGuide40_50.convertResourceEnum(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(ImplementationGuide40_50.convertCanonical(src.getProfileElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(ImplementationGuide40_50.convertResourceEnum(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(ImplementationGuide40_50.convertCanonical(src.getProfileElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionComponent convertImplementationGuideDefinitionComponent(ImplementationGuide.ImplementationGuideDefinitionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        for (ImplementationGuide.ImplementationGuideDefinitionGroupingComponent implementationGuideDefinitionGroupingComponent : src.getGrouping()) {
            tgt.addGrouping(ImplementationGuide40_50.convertImplementationGuideDefinitionGroupingComponent(implementationGuideDefinitionGroupingComponent));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionResourceComponent implementationGuideDefinitionResourceComponent : src.getResource()) {
            tgt.addResource(ImplementationGuide40_50.convertImplementationGuideDefinitionResourceComponent(implementationGuideDefinitionResourceComponent));
        }
        if (src.hasPage()) {
            tgt.setPage(ImplementationGuide40_50.convertImplementationGuideDefinitionPageComponent(src.getPage()));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionParameterComponent implementationGuideDefinitionParameterComponent : src.getParameter()) {
            tgt.addParameter(ImplementationGuide40_50.convertImplementationGuideDefinitionParameterComponent(implementationGuideDefinitionParameterComponent));
        }
        for (Extension extension : ToolingExtensions.getExtensions(src, EXT_IG_DEFINITION_PARAMETER)) {
            ImplementationGuide.ImplementationGuideDefinitionParameterComponent p = new ImplementationGuide.ImplementationGuideDefinitionParameterComponent();
            p.setCode(ToolingExtensions.readStringExtension(extension, "code"));
            p.setValue(ToolingExtensions.readStringExtension(extension, "Value"));
            tgt.addParameter(p);
        }
        for (ImplementationGuide.ImplementationGuideDefinitionTemplateComponent implementationGuideDefinitionTemplateComponent : src.getTemplate()) {
            tgt.addTemplate(ImplementationGuide40_50.convertImplementationGuideDefinitionTemplateComponent(implementationGuideDefinitionTemplateComponent));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionComponent convertImplementationGuideDefinitionComponent(ImplementationGuide.ImplementationGuideDefinitionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        for (ImplementationGuide.ImplementationGuideDefinitionGroupingComponent implementationGuideDefinitionGroupingComponent : src.getGrouping()) {
            tgt.addGrouping(ImplementationGuide40_50.convertImplementationGuideDefinitionGroupingComponent(implementationGuideDefinitionGroupingComponent));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionResourceComponent implementationGuideDefinitionResourceComponent : src.getResource()) {
            tgt.addResource(ImplementationGuide40_50.convertImplementationGuideDefinitionResourceComponent(implementationGuideDefinitionResourceComponent));
        }
        if (src.hasPage()) {
            tgt.setPage(ImplementationGuide40_50.convertImplementationGuideDefinitionPageComponent(src.getPage()));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionParameterComponent implementationGuideDefinitionParameterComponent : src.getParameter()) {
            if (Utilities.existsInList(implementationGuideDefinitionParameterComponent.getCode(), "apply", "path-resource", "path-pages", "path-tx-cache", "expansion-parameter", "rule-broken-links", "generate-xml", "generate-json", "generate-turtle", "html-template")) {
                tgt.addParameter(ImplementationGuide40_50.convertImplementationGuideDefinitionParameterComponent(implementationGuideDefinitionParameterComponent));
                continue;
            }
            Extension e = new Extension(EXT_IG_DEFINITION_PARAMETER);
            Extension eCode = new Extension("code", new org.hl7.fhir.r4.model.StringType(implementationGuideDefinitionParameterComponent.getCode()));
            Extension eValue = new Extension("value", new org.hl7.fhir.r4.model.StringType(implementationGuideDefinitionParameterComponent.getValue()));
            e.addExtension(eCode);
            e.addExtension(eValue);
            tgt.addExtension(e);
        }
        for (ImplementationGuide.ImplementationGuideDefinitionTemplateComponent implementationGuideDefinitionTemplateComponent : src.getTemplate()) {
            tgt.addTemplate(ImplementationGuide40_50.convertImplementationGuideDefinitionTemplateComponent(implementationGuideDefinitionTemplateComponent));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionGroupingComponent convertImplementationGuideDefinitionGroupingComponent(ImplementationGuide.ImplementationGuideDefinitionGroupingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionGroupingComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionGroupingComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(ImplementationGuide40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ImplementationGuide40_50.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionGroupingComponent convertImplementationGuideDefinitionGroupingComponent(ImplementationGuide.ImplementationGuideDefinitionGroupingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionGroupingComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionGroupingComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(ImplementationGuide40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ImplementationGuide40_50.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionResourceComponent convertImplementationGuideDefinitionResourceComponent(ImplementationGuide.ImplementationGuideDefinitionResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionResourceComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReference(ImplementationGuide40_50.convertReference(src.getReference()));
        }
        tgt.setFhirVersion(src.getFhirVersion().stream().map(Enumerations40_50::convertFHIRVersion).collect(Collectors.toList()));
        if (src.hasName()) {
            tgt.setNameElement(ImplementationGuide40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ImplementationGuide40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasExample()) {
            tgt.setExample(ImplementationGuide40_50.convertType(src.getExample()));
        }
        if (src.hasGroupingId()) {
            tgt.setGroupingIdElement(ImplementationGuide40_50.convertId(src.getGroupingIdElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionResourceComponent convertImplementationGuideDefinitionResourceComponent(ImplementationGuide.ImplementationGuideDefinitionResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionResourceComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReference(ImplementationGuide40_50.convertReference(src.getReference()));
        }
        tgt.setFhirVersion(src.getFhirVersion().stream().map(Enumerations40_50::convertFHIRVersion).collect(Collectors.toList()));
        if (src.hasName()) {
            tgt.setNameElement(ImplementationGuide40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ImplementationGuide40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasExample()) {
            tgt.setExample(ImplementationGuide40_50.convertType(src.getExample()));
        }
        if (src.hasGroupingId()) {
            tgt.setGroupingIdElement(ImplementationGuide40_50.convertId(src.getGroupingIdElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionPageComponent convertImplementationGuideDefinitionPageComponent(ImplementationGuide.ImplementationGuideDefinitionPageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionPageComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setName(ImplementationGuide40_50.convertType(src.getName()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ImplementationGuide40_50.convertString(src.getTitleElement()));
        }
        if (src.hasGeneration()) {
            tgt.setGenerationElement(ImplementationGuide40_50.convertGuidePageGeneration(src.getGenerationElement()));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionPageComponent t : src.getPage()) {
            tgt.addPage(ImplementationGuide40_50.convertImplementationGuideDefinitionPageComponent(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionPageComponent convertImplementationGuideDefinitionPageComponent(ImplementationGuide.ImplementationGuideDefinitionPageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionPageComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setName(ImplementationGuide40_50.convertType(src.getName()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ImplementationGuide40_50.convertString(src.getTitleElement()));
        }
        if (src.hasGeneration()) {
            tgt.setGenerationElement(ImplementationGuide40_50.convertGuidePageGeneration(src.getGenerationElement()));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionPageComponent t : src.getPage()) {
            tgt.addPage(ImplementationGuide40_50.convertImplementationGuideDefinitionPageComponent(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ImplementationGuide.GuidePageGeneration> convertGuidePageGeneration(Enumeration<ImplementationGuide.GuidePageGeneration> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ImplementationGuide.GuidePageGeneration> tgt = new org.hl7.fhir.r5.model.Enumeration<ImplementationGuide.GuidePageGeneration>(new ImplementationGuide.GuidePageGenerationEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ImplementationGuide.GuidePageGeneration)((Object)src.getValue())) {
            case HTML: {
                tgt.setValue((Object)ImplementationGuide.GuidePageGeneration.HTML);
                break;
            }
            case MARKDOWN: {
                tgt.setValue((Object)ImplementationGuide.GuidePageGeneration.MARKDOWN);
                break;
            }
            case XML: {
                tgt.setValue((Object)ImplementationGuide.GuidePageGeneration.XML);
                break;
            }
            case GENERATED: {
                tgt.setValue((Object)ImplementationGuide.GuidePageGeneration.GENERATED);
                break;
            }
            default: {
                tgt.setValue((Object)ImplementationGuide.GuidePageGeneration.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ImplementationGuide.GuidePageGeneration> convertGuidePageGeneration(org.hl7.fhir.r5.model.Enumeration<ImplementationGuide.GuidePageGeneration> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ImplementationGuide.GuidePageGeneration> tgt = new Enumeration<ImplementationGuide.GuidePageGeneration>(new ImplementationGuide.GuidePageGenerationEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ImplementationGuide.GuidePageGeneration)((Object)src.getValue())) {
            case HTML: {
                tgt.setValue((Object)ImplementationGuide.GuidePageGeneration.HTML);
                break;
            }
            case MARKDOWN: {
                tgt.setValue((Object)ImplementationGuide.GuidePageGeneration.MARKDOWN);
                break;
            }
            case XML: {
                tgt.setValue((Object)ImplementationGuide.GuidePageGeneration.XML);
                break;
            }
            case GENERATED: {
                tgt.setValue((Object)ImplementationGuide.GuidePageGeneration.GENERATED);
                break;
            }
            default: {
                tgt.setValue((Object)ImplementationGuide.GuidePageGeneration.NULL);
            }
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionParameterComponent convertImplementationGuideDefinitionParameterComponent(ImplementationGuide.ImplementationGuideDefinitionParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionParameterComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionParameterComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(ImplementationGuide40_50.convertString(src.getCodeElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(ImplementationGuide40_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionParameterComponent convertImplementationGuideDefinitionParameterComponent(ImplementationGuide.ImplementationGuideDefinitionParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionParameterComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionParameterComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(ImplementationGuide40_50.convertString(src.getCodeElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(ImplementationGuide40_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static GuideParameterCode convertGuideParameterCode(ImplementationGuide.GuideParameterCode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case APPLY: {
                return GuideParameterCode.APPLY;
            }
            case PATHRESOURCE: {
                return GuideParameterCode.PATHRESOURCE;
            }
            case PATHPAGES: {
                return GuideParameterCode.PATHPAGES;
            }
            case PATHTXCACHE: {
                return GuideParameterCode.PATHTXCACHE;
            }
            case EXPANSIONPARAMETER: {
                return GuideParameterCode.EXPANSIONPARAMETER;
            }
            case RULEBROKENLINKS: {
                return GuideParameterCode.RULEBROKENLINKS;
            }
            case GENERATEXML: {
                return GuideParameterCode.GENERATEXML;
            }
            case GENERATEJSON: {
                return GuideParameterCode.GENERATEJSON;
            }
            case GENERATETURTLE: {
                return GuideParameterCode.GENERATETURTLE;
            }
            case HTMLTEMPLATE: {
                return GuideParameterCode.HTMLTEMPLATE;
            }
        }
        return GuideParameterCode.NULL;
    }

    public static ImplementationGuide.GuideParameterCode convertGuideParameterCode(GuideParameterCode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case APPLY: {
                return ImplementationGuide.GuideParameterCode.APPLY;
            }
            case PATHRESOURCE: {
                return ImplementationGuide.GuideParameterCode.PATHRESOURCE;
            }
            case PATHPAGES: {
                return ImplementationGuide.GuideParameterCode.PATHPAGES;
            }
            case PATHTXCACHE: {
                return ImplementationGuide.GuideParameterCode.PATHTXCACHE;
            }
            case EXPANSIONPARAMETER: {
                return ImplementationGuide.GuideParameterCode.EXPANSIONPARAMETER;
            }
            case RULEBROKENLINKS: {
                return ImplementationGuide.GuideParameterCode.RULEBROKENLINKS;
            }
            case GENERATEXML: {
                return ImplementationGuide.GuideParameterCode.GENERATEXML;
            }
            case GENERATEJSON: {
                return ImplementationGuide.GuideParameterCode.GENERATEJSON;
            }
            case GENERATETURTLE: {
                return ImplementationGuide.GuideParameterCode.GENERATETURTLE;
            }
            case HTMLTEMPLATE: {
                return ImplementationGuide.GuideParameterCode.HTMLTEMPLATE;
            }
        }
        return ImplementationGuide.GuideParameterCode.NULL;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionTemplateComponent convertImplementationGuideDefinitionTemplateComponent(ImplementationGuide.ImplementationGuideDefinitionTemplateComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionTemplateComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionTemplateComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(ImplementationGuide40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasSource()) {
            tgt.setSourceElement(ImplementationGuide40_50.convertString(src.getSourceElement()));
        }
        if (src.hasScope()) {
            tgt.setScopeElement(ImplementationGuide40_50.convertString(src.getScopeElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionTemplateComponent convertImplementationGuideDefinitionTemplateComponent(ImplementationGuide.ImplementationGuideDefinitionTemplateComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionTemplateComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionTemplateComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(ImplementationGuide40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasSource()) {
            tgt.setSourceElement(ImplementationGuide40_50.convertString(src.getSourceElement()));
        }
        if (src.hasScope()) {
            tgt.setScopeElement(ImplementationGuide40_50.convertString(src.getScopeElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideManifestComponent convertImplementationGuideManifestComponent(ImplementationGuide.ImplementationGuideManifestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideManifestComponent tgt = new ImplementationGuide.ImplementationGuideManifestComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasRendering()) {
            tgt.setRenderingElement(ImplementationGuide40_50.convertUrl(src.getRenderingElement()));
        }
        for (ImplementationGuide.ManifestResourceComponent manifestResourceComponent : src.getResource()) {
            tgt.addResource(ImplementationGuide40_50.convertManifestResourceComponent(manifestResourceComponent));
        }
        for (ImplementationGuide.ManifestPageComponent manifestPageComponent : src.getPage()) {
            tgt.addPage(ImplementationGuide40_50.convertManifestPageComponent(manifestPageComponent));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getImage()) {
            tgt.getImage().add(ImplementationGuide40_50.convertString(stringType));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getOther()) {
            tgt.getOther().add(ImplementationGuide40_50.convertString(stringType));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideManifestComponent convertImplementationGuideManifestComponent(ImplementationGuide.ImplementationGuideManifestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideManifestComponent tgt = new ImplementationGuide.ImplementationGuideManifestComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasRendering()) {
            tgt.setRenderingElement(ImplementationGuide40_50.convertUrl(src.getRenderingElement()));
        }
        for (ImplementationGuide.ManifestResourceComponent manifestResourceComponent : src.getResource()) {
            tgt.addResource(ImplementationGuide40_50.convertManifestResourceComponent(manifestResourceComponent));
        }
        for (ImplementationGuide.ManifestPageComponent manifestPageComponent : src.getPage()) {
            tgt.addPage(ImplementationGuide40_50.convertManifestPageComponent(manifestPageComponent));
        }
        for (StringType stringType : src.getImage()) {
            tgt.getImage().add(ImplementationGuide40_50.convertString(stringType));
        }
        for (StringType stringType : src.getOther()) {
            tgt.getOther().add(ImplementationGuide40_50.convertString(stringType));
        }
        return tgt;
    }

    public static ImplementationGuide.ManifestResourceComponent convertManifestResourceComponent(ImplementationGuide.ManifestResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ManifestResourceComponent tgt = new ImplementationGuide.ManifestResourceComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReference(ImplementationGuide40_50.convertReference(src.getReference()));
        }
        if (src.hasExample()) {
            tgt.setExample(ImplementationGuide40_50.convertType(src.getExample()));
        }
        if (src.hasRelativePath()) {
            tgt.setRelativePathElement(ImplementationGuide40_50.convertUrl(src.getRelativePathElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ManifestResourceComponent convertManifestResourceComponent(ImplementationGuide.ManifestResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ManifestResourceComponent tgt = new ImplementationGuide.ManifestResourceComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReference(ImplementationGuide40_50.convertReference(src.getReference()));
        }
        if (src.hasExample()) {
            tgt.setExample(ImplementationGuide40_50.convertType(src.getExample()));
        }
        if (src.hasRelativePath()) {
            tgt.setRelativePathElement(ImplementationGuide40_50.convertUrl(src.getRelativePathElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ManifestPageComponent convertManifestPageComponent(ImplementationGuide.ManifestPageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ManifestPageComponent tgt = new ImplementationGuide.ManifestPageComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(ImplementationGuide40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ImplementationGuide40_50.convertString(src.getTitleElement()));
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getAnchor()) {
            tgt.getAnchor().add(ImplementationGuide40_50.convertString(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ManifestPageComponent convertManifestPageComponent(ImplementationGuide.ManifestPageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ManifestPageComponent tgt = new ImplementationGuide.ManifestPageComponent();
        ImplementationGuide40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(ImplementationGuide40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ImplementationGuide40_50.convertString(src.getTitleElement()));
        }
        for (StringType t : src.getAnchor()) {
            tgt.getAnchor().add(ImplementationGuide40_50.convertString(t));
        }
        return tgt;
    }
}

