/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.Enumerations;

public class Coverage40_50
extends VersionConvertor_40_50 {
    public static Coverage convertCoverage(org.hl7.fhir.r4.model.Coverage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Coverage tgt = new Coverage();
        Coverage40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Coverage40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Coverage40_50.convertCoverageStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Coverage40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasPolicyHolder()) {
            tgt.setPolicyHolder(Coverage40_50.convertReference(src.getPolicyHolder()));
        }
        if (src.hasSubscriber()) {
            tgt.setSubscriber(Coverage40_50.convertReference(src.getSubscriber()));
        }
        if (src.hasSubscriberId()) {
            tgt.getSubscriberId().setValueElement(Coverage40_50.convertString(src.getSubscriberIdElement()));
        }
        if (src.hasBeneficiary()) {
            tgt.setBeneficiary(Coverage40_50.convertReference(src.getBeneficiary()));
        }
        if (src.hasDependent()) {
            tgt.setDependentElement(Coverage40_50.convertString(src.getDependentElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(Coverage40_50.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Coverage40_50.convertPeriod(src.getPeriod()));
        }
        for (Reference reference : src.getPayor()) {
            tgt.addPayor(Coverage40_50.convertReference(reference));
        }
        for (Coverage.ClassComponent classComponent : src.getClass_()) {
            tgt.addClass_(Coverage40_50.convertClassComponent(classComponent));
        }
        if (src.hasOrder()) {
            tgt.setOrderElement(Coverage40_50.convertPositiveInt(src.getOrderElement()));
        }
        if (src.hasNetwork()) {
            tgt.setNetworkElement(Coverage40_50.convertString(src.getNetworkElement()));
        }
        for (Coverage.CostToBeneficiaryComponent costToBeneficiaryComponent : src.getCostToBeneficiary()) {
            tgt.addCostToBeneficiary(Coverage40_50.convertCostToBeneficiaryComponent(costToBeneficiaryComponent));
        }
        if (src.hasSubrogation()) {
            tgt.setSubrogationElement(Coverage40_50.convertBoolean(src.getSubrogationElement()));
        }
        for (Reference reference : src.getContract()) {
            tgt.addContract(Coverage40_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Coverage convertCoverage(Coverage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Coverage tgt = new org.hl7.fhir.r4.model.Coverage();
        Coverage40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Coverage40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Coverage40_50.convertCoverageStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Coverage40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasPolicyHolder()) {
            tgt.setPolicyHolder(Coverage40_50.convertReference(src.getPolicyHolder()));
        }
        if (src.hasSubscriber()) {
            tgt.setSubscriber(Coverage40_50.convertReference(src.getSubscriber()));
        }
        if (src.hasSubscriberId()) {
            tgt.setSubscriberIdElement(Coverage40_50.convertString(src.getSubscriberId().getValueElement()));
        }
        if (src.hasBeneficiary()) {
            tgt.setBeneficiary(Coverage40_50.convertReference(src.getBeneficiary()));
        }
        if (src.hasDependent()) {
            tgt.setDependentElement(Coverage40_50.convertString(src.getDependentElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(Coverage40_50.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Coverage40_50.convertPeriod(src.getPeriod()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getPayor()) {
            tgt.addPayor(Coverage40_50.convertReference(reference));
        }
        for (Coverage.ClassComponent classComponent : src.getClass_()) {
            tgt.addClass_(Coverage40_50.convertClassComponent(classComponent));
        }
        if (src.hasOrder()) {
            tgt.setOrderElement(Coverage40_50.convertPositiveInt(src.getOrderElement()));
        }
        if (src.hasNetwork()) {
            tgt.setNetworkElement(Coverage40_50.convertString(src.getNetworkElement()));
        }
        for (Coverage.CostToBeneficiaryComponent costToBeneficiaryComponent : src.getCostToBeneficiary()) {
            tgt.addCostToBeneficiary(Coverage40_50.convertCostToBeneficiaryComponent(costToBeneficiaryComponent));
        }
        if (src.hasSubrogation()) {
            tgt.setSubrogationElement(Coverage40_50.convertBoolean(src.getSubrogationElement()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getContract()) {
            tgt.addContract(Coverage40_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> convertCoverageStatus(Enumeration<Coverage.CoverageStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Coverage.CoverageStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Coverage.CoverageStatus> convertCoverageStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Coverage.CoverageStatus> tgt = new Enumeration<Coverage.CoverageStatus>(new Coverage.CoverageStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.FinancialResourceStatusCodes)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Coverage.CoverageStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Coverage.CoverageStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)Coverage.CoverageStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Coverage.CoverageStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Coverage.CoverageStatus.NULL);
            }
        }
        return tgt;
    }

    public static Coverage.ClassComponent convertClassComponent(Coverage.ClassComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Coverage.ClassComponent tgt = new Coverage.ClassComponent();
        Coverage40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Coverage40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(Coverage40_50.convertString(src.getValueElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Coverage40_50.convertString(src.getNameElement()));
        }
        return tgt;
    }

    public static Coverage.ClassComponent convertClassComponent(Coverage.ClassComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Coverage.ClassComponent tgt = new Coverage.ClassComponent();
        Coverage40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Coverage40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(Coverage40_50.convertString(src.getValueElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Coverage40_50.convertString(src.getNameElement()));
        }
        return tgt;
    }

    public static Coverage.CostToBeneficiaryComponent convertCostToBeneficiaryComponent(Coverage.CostToBeneficiaryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Coverage.CostToBeneficiaryComponent tgt = new Coverage.CostToBeneficiaryComponent();
        Coverage40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Coverage40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasValue()) {
            tgt.setValue(Coverage40_50.convertType(src.getValue()));
        }
        for (Coverage.ExemptionComponent t : src.getException()) {
            tgt.addException(Coverage40_50.convertExemptionComponent(t));
        }
        return tgt;
    }

    public static Coverage.CostToBeneficiaryComponent convertCostToBeneficiaryComponent(Coverage.CostToBeneficiaryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Coverage.CostToBeneficiaryComponent tgt = new Coverage.CostToBeneficiaryComponent();
        Coverage40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Coverage40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasValue()) {
            tgt.setValue(Coverage40_50.convertType(src.getValue()));
        }
        for (Coverage.ExemptionComponent t : src.getException()) {
            tgt.addException(Coverage40_50.convertExemptionComponent(t));
        }
        return tgt;
    }

    public static Coverage.ExemptionComponent convertExemptionComponent(Coverage.ExemptionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Coverage.ExemptionComponent tgt = new Coverage.ExemptionComponent();
        Coverage40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Coverage40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Coverage40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Coverage.ExemptionComponent convertExemptionComponent(Coverage.ExemptionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Coverage.ExemptionComponent tgt = new Coverage.ExemptionComponent();
        Coverage40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Coverage40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Coverage40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }
}

