/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.AppointmentResponse;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.Enumerations;

public class AppointmentResponse40_50
extends VersionConvertor_40_50 {
    public static AppointmentResponse convertAppointmentResponse(org.hl7.fhir.r4.model.AppointmentResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AppointmentResponse tgt = new AppointmentResponse();
        AppointmentResponse40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(AppointmentResponse40_50.convertIdentifier(identifier));
        }
        if (src.hasAppointment()) {
            tgt.setAppointment(AppointmentResponse40_50.convertReference(src.getAppointment()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(AppointmentResponse40_50.convertInstant(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(AppointmentResponse40_50.convertInstant(src.getEndElement()));
        }
        for (CodeableConcept codeableConcept : src.getParticipantType()) {
            tgt.addParticipantType(AppointmentResponse40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasActor()) {
            tgt.setActor(AppointmentResponse40_50.convertReference(src.getActor()));
        }
        if (src.hasParticipantStatus()) {
            tgt.setParticipantStatusElement(AppointmentResponse40_50.convertParticipantStatus(src.getParticipantStatusElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(AppointmentResponse40_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.AppointmentResponse convertAppointmentResponse(AppointmentResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.AppointmentResponse tgt = new org.hl7.fhir.r4.model.AppointmentResponse();
        AppointmentResponse40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(AppointmentResponse40_50.convertIdentifier(identifier));
        }
        if (src.hasAppointment()) {
            tgt.setAppointment(AppointmentResponse40_50.convertReference(src.getAppointment()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(AppointmentResponse40_50.convertInstant(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(AppointmentResponse40_50.convertInstant(src.getEndElement()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getParticipantType()) {
            tgt.addParticipantType(AppointmentResponse40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasActor()) {
            tgt.setActor(AppointmentResponse40_50.convertReference(src.getActor()));
        }
        if (src.hasParticipantStatus()) {
            tgt.setParticipantStatusElement(AppointmentResponse40_50.convertParticipantStatus(src.getParticipantStatusElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(AppointmentResponse40_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus> convertParticipantStatus(Enumeration<AppointmentResponse.ParticipantStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus>(new Enumerations.ParticipationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((AppointmentResponse.ParticipantStatus)((Object)src.getValue())) {
            case ACCEPTED: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.ACCEPTED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.DECLINED);
                break;
            }
            case TENTATIVE: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.TENTATIVE);
                break;
            }
            case NEEDSACTION: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.NEEDSACTION);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<AppointmentResponse.ParticipantStatus> convertParticipantStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<AppointmentResponse.ParticipantStatus> tgt = new Enumeration<AppointmentResponse.ParticipantStatus>(new AppointmentResponse.ParticipantStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ParticipationStatus)((Object)src.getValue())) {
            case ACCEPTED: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.ACCEPTED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.DECLINED);
                break;
            }
            case TENTATIVE: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.TENTATIVE);
                break;
            }
            case NEEDSACTION: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.NEEDSACTION);
                break;
            }
            default: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.NULL);
            }
        }
        return tgt;
    }
}

