/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableReference;

public class AllergyIntolerance40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.AllergyIntolerance convertAllergyIntolerance(AllergyIntolerance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.AllergyIntolerance tgt = new org.hl7.fhir.r5.model.AllergyIntolerance();
        AllergyIntolerance40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(AllergyIntolerance40_50.convertIdentifier(identifier));
        }
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(AllergyIntolerance40_50.convertCodeableConcept(src.getClinicalStatus()));
        }
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatus(AllergyIntolerance40_50.convertCodeableConcept(src.getVerificationStatus()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(AllergyIntolerance40_50.convertAllergyIntoleranceType(src.getTypeElement()));
        }
        tgt.setCategory(src.getCategory().stream().map(AllergyIntolerance40_50::convertAllergyIntoleranceCategory).collect(Collectors.toList()));
        if (src.hasCriticality()) {
            tgt.setCriticalityElement(AllergyIntolerance40_50.convertAllergyIntoleranceCriticality(src.getCriticalityElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(AllergyIntolerance40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(AllergyIntolerance40_50.convertReference(src.getPatient()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(AllergyIntolerance40_50.convertReference(src.getEncounter()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(AllergyIntolerance40_50.convertType(src.getOnset()));
        }
        if (src.hasRecordedDate()) {
            tgt.setRecordedDateElement(AllergyIntolerance40_50.convertDateTime(src.getRecordedDateElement()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(AllergyIntolerance40_50.convertReference(src.getRecorder()));
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(AllergyIntolerance40_50.convertReference(src.getAsserter()));
        }
        if (src.hasLastOccurrence()) {
            tgt.setLastOccurrenceElement(AllergyIntolerance40_50.convertDateTime(src.getLastOccurrenceElement()));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(AllergyIntolerance40_50.convertAnnotation(annotation));
        }
        for (AllergyIntolerance.AllergyIntoleranceReactionComponent allergyIntoleranceReactionComponent : src.getReaction()) {
            tgt.addReaction(AllergyIntolerance40_50.convertAllergyIntoleranceReactionComponent(allergyIntoleranceReactionComponent));
        }
        return tgt;
    }

    public static AllergyIntolerance convertAllergyIntolerance(org.hl7.fhir.r5.model.AllergyIntolerance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AllergyIntolerance tgt = new AllergyIntolerance();
        AllergyIntolerance40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(AllergyIntolerance40_50.convertIdentifier(identifier));
        }
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(AllergyIntolerance40_50.convertCodeableConcept(src.getClinicalStatus()));
        }
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatus(AllergyIntolerance40_50.convertCodeableConcept(src.getVerificationStatus()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(AllergyIntolerance40_50.convertAllergyIntoleranceType(src.getTypeElement()));
        }
        tgt.setCategory(src.getCategory().stream().map(AllergyIntolerance40_50::convertAllergyIntoleranceCategory).collect(Collectors.toList()));
        if (src.hasCriticality()) {
            tgt.setCriticalityElement(AllergyIntolerance40_50.convertAllergyIntoleranceCriticality(src.getCriticalityElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(AllergyIntolerance40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(AllergyIntolerance40_50.convertReference(src.getPatient()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(AllergyIntolerance40_50.convertReference(src.getEncounter()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(AllergyIntolerance40_50.convertType(src.getOnset()));
        }
        if (src.hasRecordedDate()) {
            tgt.setRecordedDateElement(AllergyIntolerance40_50.convertDateTime(src.getRecordedDateElement()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(AllergyIntolerance40_50.convertReference(src.getRecorder()));
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(AllergyIntolerance40_50.convertReference(src.getAsserter()));
        }
        if (src.hasLastOccurrence()) {
            tgt.setLastOccurrenceElement(AllergyIntolerance40_50.convertDateTime(src.getLastOccurrenceElement()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(AllergyIntolerance40_50.convertAnnotation(annotation));
        }
        for (AllergyIntolerance.AllergyIntoleranceReactionComponent allergyIntoleranceReactionComponent : src.getReaction()) {
            tgt.addReaction(AllergyIntolerance40_50.convertAllergyIntoleranceReactionComponent(allergyIntoleranceReactionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceType> convertAllergyIntoleranceType(Enumeration<AllergyIntolerance.AllergyIntoleranceType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceType> tgt = new org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceType>(new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceType)((Object)src.getValue())) {
            case ALLERGY: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceType.ALLERGY);
                break;
            }
            case INTOLERANCE: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceType.INTOLERANCE);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<AllergyIntolerance.AllergyIntoleranceType> convertAllergyIntoleranceType(org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<AllergyIntolerance.AllergyIntoleranceType> tgt = new Enumeration<AllergyIntolerance.AllergyIntoleranceType>(new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceType)((Object)src.getValue())) {
            case ALLERGY: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceType.ALLERGY);
                break;
            }
            case INTOLERANCE: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceType.INTOLERANCE);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCategory> convertAllergyIntoleranceCategory(Enumeration<AllergyIntolerance.AllergyIntoleranceCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCategory> tgt = new org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCategory>(new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceCategory)((Object)src.getValue())) {
            case FOOD: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.FOOD);
                break;
            }
            case MEDICATION: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.MEDICATION);
                break;
            }
            case ENVIRONMENT: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.ENVIRONMENT);
                break;
            }
            case BIOLOGIC: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.BIOLOGIC);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<AllergyIntolerance.AllergyIntoleranceCategory> convertAllergyIntoleranceCategory(org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<AllergyIntolerance.AllergyIntoleranceCategory> tgt = new Enumeration<AllergyIntolerance.AllergyIntoleranceCategory>(new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceCategory)((Object)src.getValue())) {
            case FOOD: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.FOOD);
                break;
            }
            case MEDICATION: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.MEDICATION);
                break;
            }
            case ENVIRONMENT: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.ENVIRONMENT);
                break;
            }
            case BIOLOGIC: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.BIOLOGIC);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality> convertAllergyIntoleranceCriticality(Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality> tgt = new org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality>(new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceCriticality)((Object)src.getValue())) {
            case LOW: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.LOW);
                break;
            }
            case HIGH: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.HIGH);
                break;
            }
            case UNABLETOASSESS: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.UNABLETOASSESS);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality> convertAllergyIntoleranceCriticality(org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality> tgt = new Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality>(new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceCriticality)((Object)src.getValue())) {
            case LOW: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.LOW);
                break;
            }
            case HIGH: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.HIGH);
                break;
            }
            case UNABLETOASSESS: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.UNABLETOASSESS);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.NULL);
            }
        }
        return tgt;
    }

    public static AllergyIntolerance.AllergyIntoleranceReactionComponent convertAllergyIntoleranceReactionComponent(AllergyIntolerance.AllergyIntoleranceReactionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AllergyIntolerance.AllergyIntoleranceReactionComponent tgt = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        AllergyIntolerance40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSubstance()) {
            tgt.setSubstance(AllergyIntolerance40_50.convertCodeableConcept(src.getSubstance()));
        }
        for (CodeableConcept codeableConcept : src.getManifestation()) {
            tgt.addManifestation(new CodeableReference(AllergyIntolerance40_50.convertCodeableConcept(codeableConcept)));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(AllergyIntolerance40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasOnset()) {
            tgt.setOnsetElement(AllergyIntolerance40_50.convertDateTime(src.getOnsetElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(AllergyIntolerance40_50.convertAllergyIntoleranceSeverity(src.getSeverityElement()));
        }
        if (src.hasExposureRoute()) {
            tgt.setExposureRoute(AllergyIntolerance40_50.convertCodeableConcept(src.getExposureRoute()));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(AllergyIntolerance40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static AllergyIntolerance.AllergyIntoleranceReactionComponent convertAllergyIntoleranceReactionComponent(AllergyIntolerance.AllergyIntoleranceReactionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AllergyIntolerance.AllergyIntoleranceReactionComponent tgt = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        AllergyIntolerance40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSubstance()) {
            tgt.setSubstance(AllergyIntolerance40_50.convertCodeableConcept(src.getSubstance()));
        }
        for (CodeableReference codeableReference : src.getManifestation()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addManifestation(AllergyIntolerance40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(AllergyIntolerance40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasOnset()) {
            tgt.setOnsetElement(AllergyIntolerance40_50.convertDateTime(src.getOnsetElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(AllergyIntolerance40_50.convertAllergyIntoleranceSeverity(src.getSeverityElement()));
        }
        if (src.hasExposureRoute()) {
            tgt.setExposureRoute(AllergyIntolerance40_50.convertCodeableConcept(src.getExposureRoute()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(AllergyIntolerance40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity> convertAllergyIntoleranceSeverity(Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity> tgt = new org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity>(new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceSeverity)((Object)src.getValue())) {
            case MILD: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.MILD);
                break;
            }
            case MODERATE: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.MODERATE);
                break;
            }
            case SEVERE: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.SEVERE);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity> convertAllergyIntoleranceSeverity(org.hl7.fhir.r5.model.Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity> tgt = new Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity>(new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceSeverity)((Object)src.getValue())) {
            case MILD: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.MILD);
                break;
            }
            case MODERATE: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.MODERATE);
                break;
            }
            case SEVERE: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.SEVERE);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.NULL);
            }
        }
        return tgt;
    }
}

