/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Account;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.Account;

public class Account40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Account convertAccount(Account src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Account tgt = new org.hl7.fhir.r5.model.Account();
        Account40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Account40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Account40_50.convertAccountStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Account40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Account40_50.convertString(src.getNameElement()));
        }
        for (Reference reference : src.getSubject()) {
            tgt.addSubject(Account40_50.convertReference(reference));
        }
        if (src.hasServicePeriod()) {
            tgt.setServicePeriod(Account40_50.convertPeriod(src.getServicePeriod()));
        }
        for (Account.CoverageComponent coverageComponent : src.getCoverage()) {
            tgt.addCoverage(Account40_50.convertCoverageComponent(coverageComponent));
        }
        if (src.hasOwner()) {
            tgt.setOwner(Account40_50.convertReference(src.getOwner()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Account40_50.convertString(src.getDescriptionElement()));
        }
        for (Account.GuarantorComponent guarantorComponent : src.getGuarantor()) {
            tgt.addGuarantor(Account40_50.convertGuarantorComponent(guarantorComponent));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(Account40_50.convertReference(src.getPartOf()));
        }
        return tgt;
    }

    public static Account convertAccount(org.hl7.fhir.r5.model.Account src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Account tgt = new Account();
        Account40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Account40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Account40_50.convertAccountStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Account40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Account40_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getSubject()) {
            tgt.addSubject(Account40_50.convertReference(reference));
        }
        if (src.hasServicePeriod()) {
            tgt.setServicePeriod(Account40_50.convertPeriod(src.getServicePeriod()));
        }
        for (Account.CoverageComponent coverageComponent : src.getCoverage()) {
            tgt.addCoverage(Account40_50.convertCoverageComponent(coverageComponent));
        }
        if (src.hasOwner()) {
            tgt.setOwner(Account40_50.convertReference(src.getOwner()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Account40_50.convertString(src.getDescriptionElement()));
        }
        for (Account.GuarantorComponent guarantorComponent : src.getGuarantor()) {
            tgt.addGuarantor(Account40_50.convertGuarantorComponent(guarantorComponent));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(Account40_50.convertReference(src.getPartOf()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Account.AccountStatus> convertAccountStatus(Enumeration<Account.AccountStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Account.AccountStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Account.AccountStatus>(new Account.AccountStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Account.AccountStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Account.AccountStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Account.AccountStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Account.AccountStatus.ENTEREDINERROR);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Account.AccountStatus.ONHOLD);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Account.AccountStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Account.AccountStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Account.AccountStatus> convertAccountStatus(org.hl7.fhir.r5.model.Enumeration<Account.AccountStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Account.AccountStatus> tgt = new Enumeration<Account.AccountStatus>(new Account.AccountStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Account.AccountStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Account.AccountStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Account.AccountStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Account.AccountStatus.ENTEREDINERROR);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Account.AccountStatus.ONHOLD);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Account.AccountStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Account.AccountStatus.NULL);
            }
        }
        return tgt;
    }

    public static Account.CoverageComponent convertCoverageComponent(Account.CoverageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Account.CoverageComponent tgt = new Account.CoverageComponent();
        Account40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCoverage()) {
            tgt.setCoverage(Account40_50.convertReference(src.getCoverage()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(Account40_50.convertPositiveInt(src.getPriorityElement()));
        }
        return tgt;
    }

    public static Account.CoverageComponent convertCoverageComponent(Account.CoverageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Account.CoverageComponent tgt = new Account.CoverageComponent();
        Account40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCoverage()) {
            tgt.setCoverage(Account40_50.convertReference(src.getCoverage()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(Account40_50.convertPositiveInt(src.getPriorityElement()));
        }
        return tgt;
    }

    public static Account.GuarantorComponent convertGuarantorComponent(Account.GuarantorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Account.GuarantorComponent tgt = new Account.GuarantorComponent();
        Account40_50.copyElement(src, tgt, new String[0]);
        if (src.hasParty()) {
            tgt.setParty(Account40_50.convertReference(src.getParty()));
        }
        if (src.hasOnHold()) {
            tgt.setOnHoldElement(Account40_50.convertBoolean(src.getOnHoldElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Account40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Account.GuarantorComponent convertGuarantorComponent(Account.GuarantorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Account.GuarantorComponent tgt = new Account.GuarantorComponent();
        Account40_50.copyElement(src, tgt, new String[0]);
        if (src.hasParty()) {
            tgt.setParty(Account40_50.convertReference(src.getParty()));
        }
        if (src.hasOnHold()) {
            tgt.setOnHoldElement(Account40_50.convertBoolean(src.getOnHoldElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Account40_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }
}

