/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.MessageHeader;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.MessageHeader;

public class MessageHeader30_50 {
    public static MessageHeader.MessageDestinationComponent convertMessageDestinationComponent(MessageHeader.MessageDestinationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageDestinationComponent tgt = new MessageHeader.MessageDestinationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_50.convertReference(src.getTarget()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpoint(src.getEndpoint());
        }
        return tgt;
    }

    public static MessageHeader.MessageDestinationComponent convertMessageDestinationComponent(MessageHeader.MessageDestinationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageDestinationComponent tgt = new MessageHeader.MessageDestinationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_50.convertReference(src.getTarget()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpoint(src.getEndpoint());
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.MessageHeader convertMessageHeader(MessageHeader src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.MessageHeader tgt = new org.hl7.fhir.r5.model.MessageHeader();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasEvent()) {
            tgt.setEvent(VersionConvertor_30_50.convertCoding(src.getEvent()));
        }
        for (MessageHeader.MessageDestinationComponent messageDestinationComponent : src.getDestination()) {
            tgt.addDestination(MessageHeader30_50.convertMessageDestinationComponent(messageDestinationComponent));
        }
        if (src.hasSender()) {
            tgt.setSender(VersionConvertor_30_50.convertReference(src.getSender()));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(VersionConvertor_30_50.convertReference(src.getEnterer()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_50.convertReference(src.getAuthor()));
        }
        if (src.hasSource()) {
            tgt.setSource(MessageHeader30_50.convertMessageSourceComponent(src.getSource()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(VersionConvertor_30_50.convertReference(src.getResponsible()));
        }
        if (src.hasReason()) {
            tgt.setReason(VersionConvertor_30_50.convertCodeableConcept(src.getReason()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(MessageHeader30_50.convertMessageHeaderResponseComponent(src.getResponse()));
        }
        for (Reference reference : src.getFocus()) {
            tgt.addFocus(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static MessageHeader convertMessageHeader(org.hl7.fhir.r5.model.MessageHeader src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader tgt = new MessageHeader();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasEventCoding()) {
            tgt.setEvent(VersionConvertor_30_50.convertCoding(src.getEventCoding()));
        }
        for (MessageHeader.MessageDestinationComponent messageDestinationComponent : src.getDestination()) {
            tgt.addDestination(MessageHeader30_50.convertMessageDestinationComponent(messageDestinationComponent));
        }
        if (src.hasSender()) {
            tgt.setSender(VersionConvertor_30_50.convertReference(src.getSender()));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(VersionConvertor_30_50.convertReference(src.getEnterer()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_50.convertReference(src.getAuthor()));
        }
        if (src.hasSource()) {
            tgt.setSource(MessageHeader30_50.convertMessageSourceComponent(src.getSource()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(VersionConvertor_30_50.convertReference(src.getResponsible()));
        }
        if (src.hasReason()) {
            tgt.setReason(VersionConvertor_30_50.convertCodeableConcept(src.getReason()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(MessageHeader30_50.convertMessageHeaderResponseComponent(src.getResponse()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getFocus()) {
            tgt.addFocus(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static MessageHeader.MessageHeaderResponseComponent convertMessageHeaderResponseComponent(MessageHeader.MessageHeaderResponseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageHeaderResponseComponent tgt = new MessageHeader.MessageHeaderResponseComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifierElement(VersionConvertor_30_50.convertId(src.getIdentifierElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(MessageHeader30_50.convertResponseType(src.getCodeElement()));
        }
        if (src.hasDetails()) {
            tgt.setDetails(VersionConvertor_30_50.convertReference(src.getDetails()));
        }
        return tgt;
    }

    public static MessageHeader.MessageHeaderResponseComponent convertMessageHeaderResponseComponent(MessageHeader.MessageHeaderResponseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageHeaderResponseComponent tgt = new MessageHeader.MessageHeaderResponseComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifierElement(VersionConvertor_30_50.convertId(src.getIdentifierElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(MessageHeader30_50.convertResponseType(src.getCodeElement()));
        }
        if (src.hasDetails()) {
            tgt.setDetails(VersionConvertor_30_50.convertReference(src.getDetails()));
        }
        return tgt;
    }

    public static MessageHeader.MessageSourceComponent convertMessageSourceComponent(MessageHeader.MessageSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageSourceComponent tgt = new MessageHeader.MessageSourceComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasSoftware()) {
            tgt.setSoftwareElement(VersionConvertor_30_50.convertString(src.getSoftwareElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasContact()) {
            tgt.setContact(VersionConvertor_30_50.convertContactPoint(src.getContact()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpoint(src.getEndpoint());
        }
        return tgt;
    }

    public static MessageHeader.MessageSourceComponent convertMessageSourceComponent(MessageHeader.MessageSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageSourceComponent tgt = new MessageHeader.MessageSourceComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasSoftware()) {
            tgt.setSoftwareElement(VersionConvertor_30_50.convertString(src.getSoftwareElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasContact()) {
            tgt.setContact(VersionConvertor_30_50.convertContactPoint(src.getContact()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpoint(src.getEndpoint());
        }
        return tgt;
    }

    public static Enumeration<MessageHeader.ResponseType> convertResponseType(org.hl7.fhir.dstu3.model.Enumeration<MessageHeader.ResponseType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MessageHeader.ResponseType> tgt = new Enumeration<MessageHeader.ResponseType>(new MessageHeader.ResponseTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((MessageHeader.ResponseType)((Object)src.getValue())) {
            case OK: {
                tgt.setValue((Object)MessageHeader.ResponseType.OK);
                break;
            }
            case TRANSIENTERROR: {
                tgt.setValue((Object)MessageHeader.ResponseType.TRANSIENTERROR);
                break;
            }
            case FATALERROR: {
                tgt.setValue((Object)MessageHeader.ResponseType.FATALERROR);
                break;
            }
            default: {
                tgt.setValue((Object)MessageHeader.ResponseType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<MessageHeader.ResponseType> convertResponseType(Enumeration<MessageHeader.ResponseType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MessageHeader.ResponseType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MessageHeader.ResponseType>(new MessageHeader.ResponseTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((MessageHeader.ResponseType)((Object)src.getValue())) {
            case OK: {
                tgt.setValue((Object)MessageHeader.ResponseType.OK);
                break;
            }
            case TRANSIENTERROR: {
                tgt.setValue((Object)MessageHeader.ResponseType.TRANSIENTERROR);
                break;
            }
            case FATALERROR: {
                tgt.setValue((Object)MessageHeader.ResponseType.FATALERROR);
                break;
            }
            default: {
                tgt.setValue((Object)MessageHeader.ResponseType.NULL);
            }
        }
        return tgt;
    }
}

