/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.FamilyMemberHistory;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.UriType;

public class FamilyMemberHistory30_50 {
    public static org.hl7.fhir.dstu3.model.Enumeration<FamilyMemberHistory.FamilyHistoryStatus> convertFamilyHistoryStatus(Enumeration<FamilyMemberHistory.FamilyHistoryStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<FamilyMemberHistory.FamilyHistoryStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<FamilyMemberHistory.FamilyHistoryStatus>(new FamilyMemberHistory.FamilyHistoryStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((FamilyMemberHistory.FamilyHistoryStatus)((Object)src.getValue())) {
            case PARTIAL: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.PARTIAL);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.ENTEREDINERROR);
                break;
            }
            case HEALTHUNKNOWN: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.HEALTHUNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<FamilyMemberHistory.FamilyHistoryStatus> convertFamilyHistoryStatus(org.hl7.fhir.dstu3.model.Enumeration<FamilyMemberHistory.FamilyHistoryStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<FamilyMemberHistory.FamilyHistoryStatus> tgt = new Enumeration<FamilyMemberHistory.FamilyHistoryStatus>(new FamilyMemberHistory.FamilyHistoryStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((FamilyMemberHistory.FamilyHistoryStatus)((Object)src.getValue())) {
            case PARTIAL: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.PARTIAL);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.ENTEREDINERROR);
                break;
            }
            case HEALTHUNKNOWN: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.HEALTHUNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.NULL);
            }
        }
        return tgt;
    }

    public static FamilyMemberHistory convertFamilyMemberHistory(org.hl7.fhir.r5.model.FamilyMemberHistory src) throws FHIRException {
        if (src == null) {
            return null;
        }
        FamilyMemberHistory tgt = new FamilyMemberHistory();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        for (UriType uriType : src.getInstantiatesCanonical()) {
            tgt.addDefinition(new Reference((String)uriType.getValue()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(FamilyMemberHistory30_50.convertFamilyHistoryStatus(src.getStatusElement()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setNotDoneReason(VersionConvertor_30_50.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_50.convertReference(src.getPatient()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(VersionConvertor_30_50.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasBorn()) {
            tgt.setBorn(VersionConvertor_30_50.convertType(src.getBorn()));
        }
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_30_50.convertType(src.getAge()));
        }
        if (src.hasEstimatedAge()) {
            tgt.setEstimatedAgeElement(VersionConvertor_30_50.convertBoolean(src.getEstimatedAgeElement()));
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(VersionConvertor_30_50.convertType(src.getDeceased()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(VersionConvertor_30_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(VersionConvertor_30_50.convertReference(codeableReference.getReference()));
        }
        for (org.hl7.fhir.r5.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        for (FamilyMemberHistory.FamilyMemberHistoryConditionComponent familyMemberHistoryConditionComponent : src.getCondition()) {
            tgt.addCondition(FamilyMemberHistory30_50.convertFamilyMemberHistoryConditionComponent(familyMemberHistoryConditionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.FamilyMemberHistory convertFamilyMemberHistory(FamilyMemberHistory src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.FamilyMemberHistory tgt = new org.hl7.fhir.r5.model.FamilyMemberHistory();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        for (Reference reference : src.getDefinition()) {
            tgt.addInstantiatesCanonical(reference.getReference());
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(FamilyMemberHistory30_50.convertFamilyHistoryStatus(src.getStatusElement()));
        }
        if (src.hasNotDoneReason()) {
            tgt.setDataAbsentReason(VersionConvertor_30_50.convertCodeableConcept(src.getNotDoneReason()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_50.convertReference(src.getPatient()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(VersionConvertor_30_50.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasBorn()) {
            tgt.setBorn(VersionConvertor_30_50.convertType(src.getBorn()));
        }
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_30_50.convertType(src.getAge()));
        }
        if (src.hasEstimatedAge()) {
            tgt.setEstimatedAgeElement(VersionConvertor_30_50.convertBoolean(src.getEstimatedAgeElement()));
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(VersionConvertor_30_50.convertType(src.getDeceased()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(VersionConvertor_30_50.convertCodeableConceptToCodableReference(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReason(VersionConvertor_30_50.convertReferenceToCodableReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        for (FamilyMemberHistory.FamilyMemberHistoryConditionComponent familyMemberHistoryConditionComponent : src.getCondition()) {
            tgt.addCondition(FamilyMemberHistory30_50.convertFamilyMemberHistoryConditionComponent(familyMemberHistoryConditionComponent));
        }
        return tgt;
    }

    public static FamilyMemberHistory.FamilyMemberHistoryConditionComponent convertFamilyMemberHistoryConditionComponent(FamilyMemberHistory.FamilyMemberHistoryConditionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent tgt = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_50.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_30_50.convertType(src.getOnset()));
        }
        for (Annotation t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(t));
        }
        return tgt;
    }

    public static FamilyMemberHistory.FamilyMemberHistoryConditionComponent convertFamilyMemberHistoryConditionComponent(FamilyMemberHistory.FamilyMemberHistoryConditionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent tgt = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_50.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_30_50.convertType(src.getOnset()));
        }
        for (org.hl7.fhir.r5.model.Annotation t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(t));
        }
        return tgt;
    }
}

