/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.DetectedIssue;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;

public class DetectedIssue30_50 {
    public static DetectedIssue convertDetectedIssue(org.hl7.fhir.r5.model.DetectedIssue src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DetectedIssue tgt = new DetectedIssue();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DetectedIssue30_50.convertDetectedIssueStatus(src.getStatusElement()));
        }
        if (src.hasCode()) {
            tgt.setCategory(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(DetectedIssue30_50.convertDetectedIssueSeverity(src.getSeverityElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_50.convertReference(src.getPatient()));
        }
        if (src.hasIdentifiedDateTimeType()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getIdentifiedDateTimeType()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_50.convertReference(src.getAuthor()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getImplicated()) {
            tgt.addImplicated(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(VersionConvertor_30_50.convertString(src.getDetailElement()));
        }
        if (src.hasReference()) {
            tgt.setReferenceElement(VersionConvertor_30_50.convertUri(src.getReferenceElement()));
        }
        for (DetectedIssue.DetectedIssueMitigationComponent detectedIssueMitigationComponent : src.getMitigation()) {
            tgt.addMitigation(DetectedIssue30_50.convertDetectedIssueMitigationComponent(detectedIssueMitigationComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.DetectedIssue convertDetectedIssue(DetectedIssue src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.DetectedIssue tgt = new org.hl7.fhir.r5.model.DetectedIssue();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DetectedIssue30_50.convertDetectedIssueStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(DetectedIssue30_50.convertDetectedIssueSeverity(src.getSeverityElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_50.convertReference(src.getPatient()));
        }
        if (src.hasDate()) {
            tgt.setIdentified(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_50.convertReference(src.getAuthor()));
        }
        for (Reference reference : src.getImplicated()) {
            tgt.addImplicated(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(VersionConvertor_30_50.convertString(src.getDetailElement()));
        }
        if (src.hasReference()) {
            tgt.setReferenceElement(VersionConvertor_30_50.convertUri(src.getReferenceElement()));
        }
        for (DetectedIssue.DetectedIssueMitigationComponent detectedIssueMitigationComponent : src.getMitigation()) {
            tgt.addMitigation(DetectedIssue30_50.convertDetectedIssueMitigationComponent(detectedIssueMitigationComponent));
        }
        return tgt;
    }

    public static DetectedIssue.DetectedIssueMitigationComponent convertDetectedIssueMitigationComponent(DetectedIssue.DetectedIssueMitigationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DetectedIssue.DetectedIssueMitigationComponent tgt = new DetectedIssue.DetectedIssueMitigationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasAction()) {
            tgt.setAction(VersionConvertor_30_50.convertCodeableConcept(src.getAction()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_50.convertReference(src.getAuthor()));
        }
        return tgt;
    }

    public static DetectedIssue.DetectedIssueMitigationComponent convertDetectedIssueMitigationComponent(DetectedIssue.DetectedIssueMitigationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DetectedIssue.DetectedIssueMitigationComponent tgt = new DetectedIssue.DetectedIssueMitigationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasAction()) {
            tgt.setAction(VersionConvertor_30_50.convertCodeableConcept(src.getAction()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_50.convertReference(src.getAuthor()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<DetectedIssue.DetectedIssueSeverity> convertDetectedIssueSeverity(Enumeration<DetectedIssue.DetectedIssueSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<DetectedIssue.DetectedIssueSeverity> tgt = new org.hl7.fhir.dstu3.model.Enumeration<DetectedIssue.DetectedIssueSeverity>(new DetectedIssue.DetectedIssueSeverityEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((DetectedIssue.DetectedIssueSeverity)((Object)src.getValue())) {
            case HIGH: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.HIGH);
                break;
            }
            case MODERATE: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.MODERATE);
                break;
            }
            case LOW: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.LOW);
                break;
            }
            default: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DetectedIssue.DetectedIssueSeverity> convertDetectedIssueSeverity(org.hl7.fhir.dstu3.model.Enumeration<DetectedIssue.DetectedIssueSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DetectedIssue.DetectedIssueSeverity> tgt = new Enumeration<DetectedIssue.DetectedIssueSeverity>(new DetectedIssue.DetectedIssueSeverityEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((DetectedIssue.DetectedIssueSeverity)((Object)src.getValue())) {
            case HIGH: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.HIGH);
                break;
            }
            case MODERATE: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.MODERATE);
                break;
            }
            case LOW: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.LOW);
                break;
            }
            default: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.ObservationStatus> convertDetectedIssueStatus(org.hl7.fhir.dstu3.model.Enumeration<DetectedIssue.DetectedIssueStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.ObservationStatus> tgt = new Enumeration<Enumerations.ObservationStatus>(new Enumerations.ObservationStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((DetectedIssue.DetectedIssueStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)Enumerations.ObservationStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Enumerations.ObservationStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.CORRECTED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.ObservationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.ObservationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ObservationStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<DetectedIssue.DetectedIssueStatus> convertDetectedIssueStatus(Enumeration<Enumerations.ObservationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<DetectedIssue.DetectedIssueStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<DetectedIssue.DetectedIssueStatus>(new DetectedIssue.DetectedIssueStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ObservationStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.CORRECTED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueStatus.NULL);
            }
        }
        return tgt;
    }
}

