/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import java.util.Collections;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Composition;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;

public class Composition30_50 {
    public static Composition convertComposition(org.hl7.fhir.dstu3.model.Composition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition tgt = new Composition();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Composition30_50.convertCompositionStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasClass_()) {
            tgt.addCategory(VersionConvertor_30_50.convertCodeableConcept(src.getClass_()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_50.convertReference(src.getEncounter()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        for (Reference reference : src.getAuthor()) {
            tgt.addAuthor(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasConfidentiality()) {
            tgt.setConfidentialityElement(Composition30_50.convertDocumentConfidentiality(src.getConfidentialityElement()));
        }
        for (Composition.CompositionAttesterComponent compositionAttesterComponent : src.getAttester()) {
            tgt.addAttester(Composition30_50.convertCompositionAttesterComponent(compositionAttesterComponent));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_30_50.convertReference(src.getCustodian()));
        }
        for (Composition.CompositionRelatesToComponent compositionRelatesToComponent : src.getRelatesTo()) {
            tgt.addRelatesTo(Composition30_50.convertCompositionRelatesToComponent(compositionRelatesToComponent));
        }
        for (Composition.CompositionEventComponent compositionEventComponent : src.getEvent()) {
            tgt.addEvent(Composition30_50.convertCompositionEventComponent(compositionEventComponent));
        }
        for (Composition.SectionComponent sectionComponent : src.getSection()) {
            tgt.addSection(Composition30_50.convertSectionComponent(sectionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Composition convertComposition(Composition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Composition tgt = new org.hl7.fhir.dstu3.model.Composition();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Composition30_50.convertCompositionStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasCategory()) {
            tgt.setClass_(VersionConvertor_30_50.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_50.convertReference(src.getEncounter()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getAuthor()) {
            tgt.addAuthor(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasConfidentiality()) {
            tgt.setConfidentialityElement(Composition30_50.convertDocumentConfidentiality(src.getConfidentialityElement()));
        }
        for (Composition.CompositionAttesterComponent compositionAttesterComponent : src.getAttester()) {
            tgt.addAttester(Composition30_50.convertCompositionAttesterComponent(compositionAttesterComponent));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_30_50.convertReference(src.getCustodian()));
        }
        for (Composition.CompositionRelatesToComponent compositionRelatesToComponent : src.getRelatesTo()) {
            tgt.addRelatesTo(Composition30_50.convertCompositionRelatesToComponent(compositionRelatesToComponent));
        }
        for (Composition.CompositionEventComponent compositionEventComponent : src.getEvent()) {
            tgt.addEvent(Composition30_50.convertCompositionEventComponent(compositionEventComponent));
        }
        for (Composition.SectionComponent sectionComponent : src.getSection()) {
            tgt.addSection(Composition30_50.convertSectionComponent(sectionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionAttestationMode> convertCompositionAttestationMode(Enumeration<Composition.CompositionAttestationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionAttestationMode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionAttestationMode>(new Composition.CompositionAttestationModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Composition.CompositionAttestationMode)((Object)src.getValue())) {
            case PERSONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PERSONAL);
                break;
            }
            case PROFESSIONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PROFESSIONAL);
                break;
            }
            case LEGAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.LEGAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.OFFICIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Composition.CompositionAttestationMode> convertCompositionAttestationMode(org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionAttestationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Composition.CompositionAttestationMode> tgt = new Enumeration<Composition.CompositionAttestationMode>(new Composition.CompositionAttestationModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Composition.CompositionAttestationMode)((Object)src.getValue())) {
            case PERSONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PERSONAL);
                break;
            }
            case PROFESSIONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PROFESSIONAL);
                break;
            }
            case LEGAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.LEGAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.OFFICIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.NULL);
            }
        }
        return tgt;
    }

    public static Composition.CompositionAttesterComponent convertCompositionAttesterComponent(Composition.CompositionAttesterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionAttesterComponent tgt = new Composition.CompositionAttesterComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(Composition30_50.convertCompositionAttestationMode(src.getMode().get(0)));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(VersionConvertor_30_50.convertDateTime(src.getTimeElement()));
        }
        if (src.hasParty()) {
            tgt.setParty(VersionConvertor_30_50.convertReference(src.getParty()));
        }
        return tgt;
    }

    public static Composition.CompositionAttesterComponent convertCompositionAttesterComponent(Composition.CompositionAttesterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionAttesterComponent tgt = new Composition.CompositionAttesterComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setMode(Collections.singletonList(Composition30_50.convertCompositionAttestationMode(src.getModeElement())));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(VersionConvertor_30_50.convertDateTime(src.getTimeElement()));
        }
        if (src.hasParty()) {
            tgt.setParty(VersionConvertor_30_50.convertReference(src.getParty()));
        }
        return tgt;
    }

    public static Composition.CompositionEventComponent convertCompositionEventComponent(Composition.CompositionEventComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionEventComponent tgt = new Composition.CompositionEventComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getDetail()) {
            tgt.addDetail(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static Composition.CompositionEventComponent convertCompositionEventComponent(Composition.CompositionEventComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionEventComponent tgt = new Composition.CompositionEventComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        for (Reference reference : src.getDetail()) {
            tgt.addDetail(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static Composition.CompositionRelatesToComponent convertCompositionRelatesToComponent(Composition.CompositionRelatesToComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionRelatesToComponent tgt = new Composition.CompositionRelatesToComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(Composition30_50.convertDocumentRelationshipType(src.getCodeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_50.convertType(src.getTarget()));
        }
        return tgt;
    }

    public static Composition.CompositionRelatesToComponent convertCompositionRelatesToComponent(Composition.CompositionRelatesToComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionRelatesToComponent tgt = new Composition.CompositionRelatesToComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(Composition30_50.convertDocumentRelationshipType(src.getCodeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_50.convertType(src.getTarget()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Composition.DocumentRelationshipType> convertDocumentRelationshipType(Enumeration<Enumerations.DocumentRelationshipType> src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Composition.DocumentRelationshipType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Composition.DocumentRelationshipType>(new Composition.DocumentRelationshipTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.DocumentRelationshipType)((Object)src.getValue())) {
            case REPLACES: {
                tgt.setValue((Object)Composition.DocumentRelationshipType.REPLACES);
                break;
            }
            case TRANSFORMS: {
                tgt.setValue((Object)Composition.DocumentRelationshipType.TRANSFORMS);
                break;
            }
            case SIGNS: {
                tgt.setValue((Object)Composition.DocumentRelationshipType.SIGNS);
                break;
            }
            case APPENDS: {
                tgt.setValue((Object)Composition.DocumentRelationshipType.APPENDS);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.DocumentRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.DocumentRelationshipType> convertDocumentRelationshipType(org.hl7.fhir.dstu3.model.Enumeration<Composition.DocumentRelationshipType> src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Enumeration<Enumerations.DocumentRelationshipType> tgt = new Enumeration<Enumerations.DocumentRelationshipType>(new Enumerations.DocumentRelationshipTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Composition.DocumentRelationshipType)((Object)src.getValue())) {
            case REPLACES: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.REPLACES);
                break;
            }
            case TRANSFORMS: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.TRANSFORMS);
                break;
            }
            case SIGNS: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.SIGNS);
                break;
            }
            case APPENDS: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.APPENDS);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionStatus> convertCompositionStatus(Enumeration<Enumerations.CompositionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionStatus>(new Composition.CompositionStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.CompositionStatus)((Object)src.getValue())) {
            case PRELIMINARY: {
                tgt.setValue((Object)Composition.CompositionStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Composition.CompositionStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Composition.CompositionStatus.AMENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Composition.CompositionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.CompositionStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.CompositionStatus> convertCompositionStatus(org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.CompositionStatus> tgt = new Enumeration<Enumerations.CompositionStatus>(new Enumerations.CompositionStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Composition.CompositionStatus)((Object)src.getValue())) {
            case PRELIMINARY: {
                tgt.setValue((Object)Enumerations.CompositionStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Enumerations.CompositionStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Enumerations.CompositionStatus.AMENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.CompositionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.CompositionStatus.NULL);
            }
        }
        return tgt;
    }

    public static CodeType convertDocumentConfidentiality(org.hl7.fhir.dstu3.model.Enumeration<Composition.DocumentConfidentiality> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeType tgt = new CodeType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        tgt.setValue(((Composition.DocumentConfidentiality)((Object)src.getValue())).toCode());
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Composition.DocumentConfidentiality> convertDocumentConfidentiality(CodeType src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Composition.DocumentConfidentiality> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Composition.DocumentConfidentiality>(new Composition.DocumentConfidentialityEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((String)src.getValue()) {
            case "U": {
                tgt.setValue((Object)Composition.DocumentConfidentiality.U);
                break;
            }
            case "L": {
                tgt.setValue((Object)Composition.DocumentConfidentiality.L);
                break;
            }
            case "M": {
                tgt.setValue((Object)Composition.DocumentConfidentiality.M);
                break;
            }
            case "N": {
                tgt.setValue((Object)Composition.DocumentConfidentiality.N);
                break;
            }
            case "R": {
                tgt.setValue((Object)Composition.DocumentConfidentiality.R);
                break;
            }
            case "V": {
                tgt.setValue((Object)Composition.DocumentConfidentiality.V);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.DocumentConfidentiality.NULL);
            }
        }
        return tgt;
    }

    public static Composition.SectionComponent convertSectionComponent(Composition.SectionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.SectionComponent tgt = new Composition.SectionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasText()) {
            tgt.setText(VersionConvertor_30_50.convertNarrative(src.getText()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(Composition30_50.convertSectionMode(src.getModeElement()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_30_50.convertCodeableConcept(src.getOrderedBy()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getEntry()) {
            tgt.addEntry(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(VersionConvertor_30_50.convertCodeableConcept(src.getEmptyReason()));
        }
        for (Composition.SectionComponent sectionComponent : src.getSection()) {
            tgt.addSection(Composition30_50.convertSectionComponent(sectionComponent));
        }
        return tgt;
    }

    public static Composition.SectionComponent convertSectionComponent(Composition.SectionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.SectionComponent tgt = new Composition.SectionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasText()) {
            tgt.setText(VersionConvertor_30_50.convertNarrative(src.getText()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(Composition30_50.convertSectionMode(src.getModeElement()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_30_50.convertCodeableConcept(src.getOrderedBy()));
        }
        for (Reference reference : src.getEntry()) {
            tgt.addEntry(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(VersionConvertor_30_50.convertCodeableConcept(src.getEmptyReason()));
        }
        for (Composition.SectionComponent sectionComponent : src.getSection()) {
            tgt.addSection(Composition30_50.convertSectionComponent(sectionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Composition.SectionMode> convertSectionMode(Enumeration<Enumerations.ListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Composition.SectionMode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Composition.SectionMode>(new Composition.SectionModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ListMode)((Object)src.getValue())) {
            case WORKING: {
                tgt.setValue((Object)Composition.SectionMode.WORKING);
                break;
            }
            case SNAPSHOT: {
                tgt.setValue((Object)Composition.SectionMode.SNAPSHOT);
                break;
            }
            case CHANGES: {
                tgt.setValue((Object)Composition.SectionMode.CHANGES);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.SectionMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.ListMode> convertSectionMode(org.hl7.fhir.dstu3.model.Enumeration<Composition.SectionMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.ListMode> tgt = new Enumeration<Enumerations.ListMode>(new Enumerations.ListModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Composition.SectionMode)((Object)src.getValue())) {
            case WORKING: {
                tgt.setValue((Object)Enumerations.ListMode.WORKING);
                break;
            }
            case SNAPSHOT: {
                tgt.setValue((Object)Enumerations.ListMode.SNAPSHOT);
                break;
            }
            case CHANGES: {
                tgt.setValue((Object)Enumerations.ListMode.CHANGES);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ListMode.NULL);
            }
        }
        return tgt;
    }
}

