/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.ClinicalImpression;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;

public class ClinicalImpression30_50 {
    public static org.hl7.fhir.dstu3.model.ClinicalImpression convertClinicalImpression(ClinicalImpression src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ClinicalImpression tgt = new org.hl7.fhir.dstu3.model.ClinicalImpression();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ClinicalImpression30_50.convertClinicalImpressionStatus(src.getStatusElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_50.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_50.convertType(src.getEffective()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPerformer()) {
            tgt.setAssessor(VersionConvertor_30_50.convertReference(src.getPerformer()));
        }
        if (src.hasPrevious()) {
            tgt.setPrevious(VersionConvertor_30_50.convertReference(src.getPrevious()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getProblem()) {
            tgt.addProblem(VersionConvertor_30_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getProtocol()) {
            tgt.addProtocol((String)uriType.getValue());
        }
        if (src.hasSummary()) {
            tgt.setSummaryElement(VersionConvertor_30_50.convertString(src.getSummaryElement()));
        }
        for (ClinicalImpression.ClinicalImpressionFindingComponent clinicalImpressionFindingComponent : src.getFinding()) {
            tgt.addFinding(ClinicalImpression30_50.convertClinicalImpressionFindingComponent(clinicalImpressionFindingComponent));
        }
        for (CodeableConcept codeableConcept : src.getPrognosisCodeableConcept()) {
            tgt.addPrognosisCodeableConcept(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getPrognosisReference()) {
            tgt.addPrognosisReference(VersionConvertor_30_50.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static ClinicalImpression convertClinicalImpression(org.hl7.fhir.dstu3.model.ClinicalImpression src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression tgt = new ClinicalImpression();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ClinicalImpression30_50.convertClinicalImpressionStatus(src.getStatusElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_50.convertReference(src.getContext()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_50.convertType(src.getEffective()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasAssessor()) {
            tgt.setPerformer(VersionConvertor_30_50.convertReference(src.getAssessor()));
        }
        if (src.hasPrevious()) {
            tgt.setPrevious(VersionConvertor_30_50.convertReference(src.getPrevious()));
        }
        for (Reference reference : src.getProblem()) {
            tgt.addProblem(VersionConvertor_30_50.convertReference(reference));
        }
        for (UriType uriType : src.getProtocol()) {
            tgt.addProtocol((String)uriType.getValue());
        }
        if (src.hasSummary()) {
            tgt.setSummaryElement(VersionConvertor_30_50.convertString(src.getSummaryElement()));
        }
        for (ClinicalImpression.ClinicalImpressionFindingComponent clinicalImpressionFindingComponent : src.getFinding()) {
            tgt.addFinding(ClinicalImpression30_50.convertClinicalImpressionFindingComponent(clinicalImpressionFindingComponent));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getPrognosisCodeableConcept()) {
            tgt.addPrognosisCodeableConcept(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getPrognosisReference()) {
            tgt.addPrognosisReference(VersionConvertor_30_50.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static ClinicalImpression.ClinicalImpressionFindingComponent convertClinicalImpressionFindingComponent(ClinicalImpression.ClinicalImpressionFindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression.ClinicalImpressionFindingComponent tgt = new ClinicalImpression.ClinicalImpressionFindingComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasItem() && src.getItem().hasConcept()) {
            tgt.setItem(VersionConvertor_30_50.convertType(src.getItem().getConcept()));
        } else if (src.hasItem() && src.getItem().hasReference()) {
            tgt.setItem(VersionConvertor_30_50.convertType(src.getItem().getReference()));
        }
        if (src.hasBasis()) {
            tgt.setBasisElement(VersionConvertor_30_50.convertString(src.getBasisElement()));
        }
        return tgt;
    }

    public static ClinicalImpression.ClinicalImpressionFindingComponent convertClinicalImpressionFindingComponent(ClinicalImpression.ClinicalImpressionFindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression.ClinicalImpressionFindingComponent tgt = new ClinicalImpression.ClinicalImpressionFindingComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasItemCodeableConcept()) {
            tgt.setItem(VersionConvertor_30_50.convertCodeableConceptToCodableReference(src.getItemCodeableConcept()));
        }
        if (src.hasItemReference()) {
            tgt.setItem(VersionConvertor_30_50.convertReferenceToCodableReference(src.getItemReference()));
        }
        if (src.hasBasis()) {
            tgt.setBasisElement(VersionConvertor_30_50.convertString(src.getBasisElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ClinicalImpression.ClinicalImpressionStatus> convertClinicalImpressionStatus(Enumeration<Enumerations.EventStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ClinicalImpression.ClinicalImpressionStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ClinicalImpression.ClinicalImpressionStatus>(new ClinicalImpression.ClinicalImpressionStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.EventStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.DRAFT);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.EventStatus> convertClinicalImpressionStatus(org.hl7.fhir.dstu3.model.Enumeration<ClinicalImpression.ClinicalImpressionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.EventStatus> tgt = new Enumeration<Enumerations.EventStatus>(new Enumerations.EventStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((ClinicalImpression.ClinicalImpressionStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.EventStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Enumerations.EventStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.EventStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.EventStatus.NULL);
            }
        }
        return tgt;
    }
}

