/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Dosage;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.MedicationRequest;

public class MedicationRequest30_40 {
    public static MedicationRequest convertMedicationRequest(org.hl7.fhir.dstu3.model.MedicationRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest tgt = new MedicationRequest();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(VersionConvertor_30_40.convertIdentifier(src.getGroupIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationRequest30_40.convertMedicationRequestStatus(src.getStatusElement()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(MedicationRequest30_40.convertMedicationRequestIntent(src.getIntentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(MedicationRequest30_40.convertMedicationRequestPriority(src.getPriorityElement()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_30_40.convertType(src.getMedication()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        for (Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(VersionConvertor_30_40.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(VersionConvertor_30_40.convertReference(src.getRecorder()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        for (Dosage dosage : src.getDosageInstruction()) {
            tgt.addDosageInstruction(VersionConvertor_30_40.convertDosage(dosage));
        }
        if (src.hasDispenseRequest()) {
            tgt.setDispenseRequest(MedicationRequest30_40.convertMedicationRequestDispenseRequestComponent(src.getDispenseRequest()));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationRequest30_40.convertMedicationRequestSubstitutionComponent(src.getSubstitution()));
        }
        if (src.hasPriorPrescription()) {
            tgt.setPriorPrescription(VersionConvertor_30_40.convertReference(src.getPriorPrescription()));
        }
        for (Reference reference : src.getDetectedIssue()) {
            tgt.addDetectedIssue(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasRequester()) {
            if (src.getRequester().hasAgent()) {
                tgt.setRequester(VersionConvertor_30_40.convertReference(src.getRequester().getAgent()));
            }
            if (src.getRequester().hasOnBehalfOf()) {
                tgt.addExtension("http://hl7.org/fhir/3.0/StructureDefinition/extension-MedicationRequest.requester.onBehalfOf", VersionConvertor_30_40.convertReference(src.getRequester().getOnBehalfOf()));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.MedicationRequest convertMedicationRequest(MedicationRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.MedicationRequest tgt = new org.hl7.fhir.dstu3.model.MedicationRequest();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(VersionConvertor_30_40.convertIdentifier(src.getGroupIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationRequest30_40.convertMedicationRequestStatus(src.getStatusElement()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(MedicationRequest30_40.convertMedicationRequestIntent(src.getIntentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(MedicationRequest30_40.convertMedicationRequestPriority(src.getPriorityElement()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_30_40.convertType(src.getMedication()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(VersionConvertor_30_40.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(VersionConvertor_30_40.convertReference(src.getRecorder()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.r4.model.Dosage dosage : src.getDosageInstruction()) {
            tgt.addDosageInstruction(VersionConvertor_30_40.convertDosage(dosage));
        }
        if (src.hasDispenseRequest()) {
            tgt.setDispenseRequest(MedicationRequest30_40.convertMedicationRequestDispenseRequestComponent(src.getDispenseRequest()));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationRequest30_40.convertMedicationRequestSubstitutionComponent(src.getSubstitution()));
        }
        if (src.hasPriorPrescription()) {
            tgt.setPriorPrescription(VersionConvertor_30_40.convertReference(src.getPriorPrescription()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getDetectedIssue()) {
            tgt.addDetectedIssue(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasRequester()) {
            tgt.getRequester().setAgent(VersionConvertor_30_40.convertReference(src.getRequester()));
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestDispenseRequestComponent convertMedicationRequestDispenseRequestComponent(MedicationRequest.MedicationRequestDispenseRequestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestDispenseRequestComponent tgt = new MedicationRequest.MedicationRequestDispenseRequestComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasValidityPeriod()) {
            tgt.setValidityPeriod(VersionConvertor_30_40.convertPeriod(src.getValidityPeriod()));
        }
        if (src.hasNumberOfRepeatsAllowed()) {
            tgt.setNumberOfRepeatsAllowed(src.getNumberOfRepeatsAllowed());
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasExpectedSupplyDuration()) {
            tgt.setExpectedSupplyDuration(VersionConvertor_30_40.convertDuration(src.getExpectedSupplyDuration()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_30_40.convertReference(src.getPerformer()));
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestDispenseRequestComponent convertMedicationRequestDispenseRequestComponent(MedicationRequest.MedicationRequestDispenseRequestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestDispenseRequestComponent tgt = new MedicationRequest.MedicationRequestDispenseRequestComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasValidityPeriod()) {
            tgt.setValidityPeriod(VersionConvertor_30_40.convertPeriod(src.getValidityPeriod()));
        }
        if (src.hasNumberOfRepeatsAllowed()) {
            tgt.setNumberOfRepeatsAllowed(src.getNumberOfRepeatsAllowed());
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasExpectedSupplyDuration()) {
            tgt.setExpectedSupplyDuration(VersionConvertor_30_40.convertDuration(src.getExpectedSupplyDuration()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_30_40.convertReference(src.getPerformer()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestIntent> convertMedicationRequestIntent(Enumeration<MedicationRequest.MedicationRequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestIntent> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestIntent>(new MedicationRequest.MedicationRequestIntentEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationRequestIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.PLAN);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.ORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.INSTANCEORDER);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MedicationRequest.MedicationRequestIntent> convertMedicationRequestIntent(org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MedicationRequest.MedicationRequestIntent> tgt = new Enumeration<MedicationRequest.MedicationRequestIntent>(new MedicationRequest.MedicationRequestIntentEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationRequestIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.PLAN);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.ORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.INSTANCEORDER);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MedicationRequest.MedicationRequestPriority> convertMedicationRequestPriority(org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MedicationRequest.MedicationRequestPriority> tgt = new Enumeration<MedicationRequest.MedicationRequestPriority>(new MedicationRequest.MedicationRequestPriorityEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationRequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.URGENT);
                break;
            }
            case STAT: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.STAT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.ASAP);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestPriority> convertMedicationRequestPriority(Enumeration<MedicationRequest.MedicationRequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestPriority> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestPriority>(new MedicationRequest.MedicationRequestPriorityEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationRequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.URGENT);
                break;
            }
            case STAT: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.STAT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.ASAP);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MedicationRequest.MedicationRequestStatus> convertMedicationRequestStatus(org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MedicationRequest.MedicationRequestStatus> tgt = new Enumeration<MedicationRequest.MedicationRequestStatus>(new MedicationRequest.MedicationRequestStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationRequestStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.ONHOLD);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.CANCELLED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.ENTEREDINERROR);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.STOPPED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.DRAFT);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestStatus> convertMedicationRequestStatus(Enumeration<MedicationRequest.MedicationRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestStatus>(new MedicationRequest.MedicationRequestStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationRequestStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.ONHOLD);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.CANCELLED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.ENTEREDINERROR);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.STOPPED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.DRAFT);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestSubstitutionComponent convertMedicationRequestSubstitutionComponent(MedicationRequest.MedicationRequestSubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestSubstitutionComponent tgt = new MedicationRequest.MedicationRequestSubstitutionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasAllowedBooleanType()) {
            tgt.setAllowedElement(VersionConvertor_30_40.convertBoolean(src.getAllowedBooleanType()));
        }
        if (src.hasReason()) {
            tgt.setReason(VersionConvertor_30_40.convertCodeableConcept(src.getReason()));
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestSubstitutionComponent convertMedicationRequestSubstitutionComponent(MedicationRequest.MedicationRequestSubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestSubstitutionComponent tgt = new MedicationRequest.MedicationRequestSubstitutionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasAllowed()) {
            tgt.setAllowed(VersionConvertor_30_40.convertBoolean(src.getAllowedElement()));
        }
        if (src.hasReason()) {
            tgt.setReason(VersionConvertor_30_40.convertCodeableConcept(src.getReason()));
        }
        return tgt;
    }
}

