/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import java.util.Iterator;
import java.util.List;
import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.ImplementationGuide;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.ImplementationGuide;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.UsageContext;

public class ImplementationGuide30_40 {
    public static org.hl7.fhir.dstu3.model.ImplementationGuide convertImplementationGuide(ImplementationGuide src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ImplementationGuide tgt = new org.hl7.fhir.dstu3.model.ImplementationGuide();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_40.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_40.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_40.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext(usageContext));
        }
        Iterator<Element> iterator2 = src.getJurisdiction().iterator();
        while (iterator2.hasNext()) {
            CodeableConcept codeableConcept = (CodeableConcept)iterator2.next();
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_40.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasFhirVersion() && (iterator2 = src.getFhirVersion().iterator()).hasNext()) {
            Enumeration enumeration = (Enumeration)iterator2.next();
            tgt.setFhirVersion(enumeration.asStringValue());
        }
        for (ImplementationGuide.ImplementationGuideDependsOnComponent implementationGuideDependsOnComponent : src.getDependsOn()) {
            tgt.addDependency(ImplementationGuide30_40.convertImplementationGuideDependencyComponent(implementationGuideDependsOnComponent));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionGroupingComponent implementationGuideDefinitionGroupingComponent : src.getDefinition().getGrouping()) {
            tgt.addPackage(ImplementationGuide30_40.convertImplementationGuidePackageComponent(implementationGuideDefinitionGroupingComponent));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionResourceComponent implementationGuideDefinitionResourceComponent : src.getDefinition().getResource()) {
            ImplementationGuide30_40.findPackage(tgt.getPackage(), implementationGuideDefinitionResourceComponent.getGroupingId()).addResource(ImplementationGuide30_40.convertImplementationGuidePackageResourceComponent(implementationGuideDefinitionResourceComponent));
        }
        for (ImplementationGuide.ImplementationGuideGlobalComponent implementationGuideGlobalComponent : src.getGlobal()) {
            tgt.addGlobal(ImplementationGuide30_40.convertImplementationGuideGlobalComponent(implementationGuideGlobalComponent));
        }
        if (src.getDefinition().hasPage()) {
            tgt.setPage(ImplementationGuide30_40.convertImplementationGuidePageComponent(src.getDefinition().getPage()));
        }
        return tgt;
    }

    public static ImplementationGuide convertImplementationGuide(org.hl7.fhir.dstu3.model.ImplementationGuide src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide tgt = new ImplementationGuide();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_40.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_40.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_40.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.dstu3.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_40.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasFhirVersion()) {
            tgt.addFhirVersion(Enumerations.FHIRVersion.fromCode(src.getFhirVersion()));
        }
        for (ImplementationGuide.ImplementationGuideDependencyComponent implementationGuideDependencyComponent : src.getDependency()) {
            tgt.addDependsOn(ImplementationGuide30_40.convertImplementationGuideDependencyComponent(implementationGuideDependencyComponent));
        }
        for (ImplementationGuide.ImplementationGuidePackageComponent implementationGuidePackageComponent : src.getPackage()) {
            tgt.getDefinition().addGrouping(ImplementationGuide30_40.convertImplementationGuidePackageComponent(tgt.getDefinition(), implementationGuidePackageComponent));
        }
        for (ImplementationGuide.ImplementationGuideGlobalComponent implementationGuideGlobalComponent : src.getGlobal()) {
            tgt.addGlobal(ImplementationGuide30_40.convertImplementationGuideGlobalComponent(implementationGuideGlobalComponent));
        }
        if (src.hasPage()) {
            tgt.getDefinition().setPage(ImplementationGuide30_40.convertImplementationGuidePageComponent(src.getPage()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDependencyComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependsOnComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependencyComponent tgt = new ImplementationGuide.ImplementationGuideDependencyComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        tgt.setType(ImplementationGuide.GuideDependencyType.REFERENCE);
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDependsOnComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependencyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependsOnComponent tgt = new ImplementationGuide.ImplementationGuideDependsOnComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_30_40.convertCanonicalToReference(src.getProfileElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getProfile()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuideDefinitionGroupingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageComponent tgt = new ImplementationGuide.ImplementationGuidePackageComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        tgt.setId(src.getId());
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionGroupingComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuideDefinitionComponent context, ImplementationGuide.ImplementationGuidePackageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionGroupingComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionGroupingComponent();
        tgt.setId("p" + (context.getGrouping().size() + 1));
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        for (ImplementationGuide.ImplementationGuidePackageResourceComponent t : src.getResource()) {
            ImplementationGuide.ImplementationGuideDefinitionResourceComponent tn = ImplementationGuide30_40.convertImplementationGuidePackageResourceComponent(t);
            tn.setGroupingId(tgt.getId());
            context.addResource(tn);
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuidePackageResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionResourceComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasExampleFor()) {
            Type t = VersionConvertor_30_40.convertType(src.getExampleFor());
            tgt.setExample(t instanceof Reference ? new CanonicalType(((Reference)t).getReference()) : t);
        } else if (src.hasExample()) {
            tgt.setExample(new BooleanType(src.getExample()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasSourceReference()) {
            tgt.setReference(VersionConvertor_30_40.convertReference(src.getSourceReference()));
        } else if (src.hasSourceUriType()) {
            tgt.setReference(new Reference((String)src.getSourceUriType().getValue()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuideDefinitionResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageResourceComponent tgt = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasExampleCanonicalType()) {
            if (src.hasExampleCanonicalType()) {
                tgt.setExampleFor(VersionConvertor_30_40.convertCanonicalToReference(src.getExampleCanonicalType()));
            }
            tgt.setExample(true);
        } else if (src.hasExampleBooleanType()) {
            tgt.setExample((Boolean)src.getExampleBooleanType().getValue());
        } else {
            tgt.setExample(false);
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasReference()) {
            tgt.setSource(VersionConvertor_30_40.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuideDefinitionPageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePageComponent tgt = new ImplementationGuide.ImplementationGuidePageComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasNameUrlType()) {
            tgt.setSource((String)src.getNameUrlType().getValue());
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasGeneration()) {
            tgt.setKind(ImplementationGuide30_40.convertPageGeneration(src.getGeneration()));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionPageComponent t : src.getPage()) {
            tgt.addPage(ImplementationGuide30_40.convertImplementationGuidePageComponent(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionPageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuidePageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionPageComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasSource()) {
            tgt.setName(ImplementationGuide30_40.convertUriToUrl(src.getSourceElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasKind()) {
            tgt.setGeneration(ImplementationGuide30_40.convertPageGeneration(src.getKind()));
        }
        for (ImplementationGuide.ImplementationGuidePageComponent t : src.getPage()) {
            tgt.addPage(ImplementationGuide30_40.convertImplementationGuidePageComponent(t));
        }
        return tgt;
    }

    public static ImplementationGuide.GuidePageGeneration convertPageGeneration(ImplementationGuide.GuidePageKind kind) {
        switch (kind) {
            case PAGE: {
                return ImplementationGuide.GuidePageGeneration.HTML;
            }
        }
        return ImplementationGuide.GuidePageGeneration.GENERATED;
    }

    public static ImplementationGuide.GuidePageKind convertPageGeneration(ImplementationGuide.GuidePageGeneration generation) {
        switch (generation) {
            case HTML: {
                return ImplementationGuide.GuidePageKind.PAGE;
            }
        }
        return ImplementationGuide.GuidePageKind.RESOURCE;
    }

    public static UrlType convertUriToUrl(UriType src) throws FHIRException {
        UrlType tgt = new UrlType((String)src.getValue());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageComponent findPackage(List<ImplementationGuide.ImplementationGuidePackageComponent> definition, String id) {
        for (ImplementationGuide.ImplementationGuidePackageComponent t : definition) {
            if (!t.getId().equals(id)) continue;
            return t;
        }
        ImplementationGuide.ImplementationGuidePackageComponent t1 = new ImplementationGuide.ImplementationGuidePackageComponent();
        t1.setName("Default Package");
        t1.setId(id);
        return t1;
    }
}

