/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import java.util.Collections;
import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.Enumeration;

public class Device30_40
extends VersionConvertor_30_40 {
    public static org.hl7.fhir.r4.model.Device convertDevice(Device src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Device tgt = new org.hl7.fhir.r4.model.Device();
        Device30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Device30_40.convertIdentifier(identifier));
        }
        if (src.hasUdi()) {
            Device.DeviceUdiCarrierComponent carrierComponent = tgt.getUdiCarrierFirstRep();
            carrierComponent.setDeviceIdentifierElement(VersionConvertor_30_40.convertString(src.getUdi().getDeviceIdentifierElement()));
            carrierComponent.setJurisdictionElement(VersionConvertor_30_40.convertUri(src.getUdi().getJurisdictionElement()));
            carrierComponent.setCarrierHRFElement(VersionConvertor_30_40.convertString(src.getUdi().getCarrierHRFElement()));
            carrierComponent.setCarrierAIDCElement(VersionConvertor_30_40.convertBase64Binary(src.getUdi().getCarrierAIDCElement()));
            carrierComponent.setIssuerElement(VersionConvertor_30_40.convertUri(src.getUdi().getIssuerElement()));
            carrierComponent.setEntryTypeElement(Device30_40.convertUDIEntryType(src.getUdi().getEntryTypeElement()));
            tgt.setUdiCarrier(Collections.singletonList(carrierComponent));
            Device.DeviceDeviceNameComponent deviceDeviceNameComponent = tgt.getDeviceNameFirstRep();
            deviceDeviceNameComponent.setNameElement(VersionConvertor_30_40.convertString(src.getUdi().getNameElement()));
            deviceDeviceNameComponent.setType(Device.DeviceNameType.UDILABELNAME);
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Device30_40.convertFHIRDeviceStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Device30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasLotNumber()) {
            tgt.setLotNumberElement(Device30_40.convertString(src.getLotNumberElement()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturerElement(Device30_40.convertString(src.getManufacturerElement()));
        }
        if (src.hasManufactureDate()) {
            tgt.setManufactureDateElement(Device30_40.convertDateTime(src.getManufactureDateElement()));
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDateElement(Device30_40.convertDateTime(src.getExpirationDateElement()));
        }
        if (src.hasModelElement()) {
            tgt.setModelNumberElement(VersionConvertor_30_40.convertString(src.getModelElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersion(Collections.singletonList(tgt.getVersionFirstRep().setValueElement(VersionConvertor_30_40.convertString(src.getVersionElement()))));
        }
        if (src.hasPatient()) {
            tgt.setPatient(Device30_40.convertReference(src.getPatient()));
        }
        if (src.hasOwner()) {
            tgt.setOwner(Device30_40.convertReference(src.getOwner()));
        }
        if (src.hasContact()) {
            tgt.setContact(src.getContact().stream().map(VersionConvertor_30_40::convertContactPoint).collect(Collectors.toList()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Device30_40.convertReference(src.getLocation()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(Device30_40.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.dstu3.model.Annotation annotation : src.getNote()) {
            tgt.addNote(Device30_40.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getSafety()) {
            tgt.addSafety(Device30_40.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static Device convertDevice(org.hl7.fhir.r4.model.Device src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Device tgt = new Device();
        Device30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Device30_40.convertIdentifier(identifier));
        }
        if (src.hasUdiCarrier()) {
            Device.DeviceUdiComponent udi = tgt.getUdi();
            udi.setDeviceIdentifierElement(VersionConvertor_30_40.convertString(src.getUdiCarrierFirstRep().getDeviceIdentifierElement()));
            udi.setJurisdictionElement(VersionConvertor_30_40.convertUri(src.getUdiCarrierFirstRep().getJurisdictionElement()));
            udi.setCarrierHRFElement(VersionConvertor_30_40.convertString(src.getUdiCarrierFirstRep().getCarrierHRFElement()));
            udi.setCarrierAIDCElement(VersionConvertor_30_40.convertBase64Binary(src.getUdiCarrierFirstRep().getCarrierAIDCElement()));
            udi.setIssuerElement(VersionConvertor_30_40.convertUri(src.getUdiCarrierFirstRep().getIssuerElement()));
            udi.setEntryTypeElement(Device30_40.convertUDIEntryType(src.getUdiCarrierFirstRep().getEntryTypeElement()));
            tgt.setUdi(udi);
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Device30_40.convertFHIRDeviceStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Device30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasLotNumber()) {
            tgt.setLotNumberElement(Device30_40.convertString(src.getLotNumberElement()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturerElement(Device30_40.convertString(src.getManufacturerElement()));
        }
        if (src.hasManufactureDate()) {
            tgt.setManufactureDateElement(Device30_40.convertDateTime(src.getManufactureDateElement()));
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDateElement(Device30_40.convertDateTime(src.getExpirationDateElement()));
        }
        if (src.hasModelNumber()) {
            tgt.setModel(src.getModelNumber());
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_40.convertString(src.getVersion().get(0).getValueElement()));
        }
        if (src.hasDeviceName()) {
            tgt.setUdi(tgt.getUdi().setName(src.getDeviceName().get(0).getName()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(Device30_40.convertReference(src.getPatient()));
        }
        if (src.hasOwner()) {
            tgt.setOwner(Device30_40.convertReference(src.getOwner()));
        }
        if (src.hasContact()) {
            tgt.setContact(src.getContact().stream().map(VersionConvertor_30_40::convertContactPoint).collect(Collectors.toList()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Device30_40.convertReference(src.getLocation()));
        }
        for (ContactPoint contactPoint : src.getContact()) {
            tgt.addContact(Device30_40.convertContactPoint(contactPoint));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(Device30_40.convertUri(src.getUrlElement()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(Device30_40.convertAnnotation(annotation));
        }
        for (CodeableConcept codeableConcept : src.getSafety()) {
            tgt.addSafety(Device30_40.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static Enumeration<Device.FHIRDeviceStatus> convertFHIRDeviceStatus(org.hl7.fhir.dstu3.model.Enumeration<Device.FHIRDeviceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Device.FHIRDeviceStatus> tgt = new Enumeration<Device.FHIRDeviceStatus>(new Device.FHIRDeviceStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Device.FHIRDeviceStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Device.FHIRDeviceStatus> convertFHIRDeviceStatus(Enumeration<Device.FHIRDeviceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Device.FHIRDeviceStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Device.FHIRDeviceStatus>(new Device.FHIRDeviceStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Device.FHIRDeviceStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Device.UDIEntryType> convertUDIEntryType(org.hl7.fhir.dstu3.model.Enumeration<Device.UDIEntryType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Device.UDIEntryType> tgt = new Enumeration<Device.UDIEntryType>(new Device.UDIEntryTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Device.UDIEntryType)((Object)src.getValue())) {
            case BARCODE: {
                tgt.setValue((Object)Device.UDIEntryType.BARCODE);
                break;
            }
            case RFID: {
                tgt.setValue((Object)Device.UDIEntryType.RFID);
                break;
            }
            case MANUAL: {
                tgt.setValue((Object)Device.UDIEntryType.MANUAL);
                break;
            }
            case CARD: {
                tgt.setValue((Object)Device.UDIEntryType.CARD);
                break;
            }
            case SELFREPORTED: {
                tgt.setValue((Object)Device.UDIEntryType.SELFREPORTED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Device.UDIEntryType.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Device.UDIEntryType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Device.UDIEntryType> convertUDIEntryType(Enumeration<Device.UDIEntryType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Device.UDIEntryType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Device.UDIEntryType>(new Device.UDIEntryTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Device.UDIEntryType)((Object)src.getValue())) {
            case BARCODE: {
                tgt.setValue((Object)Device.UDIEntryType.BARCODE);
                break;
            }
            case RFID: {
                tgt.setValue((Object)Device.UDIEntryType.RFID);
                break;
            }
            case MANUAL: {
                tgt.setValue((Object)Device.UDIEntryType.MANUAL);
                break;
            }
            case CARD: {
                tgt.setValue((Object)Device.UDIEntryType.CARD);
                break;
            }
            case SELFREPORTED: {
                tgt.setValue((Object)Device.UDIEntryType.SELFREPORTED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Device.UDIEntryType.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Device.UDIEntryType.NULL);
            }
        }
        return tgt;
    }
}

