/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Coverage;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Reference;

public class Coverage30_40
extends VersionConvertor_30_40 {
    public static Coverage convertCoverage(org.hl7.fhir.r4.model.Coverage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Coverage tgt = new Coverage();
        Coverage30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Coverage30_40.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Coverage30_40.convertCoverageStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Coverage30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasPolicyHolder()) {
            tgt.setPolicyHolder(Coverage30_40.convertReference(src.getPolicyHolder()));
        }
        if (src.hasSubscriber()) {
            tgt.setSubscriber(Coverage30_40.convertReference(src.getSubscriber()));
        }
        if (src.hasSubscriberId()) {
            tgt.setSubscriberIdElement(Coverage30_40.convertString(src.getSubscriberIdElement()));
        }
        if (src.hasBeneficiary()) {
            tgt.setBeneficiary(Coverage30_40.convertReference(src.getBeneficiary()));
        }
        if (src.hasDependent()) {
            tgt.setDependentElement(Coverage30_40.convertString(src.getDependentElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(Coverage30_40.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Coverage30_40.convertPeriod(src.getPeriod()));
        }
        for (Reference reference : src.getPayor()) {
            tgt.addPayor(Coverage30_40.convertReference(reference));
        }
        if (src.hasOrder()) {
            tgt.setOrderElement(Coverage30_40.convertPositiveInt(src.getOrderElement()));
        }
        if (src.hasNetwork()) {
            tgt.setNetworkElement(Coverage30_40.convertString(src.getNetworkElement()));
        }
        for (Reference reference : src.getContract()) {
            tgt.addContract(Coverage30_40.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Coverage convertCoverage(Coverage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Coverage tgt = new org.hl7.fhir.r4.model.Coverage();
        Coverage30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Coverage30_40.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Coverage30_40.convertCoverageStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Coverage30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasPolicyHolder()) {
            tgt.setPolicyHolder(Coverage30_40.convertReference(src.getPolicyHolder()));
        }
        if (src.hasSubscriber()) {
            tgt.setSubscriber(Coverage30_40.convertReference(src.getSubscriber()));
        }
        if (src.hasSubscriberId()) {
            tgt.setSubscriberIdElement(Coverage30_40.convertString(src.getSubscriberIdElement()));
        }
        if (src.hasBeneficiary()) {
            tgt.setBeneficiary(Coverage30_40.convertReference(src.getBeneficiary()));
        }
        if (src.hasDependent()) {
            tgt.setDependentElement(Coverage30_40.convertString(src.getDependentElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(Coverage30_40.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Coverage30_40.convertPeriod(src.getPeriod()));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getPayor()) {
            tgt.addPayor(Coverage30_40.convertReference(reference));
        }
        if (src.hasOrder()) {
            tgt.setOrderElement(Coverage30_40.convertPositiveInt(src.getOrderElement()));
        }
        if (src.hasNetwork()) {
            tgt.setNetworkElement(Coverage30_40.convertString(src.getNetworkElement()));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getContract()) {
            tgt.addContract(Coverage30_40.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Coverage.CoverageStatus> convertCoverageStatus(Enumeration<Coverage.CoverageStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Coverage.CoverageStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Coverage.CoverageStatus>(new Coverage.CoverageStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Coverage.CoverageStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Coverage.CoverageStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Coverage.CoverageStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)Coverage.CoverageStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Coverage.CoverageStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Coverage.CoverageStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Coverage.CoverageStatus> convertCoverageStatus(org.hl7.fhir.dstu3.model.Enumeration<Coverage.CoverageStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Coverage.CoverageStatus> tgt = new Enumeration<Coverage.CoverageStatus>(new Coverage.CoverageStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Coverage.CoverageStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Coverage.CoverageStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Coverage.CoverageStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)Coverage.CoverageStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Coverage.CoverageStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Coverage.CoverageStatus.NULL);
            }
        }
        return tgt;
    }
}

