/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.CompartmentDefinition;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.CompartmentDefinition;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.StringType;

public class CompartmentDefinition30_40 {
    public static CompartmentDefinition convertCompartmentDefinition(org.hl7.fhir.r4.model.CompartmentDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CompartmentDefinition tgt = new CompartmentDefinition();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_40.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_40.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_40.convertMarkdown(src.getPurposeElement()));
        }
        for (org.hl7.fhir.r4.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(CompartmentDefinition30_40.convertCompartmentType(src.getCodeElement()));
        }
        if (src.hasSearch()) {
            tgt.setSearchElement(VersionConvertor_30_40.convertBoolean(src.getSearchElement()));
        }
        for (CompartmentDefinition.CompartmentDefinitionResourceComponent compartmentDefinitionResourceComponent : src.getResource()) {
            tgt.addResource(CompartmentDefinition30_40.convertCompartmentDefinitionResourceComponent(compartmentDefinitionResourceComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CompartmentDefinition convertCompartmentDefinition(CompartmentDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CompartmentDefinition tgt = new org.hl7.fhir.r4.model.CompartmentDefinition();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_40.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_40.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_40.convertMarkdown(src.getPurposeElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(CompartmentDefinition30_40.convertCompartmentType(src.getCodeElement()));
        }
        if (src.hasSearch()) {
            tgt.setSearchElement(VersionConvertor_30_40.convertBoolean(src.getSearchElement()));
        }
        for (CompartmentDefinition.CompartmentDefinitionResourceComponent compartmentDefinitionResourceComponent : src.getResource()) {
            tgt.addResource(CompartmentDefinition30_40.convertCompartmentDefinitionResourceComponent(compartmentDefinitionResourceComponent));
        }
        return tgt;
    }

    public static CompartmentDefinition.CompartmentDefinitionResourceComponent convertCompartmentDefinitionResourceComponent(CompartmentDefinition.CompartmentDefinitionResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CompartmentDefinition.CompartmentDefinitionResourceComponent tgt = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        for (org.hl7.fhir.dstu3.model.StringType t : src.getParam()) {
            tgt.addParam((String)t.getValue());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_40.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static CompartmentDefinition.CompartmentDefinitionResourceComponent convertCompartmentDefinitionResourceComponent(CompartmentDefinition.CompartmentDefinitionResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CompartmentDefinition.CompartmentDefinitionResourceComponent tgt = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertCode(src.getCodeElement()));
        }
        for (StringType t : src.getParam()) {
            tgt.addParam((String)t.getValue());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_40.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static Enumeration<CompartmentDefinition.CompartmentType> convertCompartmentType(org.hl7.fhir.dstu3.model.Enumeration<CompartmentDefinition.CompartmentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CompartmentDefinition.CompartmentType> tgt = new Enumeration<CompartmentDefinition.CompartmentType>(new CompartmentDefinition.CompartmentTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CompartmentDefinition.CompartmentType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.PATIENT);
                break;
            }
            case ENCOUNTER: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.ENCOUNTER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.RELATEDPERSON);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CompartmentDefinition.CompartmentType> convertCompartmentType(Enumeration<CompartmentDefinition.CompartmentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CompartmentDefinition.CompartmentType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CompartmentDefinition.CompartmentType>(new CompartmentDefinition.CompartmentTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CompartmentDefinition.CompartmentType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.PATIENT);
                break;
            }
            case ENCOUNTER: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.ENCOUNTER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.RELATEDPERSON);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.NULL);
            }
        }
        return tgt;
    }
}

