/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.StructureMap;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;

public class StructureMap14_50 {
    public static org.hl7.fhir.r5.model.StructureMap convertStructureMap(StructureMap src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.StructureMap tgt = new org.hl7.fhir.r5.model.StructureMap();
        VersionConvertor_14_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_50.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_50.convertConformanceResourceStatus((org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_50.convertIdentifier(t));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getContact()) {
            tgt.addContact(StructureMap14_50.convertStructureMapContactComponent((StructureMap.StructureMapContactComponent)t));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getUseContext()) {
            if (VersionConvertor_14_50.isJurisdiction((org.hl7.fhir.dstu2016may.model.CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_50.convertCodeableConcept((org.hl7.fhir.dstu2016may.model.CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConceptToUsageContext((org.hl7.fhir.dstu2016may.model.CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getStructure()) {
            tgt.addStructure(StructureMap14_50.convertStructureMapStructureComponent((StructureMap.StructureMapStructureComponent)t));
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getImport()) {
            tgt.addImport((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getGroup()) {
            tgt.addGroup(StructureMap14_50.convertStructureMapGroupComponent((StructureMap.StructureMapGroupComponent)t));
        }
        return tgt;
    }

    public static StructureMap convertStructureMap(org.hl7.fhir.r5.model.StructureMap src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap tgt = new StructureMap();
        VersionConvertor_14_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_50.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_50.convertConformanceResourceStatus(src.getStatusElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_50.convertIdentifier(identifier));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(StructureMap14_50.convertStructureMapContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (StructureMap.StructureMapStructureComponent structureMapStructureComponent : src.getStructure()) {
            tgt.addStructure(StructureMap14_50.convertStructureMapStructureComponent(structureMapStructureComponent));
        }
        for (UriType uriType : src.getImport()) {
            tgt.addImport((String)uriType.getValue());
        }
        for (StructureMap.StructureMapGroupComponent structureMapGroupComponent : src.getGroup()) {
            tgt.addGroup(StructureMap14_50.convertStructureMapGroupComponent(structureMapGroupComponent));
        }
        return tgt;
    }

    public static ContactDetail convertStructureMapContactComponent(StructureMap.StructureMapContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static StructureMap.StructureMapContactComponent convertStructureMapContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapContactComponent tgt = new StructureMap.StructureMapContactComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupComponent convertStructureMapGroupComponent(StructureMap.StructureMapGroupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapGroupComponent tgt = new StructureMap.StructureMapGroupComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertId(src.getNameElement()));
        }
        if (src.hasExtends()) {
            tgt.setExtendsElement(VersionConvertor_14_50.convertId(src.getExtendsElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_50.convertString(src.getDocumentationElement()));
        }
        for (StructureMap.StructureMapGroupInputComponent t : src.getInput()) {
            tgt.addInput(StructureMap14_50.convertStructureMapGroupInputComponent(t));
        }
        for (StructureMap.StructureMapGroupInputComponent t : src.getRule()) {
            tgt.addRule(StructureMap14_50.convertStructureMapGroupRuleComponent((StructureMap.StructureMapGroupRuleComponent)t));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupComponent convertStructureMapGroupComponent(StructureMap.StructureMapGroupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapGroupComponent tgt = new StructureMap.StructureMapGroupComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertId(src.getNameElement()));
        }
        if (src.hasExtends()) {
            tgt.setExtendsElement(VersionConvertor_14_50.convertId(src.getExtendsElement()));
        }
        if (src.hasTypeMode()) {
            throw new FHIRException("Unable to downgrade structure map with group.typeMode other than 'None': " + src.getTypeMode().getDisplay());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_50.convertString(src.getDocumentationElement()));
        }
        for (StructureMap.StructureMapGroupInputComponent structureMapGroupInputComponent : src.getInput()) {
            tgt.addInput(StructureMap14_50.convertStructureMapGroupInputComponent(structureMapGroupInputComponent));
        }
        for (StructureMap.StructureMapGroupRuleComponent structureMapGroupRuleComponent : src.getRule()) {
            tgt.addRule(StructureMap14_50.convertStructureMapGroupRuleComponent(structureMapGroupRuleComponent));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupInputComponent convertStructureMapGroupInputComponent(StructureMap.StructureMapGroupInputComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapGroupInputComponent tgt = new StructureMap.StructureMapGroupInputComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertId(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_50.convertString(src.getTypeElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(StructureMap14_50.convertStructureMapInputMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupInputComponent convertStructureMapGroupInputComponent(StructureMap.StructureMapGroupInputComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapGroupInputComponent tgt = new StructureMap.StructureMapGroupInputComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertId(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_50.convertString(src.getTypeElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(StructureMap14_50.convertStructureMapInputMode((org.hl7.fhir.dstu2016may.model.Enumeration<StructureMap.StructureMapInputMode>)src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleComponent convertStructureMapGroupRuleComponent(StructureMap.StructureMapGroupRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapGroupRuleComponent tgt = new StructureMap.StructureMapGroupRuleComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertId(src.getNameElement()));
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent structureMapGroupRuleSourceComponent : src.getSource()) {
            tgt.addSource(StructureMap14_50.convertStructureMapGroupRuleSourceComponent(structureMapGroupRuleSourceComponent));
        }
        for (StructureMap.StructureMapGroupRuleTargetComponent structureMapGroupRuleTargetComponent : src.getTarget()) {
            tgt.addTarget(StructureMap14_50.convertStructureMapGroupRuleTargetComponent(structureMapGroupRuleTargetComponent));
        }
        for (StructureMap.StructureMapGroupRuleComponent structureMapGroupRuleComponent : src.getRule()) {
            tgt.addRule(StructureMap14_50.convertStructureMapGroupRuleComponent(structureMapGroupRuleComponent));
        }
        for (StructureMap.StructureMapGroupRuleDependentComponent structureMapGroupRuleDependentComponent : src.getDependent()) {
            tgt.addDependent(StructureMap14_50.convertStructureMapGroupRuleDependentComponent(structureMapGroupRuleDependentComponent));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleComponent convertStructureMapGroupRuleComponent(StructureMap.StructureMapGroupRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapGroupRuleComponent tgt = new StructureMap.StructureMapGroupRuleComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertId(src.getNameElement()));
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent t : src.getSource()) {
            tgt.addSource(StructureMap14_50.convertStructureMapGroupRuleSourceComponent(t));
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent t : src.getTarget()) {
            tgt.addTarget(StructureMap14_50.convertStructureMapGroupRuleTargetComponent((StructureMap.StructureMapGroupRuleTargetComponent)t));
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent t : src.getRule()) {
            tgt.addRule(StructureMap14_50.convertStructureMapGroupRuleComponent((StructureMap.StructureMapGroupRuleComponent)t));
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent t : src.getDependent()) {
            tgt.addDependent(StructureMap14_50.convertStructureMapGroupRuleDependentComponent((StructureMap.StructureMapGroupRuleDependentComponent)t));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleDependentComponent convertStructureMapGroupRuleDependentComponent(StructureMap.StructureMapGroupRuleDependentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapGroupRuleDependentComponent tgt = new StructureMap.StructureMapGroupRuleDependentComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertId(src.getNameElement()));
        }
        for (StringType t : src.getVariable()) {
            tgt.addVariable(t.asStringValue());
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleDependentComponent convertStructureMapGroupRuleDependentComponent(StructureMap.StructureMapGroupRuleDependentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapGroupRuleDependentComponent tgt = new StructureMap.StructureMapGroupRuleDependentComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertId(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getVariable()) {
            tgt.addVariable(t.asStringValue());
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleSourceComponent convertStructureMapGroupRuleSourceComponent(StructureMap.StructureMapGroupRuleSourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapGroupRuleSourceComponent tgt = new StructureMap.StructureMapGroupRuleSourceComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        tgt.setContextType(StructureMap.StructureMapContextType.TYPE);
        if (src.hasContextElement()) {
            tgt.setContextElement(VersionConvertor_14_50.convertId(src.getContextElement()));
        }
        if (src.hasElement()) {
            tgt.setElementElement(VersionConvertor_14_50.convertString(src.getElementElement()));
        }
        if (src.hasListMode()) {
            tgt.setListModeElement(StructureMap14_50.convertStructureMapSourceListMode(src.getListModeElement()));
        }
        if (src.hasVariable()) {
            tgt.setVariableElement(VersionConvertor_14_50.convertId(src.getVariableElement()));
        }
        if (src.hasCondition()) {
            tgt.setConditionElement(VersionConvertor_14_50.convertString(src.getConditionElement()));
        }
        if (src.hasCheck()) {
            tgt.setCheckElement(VersionConvertor_14_50.convertString(src.getCheckElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleSourceComponent convertStructureMapGroupRuleSourceComponent(StructureMap.StructureMapGroupRuleSourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapGroupRuleSourceComponent tgt = new StructureMap.StructureMapGroupRuleSourceComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        tgt.setMin(src.getRequired() ? 1 : 0);
        if (src.getContextType().equals((Object)StructureMap.StructureMapContextType.TYPE)) {
            tgt.setType(src.getContext());
        }
        if (src.hasElement()) {
            tgt.setElementElement(VersionConvertor_14_50.convertString(src.getElementElement()));
        }
        if (src.hasListMode()) {
            tgt.setListModeElement(StructureMap14_50.convertStructureMapSourceListMode((org.hl7.fhir.dstu2016may.model.Enumeration<StructureMap.StructureMapListMode>)src.getListModeElement()));
        }
        if (src.hasVariable()) {
            tgt.setVariableElement(VersionConvertor_14_50.convertId(src.getVariableElement()));
        }
        if (src.hasCondition()) {
            tgt.setConditionElement(VersionConvertor_14_50.convertString(src.getConditionElement()));
        }
        if (src.hasCheck()) {
            tgt.setCheckElement(VersionConvertor_14_50.convertString(src.getCheckElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleTargetComponent convertStructureMapGroupRuleTargetComponent(StructureMap.StructureMapGroupRuleTargetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetComponent tgt = new StructureMap.StructureMapGroupRuleTargetComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasContext()) {
            tgt.setContextElement(VersionConvertor_14_50.convertId(src.getContextElement()));
        }
        tgt.setContextType(StructureMap.StructureMapContextType.VARIABLE);
        if (src.hasElement()) {
            tgt.setElementElement(VersionConvertor_14_50.convertString(src.getElementElement()));
        }
        if (src.hasVariable()) {
            tgt.setVariableElement(VersionConvertor_14_50.convertId(src.getVariableElement()));
        }
        tgt.setListMode(src.getListMode().stream().map(StructureMap14_50::convertStructureMapTargetListMode).collect(Collectors.toList()));
        if (src.hasListRuleId()) {
            tgt.setListRuleIdElement(VersionConvertor_14_50.convertId(src.getListRuleIdElement()));
        }
        if (src.hasTransform()) {
            tgt.setTransformElement(StructureMap14_50.convertStructureMapTransform(src.getTransformElement()));
        }
        for (StructureMap.StructureMapGroupRuleTargetParameterComponent t : src.getParameter()) {
            tgt.addParameter(StructureMap14_50.convertStructureMapGroupRuleTargetParameterComponent(t));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleTargetComponent convertStructureMapGroupRuleTargetComponent(StructureMap.StructureMapGroupRuleTargetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetComponent tgt = new StructureMap.StructureMapGroupRuleTargetComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasContext()) {
            tgt.setContextElement(VersionConvertor_14_50.convertId(src.getContextElement()));
        }
        if (src.hasContextType() && src.getContextType() == StructureMap.StructureMapContextType.VARIABLE) {
            throw new Error("This conversion is not supported. Consult code maintainers");
        }
        if (src.hasElement()) {
            tgt.setElementElement(VersionConvertor_14_50.convertString(src.getElementElement()));
        }
        if (src.hasVariable()) {
            tgt.setVariableElement(VersionConvertor_14_50.convertId(src.getVariableElement()));
        }
        tgt.setListMode(src.getListMode().stream().map(StructureMap14_50::convertStructureMapTargetListMode).collect(Collectors.toList()));
        if (src.hasListRuleId()) {
            tgt.setListRuleIdElement(VersionConvertor_14_50.convertId(src.getListRuleIdElement()));
        }
        if (src.hasTransform()) {
            tgt.setTransformElement(StructureMap14_50.convertStructureMapTransform((org.hl7.fhir.dstu2016may.model.Enumeration<StructureMap.StructureMapTransform>)src.getTransformElement()));
        }
        for (StructureMap.StructureMapGroupRuleTargetParameterComponent t : src.getParameter()) {
            tgt.addParameter(StructureMap14_50.convertStructureMapGroupRuleTargetParameterComponent(t));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleTargetParameterComponent convertStructureMapGroupRuleTargetParameterComponent(StructureMap.StructureMapGroupRuleTargetParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetParameterComponent tgt = new StructureMap.StructureMapGroupRuleTargetParameterComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_14_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleTargetParameterComponent convertStructureMapGroupRuleTargetParameterComponent(StructureMap.StructureMapGroupRuleTargetParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetParameterComponent tgt = new StructureMap.StructureMapGroupRuleTargetParameterComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_14_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<StructureMap.StructureMapInputMode> convertStructureMapInputMode(Enumeration<StructureMap.StructureMapInputMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new StructureMap.StructureMapInputModeEnumFactory());
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((StructureMap.StructureMapInputMode)((Object)src.getValue())) {
            case SOURCE: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.SOURCE);
                break;
            }
            case TARGET: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.TARGET);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapInputMode> convertStructureMapInputMode(org.hl7.fhir.dstu2016may.model.Enumeration<StructureMap.StructureMapInputMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapInputMode> tgt = new Enumeration<StructureMap.StructureMapInputMode>(new StructureMap.StructureMapInputModeEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapInputMode)src.getValue()) {
            case SOURCE: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.SOURCE);
                break;
            }
            case TARGET: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.TARGET);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<StructureMap.StructureMapListMode> convertStructureMapSourceListMode(Enumeration<StructureMap.StructureMapSourceListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new StructureMap.StructureMapListModeEnumFactory());
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((StructureMap.StructureMapSourceListMode)((Object)src.getValue())) {
            case FIRST: {
                tgt.setValue((Object)StructureMap.StructureMapListMode.FIRST);
                break;
            }
            case LAST: {
                tgt.setValue((Object)StructureMap.StructureMapListMode.LAST);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapListMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapSourceListMode> convertStructureMapSourceListMode(org.hl7.fhir.dstu2016may.model.Enumeration<StructureMap.StructureMapListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapSourceListMode> tgt = new Enumeration<StructureMap.StructureMapSourceListMode>(new StructureMap.StructureMapSourceListModeEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapListMode)src.getValue()) {
            case FIRST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.FIRST);
                break;
            }
            case LAST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.LAST);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.NULL);
            }
        }
        return tgt;
    }

    public static StructureMap.StructureMapStructureComponent convertStructureMapStructureComponent(StructureMap.StructureMapStructureComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapStructureComponent tgt = new StructureMap.StructureMapStructureComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasMode()) {
            tgt.setModeElement(StructureMap14_50.convertStructureMapStructureMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapStructureComponent convertStructureMapStructureComponent(StructureMap.StructureMapStructureComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureMap.StructureMapStructureComponent tgt = new StructureMap.StructureMapStructureComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasMode()) {
            tgt.setModeElement(StructureMap14_50.convertStructureMapStructureMode((org.hl7.fhir.dstu2016may.model.Enumeration<StructureMap.StructureMapModelMode>)src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<StructureMap.StructureMapModelMode> convertStructureMapStructureMode(Enumeration<StructureMap.StructureMapModelMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new StructureMap.StructureMapModelModeEnumFactory());
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((StructureMap.StructureMapModelMode)((Object)src.getValue())) {
            case PRODUCED: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.PRODUCED);
                break;
            }
            case QUERIED: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.QUERIED);
                break;
            }
            case SOURCE: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.SOURCE);
                break;
            }
            case TARGET: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.TARGET);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapModelMode> convertStructureMapStructureMode(org.hl7.fhir.dstu2016may.model.Enumeration<StructureMap.StructureMapModelMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapModelMode> tgt = new Enumeration<StructureMap.StructureMapModelMode>(new StructureMap.StructureMapModelModeEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapModelMode)src.getValue()) {
            case PRODUCED: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.PRODUCED);
                break;
            }
            case QUERIED: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.QUERIED);
                break;
            }
            case SOURCE: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.SOURCE);
                break;
            }
            case TARGET: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.TARGET);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<StructureMap.StructureMapListMode> convertStructureMapTargetListMode(Enumeration<StructureMap.StructureMapTargetListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new StructureMap.StructureMapListModeEnumFactory());
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((StructureMap.StructureMapTargetListMode)((Object)src.getValue())) {
            case FIRST: {
                tgt.setValue((Object)StructureMap.StructureMapListMode.FIRST);
                break;
            }
            case LAST: {
                tgt.setValue((Object)StructureMap.StructureMapListMode.LAST);
                break;
            }
            case SHARE: {
                tgt.setValue((Object)StructureMap.StructureMapListMode.SHARE);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapListMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapTargetListMode> convertStructureMapTargetListMode(org.hl7.fhir.dstu2016may.model.Enumeration<StructureMap.StructureMapListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapTargetListMode> tgt = new Enumeration<StructureMap.StructureMapTargetListMode>(new StructureMap.StructureMapTargetListModeEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapListMode)src.getValue()) {
            case FIRST: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.FIRST);
                break;
            }
            case LAST: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.LAST);
                break;
            }
            case SHARE: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.SHARE);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapTransform> convertStructureMapTransform(org.hl7.fhir.dstu2016may.model.Enumeration<StructureMap.StructureMapTransform> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapTransform> tgt = new Enumeration<StructureMap.StructureMapTransform>(new StructureMap.StructureMapTransformEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapTransform)src.getValue()) {
            case APPEND: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.APPEND);
            }
            case CAST: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CAST);
            }
            case COPY: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.COPY);
            }
            case CREATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CREATE);
            }
            case DATEOP: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.DATEOP);
            }
            case ESCAPE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.ESCAPE);
            }
            case EVALUATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.EVALUATE);
            }
            case POINTER: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.POINTER);
            }
            case REFERENCE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.REFERENCE);
            }
            case TRANSLATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.TRANSLATE);
            }
            case TRUNCATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.TRUNCATE);
            }
            case UUID: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.UUID);
            }
        }
        tgt.setValue((Object)StructureMap.StructureMapTransform.NULL);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<StructureMap.StructureMapTransform> convertStructureMapTransform(Enumeration<StructureMap.StructureMapTransform> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new StructureMap.StructureMapTransformEnumFactory());
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((StructureMap.StructureMapTransform)((Object)src.getValue())) {
            case APPEND: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.APPEND);
                break;
            }
            case CAST: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CAST);
                break;
            }
            case COPY: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.COPY);
                break;
            }
            case CREATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CREATE);
                break;
            }
            case DATEOP: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.DATEOP);
                break;
            }
            case ESCAPE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.ESCAPE);
                break;
            }
            case EVALUATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.EVALUATE);
                break;
            }
            case POINTER: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.POINTER);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.REFERENCE);
                break;
            }
            case TRANSLATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.TRANSLATE);
                break;
            }
            case TRUNCATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.TRUNCATE);
                break;
            }
            case UUID: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.UUID);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.NULL);
            }
        }
        return tgt;
    }
}

