/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_50;

import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.Conformance;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;

public class Conformance14_50 {
    public static org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.ConditionalDeleteStatus> convertConditionalDeleteStatus(Enumeration<CapabilityStatement.ConditionalDeleteStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new Conformance.ConditionalDeleteStatusEnumFactory());
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((CapabilityStatement.ConditionalDeleteStatus)((Object)src.getValue())) {
            case NOTSUPPORTED: {
                tgt.setValue((Object)Conformance.ConditionalDeleteStatus.NOTSUPPORTED);
                break;
            }
            case SINGLE: {
                tgt.setValue((Object)Conformance.ConditionalDeleteStatus.SINGLE);
                break;
            }
            case MULTIPLE: {
                tgt.setValue((Object)Conformance.ConditionalDeleteStatus.MULTIPLE);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.ConditionalDeleteStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.ConditionalDeleteStatus> convertConditionalDeleteStatus(org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.ConditionalDeleteStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.ConditionalDeleteStatus> tgt = new Enumeration<CapabilityStatement.ConditionalDeleteStatus>(new CapabilityStatement.ConditionalDeleteStatusEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((Conformance.ConditionalDeleteStatus)src.getValue()) {
            case NOTSUPPORTED: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.NOTSUPPORTED);
                break;
            }
            case SINGLE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.SINGLE);
                break;
            }
            case MULTIPLE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.MULTIPLE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.NULL);
            }
        }
        return tgt;
    }

    public static CapabilityStatement convertConformance(Conformance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement tgt = new CapabilityStatement();
        VersionConvertor_14_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_50.convertConformanceResourceStatus((org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (Conformance.ConformanceContactComponent t : src.getContact()) {
            tgt.addContact(Conformance14_50.convertConformanceContactComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (Conformance.ConformanceContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_50.isJurisdiction((org.hl7.fhir.dstu2016may.model.CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_50.convertCodeableConcept((org.hl7.fhir.dstu2016may.model.CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConceptToUsageContext((org.hl7.fhir.dstu2016may.model.CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasKind()) {
            tgt.setKindElement(Conformance14_50.convertConformanceStatementKind((org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.ConformanceStatementKind>)src.getKindElement()));
        }
        if (src.hasSoftware()) {
            tgt.setSoftware(Conformance14_50.convertConformanceSoftwareComponent(src.getSoftware()));
        }
        if (src.hasImplementation()) {
            tgt.setImplementation(Conformance14_50.convertConformanceImplementationComponent(src.getImplementation()));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(Enumerations.FHIRVersion.fromCode(src.getFhirVersion()));
        }
        if (src.hasAcceptUnknown()) {
            tgt.addExtension().setUrl("http://hl7.org/fhir/3.0/StructureDefinition/extension-CapabilityStatement.acceptUnknown").setValue(new org.hl7.fhir.r5.model.CodeType(src.getAcceptUnknownElement().asStringValue()));
        }
        for (Conformance.ConformanceContactComponent t : src.getFormat()) {
            tgt.addFormat((String)t.getValue());
        }
        for (Conformance.ConformanceContactComponent t : src.getRest()) {
            tgt.addRest(Conformance14_50.convertConformanceRestComponent((Conformance.ConformanceRestComponent)t));
        }
        for (Conformance.ConformanceContactComponent t : src.getMessaging()) {
            tgt.addMessaging(Conformance14_50.convertConformanceMessagingComponent((Conformance.ConformanceMessagingComponent)t));
        }
        for (Conformance.ConformanceContactComponent t : src.getDocument()) {
            tgt.addDocument(Conformance14_50.convertConformanceDocumentComponent((Conformance.ConformanceDocumentComponent)t));
        }
        return tgt;
    }

    public static Conformance convertConformance(CapabilityStatement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance tgt = new Conformance();
        VersionConvertor_14_50.copyDomainResource(src, (DomainResource)tgt, "http://hl7.org/fhir/3.0/StructureDefinition/extension-CapabilityStatement.acceptUnknown");
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_50.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(Conformance14_50.convertConformanceContactComponent(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasKind()) {
            tgt.setKindElement(Conformance14_50.convertConformanceStatementKind(src.getKindElement()));
        }
        if (src.hasSoftware()) {
            tgt.setSoftware(Conformance14_50.convertConformanceSoftwareComponent(src.getSoftware()));
        }
        if (src.hasImplementation()) {
            tgt.setImplementation(Conformance14_50.convertConformanceImplementationComponent(src.getImplementation()));
        }
        tgt.setFhirVersion(src.getFhirVersion().toCode());
        if (src.hasExtension("http://hl7.org/fhir/3.0/StructureDefinition/extension-CapabilityStatement.acceptUnknown")) {
            tgt.setAcceptUnknown(Conformance.UnknownContentCode.fromCode((String)src.getExtensionByUrl("http://hl7.org/fhir/3.0/StructureDefinition/extension-CapabilityStatement.acceptUnknown").getValue().primitiveValue()));
        }
        for (org.hl7.fhir.r5.model.CodeType codeType : src.getFormat()) {
            tgt.addFormat((String)codeType.getValue());
        }
        for (CapabilityStatement.CapabilityStatementRestComponent capabilityStatementRestComponent : src.getRest()) {
            for (CapabilityStatement.CapabilityStatementRestResourceComponent rr : capabilityStatementRestComponent.getResource()) {
                for (CanonicalType t : rr.getSupportedProfile()) {
                    tgt.addProfile(VersionConvertor_14_50.convertCanonicalToReference(t));
                }
            }
        }
        for (CapabilityStatement.CapabilityStatementRestComponent capabilityStatementRestComponent : src.getRest()) {
            tgt.addRest(Conformance14_50.convertConformanceRestComponent(capabilityStatementRestComponent));
        }
        for (CapabilityStatement.CapabilityStatementMessagingComponent capabilityStatementMessagingComponent : src.getMessaging()) {
            tgt.addMessaging(Conformance14_50.convertConformanceMessagingComponent(capabilityStatementMessagingComponent));
        }
        for (CapabilityStatement.CapabilityStatementDocumentComponent capabilityStatementDocumentComponent : src.getDocument()) {
            tgt.addDocument(Conformance14_50.convertConformanceDocumentComponent(capabilityStatementDocumentComponent));
        }
        return tgt;
    }

    public static Conformance.ConformanceContactComponent convertConformanceContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceContactComponent tgt = new Conformance.ConformanceContactComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertConformanceContactComponent(Conformance.ConformanceContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementDocumentComponent convertConformanceDocumentComponent(Conformance.ConformanceDocumentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementDocumentComponent tgt = new CapabilityStatement.CapabilityStatementDocumentComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(Conformance14_50.convertDocumentMode((org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.DocumentMode>)src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(VersionConvertor_14_50.convertReferenceToCanonical(src.getProfile()));
        }
        return tgt;
    }

    public static Conformance.ConformanceDocumentComponent convertConformanceDocumentComponent(CapabilityStatement.CapabilityStatementDocumentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceDocumentComponent tgt = new Conformance.ConformanceDocumentComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(Conformance14_50.convertDocumentMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasProfileElement()) {
            tgt.setProfile(VersionConvertor_14_50.convertCanonicalToReference(src.getProfileElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementImplementationComponent convertConformanceImplementationComponent(Conformance.ConformanceImplementationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementImplementationComponent tgt = new CapabilityStatement.CapabilityStatementImplementationComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_14_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    public static Conformance.ConformanceImplementationComponent convertConformanceImplementationComponent(CapabilityStatement.CapabilityStatementImplementationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceImplementationComponent tgt = new Conformance.ConformanceImplementationComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_14_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    public static Conformance.ConformanceMessagingComponent convertConformanceMessagingComponent(CapabilityStatement.CapabilityStatementMessagingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceMessagingComponent tgt = new Conformance.ConformanceMessagingComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        for (CapabilityStatement.CapabilityStatementMessagingEndpointComponent t : src.getEndpoint()) {
            tgt.addEndpoint(Conformance14_50.convertConformanceMessagingEndpointComponent(t));
        }
        if (src.hasReliableCache()) {
            tgt.setReliableCacheElement(VersionConvertor_14_50.convertUnsignedInt(src.getReliableCacheElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        for (Extension e : src.getExtensionsByUrl("http://hl7.org/fhir/1.0/StructureDefinition/extension-Conformance.messaging.event")) {
            Conformance.ConformanceMessagingEventComponent event = new Conformance.ConformanceMessagingEventComponent();
            tgt.addEvent(event);
            event.setCode(VersionConvertor_14_50.convertCoding((Coding)e.getExtensionByUrl("code").getValue()));
            if (e.hasExtension("category")) {
                event.setCategory(Conformance.MessageSignificanceCategory.fromCode((String)e.getExtensionByUrl("category").getValue().toString()));
            }
            event.setMode(Conformance.ConformanceEventMode.fromCode((String)e.getExtensionByUrl("mode").getValue().toString()));
            Extension focusE = e.getExtensionByUrl("focus");
            if (focusE.getValue().hasPrimitiveValue()) {
                event.setFocus(focusE.getValue().toString());
            } else {
                event.setFocusElement(new CodeType());
                VersionConvertor_14_50.copyElement(focusE.getValue(), (Element)event.getFocusElement(), new String[0]);
            }
            event.setRequest(VersionConvertor_14_50.convertReference((Reference)e.getExtensionByUrl("request").getValue()));
            event.setResponse(VersionConvertor_14_50.convertReference((Reference)e.getExtensionByUrl("response").getValue()));
            if (!e.hasExtension("documentation")) continue;
            event.setDocumentation(e.getExtensionByUrl("documentation").getValue().toString());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingComponent convertConformanceMessagingComponent(Conformance.ConformanceMessagingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingComponent tgt = new CapabilityStatement.CapabilityStatementMessagingComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        for (Conformance.ConformanceMessagingEndpointComponent t : src.getEndpoint()) {
            tgt.addEndpoint(Conformance14_50.convertConformanceMessagingEndpointComponent(t));
        }
        if (src.hasReliableCache()) {
            tgt.setReliableCacheElement(VersionConvertor_14_50.convertUnsignedInt(src.getReliableCacheElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        for (Conformance.ConformanceMessagingEndpointComponent t : src.getEvent()) {
            Extension e = new Extension("http://hl7.org/fhir/1.0/StructureDefinition/extension-Conformance.messaging.event");
            e.addExtension(new Extension("code", VersionConvertor_14_50.convertCoding(t.getCode())));
            if (t.hasCategory()) {
                e.addExtension(new Extension("category", new org.hl7.fhir.r5.model.CodeType(t.getCategory().toCode())));
            }
            e.addExtension(new Extension("mode", new org.hl7.fhir.r5.model.CodeType(t.getMode().toCode())));
            if (t.getFocusElement().hasValue()) {
                e.addExtension(new Extension("focus", new StringType(t.getFocus())));
            } else {
                org.hl7.fhir.r5.model.CodeType focus = new org.hl7.fhir.r5.model.CodeType();
                Extension focusE = new Extension("focus", focus);
                VersionConvertor_14_50.copyElement((Element)t.getFocusElement(), focus, new String[0]);
                e.addExtension(focusE);
            }
            e.addExtension(new Extension("request", VersionConvertor_14_50.convertReference(t.getRequest())));
            e.addExtension(new Extension("response", VersionConvertor_14_50.convertReference(t.getResponse())));
            if (t.hasDocumentation()) {
                e.addExtension(new Extension("documentation", new StringType(t.getDocumentation())));
            }
            tgt.addExtension(e);
        }
        return tgt;
    }

    public static Conformance.ConformanceMessagingEndpointComponent convertConformanceMessagingEndpointComponent(CapabilityStatement.CapabilityStatementMessagingEndpointComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceMessagingEndpointComponent tgt = new Conformance.ConformanceMessagingEndpointComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasProtocol()) {
            tgt.setProtocol(VersionConvertor_14_50.convertCoding(src.getProtocol()));
        }
        if (src.hasAddress()) {
            tgt.setAddress(src.getAddress());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingEndpointComponent convertConformanceMessagingEndpointComponent(Conformance.ConformanceMessagingEndpointComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent tgt = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasProtocol()) {
            tgt.setProtocol(VersionConvertor_14_50.convertCoding(src.getProtocol()));
        }
        if (src.hasAddress()) {
            tgt.setAddress(src.getAddress());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestComponent convertConformanceRestComponent(Conformance.ConformanceRestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestComponent tgt = new CapabilityStatement.CapabilityStatementRestComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(Conformance14_50.convertRestfulConformanceMode((org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.RestfulConformanceMode>)src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasSecurity()) {
            tgt.setSecurity(Conformance14_50.convertConformanceRestSecurityComponent(src.getSecurity()));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getResource()) {
            tgt.addResource(Conformance14_50.convertConformanceRestResourceComponent(t));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getInteraction()) {
            tgt.addInteraction(Conformance14_50.convertSystemInteractionComponent((Conformance.SystemInteractionComponent)t));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getSearchParam()) {
            tgt.addSearchParam(Conformance14_50.convertConformanceRestResourceSearchParamComponent((Conformance.ConformanceRestResourceSearchParamComponent)t));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getOperation()) {
            tgt.addOperation(Conformance14_50.convertConformanceRestOperationComponent((Conformance.ConformanceRestOperationComponent)t));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getCompartment()) {
            tgt.addCompartment((String)t.getValue());
        }
        return tgt;
    }

    public static Conformance.ConformanceRestComponent convertConformanceRestComponent(CapabilityStatement.CapabilityStatementRestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestComponent tgt = new Conformance.ConformanceRestComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(Conformance14_50.convertRestfulConformanceMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasSecurity()) {
            tgt.setSecurity(Conformance14_50.convertConformanceRestSecurityComponent(src.getSecurity()));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent capabilityStatementRestResourceComponent : src.getResource()) {
            tgt.addResource(Conformance14_50.convertConformanceRestResourceComponent(capabilityStatementRestResourceComponent));
        }
        for (CapabilityStatement.SystemInteractionComponent systemInteractionComponent : src.getInteraction()) {
            tgt.addInteraction(Conformance14_50.convertSystemInteractionComponent(systemInteractionComponent));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent capabilityStatementRestResourceSearchParamComponent : src.getSearchParam()) {
            tgt.addSearchParam(Conformance14_50.convertConformanceRestResourceSearchParamComponent(capabilityStatementRestResourceSearchParamComponent));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent capabilityStatementRestResourceOperationComponent : src.getOperation()) {
            tgt.addOperation(Conformance14_50.convertConformanceRestOperationComponent(capabilityStatementRestResourceOperationComponent));
        }
        for (UriType uriType : src.getCompartment()) {
            tgt.addCompartment((String)uriType.getValue());
        }
        return tgt;
    }

    public static Conformance.ConformanceRestOperationComponent convertConformanceRestOperationComponent(CapabilityStatement.CapabilityStatementRestResourceOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestOperationComponent tgt = new Conformance.ConformanceRestOperationComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasDefinitionElement()) {
            tgt.setDefinition(VersionConvertor_14_50.convertCanonicalToReference(src.getDefinitionElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceOperationComponent convertConformanceRestOperationComponent(Conformance.ConformanceRestOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_14_50.convertReferenceToCanonical(src.getDefinition()));
        }
        return tgt;
    }

    public static Conformance.ConformanceRestResourceComponent convertConformanceRestResourceComponent(CapabilityStatement.CapabilityStatementRestResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestResourceComponent tgt = new Conformance.ConformanceRestResourceComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasType() && src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_14_50.convertCode(src.getTypeElement()));
        }
        if (src.hasProfileElement()) {
            tgt.setProfile(VersionConvertor_14_50.convertCanonicalToReference(src.getProfileElement()));
        }
        for (CapabilityStatement.ResourceInteractionComponent resourceInteractionComponent : src.getInteraction()) {
            tgt.addInteraction(Conformance14_50.convertResourceInteractionComponent(resourceInteractionComponent));
        }
        if (src.hasVersioning()) {
            tgt.setVersioningElement(Conformance14_50.convertResourceVersionPolicy(src.getVersioningElement()));
        }
        if (src.hasReadHistory()) {
            tgt.setReadHistoryElement(VersionConvertor_14_50.convertBoolean(src.getReadHistoryElement()));
        }
        if (src.hasUpdateCreate()) {
            tgt.setUpdateCreateElement(VersionConvertor_14_50.convertBoolean(src.getUpdateCreateElement()));
        }
        if (src.hasConditionalCreate()) {
            tgt.setConditionalCreateElement(VersionConvertor_14_50.convertBoolean(src.getConditionalCreateElement()));
        }
        if (src.hasConditionalUpdate()) {
            tgt.setConditionalUpdateElement(VersionConvertor_14_50.convertBoolean(src.getConditionalUpdateElement()));
        }
        if (src.hasConditionalDelete()) {
            tgt.setConditionalDeleteElement(Conformance14_50.convertConditionalDeleteStatus(src.getConditionalDeleteElement()));
        }
        for (StringType stringType : src.getSearchInclude()) {
            tgt.addSearchInclude((String)stringType.getValue());
        }
        for (StringType stringType : src.getSearchRevInclude()) {
            tgt.addSearchRevInclude((String)stringType.getValue());
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent capabilityStatementRestResourceSearchParamComponent : src.getSearchParam()) {
            tgt.addSearchParam(Conformance14_50.convertConformanceRestResourceSearchParamComponent(capabilityStatementRestResourceSearchParamComponent));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceComponent convertConformanceRestResourceComponent(Conformance.ConformanceRestResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_14_50.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(VersionConvertor_14_50.convertReferenceToCanonical(src.getProfile()));
        }
        for (Conformance.ResourceInteractionComponent t : src.getInteraction()) {
            tgt.addInteraction(Conformance14_50.convertResourceInteractionComponent(t));
        }
        if (src.hasVersioning()) {
            tgt.setVersioningElement(Conformance14_50.convertResourceVersionPolicy((org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.ResourceVersionPolicy>)src.getVersioningElement()));
        }
        if (src.hasReadHistory()) {
            tgt.setReadHistoryElement(VersionConvertor_14_50.convertBoolean(src.getReadHistoryElement()));
        }
        if (src.hasUpdateCreate()) {
            tgt.setUpdateCreateElement(VersionConvertor_14_50.convertBoolean(src.getUpdateCreateElement()));
        }
        if (src.hasConditionalCreate()) {
            tgt.setConditionalCreateElement(VersionConvertor_14_50.convertBoolean(src.getConditionalCreateElement()));
        }
        if (src.hasConditionalUpdate()) {
            tgt.setConditionalUpdateElement(VersionConvertor_14_50.convertBoolean(src.getConditionalUpdateElement()));
        }
        if (src.hasConditionalDelete()) {
            tgt.setConditionalDeleteElement(Conformance14_50.convertConditionalDeleteStatus((org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.ConditionalDeleteStatus>)src.getConditionalDeleteElement()));
        }
        for (Conformance.ResourceInteractionComponent t : src.getSearchInclude()) {
            tgt.addSearchInclude((String)t.getValue());
        }
        for (Conformance.ResourceInteractionComponent t : src.getSearchRevInclude()) {
            tgt.addSearchRevInclude((String)t.getValue());
        }
        for (Conformance.ResourceInteractionComponent t : src.getSearchParam()) {
            tgt.addSearchParam(Conformance14_50.convertConformanceRestResourceSearchParamComponent((Conformance.ConformanceRestResourceSearchParamComponent)t));
        }
        return tgt;
    }

    public static Conformance.ConformanceRestResourceSearchParamComponent convertConformanceRestResourceSearchParamComponent(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestResourceSearchParamComponent tgt = new Conformance.ConformanceRestResourceSearchParamComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_50.convertSearchParamType(src.getTypeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent convertConformanceRestResourceSearchParamComponent(Conformance.ConformanceRestResourceSearchParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_50.convertSearchParamType((org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.SearchParamType>)src.getTypeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestSecurityComponent convertConformanceRestSecurityComponent(Conformance.ConformanceRestSecurityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestSecurityComponent tgt = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasCors()) {
            tgt.setCorsElement(VersionConvertor_14_50.convertBoolean(src.getCorsElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.CodeableConcept t : src.getService()) {
            tgt.addService(VersionConvertor_14_50.convertCodeableConcept(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        return tgt;
    }

    public static Conformance.ConformanceRestSecurityComponent convertConformanceRestSecurityComponent(CapabilityStatement.CapabilityStatementRestSecurityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestSecurityComponent tgt = new Conformance.ConformanceRestSecurityComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasCors()) {
            tgt.setCorsElement(VersionConvertor_14_50.convertBoolean(src.getCorsElement()));
        }
        for (CodeableConcept t : src.getService()) {
            tgt.addService(VersionConvertor_14_50.convertCodeableConcept(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementSoftwareComponent convertConformanceSoftwareComponent(Conformance.ConformanceSoftwareComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementSoftwareComponent tgt = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_50.convertString(src.getVersionElement()));
        }
        if (src.hasReleaseDate()) {
            tgt.setReleaseDateElement(VersionConvertor_14_50.convertDateTime(src.getReleaseDateElement()));
        }
        return tgt;
    }

    public static Conformance.ConformanceSoftwareComponent convertConformanceSoftwareComponent(CapabilityStatement.CapabilityStatementSoftwareComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceSoftwareComponent tgt = new Conformance.ConformanceSoftwareComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_50.convertString(src.getVersionElement()));
        }
        if (src.hasReleaseDate()) {
            tgt.setReleaseDateElement(VersionConvertor_14_50.convertDateTime(src.getReleaseDateElement()));
        }
        return tgt;
    }

    public static Enumeration<Enumerations.CapabilityStatementKind> convertConformanceStatementKind(org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.ConformanceStatementKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.CapabilityStatementKind> tgt = new Enumeration<Enumerations.CapabilityStatementKind>(new Enumerations.CapabilityStatementKindEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((Conformance.ConformanceStatementKind)src.getValue()) {
            case INSTANCE: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.INSTANCE);
                break;
            }
            case CAPABILITY: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.CAPABILITY);
                break;
            }
            case REQUIREMENTS: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.REQUIREMENTS);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.ConformanceStatementKind> convertConformanceStatementKind(Enumeration<Enumerations.CapabilityStatementKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new Conformance.ConformanceStatementKindEnumFactory());
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((Enumerations.CapabilityStatementKind)((Object)src.getValue())) {
            case INSTANCE: {
                tgt.setValue((Object)Conformance.ConformanceStatementKind.INSTANCE);
                break;
            }
            case CAPABILITY: {
                tgt.setValue((Object)Conformance.ConformanceStatementKind.CAPABILITY);
                break;
            }
            case REQUIREMENTS: {
                tgt.setValue((Object)Conformance.ConformanceStatementKind.REQUIREMENTS);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.ConformanceStatementKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.DocumentMode> convertDocumentMode(org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.DocumentMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.DocumentMode> tgt = new Enumeration<CapabilityStatement.DocumentMode>(new CapabilityStatement.DocumentModeEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((Conformance.DocumentMode)src.getValue()) {
            case PRODUCER: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.PRODUCER);
                break;
            }
            case CONSUMER: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.CONSUMER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.DocumentMode> convertDocumentMode(Enumeration<CapabilityStatement.DocumentMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new Conformance.DocumentModeEnumFactory());
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((CapabilityStatement.DocumentMode)((Object)src.getValue())) {
            case PRODUCER: {
                tgt.setValue((Object)Conformance.DocumentMode.PRODUCER);
                break;
            }
            case CONSUMER: {
                tgt.setValue((Object)Conformance.DocumentMode.CONSUMER);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.DocumentMode.NULL);
            }
        }
        return tgt;
    }

    public static CapabilityStatement.ResourceInteractionComponent convertResourceInteractionComponent(Conformance.ResourceInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.ResourceInteractionComponent tgt = new CapabilityStatement.ResourceInteractionComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(Conformance14_50.convertTypeRestfulInteraction((org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.TypeRestfulInteraction>)src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static Conformance.ResourceInteractionComponent convertResourceInteractionComponent(CapabilityStatement.ResourceInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ResourceInteractionComponent tgt = new Conformance.ResourceInteractionComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(Conformance14_50.convertTypeRestfulInteraction(src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.ResourceVersionPolicy> convertResourceVersionPolicy(org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.ResourceVersionPolicy> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.ResourceVersionPolicy> tgt = new Enumeration<CapabilityStatement.ResourceVersionPolicy>(new CapabilityStatement.ResourceVersionPolicyEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((Conformance.ResourceVersionPolicy)src.getValue()) {
            case NOVERSION: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.NOVERSION);
                break;
            }
            case VERSIONED: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.VERSIONED);
                break;
            }
            case VERSIONEDUPDATE: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.VERSIONEDUPDATE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.ResourceVersionPolicy> convertResourceVersionPolicy(Enumeration<CapabilityStatement.ResourceVersionPolicy> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new Conformance.ResourceVersionPolicyEnumFactory());
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((CapabilityStatement.ResourceVersionPolicy)((Object)src.getValue())) {
            case NOVERSION: {
                tgt.setValue((Object)Conformance.ResourceVersionPolicy.NOVERSION);
                break;
            }
            case VERSIONED: {
                tgt.setValue((Object)Conformance.ResourceVersionPolicy.VERSIONED);
                break;
            }
            case VERSIONEDUPDATE: {
                tgt.setValue((Object)Conformance.ResourceVersionPolicy.VERSIONEDUPDATE);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.ResourceVersionPolicy.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.RestfulCapabilityMode> convertRestfulConformanceMode(org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.RestfulConformanceMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.RestfulCapabilityMode> tgt = new Enumeration<Enumerations.RestfulCapabilityMode>(new Enumerations.RestfulCapabilityModeEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((Conformance.RestfulConformanceMode)src.getValue()) {
            case CLIENT: {
                tgt.setValue((Object)Enumerations.RestfulCapabilityMode.CLIENT);
                break;
            }
            case SERVER: {
                tgt.setValue((Object)Enumerations.RestfulCapabilityMode.SERVER);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RestfulCapabilityMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.RestfulConformanceMode> convertRestfulConformanceMode(Enumeration<Enumerations.RestfulCapabilityMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new Conformance.RestfulConformanceModeEnumFactory());
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((Enumerations.RestfulCapabilityMode)((Object)src.getValue())) {
            case CLIENT: {
                tgt.setValue((Object)Conformance.RestfulConformanceMode.CLIENT);
                break;
            }
            case SERVER: {
                tgt.setValue((Object)Conformance.RestfulConformanceMode.SERVER);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.RestfulConformanceMode.NULL);
            }
        }
        return tgt;
    }

    public static Conformance.SystemInteractionComponent convertSystemInteractionComponent(CapabilityStatement.SystemInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.SystemInteractionComponent tgt = new Conformance.SystemInteractionComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(Conformance14_50.convertSystemRestfulInteraction(src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static CapabilityStatement.SystemInteractionComponent convertSystemInteractionComponent(Conformance.SystemInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.SystemInteractionComponent tgt = new CapabilityStatement.SystemInteractionComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(Conformance14_50.convertSystemRestfulInteraction((org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.SystemRestfulInteraction>)src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.SystemRestfulInteraction> convertSystemRestfulInteraction(org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.SystemRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.SystemRestfulInteraction> tgt = new Enumeration<CapabilityStatement.SystemRestfulInteraction>(new CapabilityStatement.SystemRestfulInteractionEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((Conformance.SystemRestfulInteraction)src.getValue()) {
            case TRANSACTION: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.TRANSACTION);
                break;
            }
            case SEARCHSYSTEM: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.SEARCHSYSTEM);
                break;
            }
            case HISTORYSYSTEM: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.HISTORYSYSTEM);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.SystemRestfulInteraction> convertSystemRestfulInteraction(Enumeration<CapabilityStatement.SystemRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new Conformance.SystemRestfulInteractionEnumFactory());
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((CapabilityStatement.SystemRestfulInteraction)((Object)src.getValue())) {
            case TRANSACTION: {
                tgt.setValue((Object)Conformance.SystemRestfulInteraction.TRANSACTION);
                break;
            }
            case SEARCHSYSTEM: {
                tgt.setValue((Object)Conformance.SystemRestfulInteraction.SEARCHSYSTEM);
                break;
            }
            case HISTORYSYSTEM: {
                tgt.setValue((Object)Conformance.SystemRestfulInteraction.HISTORYSYSTEM);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.SystemRestfulInteraction.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.TypeRestfulInteraction> convertTypeRestfulInteraction(Enumeration<CapabilityStatement.TypeRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new Conformance.TypeRestfulInteractionEnumFactory());
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((CapabilityStatement.TypeRestfulInteraction)((Object)src.getValue())) {
            case READ: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.READ);
                break;
            }
            case VREAD: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.VREAD);
                break;
            }
            case UPDATE: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.UPDATE);
                break;
            }
            case DELETE: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.DELETE);
                break;
            }
            case HISTORYINSTANCE: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.HISTORYINSTANCE);
                break;
            }
            case HISTORYTYPE: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.HISTORYTYPE);
                break;
            }
            case CREATE: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.CREATE);
                break;
            }
            case SEARCHTYPE: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.SEARCHTYPE);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.TypeRestfulInteraction> convertTypeRestfulInteraction(org.hl7.fhir.dstu2016may.model.Enumeration<Conformance.TypeRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.TypeRestfulInteraction> tgt = new Enumeration<CapabilityStatement.TypeRestfulInteraction>(new CapabilityStatement.TypeRestfulInteractionEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((Conformance.TypeRestfulInteraction)src.getValue()) {
            case READ: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.READ);
                break;
            }
            case VREAD: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.VREAD);
                break;
            }
            case UPDATE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.UPDATE);
                break;
            }
            case DELETE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.DELETE);
                break;
            }
            case HISTORYINSTANCE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE);
                break;
            }
            case HISTORYTYPE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE);
                break;
            }
            case CREATE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.CREATE);
                break;
            }
            case SEARCHTYPE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.NULL);
            }
        }
        return tgt;
    }
}

