/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_40;

import org.hl7.fhir.convertors.VersionConvertor_14_40;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

public class StructureDefinition14_40 {
    public static Enumeration<StructureDefinition.ExtensionContextType> convertExtensionContext(org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.ExtensionContext> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureDefinition.ExtensionContextType> tgt = new Enumeration<StructureDefinition.ExtensionContextType>(new StructureDefinition.ExtensionContextTypeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.ExtensionContext)src.getValue()) {
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.ELEMENT);
                break;
            }
            case DATATYPE: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.ELEMENT);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.EXTENSION);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.ExtensionContext> convertExtensionContext(Enumeration<StructureDefinition.ExtensionContextType> src, String expression) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new StructureDefinition.ExtensionContextEnumFactory());
        VersionConvertor_14_40.copyElement(src, (Element)tgt, new String[0]);
        switch ((StructureDefinition.ExtensionContextType)((Object)src.getValue())) {
            case FHIRPATH: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.RESOURCE);
                break;
            }
            case ELEMENT: {
                String tn;
                String string = tn = expression.contains(".") ? expression.substring(0, expression.indexOf(".")) : expression;
                if (StructureDefinition14_40.isResource140(tn)) {
                    tgt.setValue((Object)StructureDefinition.ExtensionContext.RESOURCE);
                    break;
                }
                tgt.setValue((Object)StructureDefinition.ExtensionContext.DATATYPE);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.EXTENSION);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.StructureDefinition convertStructureDefinition(StructureDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.StructureDefinition tgt = new org.hl7.fhir.dstu2016may.model.StructureDefinition();
        VersionConvertor_14_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_40.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_40.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_40.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setDisplayElement(VersionConvertor_14_40.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_40.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(StructureDefinition14_40.convertStructureDefinitionContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (Coding coding : src.getKeyword()) {
            tgt.addCode(VersionConvertor_14_40.convertCoding(coding));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(src.getFhirVersion().toCode());
        }
        for (StructureDefinition.StructureDefinitionMappingComponent structureDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(StructureDefinition14_40.convertStructureDefinitionMappingComponent(structureDefinitionMappingComponent));
        }
        if (src.hasKind()) {
            tgt.setKindElement(StructureDefinition14_40.convertStructureDefinitionKind(src.getKindElement()));
        }
        if (src.hasAbstractElement()) {
            tgt.setAbstractElement(VersionConvertor_14_40.convertBoolean(src.getAbstractElement()));
        }
        for (StructureDefinition.StructureDefinitionContextComponent structureDefinitionContextComponent : src.getContext()) {
            if (!tgt.hasContextType()) {
                tgt.setContextTypeElement(StructureDefinition14_40.convertExtensionContext(structureDefinitionContextComponent.getTypeElement(), structureDefinitionContextComponent.getExpression()));
            }
            tgt.addContext("Element".equals(structureDefinitionContextComponent.getExpression()) ? "*" : structureDefinitionContextComponent.getExpression());
        }
        if (src.hasBaseDefinition()) {
            tgt.setBaseDefinition(src.getBaseDefinition());
        }
        if (src.hasType() && src.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            tgt.setBaseType(src.getType());
        }
        if (src.hasDerivation()) {
            tgt.setDerivationElement(StructureDefinition14_40.convertTypeDerivationRule(src.getDerivationElement()));
        }
        if (src.hasSnapshot()) {
            tgt.setSnapshot(StructureDefinition14_40.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
        }
        if (src.hasDifferential()) {
            tgt.setDifferential(StructureDefinition14_40.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
        }
        return tgt;
    }

    public static StructureDefinition convertStructureDefinition(org.hl7.fhir.dstu2016may.model.StructureDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition tgt = new StructureDefinition();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_40.convertUri(src.getUrlElement()));
        }
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_40.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        if (src.hasDisplay()) {
            tgt.setTitleElement(VersionConvertor_14_40.convertString(src.getDisplayElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_40.convertConformanceResourceStatus((org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_40.convertString(src.getPublisherElement()));
        }
        for (Identifier t : src.getContact()) {
            tgt.addContact(StructureDefinition14_40.convertStructureDefinitionContactComponent((StructureDefinition.StructureDefinitionContactComponent)t));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (Identifier t : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (Identifier t : src.getCode()) {
            tgt.addKeyword(VersionConvertor_14_40.convertCoding((org.hl7.fhir.dstu2016may.model.Coding)t));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(Enumerations.FHIRVersion.fromCode(src.getFhirVersion()));
        }
        for (Identifier t : src.getMapping()) {
            tgt.addMapping(StructureDefinition14_40.convertStructureDefinitionMappingComponent((StructureDefinition.StructureDefinitionMappingComponent)t));
        }
        if (src.hasKind()) {
            tgt.setKindElement(StructureDefinition14_40.convertStructureDefinitionKind((org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.StructureDefinitionKind>)src.getKindElement(), src.getName()));
        }
        if (src.hasAbstractElement()) {
            tgt.setAbstractElement(VersionConvertor_14_40.convertBoolean(src.getAbstractElement()));
        }
        for (Identifier t : src.getContext()) {
            StructureDefinition.StructureDefinitionContextComponent ec = tgt.addContext();
            ec.setTypeElement(StructureDefinition14_40.convertExtensionContext((org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.ExtensionContext>)src.getContextTypeElement()));
            ec.setExpression("*".equals(t.getValue()) ? "Element" : (String)t.getValue());
        }
        if (src.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            tgt.setType(src.getBaseType());
        } else {
            tgt.setType(src.getId());
        }
        if (src.hasBaseDefinition()) {
            tgt.setBaseDefinition(src.getBaseDefinition());
        }
        if (src.hasDerivation()) {
            tgt.setDerivationElement(StructureDefinition14_40.convertTypeDerivationRule((org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.TypeDerivationRule>)src.getDerivationElement()));
        }
        if (src.hasSnapshot()) {
            if (src.hasSnapshot()) {
                tgt.setSnapshot(StructureDefinition14_40.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
            }
            tgt.getSnapshot().getElementFirstRep().getType().clear();
        }
        if (src.hasDifferential()) {
            if (src.hasDifferential()) {
                tgt.setDifferential(StructureDefinition14_40.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
            }
            tgt.getDifferential().getElementFirstRep().getType().clear();
        }
        if (tgt.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
            for (ElementDefinition ed : tgt.getSnapshot().getElement()) {
                if (ed.hasBase()) continue;
                ed.getBase().setPath(ed.getPath()).setMin(ed.getMin()).setMax(ed.getMax());
            }
        }
        return tgt;
    }

    public static ContactDetail convertStructureDefinitionContactComponent(StructureDefinition.StructureDefinitionContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement((Element)src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionContactComponent convertStructureDefinitionContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionContactComponent tgt = new StructureDefinition.StructureDefinitionContactComponent();
        VersionConvertor_14_40.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        VersionConvertor_14_40.copyElement(src, (Element)tgt, new String[0]);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_14_40.convertElementDefinition(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        VersionConvertor_14_40.copyElement((Element)src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2016may.model.ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_14_40.convertElementDefinition(t, src.getElement(), src.getElement().indexOf(t)));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.StructureDefinitionKind> convertStructureDefinitionKind(Enumeration<StructureDefinition.StructureDefinitionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new StructureDefinition.StructureDefinitionKindEnumFactory());
        VersionConvertor_14_40.copyElement(src, (Element)tgt, new String[0]);
        switch ((StructureDefinition.StructureDefinitionKind)((Object)src.getValue())) {
            case PRIMITIVETYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.DATATYPE);
                break;
            }
            case COMPLEXTYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.DATATYPE);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.RESOURCE);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.LOGICAL);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureDefinition.StructureDefinitionKind> convertStructureDefinitionKind(org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.StructureDefinitionKind> src, String name) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureDefinition.StructureDefinitionKind> tgt = new Enumeration<StructureDefinition.StructureDefinitionKind>(new StructureDefinition.StructureDefinitionKindEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.StructureDefinitionKind)src.getValue()) {
            case DATATYPE: {
                if (name.substring(0, 1).toLowerCase().equals(name.substring(0, 1))) {
                    tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE);
                    break;
                }
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.RESOURCE);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.LOGICAL);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.NULL);
            }
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_14_40.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_14_40.convertId(src.getIdentityElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(VersionConvertor_14_40.convertUri(src.getUriElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentsElement(VersionConvertor_14_40.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_14_40.copyElement((Element)src, tgt, new String[0]);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_14_40.convertId(src.getIdentityElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(VersionConvertor_14_40.convertUri(src.getUriElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        if (src.hasComments()) {
            tgt.setCommentElement(VersionConvertor_14_40.convertString(src.getCommentsElement()));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        VersionConvertor_14_40.copyElement((Element)src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2016may.model.ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_14_40.convertElementDefinition(t, src.getElement(), src.getElement().indexOf(t)));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        VersionConvertor_14_40.copyElement(src, (Element)tgt, new String[0]);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_14_40.convertElementDefinition(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.TypeDerivationRule> convertTypeDerivationRule(Enumeration<StructureDefinition.TypeDerivationRule> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new StructureDefinition.TypeDerivationRuleEnumFactory());
        VersionConvertor_14_40.copyElement(src, (Element)tgt, new String[0]);
        switch ((StructureDefinition.TypeDerivationRule)((Object)src.getValue())) {
            case SPECIALIZATION: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.SPECIALIZATION);
                break;
            }
            case CONSTRAINT: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.CONSTRAINT);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureDefinition.TypeDerivationRule> convertTypeDerivationRule(org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.TypeDerivationRule> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureDefinition.TypeDerivationRule> tgt = new Enumeration<StructureDefinition.TypeDerivationRule>(new StructureDefinition.TypeDerivationRuleEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.TypeDerivationRule)src.getValue()) {
            case SPECIALIZATION: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.SPECIALIZATION);
                break;
            }
            case CONSTRAINT: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.CONSTRAINT);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.NULL);
            }
        }
        return tgt;
    }

    public static boolean isResource140(String tn) {
        return Utilities.existsInList(tn, "Account", "AllergyIntolerance", "Appointment", "AppointmentResponse", "AuditEvent", "Basic", "Binary", "BodySite", "Bundle", "CarePlan", "CareTeam", "Claim", "ClaimResponse", "ClinicalImpression", "CodeSystem", "Communication", "CommunicationRequest", "CompartmentDefinition", "Composition", "ConceptMap", "Condition", "Conformance", "Contract", "Coverage", "DataElement", "DecisionSupportRule", "DecisionSupportServiceModule", "DetectedIssue", "Device", "DeviceComponent", "DeviceMetric", "DeviceUseRequest", "DeviceUseStatement", "DiagnosticOrder", "DiagnosticReport", "DocumentManifest", "DocumentReference", "EligibilityRequest", "EligibilityResponse", "Encounter", "EnrollmentRequest", "EnrollmentResponse", "EpisodeOfCare", "ExpansionProfile", "ExplanationOfBenefit", "FamilyMemberHistory", "Flag", "Goal", "Group", "GuidanceResponse", "HealthcareService", "ImagingExcerpt", "ImagingObjectSelection", "ImagingStudy", "Immunization", "ImmunizationRecommendation", "ImplementationGuide", "Library", "Linkage", "List", "Location", "Measure", "MeasureReport", "Media", "Medication", "MedicationAdministration", "MedicationDispense", "MedicationOrder", "MedicationStatement", "MessageHeader", "ModuleDefinition", "NamingSystem", "NutritionOrder", "Observation", "OperationDefinition", "OperationOutcome", "Order", "OrderResponse", "OrderSet", "Organization", "Parameters", "Patient", "PaymentNotice", "PaymentReconciliation", "Person", "Practitioner", "PractitionerRole", "Procedure", "ProcedureRequest", "ProcessRequest", "ProcessResponse", "Protocol", "Provenance", "Questionnaire", "QuestionnaireResponse", "ReferralRequest", "RelatedPerson", "RiskAssessment", "Schedule", "SearchParameter", "Sequence", "Slot", "Sequence", "Specimen", "StructureDefinition", "StructureMap", "Subscription", "Substance", "SupplyDelivery", "SupplyRequest", "Task", "TestScript", "ValueSet", "VisionPrescription");
    }
}

