/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_40;

import org.hl7.fhir.convertors.VersionConvertor_14_40;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.QuestionnaireResponse;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.QuestionnaireResponse;

public class QuestionnaireResponse14_40 {
    public static org.hl7.fhir.r4.model.QuestionnaireResponse convertQuestionnaireResponse(QuestionnaireResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.QuestionnaireResponse tgt = new org.hl7.fhir.r4.model.QuestionnaireResponse();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_14_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasQuestionnaire()) {
            tgt.setQuestionnaireElement(VersionConvertor_14_40.convertReferenceToCanonical(src.getQuestionnaire()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(QuestionnaireResponse14_40.convertQuestionnaireResponseStatus((org.hl7.fhir.dstu2016may.model.Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus>)src.getStatusElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_14_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_14_40.convertReference(src.getEncounter()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_14_40.convertReference(src.getAuthor()));
        }
        if (src.hasAuthored()) {
            tgt.setAuthoredElement(VersionConvertor_14_40.convertDateTime(src.getAuthoredElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_14_40.convertReference(src.getSource()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            tgt.addItem(QuestionnaireResponse14_40.convertQuestionnaireResponseItemComponent(t));
        }
        return tgt;
    }

    public static QuestionnaireResponse convertQuestionnaireResponse(org.hl7.fhir.r4.model.QuestionnaireResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse tgt = new QuestionnaireResponse();
        VersionConvertor_14_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_14_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasQuestionnaireElement()) {
            tgt.setQuestionnaire(VersionConvertor_14_40.convertCanonicalToReference(src.getQuestionnaireElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(QuestionnaireResponse14_40.convertQuestionnaireResponseStatus(src.getStatusElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_14_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_14_40.convertReference(src.getEncounter()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_14_40.convertReference(src.getAuthor()));
        }
        if (src.hasAuthored()) {
            tgt.setAuthoredElement(VersionConvertor_14_40.convertDateTime(src.getAuthoredElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_14_40.convertReference(src.getSource()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            tgt.addItem(QuestionnaireResponse14_40.convertQuestionnaireResponseItemComponent(t));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent convertQuestionnaireResponseItemAnswerComponent(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
        VersionConvertor_14_40.copyElement((Element)src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            tgt.addItem(QuestionnaireResponse14_40.convertQuestionnaireResponseItemComponent(t));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent convertQuestionnaireResponseItemAnswerComponent(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
        VersionConvertor_14_40.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            tgt.addItem(QuestionnaireResponse14_40.convertQuestionnaireResponseItemComponent(t));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemComponent convertQuestionnaireResponseItemComponent(QuestionnaireResponse.QuestionnaireResponseItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        VersionConvertor_14_40.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasLinkId()) {
            tgt.setLinkIdElement(VersionConvertor_14_40.convertString(src.getLinkIdElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_40.convertString(src.getTextElement()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent questionnaireResponseItemAnswerComponent : src.getAnswer()) {
            tgt.addAnswer(QuestionnaireResponse14_40.convertQuestionnaireResponseItemAnswerComponent(questionnaireResponseItemAnswerComponent));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent questionnaireResponseItemComponent : src.getItem()) {
            tgt.addItem(QuestionnaireResponse14_40.convertQuestionnaireResponseItemComponent(questionnaireResponseItemComponent));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemComponent convertQuestionnaireResponseItemComponent(QuestionnaireResponse.QuestionnaireResponseItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        VersionConvertor_14_40.copyElement((Element)src, tgt, new String[0]);
        if (src.hasLinkId()) {
            tgt.setLinkIdElement(VersionConvertor_14_40.convertString(src.getLinkIdElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_40.convertString(src.getTextElement()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent t : src.getAnswer()) {
            tgt.addAnswer(QuestionnaireResponse14_40.convertQuestionnaireResponseItemAnswerComponent(t));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent t : src.getItem()) {
            tgt.addItem(QuestionnaireResponse14_40.convertQuestionnaireResponseItemComponent((QuestionnaireResponse.QuestionnaireResponseItemComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> convertQuestionnaireResponseStatus(Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new QuestionnaireResponse.QuestionnaireResponseStatusEnumFactory());
        VersionConvertor_14_40.copyElement(src, (Element)tgt, new String[0]);
        switch ((QuestionnaireResponse.QuestionnaireResponseStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.AMENDED);
                break;
            }
            default: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> convertQuestionnaireResponseStatus(org.hl7.fhir.dstu2016may.model.Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> tgt = new Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus>(new QuestionnaireResponse.QuestionnaireResponseStatusEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((QuestionnaireResponse.QuestionnaireResponseStatus)src.getValue()) {
            case INPROGRESS: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.AMENDED);
                break;
            }
            default: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.NULL);
            }
        }
        return tgt;
    }
}

