/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_40;

import org.hl7.fhir.convertors.VersionConvertor_14_40;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.NamingSystem;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.UsageContext;

public class NamingSystem14_40 {
    public static NamingSystem convertNamingSystem(org.hl7.fhir.dstu2016may.model.NamingSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem tgt = new NamingSystem();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_40.convertConformanceResourceStatus((org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(NamingSystem14_40.convertNamingSystemType((org.hl7.fhir.dstu2016may.model.Enumeration<NamingSystem.NamingSystemType>)src.getKindElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_14_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_40.convertString(src.getPublisherElement()));
        }
        for (NamingSystem.NamingSystemContactComponent t : src.getContact()) {
            tgt.addContact(NamingSystem14_40.convertNamingSystemContactComponent(t));
        }
        if (src.hasResponsible()) {
            tgt.setResponsibleElement(VersionConvertor_14_40.convertString(src.getResponsibleElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_14_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (NamingSystem.NamingSystemContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(VersionConvertor_14_40.convertString(src.getUsageElement()));
        }
        for (NamingSystem.NamingSystemContactComponent t : src.getUniqueId()) {
            tgt.addUniqueId(NamingSystem14_40.convertNamingSystemUniqueIdComponent((NamingSystem.NamingSystemUniqueIdComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.NamingSystem convertNamingSystem(NamingSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.NamingSystem tgt = new org.hl7.fhir.dstu2016may.model.NamingSystem();
        VersionConvertor_14_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(NamingSystem14_40.convertNamingSystemType(src.getKindElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_14_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_40.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(NamingSystem14_40.convertNamingSystemContactComponent(contactDetail));
        }
        if (src.hasResponsible()) {
            tgt.setResponsibleElement(VersionConvertor_14_40.convertString(src.getResponsibleElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_14_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(VersionConvertor_14_40.convertString(src.getUsageElement()));
        }
        for (NamingSystem.NamingSystemUniqueIdComponent namingSystemUniqueIdComponent : src.getUniqueId()) {
            tgt.addUniqueId(NamingSystem14_40.convertNamingSystemUniqueIdComponent(namingSystemUniqueIdComponent));
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemContactComponent convertNamingSystemContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem.NamingSystemContactComponent tgt = new NamingSystem.NamingSystemContactComponent();
        VersionConvertor_14_40.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertNamingSystemContactComponent(NamingSystem.NamingSystemContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement((Element)src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<NamingSystem.NamingSystemIdentifierType> convertNamingSystemIdentifierType(Enumeration<NamingSystem.NamingSystemIdentifierType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new NamingSystem.NamingSystemIdentifierTypeEnumFactory());
        VersionConvertor_14_40.copyElement(src, (Element)tgt, new String[0]);
        switch ((NamingSystem.NamingSystemIdentifierType)((Object)src.getValue())) {
            case OID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OID);
                break;
            }
            case UUID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.UUID);
                break;
            }
            case URI: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.URI);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<NamingSystem.NamingSystemIdentifierType> convertNamingSystemIdentifierType(org.hl7.fhir.dstu2016may.model.Enumeration<NamingSystem.NamingSystemIdentifierType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<NamingSystem.NamingSystemIdentifierType> tgt = new Enumeration<NamingSystem.NamingSystemIdentifierType>(new NamingSystem.NamingSystemIdentifierTypeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((NamingSystem.NamingSystemIdentifierType)src.getValue()) {
            case OID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OID);
                break;
            }
            case UUID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.UUID);
                break;
            }
            case URI: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.URI);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<NamingSystem.NamingSystemType> convertNamingSystemType(Enumeration<NamingSystem.NamingSystemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new NamingSystem.NamingSystemTypeEnumFactory());
        VersionConvertor_14_40.copyElement(src, (Element)tgt, new String[0]);
        switch ((NamingSystem.NamingSystemType)((Object)src.getValue())) {
            case CODESYSTEM: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.CODESYSTEM);
                break;
            }
            case IDENTIFIER: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.IDENTIFIER);
                break;
            }
            case ROOT: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.ROOT);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<NamingSystem.NamingSystemType> convertNamingSystemType(org.hl7.fhir.dstu2016may.model.Enumeration<NamingSystem.NamingSystemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<NamingSystem.NamingSystemType> tgt = new Enumeration<NamingSystem.NamingSystemType>(new NamingSystem.NamingSystemTypeEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((NamingSystem.NamingSystemType)src.getValue()) {
            case CODESYSTEM: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.CODESYSTEM);
                break;
            }
            case IDENTIFIER: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.IDENTIFIER);
                break;
            }
            case ROOT: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.ROOT);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.NULL);
            }
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        VersionConvertor_14_40.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(NamingSystem14_40.convertNamingSystemIdentifierType(src.getTypeElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_14_40.convertString(src.getValueElement()));
        }
        if (src.hasPreferred()) {
            tgt.setPreferredElement(VersionConvertor_14_40.convertBoolean(src.getPreferredElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        VersionConvertor_14_40.copyElement((Element)src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(NamingSystem14_40.convertNamingSystemIdentifierType((org.hl7.fhir.dstu2016may.model.Enumeration<NamingSystem.NamingSystemIdentifierType>)src.getTypeElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_14_40.convertString(src.getValueElement()));
        }
        if (src.hasPreferred()) {
            tgt.setPreferredElement(VersionConvertor_14_40.convertBoolean(src.getPreferredElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }
}

