/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_30;

import org.hl7.fhir.convertors.VersionConvertor_14_30;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu3.model.OperationOutcome;
import org.hl7.fhir.exceptions.FHIRException;

public class OperationOutcome14_30 {
    public static org.hl7.fhir.dstu3.model.Enumeration<OperationOutcome.IssueSeverity> convertIssueSeverity(Enumeration<OperationOutcome.IssueSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<OperationOutcome.IssueSeverity> tgt = new org.hl7.fhir.dstu3.model.Enumeration<OperationOutcome.IssueSeverity>(new OperationOutcome.IssueSeverityEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((OperationOutcome.IssueSeverity)src.getValue()) {
            case FATAL: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.FATAL);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.ERROR);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.WARNING);
                break;
            }
            case INFORMATION: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.INFORMATION);
                break;
            }
            default: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<OperationOutcome.IssueSeverity> convertIssueSeverity(org.hl7.fhir.dstu3.model.Enumeration<OperationOutcome.IssueSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new OperationOutcome.IssueSeverityEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((OperationOutcome.IssueSeverity)((Object)src.getValue())) {
            case FATAL: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.FATAL);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.ERROR);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.WARNING);
                break;
            }
            case INFORMATION: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.INFORMATION);
                break;
            }
            default: {
                tgt.setValue((Object)OperationOutcome.IssueSeverity.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<OperationOutcome.IssueType> convertIssueType(org.hl7.fhir.dstu3.model.Enumeration<OperationOutcome.IssueType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new OperationOutcome.IssueTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((OperationOutcome.IssueType)((Object)src.getValue())) {
            case INVALID: {
                tgt.setValue((Object)OperationOutcome.IssueType.INVALID);
                break;
            }
            case STRUCTURE: {
                tgt.setValue((Object)OperationOutcome.IssueType.STRUCTURE);
                break;
            }
            case REQUIRED: {
                tgt.setValue((Object)OperationOutcome.IssueType.REQUIRED);
                break;
            }
            case VALUE: {
                tgt.setValue((Object)OperationOutcome.IssueType.VALUE);
                break;
            }
            case INVARIANT: {
                tgt.setValue((Object)OperationOutcome.IssueType.INVARIANT);
                break;
            }
            case SECURITY: {
                tgt.setValue((Object)OperationOutcome.IssueType.SECURITY);
                break;
            }
            case LOGIN: {
                tgt.setValue((Object)OperationOutcome.IssueType.LOGIN);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)OperationOutcome.IssueType.UNKNOWN);
                break;
            }
            case EXPIRED: {
                tgt.setValue((Object)OperationOutcome.IssueType.EXPIRED);
                break;
            }
            case FORBIDDEN: {
                tgt.setValue((Object)OperationOutcome.IssueType.FORBIDDEN);
                break;
            }
            case SUPPRESSED: {
                tgt.setValue((Object)OperationOutcome.IssueType.SUPPRESSED);
                break;
            }
            case PROCESSING: {
                tgt.setValue((Object)OperationOutcome.IssueType.PROCESSING);
                break;
            }
            case NOTSUPPORTED: {
                tgt.setValue((Object)OperationOutcome.IssueType.NOTSUPPORTED);
                break;
            }
            case DUPLICATE: {
                tgt.setValue((Object)OperationOutcome.IssueType.DUPLICATE);
                break;
            }
            case NOTFOUND: {
                tgt.setValue((Object)OperationOutcome.IssueType.NOTFOUND);
                break;
            }
            case TOOLONG: {
                tgt.setValue((Object)OperationOutcome.IssueType.TOOLONG);
                break;
            }
            case CODEINVALID: {
                tgt.setValue((Object)OperationOutcome.IssueType.CODEINVALID);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)OperationOutcome.IssueType.EXTENSION);
                break;
            }
            case TOOCOSTLY: {
                tgt.setValue((Object)OperationOutcome.IssueType.TOOCOSTLY);
                break;
            }
            case BUSINESSRULE: {
                tgt.setValue((Object)OperationOutcome.IssueType.BUSINESSRULE);
                break;
            }
            case CONFLICT: {
                tgt.setValue((Object)OperationOutcome.IssueType.CONFLICT);
                break;
            }
            case INCOMPLETE: {
                tgt.setValue((Object)OperationOutcome.IssueType.INCOMPLETE);
                break;
            }
            case TRANSIENT: {
                tgt.setValue((Object)OperationOutcome.IssueType.TRANSIENT);
                break;
            }
            case LOCKERROR: {
                tgt.setValue((Object)OperationOutcome.IssueType.LOCKERROR);
                break;
            }
            case NOSTORE: {
                tgt.setValue((Object)OperationOutcome.IssueType.NOSTORE);
                break;
            }
            case EXCEPTION: {
                tgt.setValue((Object)OperationOutcome.IssueType.EXCEPTION);
                break;
            }
            case TIMEOUT: {
                tgt.setValue((Object)OperationOutcome.IssueType.TIMEOUT);
                break;
            }
            case THROTTLED: {
                tgt.setValue((Object)OperationOutcome.IssueType.THROTTLED);
                break;
            }
            case INFORMATIONAL: {
                tgt.setValue((Object)OperationOutcome.IssueType.INFORMATIONAL);
                break;
            }
            default: {
                tgt.setValue((Object)OperationOutcome.IssueType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<OperationOutcome.IssueType> convertIssueType(Enumeration<OperationOutcome.IssueType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<OperationOutcome.IssueType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<OperationOutcome.IssueType>(new OperationOutcome.IssueTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((OperationOutcome.IssueType)src.getValue()) {
            case INVALID: {
                tgt.setValue((Object)OperationOutcome.IssueType.INVALID);
                break;
            }
            case STRUCTURE: {
                tgt.setValue((Object)OperationOutcome.IssueType.STRUCTURE);
                break;
            }
            case REQUIRED: {
                tgt.setValue((Object)OperationOutcome.IssueType.REQUIRED);
                break;
            }
            case VALUE: {
                tgt.setValue((Object)OperationOutcome.IssueType.VALUE);
                break;
            }
            case INVARIANT: {
                tgt.setValue((Object)OperationOutcome.IssueType.INVARIANT);
                break;
            }
            case SECURITY: {
                tgt.setValue((Object)OperationOutcome.IssueType.SECURITY);
                break;
            }
            case LOGIN: {
                tgt.setValue((Object)OperationOutcome.IssueType.LOGIN);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)OperationOutcome.IssueType.UNKNOWN);
                break;
            }
            case EXPIRED: {
                tgt.setValue((Object)OperationOutcome.IssueType.EXPIRED);
                break;
            }
            case FORBIDDEN: {
                tgt.setValue((Object)OperationOutcome.IssueType.FORBIDDEN);
                break;
            }
            case SUPPRESSED: {
                tgt.setValue((Object)OperationOutcome.IssueType.SUPPRESSED);
                break;
            }
            case PROCESSING: {
                tgt.setValue((Object)OperationOutcome.IssueType.PROCESSING);
                break;
            }
            case NOTSUPPORTED: {
                tgt.setValue((Object)OperationOutcome.IssueType.NOTSUPPORTED);
                break;
            }
            case DUPLICATE: {
                tgt.setValue((Object)OperationOutcome.IssueType.DUPLICATE);
                break;
            }
            case NOTFOUND: {
                tgt.setValue((Object)OperationOutcome.IssueType.NOTFOUND);
                break;
            }
            case TOOLONG: {
                tgt.setValue((Object)OperationOutcome.IssueType.TOOLONG);
                break;
            }
            case CODEINVALID: {
                tgt.setValue((Object)OperationOutcome.IssueType.CODEINVALID);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)OperationOutcome.IssueType.EXTENSION);
                break;
            }
            case TOOCOSTLY: {
                tgt.setValue((Object)OperationOutcome.IssueType.TOOCOSTLY);
                break;
            }
            case BUSINESSRULE: {
                tgt.setValue((Object)OperationOutcome.IssueType.BUSINESSRULE);
                break;
            }
            case CONFLICT: {
                tgt.setValue((Object)OperationOutcome.IssueType.CONFLICT);
                break;
            }
            case INCOMPLETE: {
                tgt.setValue((Object)OperationOutcome.IssueType.INCOMPLETE);
                break;
            }
            case TRANSIENT: {
                tgt.setValue((Object)OperationOutcome.IssueType.TRANSIENT);
                break;
            }
            case LOCKERROR: {
                tgt.setValue((Object)OperationOutcome.IssueType.LOCKERROR);
                break;
            }
            case NOSTORE: {
                tgt.setValue((Object)OperationOutcome.IssueType.NOSTORE);
                break;
            }
            case EXCEPTION: {
                tgt.setValue((Object)OperationOutcome.IssueType.EXCEPTION);
                break;
            }
            case TIMEOUT: {
                tgt.setValue((Object)OperationOutcome.IssueType.TIMEOUT);
                break;
            }
            case THROTTLED: {
                tgt.setValue((Object)OperationOutcome.IssueType.THROTTLED);
                break;
            }
            case INFORMATIONAL: {
                tgt.setValue((Object)OperationOutcome.IssueType.INFORMATIONAL);
                break;
            }
            default: {
                tgt.setValue((Object)OperationOutcome.IssueType.NULL);
            }
        }
        return tgt;
    }

    public static OperationOutcome convertOperationOutcome(org.hl7.fhir.dstu3.model.OperationOutcome src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationOutcome tgt = new OperationOutcome();
        VersionConvertor_14_30.copyDomainResource(src, (DomainResource)tgt);
        for (OperationOutcome.OperationOutcomeIssueComponent t : src.getIssue()) {
            tgt.addIssue(OperationOutcome14_30.convertOperationOutcomeIssueComponent(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.OperationOutcome convertOperationOutcome(OperationOutcome src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.OperationOutcome tgt = new org.hl7.fhir.dstu3.model.OperationOutcome();
        VersionConvertor_14_30.copyDomainResource((DomainResource)src, tgt);
        for (OperationOutcome.OperationOutcomeIssueComponent t : src.getIssue()) {
            tgt.addIssue(OperationOutcome14_30.convertOperationOutcomeIssueComponent(t));
        }
        return tgt;
    }

    public static OperationOutcome.OperationOutcomeIssueComponent convertOperationOutcomeIssueComponent(OperationOutcome.OperationOutcomeIssueComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationOutcome.OperationOutcomeIssueComponent tgt = new OperationOutcome.OperationOutcomeIssueComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasSeverity()) {
            tgt.setSeverityElement(OperationOutcome14_30.convertIssueSeverity(src.getSeverityElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(OperationOutcome14_30.convertIssueType(src.getCodeElement()));
        }
        if (src.hasDetails()) {
            tgt.setDetails(VersionConvertor_14_30.convertCodeableConcept(src.getDetails()));
        }
        if (src.hasDiagnostics()) {
            tgt.setDiagnosticsElement(VersionConvertor_14_30.convertString(src.getDiagnosticsElement()));
        }
        for (org.hl7.fhir.dstu3.model.StringType t : src.getLocation()) {
            tgt.addLocation((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.StringType t : src.getExpression()) {
            tgt.addExpression((String)t.getValue());
        }
        return tgt;
    }

    public static OperationOutcome.OperationOutcomeIssueComponent convertOperationOutcomeIssueComponent(OperationOutcome.OperationOutcomeIssueComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationOutcome.OperationOutcomeIssueComponent tgt = new OperationOutcome.OperationOutcomeIssueComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasSeverity()) {
            tgt.setSeverityElement(OperationOutcome14_30.convertIssueSeverity((Enumeration<OperationOutcome.IssueSeverity>)src.getSeverityElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(OperationOutcome14_30.convertIssueType((Enumeration<OperationOutcome.IssueType>)src.getCodeElement()));
        }
        if (src.hasDetails()) {
            tgt.setDetails(VersionConvertor_14_30.convertCodeableConcept(src.getDetails()));
        }
        if (src.hasDiagnostics()) {
            tgt.setDiagnosticsElement(VersionConvertor_14_30.convertString(src.getDiagnosticsElement()));
        }
        for (StringType t : src.getLocation()) {
            tgt.addLocation((String)t.getValue());
        }
        for (StringType t : src.getExpression()) {
            tgt.addExpression((String)t.getValue());
        }
        return tgt;
    }
}

