/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_30;

import org.hl7.fhir.convertors.VersionConvertor_14_30;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.OperationDefinition;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.OperationDefinition;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

public class OperationDefinition14_30 {
    public static OperationDefinition convertOperationDefinition(org.hl7.fhir.dstu2016may.model.OperationDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition tgt = new OperationDefinition();
        VersionConvertor_14_30.copyDomainResource((DomainResource)src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_30.convertConformanceResourceStatus((org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(OperationDefinition14_30.convertOperationKind((org.hl7.fhir.dstu2016may.model.Enumeration<OperationDefinition.OperationKind>)src.getKindElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (OperationDefinition.OperationDefinitionContactComponent t : src.getContact()) {
            tgt.addContact(OperationDefinition14_30.convertOperationDefinitionContactComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (OperationDefinition.OperationDefinitionContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_30.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_30.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasIdempotent()) {
            tgt.setIdempotentElement(VersionConvertor_14_30.convertBoolean(src.getIdempotentElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_14_30.convertString(src.getCommentElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_14_30.convertReference(src.getBase()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertBoolean(src.getSystemElement()));
        }
        for (OperationDefinition.OperationDefinitionContactComponent t : src.getType()) {
            tgt.addResource((String)t.getValue());
        }
        tgt.setType(tgt.hasResource());
        if (src.hasInstanceElement()) {
            tgt.setInstanceElement(VersionConvertor_14_30.convertBoolean(src.getInstanceElement()));
        }
        for (OperationDefinition.OperationDefinitionContactComponent t : src.getParameter()) {
            tgt.addParameter(OperationDefinition14_30.convertOperationDefinitionParameterComponent((OperationDefinition.OperationDefinitionParameterComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.OperationDefinition convertOperationDefinition(OperationDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.OperationDefinition tgt = new org.hl7.fhir.dstu2016may.model.OperationDefinition();
        VersionConvertor_14_30.copyDomainResource(src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(OperationDefinition14_30.convertOperationKind(src.getKindElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(OperationDefinition14_30.convertOperationDefinitionContactComponent(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasIdempotent()) {
            tgt.setIdempotentElement(VersionConvertor_14_30.convertBoolean(src.getIdempotentElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_14_30.convertString(src.getCommentElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_14_30.convertReference(src.getBase()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertBoolean(src.getSystemElement()));
        }
        if (src.getType()) {
            for (CodeType codeType : src.getResource()) {
                tgt.addType((String)codeType.getValue());
            }
        }
        if (src.hasInstanceElement()) {
            tgt.setInstanceElement(VersionConvertor_14_30.convertBoolean(src.getInstanceElement()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent operationDefinitionParameterComponent : src.getParameter()) {
            tgt.addParameter(OperationDefinition14_30.convertOperationDefinitionParameterComponent(operationDefinitionParameterComponent));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionContactComponent convertOperationDefinitionContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionContactComponent tgt = new OperationDefinition.OperationDefinitionContactComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertOperationDefinitionContactComponent(OperationDefinition.OperationDefinitionContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_14_30.convertBindingStrength((org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.BindingStrength>)src.getStrengthElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSet(VersionConvertor_14_30.convertType(src.getValueSet()));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_14_30.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSet(VersionConvertor_14_30.convertType(src.getValueSet()));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(OperationDefinition14_30.convertOperationParameterUse(src.getUseElement()));
        }
        if (src.hasMinElement()) {
            tgt.setMinElement(VersionConvertor_14_30.convertInteger(src.getMinElement()));
        }
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_14_30.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_30.convertCode(src.getTypeElement()));
        }
        if (src.hasSearchType()) {
            tgt.setSearchTypeElement(VersionConvertor_14_30.convertSearchParamType(src.getSearchTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_14_30.convertReference(src.getProfile()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(OperationDefinition14_30.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent t : src.getPart()) {
            tgt.addPart(OperationDefinition14_30.convertOperationDefinitionParameterComponent(t));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(OperationDefinition14_30.convertOperationParameterUse((org.hl7.fhir.dstu2016may.model.Enumeration<OperationDefinition.OperationParameterUse>)src.getUseElement()));
        }
        if (src.hasMinElement()) {
            tgt.setMinElement(VersionConvertor_14_30.convertInteger(src.getMinElement()));
        }
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_14_30.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        if (Utilities.existsInList(src.getType(), "token", "reference", "composite", "number", "date", "quantity", "uri")) {
            tgt.setType("string");
            if (src.hasType()) {
                tgt.setSearchType(Enumerations.SearchParamType.fromCode(src.getType()));
            }
        } else if (src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_14_30.convertCode(src.getTypeElement()));
        }
        if (src.hasSearchType()) {
            tgt.setSearchTypeElement(VersionConvertor_14_30.convertSearchParamType((org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.SearchParamType>)src.getSearchTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_14_30.convertReference(src.getProfile()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(OperationDefinition14_30.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent t : src.getPart()) {
            tgt.addPart(OperationDefinition14_30.convertOperationDefinitionParameterComponent(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<OperationDefinition.OperationKind> convertOperationKind(Enumeration<OperationDefinition.OperationKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new OperationDefinition.OperationKindEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((OperationDefinition.OperationKind)((Object)src.getValue())) {
            case OPERATION: {
                tgt.setValue((Object)OperationDefinition.OperationKind.OPERATION);
                break;
            }
            case QUERY: {
                tgt.setValue((Object)OperationDefinition.OperationKind.QUERY);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<OperationDefinition.OperationKind> convertOperationKind(org.hl7.fhir.dstu2016may.model.Enumeration<OperationDefinition.OperationKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<OperationDefinition.OperationKind> tgt = new Enumeration<OperationDefinition.OperationKind>(new OperationDefinition.OperationKindEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((OperationDefinition.OperationKind)src.getValue()) {
            case OPERATION: {
                tgt.setValue((Object)OperationDefinition.OperationKind.OPERATION);
                break;
            }
            case QUERY: {
                tgt.setValue((Object)OperationDefinition.OperationKind.QUERY);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<OperationDefinition.OperationParameterUse> convertOperationParameterUse(org.hl7.fhir.dstu2016may.model.Enumeration<OperationDefinition.OperationParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<OperationDefinition.OperationParameterUse> tgt = new Enumeration<OperationDefinition.OperationParameterUse>(new OperationDefinition.OperationParameterUseEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((OperationDefinition.OperationParameterUse)src.getValue()) {
            case IN: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<OperationDefinition.OperationParameterUse> convertOperationParameterUse(Enumeration<OperationDefinition.OperationParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new OperationDefinition.OperationParameterUseEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((OperationDefinition.OperationParameterUse)((Object)src.getValue())) {
            case IN: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.NULL);
            }
        }
        return tgt;
    }
}

