/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_30;

import org.hl7.fhir.convertors.VersionConvertor_14_30;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.ImplementationGuide;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.ImplementationGuide;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;

public class ImplementationGuide14_30 {
    public static Enumeration<ImplementationGuide.GuideDependencyType> convertGuideDependencyType(org.hl7.fhir.dstu2016may.model.Enumeration<ImplementationGuide.GuideDependencyType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ImplementationGuide.GuideDependencyType> tgt = new Enumeration<ImplementationGuide.GuideDependencyType>(new ImplementationGuide.GuideDependencyTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ImplementationGuide.GuideDependencyType)src.getValue()) {
            case REFERENCE: {
                tgt.setValue((Object)ImplementationGuide.GuideDependencyType.REFERENCE);
                break;
            }
            case INCLUSION: {
                tgt.setValue((Object)ImplementationGuide.GuideDependencyType.INCLUSION);
                break;
            }
            default: {
                tgt.setValue((Object)ImplementationGuide.GuideDependencyType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ImplementationGuide.GuideDependencyType> convertGuideDependencyType(Enumeration<ImplementationGuide.GuideDependencyType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new ImplementationGuide.GuideDependencyTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((ImplementationGuide.GuideDependencyType)((Object)src.getValue())) {
            case REFERENCE: {
                tgt.setValue((Object)ImplementationGuide.GuideDependencyType.REFERENCE);
                break;
            }
            case INCLUSION: {
                tgt.setValue((Object)ImplementationGuide.GuideDependencyType.INCLUSION);
                break;
            }
            default: {
                tgt.setValue((Object)ImplementationGuide.GuideDependencyType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ImplementationGuide.GuidePageKind> convertGuidePageKind(org.hl7.fhir.dstu2016may.model.Enumeration<ImplementationGuide.GuidePageKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ImplementationGuide.GuidePageKind> tgt = new Enumeration<ImplementationGuide.GuidePageKind>(new ImplementationGuide.GuidePageKindEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((ImplementationGuide.GuidePageKind)src.getValue()) {
            case PAGE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.PAGE);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.EXAMPLE);
                break;
            }
            case LIST: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.LIST);
                break;
            }
            case INCLUDE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.INCLUDE);
                break;
            }
            case DIRECTORY: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.DIRECTORY);
                break;
            }
            case DICTIONARY: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.DICTIONARY);
                break;
            }
            case TOC: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.TOC);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.RESOURCE);
                break;
            }
            default: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<ImplementationGuide.GuidePageKind> convertGuidePageKind(Enumeration<ImplementationGuide.GuidePageKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new ImplementationGuide.GuidePageKindEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((ImplementationGuide.GuidePageKind)((Object)src.getValue())) {
            case PAGE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.PAGE);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.EXAMPLE);
                break;
            }
            case LIST: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.LIST);
                break;
            }
            case INCLUDE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.INCLUDE);
                break;
            }
            case DIRECTORY: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.DIRECTORY);
                break;
            }
            case DICTIONARY: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.DICTIONARY);
                break;
            }
            case TOC: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.TOC);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.RESOURCE);
                break;
            }
            default: {
                tgt.setValue((Object)ImplementationGuide.GuidePageKind.NULL);
            }
        }
        return tgt;
    }

    public static ImplementationGuide convertImplementationGuide(org.hl7.fhir.dstu3.model.ImplementationGuide src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide tgt = new ImplementationGuide();
        VersionConvertor_14_30.copyDomainResource(src, (DomainResource)tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ImplementationGuide14_30.convertImplementationGuideContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersionElement(VersionConvertor_14_30.convertId(src.getFhirVersionElement()));
        }
        for (ImplementationGuide.ImplementationGuideDependencyComponent implementationGuideDependencyComponent : src.getDependency()) {
            tgt.addDependency(ImplementationGuide14_30.convertImplementationGuideDependencyComponent(implementationGuideDependencyComponent));
        }
        for (ImplementationGuide.ImplementationGuidePackageComponent implementationGuidePackageComponent : src.getPackage()) {
            tgt.addPackage(ImplementationGuide14_30.convertImplementationGuidePackageComponent(implementationGuidePackageComponent));
        }
        for (ImplementationGuide.ImplementationGuideGlobalComponent implementationGuideGlobalComponent : src.getGlobal()) {
            tgt.addGlobal(ImplementationGuide14_30.convertImplementationGuideGlobalComponent(implementationGuideGlobalComponent));
        }
        for (UriType uriType : src.getBinary()) {
            tgt.addBinary((String)uriType.getValue());
        }
        if (src.hasPage()) {
            tgt.setPage(ImplementationGuide14_30.convertImplementationGuidePageComponent(src.getPage()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ImplementationGuide convertImplementationGuide(ImplementationGuide src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ImplementationGuide tgt = new org.hl7.fhir.dstu3.model.ImplementationGuide();
        VersionConvertor_14_30.copyDomainResource((DomainResource)src, tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_30.convertConformanceResourceStatus((org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getContact()) {
            tgt.addContact(ImplementationGuide14_30.convertImplementationGuideContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_30.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_30.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersionElement(VersionConvertor_14_30.convertId(src.getFhirVersionElement()));
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getDependency()) {
            tgt.addDependency(ImplementationGuide14_30.convertImplementationGuideDependencyComponent((ImplementationGuide.ImplementationGuideDependencyComponent)t));
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getPackage()) {
            tgt.addPackage(ImplementationGuide14_30.convertImplementationGuidePackageComponent((ImplementationGuide.ImplementationGuidePackageComponent)t));
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getGlobal()) {
            tgt.addGlobal(ImplementationGuide14_30.convertImplementationGuideGlobalComponent((ImplementationGuide.ImplementationGuideGlobalComponent)t));
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getBinary()) {
            tgt.addBinary((String)t.getValue());
        }
        if (src.hasPage()) {
            tgt.setPage(ImplementationGuide14_30.convertImplementationGuidePageComponent(src.getPage()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideContactComponent convertImplementationGuideContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideContactComponent tgt = new ImplementationGuide.ImplementationGuideContactComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertImplementationGuideContactComponent(ImplementationGuide.ImplementationGuideContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDependencyComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependencyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependencyComponent tgt = new ImplementationGuide.ImplementationGuideDependencyComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(ImplementationGuide14_30.convertGuideDependencyType(src.getTypeElement()));
        }
        if (src.hasUriElement()) {
            tgt.setUriElement(VersionConvertor_14_30.convertUri(src.getUriElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDependencyComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependencyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependencyComponent tgt = new ImplementationGuide.ImplementationGuideDependencyComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(ImplementationGuide14_30.convertGuideDependencyType((org.hl7.fhir.dstu2016may.model.Enumeration<ImplementationGuide.GuideDependencyType>)src.getTypeElement()));
        }
        if (src.hasUriElement()) {
            tgt.setUriElement(VersionConvertor_14_30.convertUri(src.getUriElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_14_30.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_14_30.convertReference(src.getProfile()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_14_30.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_14_30.convertReference(src.getProfile()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuidePackageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageComponent tgt = new ImplementationGuide.ImplementationGuidePackageComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        for (ImplementationGuide.ImplementationGuidePackageResourceComponent t : src.getResource()) {
            tgt.addResource(ImplementationGuide14_30.convertImplementationGuidePackageResourceComponent(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuidePackageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageComponent tgt = new ImplementationGuide.ImplementationGuidePackageComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        for (ImplementationGuide.ImplementationGuidePackageResourceComponent t : src.getResource()) {
            tgt.addResource(ImplementationGuide14_30.convertImplementationGuidePackageResourceComponent(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuidePackageResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageResourceComponent tgt = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasExampleElement()) {
            tgt.setExampleElement(VersionConvertor_14_30.convertBoolean(src.getExampleElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasAcronym()) {
            tgt.setAcronymElement(VersionConvertor_14_30.convertString(src.getAcronymElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_14_30.convertType(src.getSource()));
        }
        if (src.hasExampleFor()) {
            tgt.setExampleFor(VersionConvertor_14_30.convertReference(src.getExampleFor()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuidePackageResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageResourceComponent tgt = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasExampleElement()) {
            tgt.setExampleElement(VersionConvertor_14_30.convertBoolean(src.getExampleElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasAcronym()) {
            tgt.setAcronymElement(VersionConvertor_14_30.convertString(src.getAcronymElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_14_30.convertType(src.getSource()));
        }
        if (src.hasExampleFor()) {
            tgt.setExampleFor(VersionConvertor_14_30.convertReference(src.getExampleFor()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuidePageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePageComponent tgt = new ImplementationGuide.ImplementationGuidePageComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasSourceElement()) {
            tgt.setSourceElement(VersionConvertor_14_30.convertUri(src.getSourceElement()));
        }
        if (src.hasNameElement()) {
            tgt.setTitleElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(ImplementationGuide14_30.convertGuidePageKind((org.hl7.fhir.dstu2016may.model.Enumeration<ImplementationGuide.GuidePageKind>)src.getKindElement()));
        }
        for (CodeType t : src.getType()) {
            tgt.addType((String)t.getValue());
        }
        for (CodeType t : src.getPackage()) {
            tgt.addPackage((String)t.getValue());
        }
        if (src.hasFormat()) {
            tgt.setFormatElement(VersionConvertor_14_30.convertCode(src.getFormatElement()));
        }
        for (CodeType t : src.getPage()) {
            tgt.addPage(ImplementationGuide14_30.convertImplementationGuidePageComponent((ImplementationGuide.ImplementationGuidePageComponent)t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuidePageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePageComponent tgt = new ImplementationGuide.ImplementationGuidePageComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasSourceElement()) {
            tgt.setSourceElement(VersionConvertor_14_30.convertUri(src.getSourceElement()));
        }
        if (src.hasTitleElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getTitleElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(ImplementationGuide14_30.convertGuidePageKind(src.getKindElement()));
        }
        for (org.hl7.fhir.dstu3.model.CodeType codeType : src.getType()) {
            tgt.addType((String)codeType.getValue());
        }
        for (StringType stringType : src.getPackage()) {
            tgt.addPackage((String)stringType.getValue());
        }
        if (src.hasFormat()) {
            tgt.setFormatElement(VersionConvertor_14_30.convertCode(src.getFormatElement()));
        }
        for (ImplementationGuide.ImplementationGuidePageComponent implementationGuidePageComponent : src.getPage()) {
            tgt.addPage(ImplementationGuide14_30.convertImplementationGuidePageComponent(implementationGuidePageComponent));
        }
        return tgt;
    }
}

