/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Organization;

public class Organization10_50 {
    public static org.hl7.fhir.r5.model.Organization convertOrganization(Organization src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Organization tgt = new org.hl7.fhir.r5.model.Organization();
        VersionConvertor_10_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(t));
        }
        if (src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_10_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasType()) {
            tgt.addType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint((ContactPoint)t));
        }
        for (Identifier t : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_50.convertAddress((org.hl7.fhir.dstu2.model.Address)t));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_10_50.convertReference(src.getPartOf()));
        }
        for (Identifier t : src.getContact()) {
            tgt.addContact(Organization10_50.convertOrganizationContactComponent((Organization.OrganizationContactComponent)t));
        }
        return tgt;
    }

    public static Organization convertOrganization(org.hl7.fhir.r5.model.Organization src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Organization tgt = new Organization();
        VersionConvertor_10_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_10_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getTypeFirstRep()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(contactPoint));
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_50.convertAddress(address));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_10_50.convertReference(src.getPartOf()));
        }
        for (Organization.OrganizationContactComponent organizationContactComponent : src.getContact()) {
            tgt.addContact(Organization10_50.convertOrganizationContactComponent(organizationContactComponent));
        }
        return tgt;
    }

    public static Organization.OrganizationContactComponent convertOrganizationContactComponent(Organization.OrganizationContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Organization.OrganizationContactComponent tgt = new Organization.OrganizationContactComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasPurpose()) {
            tgt.setPurpose(VersionConvertor_10_50.convertCodeableConcept(src.getPurpose()));
        }
        if (src.hasName()) {
            tgt.setName(VersionConvertor_10_50.convertHumanName(src.getName()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_10_50.convertAddress(src.getAddress()));
        }
        return tgt;
    }

    public static Organization.OrganizationContactComponent convertOrganizationContactComponent(Organization.OrganizationContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Organization.OrganizationContactComponent tgt = new Organization.OrganizationContactComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasPurpose()) {
            tgt.setPurpose(VersionConvertor_10_50.convertCodeableConcept(src.getPurpose()));
        }
        if (src.hasName()) {
            tgt.setName(VersionConvertor_10_50.convertHumanName(src.getName()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_10_50.convertAddress(src.getAddress()));
        }
        return tgt;
    }
}

