/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.NamingSystem;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.UsageContext;

public class NamingSystem10_50 {
    public static NamingSystem convertNamingSystem(org.hl7.fhir.r5.model.NamingSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem tgt = new NamingSystem();
        VersionConvertor_10_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_50.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(NamingSystem10_50.convertNamingSystemType(src.getKindElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(NamingSystem10_50.convertNamingSystemContactComponent(contactDetail));
        }
        if (src.hasResponsibleElement()) {
            tgt.setResponsibleElement(VersionConvertor_10_50.convertString(src.getResponsibleElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_10_50.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasUsageElement()) {
            tgt.setUsageElement(VersionConvertor_10_50.convertString(src.getUsageElement()));
        }
        for (NamingSystem.NamingSystemUniqueIdComponent namingSystemUniqueIdComponent : src.getUniqueId()) {
            tgt.addUniqueId(NamingSystem10_50.convertNamingSystemUniqueIdComponent(namingSystemUniqueIdComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.NamingSystem convertNamingSystem(NamingSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.NamingSystem tgt = new org.hl7.fhir.r5.model.NamingSystem();
        VersionConvertor_10_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)VersionConvertor_10_50.convertConformanceResourceStatus((Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(NamingSystem10_50.convertNamingSystemType((Enumeration<NamingSystem.NamingSystemType>)src.getKindElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_50.convertString(src.getPublisherElement()));
        }
        for (NamingSystem.NamingSystemContactComponent t : src.getContact()) {
            tgt.addContact(NamingSystem10_50.convertNamingSystemContactComponent(t));
        }
        if (src.hasResponsibleElement()) {
            tgt.setResponsibleElement(VersionConvertor_10_50.convertString(src.getResponsibleElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (NamingSystem.NamingSystemContactComponent t : src.getUseContext()) {
            if (VersionConvertor_10_50.isJurisdiction((org.hl7.fhir.dstu2.model.CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_10_50.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_10_50.convertCodeableConceptToUsageContext((org.hl7.fhir.dstu2.model.CodeableConcept)t));
        }
        if (src.hasUsageElement()) {
            tgt.setUsageElement(VersionConvertor_10_50.convertString(src.getUsageElement()));
        }
        for (NamingSystem.NamingSystemContactComponent t : src.getUniqueId()) {
            tgt.addUniqueId(NamingSystem10_50.convertNamingSystemUniqueIdComponent((NamingSystem.NamingSystemUniqueIdComponent)t));
        }
        return tgt;
    }

    public static ContactDetail convertNamingSystemContactComponent(NamingSystem.NamingSystemContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemContactComponent convertNamingSystemContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem.NamingSystemContactComponent tgt = new NamingSystem.NamingSystemContactComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemIdentifierType> convertNamingSystemIdentifierType(Enumeration<NamingSystem.NamingSystemIdentifierType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemIdentifierType> tgt = new org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemIdentifierType>(new NamingSystem.NamingSystemIdentifierTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((NamingSystem.NamingSystemIdentifierType)src.getValue()) {
            case OID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OID);
                break;
            }
            case UUID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.UUID);
                break;
            }
            case URI: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.URI);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<NamingSystem.NamingSystemIdentifierType> convertNamingSystemIdentifierType(org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemIdentifierType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new NamingSystem.NamingSystemIdentifierTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((NamingSystem.NamingSystemIdentifierType)((Object)src.getValue())) {
            case OID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OID);
                break;
            }
            case UUID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.UUID);
                break;
            }
            case URI: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.URI);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<NamingSystem.NamingSystemType> convertNamingSystemType(org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new NamingSystem.NamingSystemTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((NamingSystem.NamingSystemType)((Object)src.getValue())) {
            case CODESYSTEM: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.CODESYSTEM);
                break;
            }
            case IDENTIFIER: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.IDENTIFIER);
                break;
            }
            case ROOT: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.ROOT);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemType> convertNamingSystemType(Enumeration<NamingSystem.NamingSystemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemType> tgt = new org.hl7.fhir.r5.model.Enumeration<NamingSystem.NamingSystemType>(new NamingSystem.NamingSystemTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((NamingSystem.NamingSystemType)src.getValue()) {
            case CODESYSTEM: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.CODESYSTEM);
                break;
            }
            case IDENTIFIER: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.IDENTIFIER);
                break;
            }
            case ROOT: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.ROOT);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.NULL);
            }
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(NamingSystem10_50.convertNamingSystemIdentifierType((Enumeration<NamingSystem.NamingSystemIdentifierType>)src.getTypeElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertString(src.getValueElement()));
        }
        if (src.hasPreferredElement()) {
            tgt.setPreferredElement(VersionConvertor_10_50.convertBoolean(src.getPreferredElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(NamingSystem10_50.convertNamingSystemIdentifierType(src.getTypeElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertString(src.getValueElement()));
        }
        if (src.hasPreferredElement()) {
            tgt.setPreferredElement(VersionConvertor_10_50.convertBoolean(src.getPreferredElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }
}

