/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.Address;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.HumanName;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Person;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Person;

public class Person10_40 {
    public static Enumeration<Person.IdentityAssuranceLevel> convertIdentityAssuranceLevel(org.hl7.fhir.dstu2.model.Enumeration<Person.IdentityAssuranceLevel> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Person.IdentityAssuranceLevel> tgt = new Enumeration<Person.IdentityAssuranceLevel>(new Person.IdentityAssuranceLevelEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((Person.IdentityAssuranceLevel)src.getValue()) {
            case LEVEL1: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL1);
                break;
            }
            case LEVEL2: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL2);
                break;
            }
            case LEVEL3: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL3);
                break;
            }
            case LEVEL4: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL4);
                break;
            }
            default: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Person.IdentityAssuranceLevel> convertIdentityAssuranceLevel(Enumeration<Person.IdentityAssuranceLevel> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Person.IdentityAssuranceLevelEnumFactory());
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        switch ((Person.IdentityAssuranceLevel)((Object)src.getValue())) {
            case LEVEL1: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL1);
                break;
            }
            case LEVEL2: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL2);
                break;
            }
            case LEVEL3: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL3);
                break;
            }
            case LEVEL4: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL4);
                break;
            }
            default: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Person convertPerson(Person src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Person tgt = new org.hl7.fhir.r4.model.Person();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(t));
        }
        for (Identifier t : src.getName()) {
            tgt.addName(VersionConvertor_10_40.convertHumanName((HumanName)t));
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint((org.hl7.fhir.dstu2.model.ContactPoint)t));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_10_40.convertAdministrativeGender((org.hl7.fhir.dstu2.model.Enumeration<Enumerations.AdministrativeGender>)src.getGenderElement()));
        }
        if (src.hasBirthDateElement()) {
            tgt.setBirthDateElement(VersionConvertor_10_40.convertDate(src.getBirthDateElement()));
        }
        for (Identifier t : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_40.convertAddress((Address)t));
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_10_40.convertAttachment(src.getPhoto()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_10_40.convertReference(src.getManagingOrganization()));
        }
        if (src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_10_40.convertBoolean(src.getActiveElement()));
        }
        for (Identifier t : src.getLink()) {
            tgt.addLink(Person10_40.convertPersonLinkComponent((Person.PersonLinkComponent)t));
        }
        return tgt;
    }

    public static Person convertPerson(org.hl7.fhir.r4.model.Person src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Person tgt = new Person();
        VersionConvertor_10_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r4.model.HumanName humanName : src.getName()) {
            tgt.addName(VersionConvertor_10_40.convertHumanName(humanName));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_10_40.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDateElement()) {
            tgt.setBirthDateElement(VersionConvertor_10_40.convertDate(src.getBirthDateElement()));
        }
        for (org.hl7.fhir.r4.model.Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_40.convertAddress(address));
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_10_40.convertAttachment(src.getPhoto()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_10_40.convertReference(src.getManagingOrganization()));
        }
        if (src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_10_40.convertBoolean(src.getActiveElement()));
        }
        for (Person.PersonLinkComponent personLinkComponent : src.getLink()) {
            tgt.addLink(Person10_40.convertPersonLinkComponent(personLinkComponent));
        }
        return tgt;
    }

    public static Person.PersonLinkComponent convertPersonLinkComponent(Person.PersonLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Person.PersonLinkComponent tgt = new Person.PersonLinkComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_40.convertReference(src.getTarget()));
        }
        if (src.hasAssurance()) {
            tgt.setAssuranceElement(Person10_40.convertIdentityAssuranceLevel(src.getAssuranceElement()));
        }
        return tgt;
    }

    public static Person.PersonLinkComponent convertPersonLinkComponent(Person.PersonLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Person.PersonLinkComponent tgt = new Person.PersonLinkComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_40.convertReference(src.getTarget()));
        }
        if (src.hasAssurance()) {
            tgt.setAssuranceElement(Person10_40.convertIdentityAssuranceLevel((org.hl7.fhir.dstu2.model.Enumeration<Person.IdentityAssuranceLevel>)src.getAssuranceElement()));
        }
        return tgt;
    }
}

