/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Medication;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Medication;

public class Medication10_40 {
    public static org.hl7.fhir.r4.model.Medication convertMedication(Medication src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Medication tgt = new org.hl7.fhir.r4.model.Medication();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasIsBrandElement()) {
            tgt.addExtension("http://hl7.org/fhir/3.0/StructureDefinition/extension-Medication.isBrand", VersionConvertor_10_40.convertBoolean(src.getIsBrandElement()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(VersionConvertor_10_40.convertReference(src.getManufacturer()));
        }
        if (src.hasProduct()) {
            if (src.getProduct().hasForm()) {
                tgt.setForm(VersionConvertor_10_40.convertCodeableConcept(src.getProduct().getForm()));
            }
            for (Medication.MedicationProductIngredientComponent ingridient : src.getProduct().getIngredient()) {
                tgt.addIngredient(Medication10_40.convertMedicationIngridient(ingridient));
            }
            if (src.getProduct().hasBatch()) {
                tgt.setBatch(Medication10_40.batch((Medication.MedicationProductBatchComponent)src.getProduct().getBatch().get(0)));
            }
        }
        if (src.hasPackage()) {
            Medication.MedicationPackageComponent package_ = src.getPackage();
            if (package_.hasContainer()) {
                tgt.addExtension("http://hl7.org/fhir/3.0/StructureDefinition/extension-Medication.package.container", VersionConvertor_10_40.convertCodeableConcept(package_.getContainer()));
            }
            for (Medication.MedicationPackageContentComponent c : package_.getContent()) {
                tgt.addExtension("http://hl7.org/fhir/3.0/StructureDefinition/extension-Medication.package.content", Medication10_40.content(c));
            }
        }
        return tgt;
    }

    private static Medication.MedicationBatchComponent batch(Medication.MedicationProductBatchComponent src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Medication.MedicationBatchComponent tgt = new Medication.MedicationBatchComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasLotNumber()) {
            tgt.setLotNumber(src.getLotNumber());
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDate(src.getExpirationDate());
        }
        return tgt;
    }

    private static Extension content(Medication.MedicationPackageContentComponent src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Extension tgt = new Extension();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasItem()) {
            tgt.addExtension("http://hl7.org/fhir/3.0/StructureDefinition/extension-Medication.package.content", VersionConvertor_10_40.convertReference(src.getItem()));
        }
        if (src.hasAmount()) {
            tgt.addExtension("http://hl7.org/fhir/3.0/StructureDefinition/extension-Medication.package.content.amount", VersionConvertor_10_40.convertSimpleQuantity(src.getAmount()));
        }
        return tgt;
    }

    private static Medication.MedicationIngredientComponent convertMedicationIngridient(Medication.MedicationProductIngredientComponent src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Medication.MedicationIngredientComponent tgt = new Medication.MedicationIngredientComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_10_40.convertReference(src.getItem()));
        }
        if (src.hasAmount()) {
            tgt.setStrength(VersionConvertor_10_40.convertRatio(src.getAmount()));
        }
        return tgt;
    }
}

