/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Flag;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Flag;

public class Flag10_40 {
    public static org.hl7.fhir.r4.model.Flag convertFlag(Flag src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Flag tgt = new org.hl7.fhir.r4.model.Flag();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(t));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_10_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Flag10_40.convertFlagStatus((org.hl7.fhir.dstu2.model.Enumeration<Flag.FlagStatus>)src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_40.convertReference(src.getEncounter()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_10_40.convertReference(src.getAuthor()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_40.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static Flag convertFlag(org.hl7.fhir.r4.model.Flag src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Flag tgt = new Flag();
        VersionConvertor_10_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(t));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_10_40.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Flag10_40.convertFlagStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_40.convertReference(src.getEncounter()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_10_40.convertReference(src.getAuthor()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_40.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Flag.FlagStatus> convertFlagStatus(Enumeration<Flag.FlagStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Flag.FlagStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        switch ((Flag.FlagStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Flag.FlagStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Flag.FlagStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Flag.FlagStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Flag.FlagStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Flag.FlagStatus> convertFlagStatus(org.hl7.fhir.dstu2.model.Enumeration<Flag.FlagStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Flag.FlagStatus> tgt = new Enumeration<Flag.FlagStatus>(new Flag.FlagStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((Flag.FlagStatus)src.getValue()) {
            case ACTIVE: {
                tgt.setValue((Object)Flag.FlagStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Flag.FlagStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Flag.FlagStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Flag.FlagStatus.NULL);
            }
        }
        return tgt;
    }
}

