/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.DocumentReference;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Reference;

public class DocumentReference10_40 {
    public static CodeableConcept convertDocStatus(DocumentReference.ReferredDocumentStatus docStatus) {
        CodeableConcept cc = new CodeableConcept();
        switch (docStatus) {
            case AMENDED: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("amended");
                break;
            }
            case ENTEREDINERROR: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("entered-in-error");
                break;
            }
            case FINAL: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("final");
                break;
            }
            case PRELIMINARY: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("preliminary");
                break;
            }
            default: {
                return null;
            }
        }
        return cc;
    }

    public static DocumentReference.ReferredDocumentStatus convertDocStatus(CodeableConcept cc) {
        if (VersionConvertor_10_40.hasConcept(cc, "http://hl7.org/fhir/composition-status", "preliminary")) {
            return DocumentReference.ReferredDocumentStatus.PRELIMINARY;
        }
        if (VersionConvertor_10_40.hasConcept(cc, "http://hl7.org/fhir/composition-status", "final")) {
            return DocumentReference.ReferredDocumentStatus.FINAL;
        }
        if (VersionConvertor_10_40.hasConcept(cc, "http://hl7.org/fhir/composition-status", "amended")) {
            return DocumentReference.ReferredDocumentStatus.AMENDED;
        }
        if (VersionConvertor_10_40.hasConcept(cc, "http://hl7.org/fhir/composition-status", "entered-in-error")) {
            return DocumentReference.ReferredDocumentStatus.ENTEREDINERROR;
        }
        return null;
    }

    public static org.hl7.fhir.dstu2.model.DocumentReference convertDocumentReference(DocumentReference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.DocumentReference tgt = new org.hl7.fhir.dstu2.model.DocumentReference();
        VersionConvertor_10_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasMasterIdentifier()) {
            tgt.setMasterIdentifier(VersionConvertor_10_40.convertIdentifier(src.getMasterIdentifier()));
        }
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_40.convertReference(src.getSubject()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasCategory()) {
            tgt.setClass_(VersionConvertor_10_40.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_10_40.convertReference(src.getCustodian()));
        }
        if (src.hasAuthenticator()) {
            tgt.setAuthenticator(VersionConvertor_10_40.convertReference(src.getAuthenticator()));
        }
        if (src.hasDate()) {
            tgt.setCreated(src.getDate());
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DocumentReference10_40.convertDocumentReferenceStatus(src.getStatusElement()));
        }
        if (src.hasDocStatus()) {
            tgt.setDocStatus(DocumentReference10_40.convertDocStatus(src.getDocStatus()));
        }
        for (DocumentReference.DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent : src.getRelatesTo()) {
            tgt.addRelatesTo(DocumentReference10_40.convertDocumentReferenceRelatesToComponent(documentReferenceRelatesToComponent));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_40.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        for (DocumentReference.DocumentReferenceContentComponent documentReferenceContentComponent : src.getContent()) {
            tgt.addContent(DocumentReference10_40.convertDocumentReferenceContentComponent(documentReferenceContentComponent));
        }
        if (src.hasContext()) {
            tgt.setContext(DocumentReference10_40.convertDocumentReferenceContextComponent(src.getContext()));
        }
        return tgt;
    }

    public static DocumentReference convertDocumentReference(org.hl7.fhir.dstu2.model.DocumentReference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference tgt = new DocumentReference();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasMasterIdentifier()) {
            tgt.setMasterIdentifier(VersionConvertor_10_40.convertIdentifier(src.getMasterIdentifier()));
        }
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(t));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_40.convertReference(src.getSubject()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasClass_()) {
            tgt.addCategory(VersionConvertor_10_40.convertCodeableConcept(src.getClass_()));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_10_40.convertReference(src.getCustodian()));
        }
        if (src.hasAuthenticator()) {
            tgt.setAuthenticator(VersionConvertor_10_40.convertReference(src.getAuthenticator()));
        }
        if (src.hasCreated()) {
            tgt.setDate(src.getCreated());
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DocumentReference10_40.convertDocumentReferenceStatus((org.hl7.fhir.dstu2.model.Enumeration<Enumerations.DocumentReferenceStatus>)src.getStatusElement()));
        }
        if (src.hasDocStatus()) {
            tgt.setDocStatus(DocumentReference10_40.convertDocStatus(src.getDocStatus()));
        }
        for (Identifier t : src.getRelatesTo()) {
            tgt.addRelatesTo(DocumentReference10_40.convertDocumentReferenceRelatesToComponent((DocumentReference.DocumentReferenceRelatesToComponent)t));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_40.convertString(src.getDescriptionElement()));
        }
        for (Identifier t : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_10_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (Identifier t : src.getContent()) {
            tgt.addContent(DocumentReference10_40.convertDocumentReferenceContentComponent((DocumentReference.DocumentReferenceContentComponent)t));
        }
        if (src.hasContext()) {
            tgt.setContext(DocumentReference10_40.convertDocumentReferenceContextComponent(src.getContext()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContentComponent convertDocumentReferenceContentComponent(DocumentReference.DocumentReferenceContentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContentComponent tgt = new DocumentReference.DocumentReferenceContentComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasAttachment()) {
            tgt.setAttachment(VersionConvertor_10_40.convertAttachment(src.getAttachment()));
        }
        for (Coding t : src.getFormat()) {
            tgt.setFormat(VersionConvertor_10_40.convertCoding(t));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContentComponent convertDocumentReferenceContentComponent(DocumentReference.DocumentReferenceContentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContentComponent tgt = new DocumentReference.DocumentReferenceContentComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasAttachment()) {
            tgt.setAttachment(VersionConvertor_10_40.convertAttachment(src.getAttachment()));
        }
        if (src.hasFormat()) {
            tgt.addFormat(VersionConvertor_10_40.convertCoding(src.getFormat()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextComponent convertDocumentReferenceContextComponent(DocumentReference.DocumentReferenceContextComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContextComponent tgt = new DocumentReference.DocumentReferenceContextComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasEncounter()) {
            tgt.addEncounter(VersionConvertor_10_40.convertReference(src.getEncounter()));
        }
        for (CodeableConcept t : src.getEvent()) {
            tgt.addEvent(VersionConvertor_10_40.convertCodeableConcept(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasFacilityType()) {
            tgt.setFacilityType(VersionConvertor_10_40.convertCodeableConcept(src.getFacilityType()));
        }
        if (src.hasPracticeSetting()) {
            tgt.setPracticeSetting(VersionConvertor_10_40.convertCodeableConcept(src.getPracticeSetting()));
        }
        if (src.hasSourcePatientInfo()) {
            tgt.setSourcePatientInfo(VersionConvertor_10_40.convertReference(src.getSourcePatientInfo()));
        }
        for (CodeableConcept t : src.getRelated()) {
            tgt.addRelated(DocumentReference10_40.convertDocumentReferenceContextRelatedComponent((DocumentReference.DocumentReferenceContextRelatedComponent)t));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextComponent convertDocumentReferenceContextComponent(DocumentReference.DocumentReferenceContextComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContextComponent tgt = new DocumentReference.DocumentReferenceContextComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_40.convertReference(src.getEncounterFirstRep()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getEvent()) {
            tgt.addEvent(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasFacilityType()) {
            tgt.setFacilityType(VersionConvertor_10_40.convertCodeableConcept(src.getFacilityType()));
        }
        if (src.hasPracticeSetting()) {
            tgt.setPracticeSetting(VersionConvertor_10_40.convertCodeableConcept(src.getPracticeSetting()));
        }
        if (src.hasSourcePatientInfo()) {
            tgt.setSourcePatientInfo(VersionConvertor_10_40.convertReference(src.getSourcePatientInfo()));
        }
        for (Reference reference : src.getRelated()) {
            tgt.addRelated(DocumentReference10_40.convertDocumentReferenceContextRelatedComponent(reference));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextRelatedComponent convertDocumentReferenceContextRelatedComponent(Reference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContextRelatedComponent tgt = new DocumentReference.DocumentReferenceContextRelatedComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_40.convertIdentifier(src.getIdentifier()));
        }
        tgt.setRef(VersionConvertor_10_40.convertReference(src));
        return tgt;
    }

    public static Reference convertDocumentReferenceContextRelatedComponent(DocumentReference.DocumentReferenceContextRelatedComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Reference tgt = VersionConvertor_10_40.convertReference(src.getRef());
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_40.convertIdentifier(src.getIdentifier()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceRelatesToComponent convertDocumentReferenceRelatesToComponent(DocumentReference.DocumentReferenceRelatesToComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceRelatesToComponent tgt = new DocumentReference.DocumentReferenceRelatesToComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasCode()) {
            tgt.setCodeElement(DocumentReference10_40.convertDocumentRelationshipType((org.hl7.fhir.dstu2.model.Enumeration<DocumentReference.DocumentRelationshipType>)src.getCodeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_40.convertReference(src.getTarget()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceRelatesToComponent convertDocumentReferenceRelatesToComponent(DocumentReference.DocumentReferenceRelatesToComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceRelatesToComponent tgt = new DocumentReference.DocumentReferenceRelatesToComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCodeElement(DocumentReference10_40.convertDocumentRelationshipType(src.getCodeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_40.convertReference(src.getTarget()));
        }
        return tgt;
    }

    public static Enumeration<Enumerations.DocumentReferenceStatus> convertDocumentReferenceStatus(org.hl7.fhir.dstu2.model.Enumeration<Enumerations.DocumentReferenceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.DocumentReferenceStatus> tgt = new Enumeration<Enumerations.DocumentReferenceStatus>(new Enumerations.DocumentReferenceStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((Enumerations.DocumentReferenceStatus)src.getValue()) {
            case CURRENT: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.CURRENT);
                break;
            }
            case SUPERSEDED: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.SUPERSEDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Enumerations.DocumentReferenceStatus> convertDocumentReferenceStatus(Enumeration<Enumerations.DocumentReferenceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Enumerations.DocumentReferenceStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        switch ((Enumerations.DocumentReferenceStatus)((Object)src.getValue())) {
            case CURRENT: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.CURRENT);
                break;
            }
            case SUPERSEDED: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.SUPERSEDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<DocumentReference.DocumentRelationshipType> convertDocumentRelationshipType(Enumeration<DocumentReference.DocumentRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new DocumentReference.DocumentRelationshipTypeEnumFactory());
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        switch ((DocumentReference.DocumentRelationshipType)((Object)src.getValue())) {
            case REPLACES: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.REPLACES);
                break;
            }
            case TRANSFORMS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.TRANSFORMS);
                break;
            }
            case SIGNS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.SIGNS);
                break;
            }
            case APPENDS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.APPENDS);
                break;
            }
            default: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DocumentReference.DocumentRelationshipType> convertDocumentRelationshipType(org.hl7.fhir.dstu2.model.Enumeration<DocumentReference.DocumentRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DocumentReference.DocumentRelationshipType> tgt = new Enumeration<DocumentReference.DocumentRelationshipType>(new DocumentReference.DocumentRelationshipTypeEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((DocumentReference.DocumentRelationshipType)src.getValue()) {
            case REPLACES: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.REPLACES);
                break;
            }
            case TRANSFORMS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.TRANSFORMS);
                break;
            }
            case SIGNS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.SIGNS);
                break;
            }
            case APPENDS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.APPENDS);
                break;
            }
            default: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.NULL);
            }
        }
        return tgt;
    }
}

