/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.AppointmentResponse;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.AppointmentResponse;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;

public class AppointmentResponse10_40 {
    public static org.hl7.fhir.r4.model.AppointmentResponse convertAppointmentResponse(AppointmentResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.AppointmentResponse tgt = new org.hl7.fhir.r4.model.AppointmentResponse();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(t));
        }
        if (src.hasAppointment()) {
            tgt.setAppointment(VersionConvertor_10_40.convertReference(src.getAppointment()));
        }
        if (src.hasStartElement()) {
            tgt.setStartElement(VersionConvertor_10_40.convertInstant(src.getStartElement()));
        }
        if (src.hasEndElement()) {
            tgt.setEndElement(VersionConvertor_10_40.convertInstant(src.getEndElement()));
        }
        for (Identifier t : src.getParticipantType()) {
            tgt.addParticipantType(VersionConvertor_10_40.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)t));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_10_40.convertReference(src.getActor()));
        }
        if (src.hasParticipantStatus()) {
            tgt.setParticipantStatusElement(AppointmentResponse10_40.convertParticipantStatus((org.hl7.fhir.dstu2.model.Enumeration<AppointmentResponse.ParticipantStatus>)src.getParticipantStatusElement()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_40.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static AppointmentResponse convertAppointmentResponse(org.hl7.fhir.r4.model.AppointmentResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AppointmentResponse tgt = new AppointmentResponse();
        VersionConvertor_10_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        if (src.hasAppointment()) {
            tgt.setAppointment(VersionConvertor_10_40.convertReference(src.getAppointment()));
        }
        if (src.hasStartElement()) {
            tgt.setStartElement(VersionConvertor_10_40.convertInstant(src.getStartElement()));
        }
        if (src.hasEndElement()) {
            tgt.setEndElement(VersionConvertor_10_40.convertInstant(src.getEndElement()));
        }
        for (CodeableConcept codeableConcept : src.getParticipantType()) {
            tgt.addParticipantType(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_10_40.convertReference(src.getActor()));
        }
        if (src.hasParticipantStatus()) {
            tgt.setParticipantStatusElement(AppointmentResponse10_40.convertParticipantStatus(src.getParticipantStatusElement()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_40.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<AppointmentResponse.ParticipantStatus> convertParticipantStatus(Enumeration<AppointmentResponse.ParticipantStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new AppointmentResponse.ParticipantStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        switch ((AppointmentResponse.ParticipantStatus)((Object)src.getValue())) {
            case ACCEPTED: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.ACCEPTED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.DECLINED);
                break;
            }
            case TENTATIVE: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.TENTATIVE);
                break;
            }
            case NEEDSACTION: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.NEEDSACTION);
                break;
            }
            default: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<AppointmentResponse.ParticipantStatus> convertParticipantStatus(org.hl7.fhir.dstu2.model.Enumeration<AppointmentResponse.ParticipantStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<AppointmentResponse.ParticipantStatus> tgt = new Enumeration<AppointmentResponse.ParticipantStatus>(new AppointmentResponse.ParticipantStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((AppointmentResponse.ParticipantStatus)src.getValue()) {
            case ACCEPTED: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.ACCEPTED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.DECLINED);
                break;
            }
            case TENTATIVE: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.TENTATIVE);
                break;
            }
            case INPROCESS: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.ACCEPTED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.ACCEPTED);
                break;
            }
            case NEEDSACTION: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.NEEDSACTION);
                break;
            }
            default: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.NULL);
            }
        }
        return tgt;
    }
}

