/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.MedicationOrder;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Dosage;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;

public class MedicationRequest10_30 {
    public static MedicationRequest convertMedicationOrder(MedicationOrder src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationRequest tgt = new MedicationRequest();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        tgt.setIntent(MedicationRequest.MedicationRequestIntent.ORDER);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(t));
        }
        if (src.hasDateWritten()) {
            tgt.setAuthoredOn(src.getDateWritten());
        }
        if (src.hasStatus()) {
            tgt.setStatus(MedicationRequest.MedicationRequestStatus.fromCode(src.getStatus().toCode()));
        }
        if (src.hasPatient()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getPatient()));
        }
        if (src.hasPrescriber()) {
            tgt.setRequester(MedicationRequest10_30.medRequestor(src));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_10_30.convertReference(src.getEncounter()));
        }
        if (src.hasReasonCodeableConcept()) {
            tgt.addReasonCode(VersionConvertor_10_30.convertCodeableConcept(src.getReasonCodeableConcept()));
        }
        if (src.hasReasonReference()) {
            tgt.addReasonReference(VersionConvertor_10_30.convertReference(src.getReasonReference()));
        }
        if (src.hasNote()) {
            tgt.addNote(new Annotation(new StringType(src.getNote())));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_10_30.convertType(src.getMedication()));
        }
        for (MedicationOrder.MedicationOrderDosageInstructionComponent dosage : src.getDosageInstruction()) {
            tgt.addDosageInstruction(MedicationRequest10_30.medDosageInstruction(dosage));
        }
        if (src.hasDispenseRequest()) {
            tgt.setDispenseRequest(MedicationRequest10_30.medDispenseRequest(src.getDispenseRequest()));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationRequest10_30.medSubstitution(src.getSubstitution()));
        }
        if (src.hasPriorPrescription()) {
            tgt.setPriorPrescription(VersionConvertor_10_30.convertReference(src.getPriorPrescription()));
        }
        return tgt;
    }

    private static Dosage medDosageInstruction(MedicationOrder.MedicationOrderDosageInstructionComponent src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Dosage tgt = new Dosage();
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        if (src.hasAdditionalInstructions()) {
            tgt.addAdditionalInstruction(VersionConvertor_10_30.convertCodeableConcept(src.getAdditionalInstructions()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_10_30.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_10_30.convertType(src.getAsNeeded()));
        }
        if (src.hasSiteCodeableConcept()) {
            tgt.setSite(VersionConvertor_10_30.convertCodeableConcept(src.getSiteCodeableConcept()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_10_30.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_30.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose()) {
            tgt.setDose(VersionConvertor_10_30.convertType(src.getDose()));
        }
        if (src.hasRate()) {
            tgt.setRate(VersionConvertor_10_30.convertType(src.getRate()));
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_10_30.convertRatio(src.getMaxDosePerPeriod()));
        }
        return tgt;
    }

    private static MedicationRequest.MedicationRequestDispenseRequestComponent medDispenseRequest(MedicationOrder.MedicationOrderDispenseRequestComponent src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationRequest.MedicationRequestDispenseRequestComponent tgt = new MedicationRequest.MedicationRequestDispenseRequestComponent();
        if (src.hasValidityPeriod()) {
            tgt.setValidityPeriod(VersionConvertor_10_30.convertPeriod(src.getValidityPeriod()));
        }
        if (src.hasNumberOfRepeatsAllowed()) {
            tgt.setNumberOfRepeatsAllowed(src.getNumberOfRepeatsAllowed());
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_30.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasExpectedSupplyDuration()) {
            tgt.setExpectedSupplyDuration(VersionConvertor_10_30.convertDuration(src.getExpectedSupplyDuration()));
        }
        return tgt;
    }

    private static MedicationRequest.MedicationRequestSubstitutionComponent medSubstitution(MedicationOrder.MedicationOrderSubstitutionComponent src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationRequest.MedicationRequestSubstitutionComponent tgt = new MedicationRequest.MedicationRequestSubstitutionComponent();
        if (src.hasReason()) {
            tgt.setReason(VersionConvertor_10_30.convertCodeableConcept(src.getReason()));
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestRequesterComponent medRequestor(MedicationOrder src) {
        MedicationRequest.MedicationRequestRequesterComponent tgt = new MedicationRequest.MedicationRequestRequesterComponent();
        tgt.setAgent(VersionConvertor_10_30.convertReference(src.getPrescriber()));
        return tgt;
    }
}

