/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.MedicationDispense;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Dosage;
import org.hl7.fhir.dstu3.model.MedicationDispense;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;

public class MedicationDispense10_30 {
    public static MedicationDispense convertMedicationDispense(org.hl7.fhir.dstu2.model.MedicationDispense src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense tgt = new MedicationDispense();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationDispense10_30.convertMedicationDispenseStatus((Enumeration<MedicationDispense.MedicationDispenseStatus>)src.getStatusElement()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_10_30.convertType(src.getMedication()));
        }
        if (src.hasPatient()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getPatient()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getAuthorizingPrescription()) {
            tgt.addAuthorizingPrescription(VersionConvertor_10_30.convertReference(t));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_30.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDaysSupply()) {
            tgt.setDaysSupply(VersionConvertor_10_30.convertSimpleQuantity(src.getDaysSupply()));
        }
        if (src.hasWhenPreparedElement()) {
            tgt.setWhenPreparedElement(VersionConvertor_10_30.convertDateTime(src.getWhenPreparedElement()));
        }
        if (src.hasWhenHandedOverElement()) {
            tgt.setWhenHandedOverElement(VersionConvertor_10_30.convertDateTime(src.getWhenHandedOverElement()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_10_30.convertReference(src.getDestination()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_10_30.convertReference(t));
        }
        if (src.hasNote()) {
            tgt.addNote().setText(src.getNote());
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getDosageInstruction()) {
            tgt.addDosageInstruction(MedicationDispense10_30.convertMedicationDispenseDosageInstructionComponent((MedicationDispense.MedicationDispenseDosageInstructionComponent)t));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationDispense10_30.convertMedicationDispenseSubstitutionComponent(src.getSubstitution()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.MedicationDispense convertMedicationDispense(MedicationDispense src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.MedicationDispense tgt = new org.hl7.fhir.dstu2.model.MedicationDispense();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationDispense10_30.convertMedicationDispenseStatus(src.getStatusElement()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_10_30.convertType(src.getMedication()));
        }
        if (src.hasSubject()) {
            tgt.setPatient(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        for (Reference reference : src.getAuthorizingPrescription()) {
            tgt.addAuthorizingPrescription(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_30.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDaysSupply()) {
            tgt.setDaysSupply(VersionConvertor_10_30.convertSimpleQuantity(src.getDaysSupply()));
        }
        if (src.hasWhenPreparedElement()) {
            tgt.setWhenPreparedElement(VersionConvertor_10_30.convertDateTime(src.getWhenPreparedElement()));
        }
        if (src.hasWhenHandedOverElement()) {
            tgt.setWhenHandedOverElement(VersionConvertor_10_30.convertDateTime(src.getWhenHandedOverElement()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_10_30.convertReference(src.getDestination()));
        }
        for (Reference reference : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_10_30.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.setNote(annotation.getText());
        }
        for (Dosage dosage : src.getDosageInstruction()) {
            tgt.addDosageInstruction(MedicationDispense10_30.convertMedicationDispenseDosageInstructionComponent(dosage));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationDispense10_30.convertMedicationDispenseSubstitutionComponent(src.getSubstitution()));
        }
        return tgt;
    }

    public static Dosage convertMedicationDispenseDosageInstructionComponent(MedicationDispense.MedicationDispenseDosageInstructionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Dosage tgt = new Dosage();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_10_30.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_10_30.convertType(src.getAsNeeded()));
        }
        if (src.hasSiteCodeableConcept()) {
            tgt.setSite(VersionConvertor_10_30.convertCodeableConcept(src.getSiteCodeableConcept()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_10_30.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_30.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose()) {
            tgt.setDose(VersionConvertor_10_30.convertType(src.getDose()));
        }
        if (src.hasRate()) {
            tgt.setRate(VersionConvertor_10_30.convertType(src.getRate()));
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_10_30.convertRatio(src.getMaxDosePerPeriod()));
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispenseDosageInstructionComponent convertMedicationDispenseDosageInstructionComponent(Dosage src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense.MedicationDispenseDosageInstructionComponent tgt = new MedicationDispense.MedicationDispenseDosageInstructionComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        tgt.setText(src.getText());
        tgt.setTiming(VersionConvertor_10_30.convertTiming(src.getTiming()));
        tgt.setAsNeeded(VersionConvertor_10_30.convertType(src.getAsNeeded()));
        tgt.setSite(VersionConvertor_10_30.convertType(src.getSite()));
        tgt.setRoute(VersionConvertor_10_30.convertCodeableConcept(src.getRoute()));
        tgt.setMethod(VersionConvertor_10_30.convertCodeableConcept(src.getMethod()));
        tgt.setDose(VersionConvertor_10_30.convertType(src.getDose()));
        tgt.setRate(VersionConvertor_10_30.convertType(src.getRate()));
        tgt.setMaxDosePerPeriod(VersionConvertor_10_30.convertRatio(src.getMaxDosePerPeriod()));
        return tgt;
    }

    public static Enumeration<MedicationDispense.MedicationDispenseStatus> convertMedicationDispenseStatus(org.hl7.fhir.dstu3.model.Enumeration<MedicationDispense.MedicationDispenseStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new MedicationDispense.MedicationDispenseStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((MedicationDispense.MedicationDispenseStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.INPROGRESS);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.ONHOLD);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.ENTEREDINERROR);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.STOPPED);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<MedicationDispense.MedicationDispenseStatus> convertMedicationDispenseStatus(Enumeration<MedicationDispense.MedicationDispenseStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MedicationDispense.MedicationDispenseStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MedicationDispense.MedicationDispenseStatus>(new MedicationDispense.MedicationDispenseStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((MedicationDispense.MedicationDispenseStatus)src.getValue()) {
            case INPROGRESS: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.INPROGRESS);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.ONHOLD);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.ENTEREDINERROR);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.STOPPED);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.NULL);
            }
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispenseSubstitutionComponent convertMedicationDispenseSubstitutionComponent(MedicationDispense.MedicationDispenseSubstitutionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense.MedicationDispenseSubstitutionComponent tgt = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        for (CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReason(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getResponsibleParty()) {
            tgt.addResponsibleParty(VersionConvertor_10_30.convertReference(reference));
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispenseSubstitutionComponent convertMedicationDispenseSubstitutionComponent(MedicationDispense.MedicationDispenseSubstitutionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense.MedicationDispenseSubstitutionComponent tgt = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept t : src.getReason()) {
            tgt.addReason(VersionConvertor_10_30.convertCodeableConcept(t));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept t : src.getResponsibleParty()) {
            tgt.addResponsibleParty(VersionConvertor_10_30.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        return tgt;
    }
}

