/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.DocumentManifest;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu3.model.DocumentManifest;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;

public class DocumentManifest10_30 {
    public static org.hl7.fhir.dstu2.model.DocumentManifest convertDocumentManifest(DocumentManifest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.DocumentManifest tgt = new org.hl7.fhir.dstu2.model.DocumentManifest();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        if (src.hasMasterIdentifier()) {
            tgt.setMasterIdentifier(VersionConvertor_10_30.convertIdentifier(src.getMasterIdentifier()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        for (Reference reference : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        for (Reference reference : src.getAuthor()) {
            tgt.addAuthor(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasCreatedElement()) {
            tgt.setCreatedElement(VersionConvertor_10_30.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasSourceElement()) {
            tgt.setSourceElement(VersionConvertor_10_30.convertUri(src.getSourceElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_30.convertDocumentReferenceStatus(src.getStatusElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (DocumentManifest.DocumentManifestContentComponent documentManifestContentComponent : src.getContent()) {
            tgt.addContent(DocumentManifest10_30.convertDocumentManifestContentComponent(documentManifestContentComponent));
        }
        for (DocumentManifest.DocumentManifestRelatedComponent documentManifestRelatedComponent : src.getRelated()) {
            tgt.addRelated(DocumentManifest10_30.convertDocumentManifestRelatedComponent(documentManifestRelatedComponent));
        }
        return tgt;
    }

    public static DocumentManifest convertDocumentManifest(org.hl7.fhir.dstu2.model.DocumentManifest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentManifest tgt = new DocumentManifest();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        if (src.hasMasterIdentifier()) {
            tgt.setMasterIdentifier(VersionConvertor_10_30.convertIdentifier(src.getMasterIdentifier()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(t));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_10_30.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getAuthor()) {
            tgt.addAuthor(VersionConvertor_10_30.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        if (src.hasCreatedElement()) {
            tgt.setCreatedElement(VersionConvertor_10_30.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasSourceElement()) {
            tgt.setSourceElement(VersionConvertor_10_30.convertUri(src.getSourceElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_30.convertDocumentReferenceStatus((Enumeration<Enumerations.DocumentReferenceStatus>)src.getStatusElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getContent()) {
            tgt.addContent(DocumentManifest10_30.convertDocumentManifestContentComponent((DocumentManifest.DocumentManifestContentComponent)t));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getRelated()) {
            tgt.addRelated(DocumentManifest10_30.convertDocumentManifestRelatedComponent((DocumentManifest.DocumentManifestRelatedComponent)t));
        }
        return tgt;
    }

    public static DocumentManifest.DocumentManifestContentComponent convertDocumentManifestContentComponent(DocumentManifest.DocumentManifestContentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentManifest.DocumentManifestContentComponent tgt = new DocumentManifest.DocumentManifestContentComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasP()) {
            tgt.setP(VersionConvertor_10_30.convertType(src.getP()));
        }
        return tgt;
    }

    public static DocumentManifest.DocumentManifestContentComponent convertDocumentManifestContentComponent(DocumentManifest.DocumentManifestContentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentManifest.DocumentManifestContentComponent tgt = new DocumentManifest.DocumentManifestContentComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasP()) {
            tgt.setP(VersionConvertor_10_30.convertType(src.getP()));
        }
        return tgt;
    }

    public static DocumentManifest.DocumentManifestRelatedComponent convertDocumentManifestRelatedComponent(DocumentManifest.DocumentManifestRelatedComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentManifest.DocumentManifestRelatedComponent tgt = new DocumentManifest.DocumentManifestRelatedComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasRef()) {
            tgt.setRef(VersionConvertor_10_30.convertReference(src.getRef()));
        }
        return tgt;
    }

    public static DocumentManifest.DocumentManifestRelatedComponent convertDocumentManifestRelatedComponent(DocumentManifest.DocumentManifestRelatedComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentManifest.DocumentManifestRelatedComponent tgt = new DocumentManifest.DocumentManifestRelatedComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasRef()) {
            tgt.setRef(VersionConvertor_10_30.convertReference(src.getRef()));
        }
        return tgt;
    }
}

