/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Composition;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu3.model.Composition;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;

public class Composition10_30 {
    public static org.hl7.fhir.dstu3.model.Composition convertComposition(Composition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Composition tgt = new org.hl7.fhir.dstu3.model.Composition();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasClass_()) {
            tgt.setClass_(VersionConvertor_10_30.convertCodeableConcept(src.getClass_()));
        }
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_30.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Composition10_30.convertCompositionStatus((Enumeration<Composition.CompositionStatus>)src.getStatusElement()));
        }
        try {
            if (src.hasConfidentiality()) {
                tgt.setConfidentiality(Composition.DocumentConfidentiality.fromCode(src.getConfidentiality()));
            }
        }
        catch (FHIRException e) {
            throw new FHIRException(e);
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getAuthor()) {
            tgt.addAuthor(VersionConvertor_10_30.convertReference(t));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getAttester()) {
            tgt.addAttester(Composition10_30.convertCompositionAttesterComponent((Composition.CompositionAttesterComponent)t));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_10_30.convertReference(src.getCustodian()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getEvent()) {
            tgt.addEvent(Composition10_30.convertCompositionEventComponent((Composition.CompositionEventComponent)t));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_30.convertReference(src.getEncounter()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getSection()) {
            tgt.addSection(Composition10_30.convertSectionComponent((Composition.SectionComponent)t));
        }
        return tgt;
    }

    public static Composition convertComposition(org.hl7.fhir.dstu3.model.Composition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition tgt = new Composition();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasClass_()) {
            tgt.setClass_(VersionConvertor_10_30.convertCodeableConcept(src.getClass_()));
        }
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_30.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Composition10_30.convertCompositionStatus(src.getStatusElement()));
        }
        tgt.setConfidentiality(src.getConfidentiality().toCode());
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        for (Reference reference : src.getAuthor()) {
            tgt.addAuthor(VersionConvertor_10_30.convertReference(reference));
        }
        for (Composition.CompositionAttesterComponent compositionAttesterComponent : src.getAttester()) {
            tgt.addAttester(Composition10_30.convertCompositionAttesterComponent(compositionAttesterComponent));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_10_30.convertReference(src.getCustodian()));
        }
        for (Composition.CompositionEventComponent compositionEventComponent : src.getEvent()) {
            tgt.addEvent(Composition10_30.convertCompositionEventComponent(compositionEventComponent));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_30.convertReference(src.getEncounter()));
        }
        for (Composition.SectionComponent sectionComponent : src.getSection()) {
            tgt.addSection(Composition10_30.convertSectionComponent(sectionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionAttestationMode> convertCompositionAttestationMode(Enumeration<Composition.CompositionAttestationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionAttestationMode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionAttestationMode>(new Composition.CompositionAttestationModeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Composition.CompositionAttestationMode)src.getValue()) {
            case PERSONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PERSONAL);
                break;
            }
            case PROFESSIONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PROFESSIONAL);
                break;
            }
            case LEGAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.LEGAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.OFFICIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Composition.CompositionAttestationMode> convertCompositionAttestationMode(org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionAttestationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Composition.CompositionAttestationModeEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((Composition.CompositionAttestationMode)((Object)src.getValue())) {
            case PERSONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PERSONAL);
                break;
            }
            case PROFESSIONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PROFESSIONAL);
                break;
            }
            case LEGAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.LEGAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.OFFICIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.NULL);
            }
        }
        return tgt;
    }

    public static Composition.CompositionAttesterComponent convertCompositionAttesterComponent(Composition.CompositionAttesterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.CompositionAttesterComponent tgt = new Composition.CompositionAttesterComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        tgt.setMode(src.getMode().stream().map(Composition10_30::convertCompositionAttestationMode).collect(Collectors.toList()));
        if (src.hasTimeElement()) {
            tgt.setTimeElement(VersionConvertor_10_30.convertDateTime(src.getTimeElement()));
        }
        if (src.hasParty()) {
            tgt.setParty(VersionConvertor_10_30.convertReference(src.getParty()));
        }
        return tgt;
    }

    public static Composition.CompositionAttesterComponent convertCompositionAttesterComponent(Composition.CompositionAttesterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.CompositionAttesterComponent tgt = new Composition.CompositionAttesterComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        tgt.setMode(src.getMode().stream().map(Composition10_30::convertCompositionAttestationMode).collect(Collectors.toList()));
        if (src.hasTimeElement()) {
            tgt.setTimeElement(VersionConvertor_10_30.convertDateTime(src.getTimeElement()));
        }
        if (src.hasParty()) {
            tgt.setParty(VersionConvertor_10_30.convertReference(src.getParty()));
        }
        return tgt;
    }

    public static Composition.CompositionEventComponent convertCompositionEventComponent(Composition.CompositionEventComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.CompositionEventComponent tgt = new Composition.CompositionEventComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        for (Reference reference : src.getDetail()) {
            tgt.addDetail(VersionConvertor_10_30.convertReference(reference));
        }
        return tgt;
    }

    public static Composition.CompositionEventComponent convertCompositionEventComponent(Composition.CompositionEventComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.CompositionEventComponent tgt = new Composition.CompositionEventComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        for (CodeableConcept t : src.getCode()) {
            tgt.addCode(VersionConvertor_10_30.convertCodeableConcept(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        for (CodeableConcept t : src.getDetail()) {
            tgt.addDetail(VersionConvertor_10_30.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionStatus> convertCompositionStatus(Enumeration<Composition.CompositionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionStatus>(new Composition.CompositionStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Composition.CompositionStatus)src.getValue()) {
            case PRELIMINARY: {
                tgt.setValue((Object)Composition.CompositionStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Composition.CompositionStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Composition.CompositionStatus.AMENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Composition.CompositionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.CompositionStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Composition.CompositionStatus> convertCompositionStatus(org.hl7.fhir.dstu3.model.Enumeration<Composition.CompositionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Composition.CompositionStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((Composition.CompositionStatus)((Object)src.getValue())) {
            case PRELIMINARY: {
                tgt.setValue((Object)Composition.CompositionStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Composition.CompositionStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Composition.CompositionStatus.AMENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Composition.CompositionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.CompositionStatus.NULL);
            }
        }
        return tgt;
    }

    public static Composition.SectionComponent convertSectionComponent(Composition.SectionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.SectionComponent tgt = new Composition.SectionComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_30.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasText()) {
            tgt.setText(VersionConvertor_10_30.convertNarrative(src.getText()));
        }
        try {
            if (src.hasMode()) {
                tgt.setMode(Composition.SectionMode.fromCode(src.getMode()));
            }
        }
        catch (FHIRException e) {
            throw new FHIRException(e);
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_10_30.convertCodeableConcept(src.getOrderedBy()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getEntry()) {
            tgt.addEntry(VersionConvertor_10_30.convertReference(t));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(VersionConvertor_10_30.convertCodeableConcept(src.getEmptyReason()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getSection()) {
            tgt.addSection(Composition10_30.convertSectionComponent((Composition.SectionComponent)t));
        }
        return tgt;
    }

    public static Composition.SectionComponent convertSectionComponent(Composition.SectionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.SectionComponent tgt = new Composition.SectionComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_30.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasText()) {
            tgt.setText(VersionConvertor_10_30.convertNarrative(src.getText()));
        }
        tgt.setMode(src.getMode().toCode());
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_10_30.convertCodeableConcept(src.getOrderedBy()));
        }
        for (Reference reference : src.getEntry()) {
            tgt.addEntry(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(VersionConvertor_10_30.convertCodeableConcept(src.getEmptyReason()));
        }
        for (Composition.SectionComponent sectionComponent : src.getSection()) {
            tgt.addSection(Composition10_30.convertSectionComponent(sectionComponent));
        }
        return tgt;
    }
}

