/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.Annotation;
import org.hl7.fhir.dstu2.model.CarePlan;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;

public class CarePlan10_30 {
    public static CarePlan convertCarePlan(org.hl7.fhir.dstu2.model.CarePlan src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CarePlan tgt = new CarePlan();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(t));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CarePlan10_30.convertCarePlanStatus((Enumeration<CarePlan.CarePlanStatus>)src.getStatusElement()));
        }
        if (src.hasContext()) {
            tgt.setContext(VersionConvertor_10_30.convertReference(src.getContext()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getAuthor()) {
            tgt.addAuthor(VersionConvertor_10_30.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_10_30.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getAddresses()) {
            tgt.addAddresses(VersionConvertor_10_30.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getGoal()) {
            tgt.addGoal(VersionConvertor_10_30.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getActivity()) {
            tgt.addActivity(CarePlan10_30.convertCarePlanActivityComponent((CarePlan.CarePlanActivityComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.CarePlan convertCarePlan(CarePlan src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.CarePlan tgt = new org.hl7.fhir.dstu2.model.CarePlan();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CarePlan10_30.convertCarePlanStatus(src.getStatusElement()));
        }
        if (src.hasContext()) {
            tgt.setContext(VersionConvertor_10_30.convertReference(src.getContext()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        for (Reference reference : src.getAuthor()) {
            tgt.addAuthor(VersionConvertor_10_30.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (Reference reference : src.getAddresses()) {
            tgt.addAddresses(VersionConvertor_10_30.convertReference(reference));
        }
        for (Reference reference : src.getGoal()) {
            tgt.addGoal(VersionConvertor_10_30.convertReference(reference));
        }
        for (CarePlan.CarePlanActivityComponent carePlanActivityComponent : src.getActivity()) {
            tgt.addActivity(CarePlan10_30.convertCarePlanActivityComponent(carePlanActivityComponent));
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityComponent convertCarePlanActivityComponent(CarePlan.CarePlanActivityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CarePlan.CarePlanActivityComponent tgt = new CarePlan.CarePlanActivityComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        for (org.hl7.fhir.dstu3.model.Annotation t : src.getProgress()) {
            tgt.addProgress(VersionConvertor_10_30.convertAnnotation(t));
        }
        if (src.hasReference()) {
            tgt.setReference(VersionConvertor_10_30.convertReference(src.getReference()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(CarePlan10_30.convertCarePlanActivityDetailComponent(src.getDetail()));
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityComponent convertCarePlanActivityComponent(CarePlan.CarePlanActivityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CarePlan.CarePlanActivityComponent tgt = new CarePlan.CarePlanActivityComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        for (Annotation t : src.getProgress()) {
            tgt.addProgress(VersionConvertor_10_30.convertAnnotation(t));
        }
        if (src.hasReference()) {
            tgt.setReference(VersionConvertor_10_30.convertReference(src.getReference()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(CarePlan10_30.convertCarePlanActivityDetailComponent(src.getDetail()));
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityDetailComponent convertCarePlanActivityDetailComponent(CarePlan.CarePlanActivityDetailComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CarePlan.CarePlanActivityDetailComponent tgt = new CarePlan.CarePlanActivityDetailComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_10_30.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        for (CodeableConcept t : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_10_30.convertCodeableConcept(t));
        }
        for (CodeableConcept t : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_10_30.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        for (CodeableConcept t : src.getGoal()) {
            tgt.addGoal(VersionConvertor_10_30.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CarePlan10_30.convertCarePlanActivityStatus((Enumeration<CarePlan.CarePlanActivityStatus>)src.getStatusElement()));
        }
        if (src.hasProhibitedElement()) {
            tgt.setProhibitedElement(VersionConvertor_10_30.convertBoolean(src.getProhibitedElement()));
        }
        if (src.hasScheduled()) {
            tgt.setScheduled(VersionConvertor_10_30.convertType(src.getScheduled()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_10_30.convertReference(src.getLocation()));
        }
        for (CodeableConcept t : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_10_30.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        if (src.hasProduct()) {
            tgt.setProduct(VersionConvertor_10_30.convertType(src.getProduct()));
        }
        if (src.hasDailyAmount()) {
            tgt.setDailyAmount(VersionConvertor_10_30.convertSimpleQuantity(src.getDailyAmount()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_30.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityDetailComponent convertCarePlanActivityDetailComponent(CarePlan.CarePlanActivityDetailComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CarePlan.CarePlanActivityDetailComponent tgt = new CarePlan.CarePlanActivityDetailComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_10_30.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_10_30.convertReference(reference));
        }
        for (Reference reference : src.getGoal()) {
            tgt.addGoal(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CarePlan10_30.convertCarePlanActivityStatus(src.getStatusElement()));
        }
        if (src.hasProhibitedElement()) {
            tgt.setProhibitedElement(VersionConvertor_10_30.convertBoolean(src.getProhibitedElement()));
        }
        if (src.hasScheduled()) {
            tgt.setScheduled(VersionConvertor_10_30.convertType(src.getScheduled()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_10_30.convertReference(src.getLocation()));
        }
        for (Reference reference : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasProduct()) {
            tgt.setProduct(VersionConvertor_10_30.convertType(src.getProduct()));
        }
        if (src.hasDailyAmount()) {
            tgt.setDailyAmount(VersionConvertor_10_30.convertSimpleQuantity(src.getDailyAmount()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_30.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static Enumeration<CarePlan.CarePlanActivityStatus> convertCarePlanActivityStatus(org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanActivityStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new CarePlan.CarePlanActivityStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((CarePlan.CarePlanActivityStatus)((Object)src.getValue())) {
            case NOTSTARTED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NOTSTARTED);
                break;
            }
            case SCHEDULED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.SCHEDULED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.INPROGRESS);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.ONHOLD);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.COMPLETED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.CANCELLED);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanActivityStatus> convertCarePlanActivityStatus(Enumeration<CarePlan.CarePlanActivityStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanActivityStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanActivityStatus>(new CarePlan.CarePlanActivityStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((CarePlan.CarePlanActivityStatus)src.getValue()) {
            case NOTSTARTED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NOTSTARTED);
                break;
            }
            case SCHEDULED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.SCHEDULED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.INPROGRESS);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.ONHOLD);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.COMPLETED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.CANCELLED);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CarePlan.CarePlanStatus> convertCarePlanStatus(org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new CarePlan.CarePlanStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((CarePlan.CarePlanStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.COMPLETED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.CANCELLED);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanStatus> convertCarePlanStatus(Enumeration<CarePlan.CarePlanStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanStatus>(new CarePlan.CarePlanStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((CarePlan.CarePlanStatus)src.getValue()) {
            case PROPOSED: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.DRAFT);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.COMPLETED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.CANCELLED);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.NULL);
            }
        }
        return tgt;
    }
}

