/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.AuditEvent;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu3.model.AuditEvent;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;

public class AuditEvent10_30 {
    public static AuditEvent convertAuditEvent(org.hl7.fhir.dstu3.model.AuditEvent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent tgt = new AuditEvent();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        tgt.getEvent().setType(VersionConvertor_10_30.convertCoding(src.getType()));
        for (Coding coding : src.getSubtype()) {
            tgt.getEvent().addSubtype(VersionConvertor_10_30.convertCoding(coding));
        }
        tgt.getEvent().setActionElement(AuditEvent10_30.convertAuditEventAction(src.getActionElement()));
        tgt.getEvent().setDateTime(src.getRecorded());
        tgt.getEvent().setOutcomeElement(AuditEvent10_30.convertAuditEventOutcome(src.getOutcomeElement()));
        tgt.getEvent().setOutcomeDesc(src.getOutcomeDesc());
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getPurposeOfEvent()) {
            for (Coding cc : codeableConcept.getCoding()) {
                tgt.getEvent().addPurposeOfEvent(VersionConvertor_10_30.convertCoding(cc));
            }
        }
        for (AuditEvent.AuditEventAgentComponent auditEventAgentComponent : src.getAgent()) {
            tgt.addParticipant(AuditEvent10_30.convertAuditEventAgentComponent(auditEventAgentComponent));
        }
        if (src.hasSource()) {
            tgt.setSource(AuditEvent10_30.convertAuditEventSourceComponent(src.getSource()));
        }
        for (AuditEvent.AuditEventEntityComponent auditEventEntityComponent : src.getEntity()) {
            tgt.addObject(AuditEvent10_30.convertAuditEventEntityComponent(auditEventEntityComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.AuditEvent convertAuditEvent(AuditEvent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.AuditEvent tgt = new org.hl7.fhir.dstu3.model.AuditEvent();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        if (src.hasEvent()) {
            if (src.hasType(new String[0])) {
                tgt.setType(VersionConvertor_10_30.convertCoding(src.getEvent().getType()));
            }
            for (AuditEvent.AuditEventParticipantComponent t : src.getEvent().getSubtype()) {
                tgt.addSubtype(VersionConvertor_10_30.convertCoding((org.hl7.fhir.dstu2.model.Coding)t));
            }
            tgt.setActionElement(AuditEvent10_30.convertAuditEventAction((Enumeration<AuditEvent.AuditEventAction>)src.getEvent().getActionElement()));
            tgt.setRecorded(src.getEvent().getDateTime());
            tgt.setOutcomeElement(AuditEvent10_30.convertAuditEventOutcome((Enumeration<AuditEvent.AuditEventOutcome>)src.getEvent().getOutcomeElement()));
            tgt.setOutcomeDesc(src.getEvent().getOutcomeDesc());
            for (AuditEvent.AuditEventParticipantComponent t : src.getEvent().getPurposeOfEvent()) {
                tgt.addPurposeOfEvent().addCoding(VersionConvertor_10_30.convertCoding((org.hl7.fhir.dstu2.model.Coding)t));
            }
        }
        for (AuditEvent.AuditEventParticipantComponent t : src.getParticipant()) {
            tgt.addAgent(AuditEvent10_30.convertAuditEventAgentComponent(t));
        }
        if (src.hasSource()) {
            tgt.setSource(AuditEvent10_30.convertAuditEventSourceComponent(src.getSource()));
        }
        for (AuditEvent.AuditEventParticipantComponent t : src.getObject()) {
            tgt.addEntity(AuditEvent10_30.convertAuditEventEntityComponent((AuditEvent.AuditEventObjectComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAction> convertAuditEventAction(Enumeration<AuditEvent.AuditEventAction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAction> tgt = new org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAction>(new AuditEvent.AuditEventActionEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((AuditEvent.AuditEventAction)src.getValue()) {
            case C: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.C);
                break;
            }
            case R: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.R);
                break;
            }
            case U: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.U);
                break;
            }
            case D: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.D);
                break;
            }
            case E: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.E);
                break;
            }
            default: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<AuditEvent.AuditEventAction> convertAuditEventAction(org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new AuditEvent.AuditEventActionEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((AuditEvent.AuditEventAction)((Object)src.getValue())) {
            case C: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.C);
                break;
            }
            case R: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.R);
                break;
            }
            case U: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.U);
                break;
            }
            case D: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.D);
                break;
            }
            case E: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.E);
                break;
            }
            default: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.NULL);
            }
        }
        return tgt;
    }

    public static AuditEvent.AuditEventAgentComponent convertAuditEventAgentComponent(AuditEvent.AuditEventParticipantComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventAgentComponent tgt = new AuditEvent.AuditEventAgentComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        for (CodeableConcept t : src.getRole()) {
            tgt.addRole(VersionConvertor_10_30.convertCodeableConcept(t));
        }
        if (src.hasReference()) {
            tgt.setReference(VersionConvertor_10_30.convertReference(src.getReference()));
        }
        if (src.hasUserId()) {
            tgt.setUserId(VersionConvertor_10_30.convertIdentifier(src.getUserId()));
        }
        if (src.hasAltIdElement()) {
            tgt.setAltIdElement(VersionConvertor_10_30.convertString(src.getAltIdElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasRequestorElement()) {
            tgt.setRequestorElement(VersionConvertor_10_30.convertBoolean(src.getRequestorElement()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_10_30.convertReference(src.getLocation()));
        }
        for (CodeableConcept t : src.getPolicy()) {
            tgt.addPolicy((String)t.getValue());
        }
        if (src.hasMedia()) {
            tgt.setMedia(VersionConvertor_10_30.convertCoding(src.getMedia()));
        }
        if (src.hasNetwork()) {
            tgt.setNetwork(AuditEvent10_30.convertAuditEventAgentNetworkComponent(src.getNetwork()));
        }
        for (CodeableConcept t : src.getPurposeOfUse()) {
            tgt.addPurposeOfUse().addCoding(VersionConvertor_10_30.convertCoding((org.hl7.fhir.dstu2.model.Coding)t));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventParticipantComponent convertAuditEventAgentComponent(AuditEvent.AuditEventAgentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventParticipantComponent tgt = new AuditEvent.AuditEventParticipantComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getRole()) {
            tgt.addRole(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasReference()) {
            tgt.setReference(VersionConvertor_10_30.convertReference(src.getReference()));
        }
        if (src.hasUserId()) {
            tgt.setUserId(VersionConvertor_10_30.convertIdentifier(src.getUserId()));
        }
        if (src.hasAltIdElement()) {
            tgt.setAltIdElement(VersionConvertor_10_30.convertString(src.getAltIdElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasRequestorElement()) {
            tgt.setRequestorElement(VersionConvertor_10_30.convertBoolean(src.getRequestorElement()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_10_30.convertReference(src.getLocation()));
        }
        for (UriType uriType : src.getPolicy()) {
            tgt.addPolicy((String)uriType.getValue());
        }
        if (src.hasMedia()) {
            tgt.setMedia(VersionConvertor_10_30.convertCoding(src.getMedia()));
        }
        if (src.hasNetwork()) {
            tgt.setNetwork(AuditEvent10_30.convertAuditEventAgentNetworkComponent(src.getNetwork()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getPurposeOfUse()) {
            for (Coding cc : codeableConcept.getCoding()) {
                tgt.addPurposeOfUse(VersionConvertor_10_30.convertCoding(cc));
            }
        }
        return tgt;
    }

    public static AuditEvent.AuditEventParticipantNetworkComponent convertAuditEventAgentNetworkComponent(AuditEvent.AuditEventAgentNetworkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventParticipantNetworkComponent tgt = new AuditEvent.AuditEventParticipantNetworkComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasAddressElement()) {
            tgt.setAddressElement(VersionConvertor_10_30.convertString(src.getAddressElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(AuditEvent10_30.convertAuditEventParticipantNetworkType(src.getTypeElement()));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventAgentNetworkComponent convertAuditEventAgentNetworkComponent(AuditEvent.AuditEventParticipantNetworkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventAgentNetworkComponent tgt = new AuditEvent.AuditEventAgentNetworkComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasAddressElement()) {
            tgt.setAddressElement(VersionConvertor_10_30.convertString(src.getAddressElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(AuditEvent10_30.convertAuditEventParticipantNetworkType((Enumeration<AuditEvent.AuditEventParticipantNetworkType>)src.getTypeElement()));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventEntityComponent convertAuditEventEntityComponent(AuditEvent.AuditEventObjectComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventEntityComponent tgt = new AuditEvent.AuditEventEntityComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasReference()) {
            tgt.setReference(VersionConvertor_10_30.convertReference(src.getReference()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCoding(src.getType()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_10_30.convertCoding(src.getRole()));
        }
        if (src.hasLifecycle()) {
            tgt.setLifecycle(VersionConvertor_10_30.convertCoding(src.getLifecycle()));
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_10_30.convertCoding(t));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasQueryElement()) {
            tgt.setQueryElement(VersionConvertor_10_30.convertBase64Binary(src.getQueryElement()));
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getDetail()) {
            tgt.addDetail(AuditEvent10_30.convertAuditEventEntityDetailComponent((AuditEvent.AuditEventObjectDetailComponent)t));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventObjectComponent convertAuditEventEntityComponent(AuditEvent.AuditEventEntityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventObjectComponent tgt = new AuditEvent.AuditEventObjectComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasReference()) {
            tgt.setReference(VersionConvertor_10_30.convertReference(src.getReference()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCoding(src.getType()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_10_30.convertCoding(src.getRole()));
        }
        if (src.hasLifecycle()) {
            tgt.setLifecycle(VersionConvertor_10_30.convertCoding(src.getLifecycle()));
        }
        for (Coding coding : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_10_30.convertCoding(coding));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasQueryElement()) {
            tgt.setQueryElement(VersionConvertor_10_30.convertBase64Binary(src.getQueryElement()));
        }
        for (AuditEvent.AuditEventEntityDetailComponent auditEventEntityDetailComponent : src.getDetail()) {
            tgt.addDetail(AuditEvent10_30.convertAuditEventEntityDetailComponent(auditEventEntityDetailComponent));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventObjectDetailComponent convertAuditEventEntityDetailComponent(AuditEvent.AuditEventEntityDetailComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventObjectDetailComponent tgt = new AuditEvent.AuditEventObjectDetailComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_10_30.convertString(src.getTypeElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertBase64Binary(src.getValueElement()));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventEntityDetailComponent convertAuditEventEntityDetailComponent(AuditEvent.AuditEventObjectDetailComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventEntityDetailComponent tgt = new AuditEvent.AuditEventEntityDetailComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_10_30.convertString(src.getTypeElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertBase64Binary(src.getValueElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventOutcome> convertAuditEventOutcome(Enumeration<AuditEvent.AuditEventOutcome> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventOutcome> tgt = new org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventOutcome>(new AuditEvent.AuditEventOutcomeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((AuditEvent.AuditEventOutcome)src.getValue()) {
            case _0: {
                tgt.setValue((Object)AuditEvent.AuditEventOutcome._0);
                break;
            }
            case _4: {
                tgt.setValue((Object)AuditEvent.AuditEventOutcome._4);
                break;
            }
            case _8: {
                tgt.setValue((Object)AuditEvent.AuditEventOutcome._8);
                break;
            }
            case _12: {
                tgt.setValue((Object)AuditEvent.AuditEventOutcome._12);
                break;
            }
            default: {
                tgt.setValue((Object)AuditEvent.AuditEventOutcome.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<AuditEvent.AuditEventOutcome> convertAuditEventOutcome(org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventOutcome> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new AuditEvent.AuditEventOutcomeEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((AuditEvent.AuditEventOutcome)((Object)src.getValue())) {
            case _0: {
                tgt.setValue((Object)AuditEvent.AuditEventOutcome._0);
                break;
            }
            case _4: {
                tgt.setValue((Object)AuditEvent.AuditEventOutcome._4);
                break;
            }
            case _8: {
                tgt.setValue((Object)AuditEvent.AuditEventOutcome._8);
                break;
            }
            case _12: {
                tgt.setValue((Object)AuditEvent.AuditEventOutcome._12);
                break;
            }
            default: {
                tgt.setValue((Object)AuditEvent.AuditEventOutcome.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<AuditEvent.AuditEventParticipantNetworkType> convertAuditEventParticipantNetworkType(org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAgentNetworkType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new AuditEvent.AuditEventParticipantNetworkTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((AuditEvent.AuditEventAgentNetworkType)((Object)src.getValue())) {
            case _1: {
                tgt.setValue((Object)AuditEvent.AuditEventParticipantNetworkType._1);
                break;
            }
            case _2: {
                tgt.setValue((Object)AuditEvent.AuditEventParticipantNetworkType._2);
                break;
            }
            case _3: {
                tgt.setValue((Object)AuditEvent.AuditEventParticipantNetworkType._3);
                break;
            }
            case _4: {
                tgt.setValue((Object)AuditEvent.AuditEventParticipantNetworkType._4);
                break;
            }
            case _5: {
                tgt.setValue((Object)AuditEvent.AuditEventParticipantNetworkType._5);
                break;
            }
            default: {
                tgt.setValue((Object)AuditEvent.AuditEventParticipantNetworkType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAgentNetworkType> convertAuditEventParticipantNetworkType(Enumeration<AuditEvent.AuditEventParticipantNetworkType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAgentNetworkType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAgentNetworkType>(new AuditEvent.AuditEventAgentNetworkTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((AuditEvent.AuditEventParticipantNetworkType)src.getValue()) {
            case _1: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._1);
                break;
            }
            case _2: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._2);
                break;
            }
            case _3: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._3);
                break;
            }
            case _4: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._4);
                break;
            }
            case _5: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._5);
                break;
            }
            default: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType.NULL);
            }
        }
        return tgt;
    }

    public static AuditEvent.AuditEventSourceComponent convertAuditEventSourceComponent(AuditEvent.AuditEventSourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventSourceComponent tgt = new AuditEvent.AuditEventSourceComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasSiteElement()) {
            tgt.setSiteElement(VersionConvertor_10_30.convertString(src.getSiteElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        for (Coding t : src.getType()) {
            tgt.addType(VersionConvertor_10_30.convertCoding(t));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventSourceComponent convertAuditEventSourceComponent(AuditEvent.AuditEventSourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventSourceComponent tgt = new AuditEvent.AuditEventSourceComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasSiteElement()) {
            tgt.setSiteElement(VersionConvertor_10_30.convertString(src.getSiteElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getType()) {
            tgt.addType(VersionConvertor_10_30.convertCoding(t));
        }
        return tgt;
    }
}

