/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.z;

import java.util.Arrays;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.z.AbstractIntSet;
import net.sf.saxon.z.IntArraySet;
import net.sf.saxon.z.IntComplementSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntUniversalSet;

public class MonotonicIntSet
extends AbstractIntSet
implements IntSet {
    private int[] contents;
    private int used = 0;

    public MonotonicIntSet() {
        this.contents = new int[4];
        this.used = 0;
    }

    public IntSet copy() {
        MonotonicIntSet i2 = new MonotonicIntSet();
        i2.contents = Arrays.copyOf(this.contents, this.used);
        i2.used = this.used;
        return i2;
    }

    public IntSet mutableCopy() {
        return this.copy();
    }

    public void clear() {
        if (this.contents.length > this.used + 20) {
            this.contents = new int[4];
        }
        this.used = 0;
    }

    public int size() {
        return this.used;
    }

    public boolean isEmpty() {
        return this.used == 0;
    }

    public boolean contains(int value) {
        return Arrays.binarySearch(this.contents, 0, this.used, value) >= 0;
    }

    public boolean remove(int value) {
        throw new UnsupportedOperationException();
    }

    public boolean add(int value) {
        if (this.used > 0) {
            int last = this.contents[this.used - 1];
            if (value == last) {
                return false;
            }
            if (value < last) {
                throw new UnsupportedOperationException("Values must be added in monotonic order");
            }
        }
        if (this.used == this.contents.length) {
            this.contents = Arrays.copyOf(this.contents, this.used == 0 ? 4 : this.used * 2);
        }
        this.contents[this.used++] = value;
        return true;
    }

    public IntIterator iterator() {
        return new IntArraySet.IntArrayIterator(this.contents, this.used);
    }

    public IntSet union(IntSet other) {
        if (this.size() == 0) {
            return other.copy();
        }
        if (other.isEmpty()) {
            return this.copy();
        }
        if (other == IntUniversalSet.getInstance()) {
            return other;
        }
        if (other instanceof IntComplementSet) {
            return other.union(this);
        }
        if (this.equals(other)) {
            return this.copy();
        }
        if (other instanceof MonotonicIntSet) {
            int[] merged = new int[this.size() + other.size()];
            int[] a = this.contents;
            int[] b = ((MonotonicIntSet)other).contents;
            int m3 = this.used;
            int n = ((MonotonicIntSet)other).used;
            int o = 0;
            int i2 = 0;
            int j = 0;
            do {
                if (a[i2] < b[j]) {
                    merged[o++] = a[i2++];
                } else if (b[j] < a[i2]) {
                    merged[o++] = b[j++];
                } else {
                    merged[o++] = a[i2++];
                    ++j;
                }
                if (i2 != m3) continue;
                System.arraycopy(b, j, merged, o, n - j);
                return MonotonicIntSet.make(merged, o += n - j);
            } while (j != n);
            System.arraycopy(a, i2, merged, o, m3 - i2);
            return MonotonicIntSet.make(merged, o += m3 - i2);
        }
        return super.union(other);
    }

    public static MonotonicIntSet make(int[] in, int size) {
        return new MonotonicIntSet(in, size);
    }

    private MonotonicIntSet(int[] content, int used) {
        this.contents = content;
        this.used = used;
    }

    public String toString() {
        FastStringBuffer sb = new FastStringBuffer(this.used * 4);
        for (int i2 = 0; i2 < this.used; ++i2) {
            if (i2 == this.used - 1) {
                sb.append(this.contents[i2] + "");
                continue;
            }
            if (this.contents[i2] + 1 != this.contents[i2 + 1]) {
                sb.append(this.contents[i2] + ",");
                continue;
            }
            int j = i2 + 1;
            while (this.contents[j] == this.contents[j - 1] + 1 && ++j != this.used) {
            }
            sb.append(this.contents[i2] + "-" + this.contents[j - 1] + ",");
            i2 = j;
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof MonotonicIntSet) {
            MonotonicIntSet s2 = (MonotonicIntSet)other;
            if (this.used != s2.used) {
                return false;
            }
            for (int i2 = 0; i2 < this.used; ++i2) {
                if (this.contents[i2] == s2.contents[i2]) continue;
                return false;
            }
            return true;
        }
        return other instanceof IntSet && this.used == ((IntSet)other).size() && this.containsAll((IntSet)other);
    }

    public int hashCode() {
        int h2 = 936247625;
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            h2 += it.next();
        }
        return h2;
    }
}

